    create or replace PACKAGE MIGRATION_SCHEDULER authid current_user IS
    
    PROCEDURE run_redshift_dataload_scripts(schemaName IN varchar2, tableName IN varchar2);
    
    PROCEDURE createSchedulerJob(jobName IN varchar2, jobAction IN varchar2, startDate IN varchar2, jobComment IN varchar2, enabled IN boolean, autodrop in boolean);
    
    -- DBMS_SCHEDULER : schedule one job
    PROCEDURE scheduleJobAndRun(schemaName varchar2, tableName varchar2, starting varchar2);
    
    -- DBMS_SCHEDULER : schedule all jobs and run them
    PROCEDURE scheduleAndRunAllJobs;
    
    -- DBMS_SCHEDULER : schedule all jobs
    PROCEDURE scheduleAllJobs;
    
    -- DBMS_SCHEDULER : Run all schedules jobs
    PROCEDURE runAllJobs;
    
    -- DBMS_SCHEDULER : Query job scheduler
    PROCEDURE queryJobScheduler;
    
    -- DBMS_SCHEDULER : Query job scheduler
    PROCEDURE updateMigrationReport;
    
    END MIGRATION_SCHEDULER;
    /
    
    create or replace PACKAGE BODY MIGRATION_SCHEDULER IS
    
    PROCEDURE run_redshift_dataload_scripts(schemaName varchar2, tableName varchar2) IS
        sqlScript SQLDEV_MIGREPOS.md_generate.SQL_SCRIPT%type;
    
    BEGIN
           DBMS_OUTPUT.PUT_LINE ('In run_redshift_dataload_scripts' );
           
           select sql_script into sqlScript from SQLDEV_MIGREPOS.md_generate where OBJECT_TYPE= 'OCA_COPY_DATA' and schema_name = schemaName and object_name = tableName;
           DBMS_OUTPUT.PUT_LINE('dataload_script -> ' || sqlScript);
           EXECUTE IMMEDIATE sqlScript ;
           
           DBMS_OUTPUT.PUT_LINE ('Out run_redshift_dataload_scripts' );
    
    END run_redshift_dataload_scripts ;
    
    
    PROCEDURE createSchedulerJob(jobName varchar2, jobAction varchar2, startDate varchar2, jobComment varchar2, enabled boolean, autodrop boolean) AS
    
     BEGIN
         DBMS_OUTPUT.PUT_LINE ('In createSchedulerJob' );
              
              DBMS_SCHEDULER.create_job (
                job_name        => jobName,
                job_type        => 'PLSQL_BLOCK',
                job_action      => jobAction,
                start_date      => startDate,
                enabled         => enabled,
                auto_drop       => autodrop,
                comments        => jobComment
            );
    
         DBMS_OUTPUT.PUT_LINE ('Out createSchedulerJob');
    
     END createSchedulerJob;
    
     PROCEDURE scheduleJobAndRun(schemaName varchar2, tableName varchar2, starting varchar2) AS
            existing_job varchar2(100);
            jobName varchar2(100);
            jobAction varchar2(4000);
            startDate varchar2(100);
            jobComment varchar2(240);
            
     BEGIN
            DBMS_OUTPUT.PUT_LINE ('In scheduleJobAndRun');
       
            jobName :=  schemaName||'_'||tableName;     
            BEGIN
            	SELECT job_name into existing_job FROM user_scheduler_jobs where job_name = upper(jobName);
            	IF existing_job IS NOT NULL then
                	DBMS_OUTPUT.PUT_LINE ('JOB exists-> '||existing_job);
                	DBMS_SCHEDULER.drop_job (job_name => existing_job);
                	DBMS_OUTPUT.PUT_LINE ('JOB dropped-> '||existing_job);
                END IF;
    			EXCEPTION WHEN NO_DATA_FOUND THEN
        		 DBMS_OUTPUT.PUT_LINE ('JOB Does not exists-> '||jobName);  		
    		END;
            
            IF starting IS NULL then
               startDate := SYSTIMESTAMP;
            ELSE 
               startDate := starting;
            END IF;
            
            DBMS_OUTPUT.PUT_LINE('startingDate => '||startDate);
            
            DBMS_OUTPUT.PUT_LINE ('JOB -> '||jobName);
            jobAction := 'SQLDEV_MIGREPOS.MIGRATION_SCHEDULER.run_redshift_dataload_scripts('''||schemaName||''', '''||tableName||''');';
            
            jobComment := 'Data load scheduler job for '||schemaName||'.'||tableName;
                  
            createSchedulerJob(jobName, jobAction, startDate, jobComment, true, false);
            -- DBMS_SCHEDULER.run_job (job_name => jobName, USE_CURRENT_SESSION => FALSE);
        
            DBMS_OUTPUT.PUT_LINE ('Out scheduleJobAndRun');
        
     END scheduleJobAndRun;
     
    PROCEDURE scheduleAndRunAllJobs AS
    
        jobName varchar2(100);
        jobAction varchar2(4000);
        startDate varchar2(100);
        jobComment varchar2(240);
        
        CURSOR table_cursor IS 
               select schema_name, object_name from SQLDEV_MIGREPOS.md_generate where OBJECT_TYPE= 'OCA_COPY_DATA'; 
        
    BEGIN
           DBMS_OUTPUT.PUT_LINE ('In scheduleAllJobs');
           FOR i_count in table_cursor 
           LOOP
              jobName :=  i_count.schema_name||'_'||i_count.object_name;
              DBMS_OUTPUT.PUT_LINE ('JOB -> '||jobName);
              jobAction := 'run_redshift_dataload_scripts('''||i_count.schema_name||''', '''||i_count.object_name||''');';
              startDate := 'SYSTIMESTAMP';
              jobComment := 'Data load scheduler job for '||i_count.schema_name||'.'||i_count.object_name;
              
              createSchedulerJob(jobName, jobAction, startDate, jobComment, true, true); 
           END LOOP;
    
            DBMS_OUTPUT.PUT_LINE ('Out scheduleAllJobs');
    
     END scheduleAndRunAllJobs;
    
    PROCEDURE scheduleAllJobs AS
        jobName varchar2(100);
        jobAction varchar2(4000);
        startDate varchar2(100);
        jobComment varchar2(240);
        
        CURSOR table_cursor IS 
               select schema_name, object_name from SQLDEV_MIGREPOS.md_generate where OBJECT_TYPE= 'OCA_COPY_DATA'; 
        
    BEGIN
           DBMS_OUTPUT.PUT_LINE ('In scheduleAllJobs');
           FOR i_count in table_cursor 
           LOOP
              jobName :=  i_count.schema_name||'_'||i_count.object_name;
              DBMS_OUTPUT.PUT_LINE ('JOB -> '||jobName);
              jobAction := 'run_redshift_dataload_scripts('''||i_count.schema_name||''', '''||i_count.object_name||''');';
              startDate := 'SYSTIMESTAMP';
              jobComment := 'Data load scheduler job for '||i_count.schema_name||'.'||i_count.object_name;
              
              createSchedulerJob(jobName, jobAction, startDate, jobComment, false, false); 
           END LOOP;
    
            DBMS_OUTPUT.PUT_LINE ('Out scheduleAllJobs');
    
     END scheduleAllJobs;
     
    PROCEDURE runAllJobs AS
    
     BEGIN
         DBMS_OUTPUT.PUT_LINE ('In runAllJobs' );
     END runAllJobs;
     
    PROCEDURE queryJobScheduler AS
    
     BEGIN
         DBMS_OUTPUT.PUT_LINE ('In queryJobScheduler' );
     END queryJobScheduler;
    
    PROCEDURE updateMigrationReport AS
    
     BEGIN
         DBMS_OUTPUT.PUT_LINE ('In updateMigrationReport' );
     END updateMigrationReport;
    
    END MIGRATION_SCHEDULER;
    /