-- Please enter start date and time of the job
-- Example DEFINE start_date_time = SYSTIMESTAMP
-- Example DEFINE start_date_time = '''11-Aug-2018 9.44.37 AM US/Central'''
-- DEFINE start_date_time = SYSTIMESTAMP

CREATE OR REPLACE PACKAGE "REDSHIFT_MIGRATION_UTILITIES" AS

FUNCTION is_md_report_table_exists RETURN boolean;

PROCEDURE schedule_dataload_job_and_run(PROJECT_ID IN NUMBER, CONNECTION_ID IN NUMBER, CATALOG_NAME IN VARCHAR2, SOURCE_SCHEMA_NAME IN VARCHAR2, SOURCE_TABLE_NAME IN VARCHAR2, 
                                         SCHEMA_NAME IN VARCHAR2, TABLE_NAME IN VARCHAR2, CAPT_VERSION IN NUMBER, CONV_VERSION IN NUMBER, GENERATE_VERSION IN NUMBER, JOBACTION IN VARCHAR2, STARTDATE IN VARCHAR2) ;

PROCEDURE run_data_load( PROJECT_ID IN NUMBER, CONNECTION_ID IN NUMBER, CATALOG_NAME IN VARCHAR2, CAPT_VERSION IN NUMBER, CONV_VERSION IN NUMBER, GENERATE_VERSION IN NUMBER, SOURCE_SCHEMA_NAME IN VARCHAR2, SOURCE_TABLE_NAME IN VARCHAR2, SOURCE_TABLE_ROWS IN NUMBER,
		                                      TARGET_SCHEMA_NAME IN VARCHAR2, TARGET_TABLE_NAME IN VARCHAR2, CREDENTIAL_NAME VARCHAR2, FILE_URI_LIST IN VARCHAR2, FILE_FORMAT IN VARCHAR2 ) ;
	 	                    
PROCEDURE run_data_load_datetimestamp( PROJECT_ID IN NUMBER, CONNECTION_ID IN NUMBER, CATALOG_NAME IN VARCHAR2, CAPT_VERSION IN NUMBER, CONV_VERSION IN NUMBER, GENERATE_VERSION IN NUMBER, SOURCE_SCHEMA_NAME IN VARCHAR2, SOURCE_TABLE_NAME IN VARCHAR2, SOURCE_TABLE_ROWS IN NUMBER,
		                                      TARGET_SCHEMA_NAME IN VARCHAR2, TARGET_TABLE_NAME IN VARCHAR2, CREDENTIAL_NAME VARCHAR2, FILE_URI_LIST IN VARCHAR2, FILE_FORMAT IN VARCHAR2 ) ;
                    
END;
/
    
create or replace PACKAGE BODY "REDSHIFT_MIGRATION_UTILITIES" AS

        TYPE VARCHAR2_ARRAY IS TABLE OF VARCHAR2(1000);
        
        -- You can modify the Date and Timestamp formats as you wish.
        -- Date Type Format
        DT_DTFMTS VARCHAR2_ARRAY := VARCHAR2_ARRAY(
				'auto',
				'fxyyyy-mm-dd hh24:mi:ss',
				'fxyyyymmdd hh24:mi:ss',
				'fxfmyyyy.mm.dd',                  --ANSI(with Century)
				'fxfmyyyy-mm-dd',                  --ANSI(with Century) 
				'fxfmyyyy/mm/dd',                  --Japan(with Century)
				'fxfmyy/mm/dd',                    --Japan(without Century)
				'fxfmyy.mm.dd',                    --ANSI(without Century)
				'fxfmmm/dd/yy',                    --US(without Century)
				'fxfmmm-dd-yy',
				'fxfmmm.dd.yy', 
				'fxfmmm/dd/yyyy',                  --US(with Century)
				'fxfmmm-dd-yyyy',
				'fxfmmm.dd.yyyy',
				'fxfmMon dd, yy',                  --(without Century)
				'fxfmMon dd, yyyy',                --(with Century)
				'yyyy-mm-dd hh24:mi:ss'
			);   
        -- Timestamp type format
		DT_TSFMTS VARCHAR2_ARRAY := VARCHAR2_ARRAY(
				'auto',
				'fxyyyy-mm-dd hh24:mi:ss',         --ODBC canonical
				'fxyyyy-mm-dd hh24:mi:ssxff3',     --ODBC canonical (with milliseconds)
				'fxyyyy-mm-dd"T"hh12:mi:ssxff3',   --ISO8601 (no spaces)
				'fxyyyy-mm-dd hh12:mi:ssxff3',     --ISO8601 (with space)
				'yyyy-mm-dd hh24:mi:ssxff'
			);
		-- Timestamp with Time Zone type format
		DT_TSTZTS VARCHAR2_ARRAY := VARCHAR2_ARRAY(
				'auto',
				'fxyyyy-mm-dd hh24:mi:ss+tzr',
				'dd mon yyyy hh24:mi:ss.ff tzr',
				'mm/dd/yyyy hh24:mi:ss.ff tzr',
				'yyyy-mm-dd hh24:mi:ss+/-tzr',
				'yyyy-mm-dd hh24:mi:ss.ff3',
				'dd.mm.yyyy hh24:mi:ss tzr',  
				'fxyyyy-mm-dd hh24:mi:ssxff3tzr', --ISO8601 with time zone Z
				'yyyy-mm-dd hh24:mi:ssxfftzh:tzm'
			);
		-- Timestamp with Local Time Zone type format
		DT_TSLTZTS VARCHAR2_ARRAY := VARCHAR2_ARRAY(
				'auto',
				'dd mon yyyy hh24:mi:ss.ff tzr',
				'mm/dd/yyyy hh24:mi:ss.ff tzr',
				'yyyy-mm-dd hh24:mi:ss+/-tzr',
				'yyyy-mm-dd hh24:mi:ss.ff3',
				'yyyy-mm-dd hh24:mi:ss.ff3tzr',
				'dd.mm.yyyy hh24:mi:ss tzr'
			);
			
	--PRIVATE FUNCTION
		FUNCTION truncateStringByteSize(p_work VARCHAR2, p_bsize NUMBER) RETURN VARCHAR2
		IS
		v_work VARCHAR2(4000);
		v_bsize NUMBER(10);
		BEGIN
		 IF LENGTHB(p_work) <= p_bsize THEN
		    return p_work;
		  END IF;
		  v_work := p_work;
		  v_work := SUBSTRB(v_work, 1, p_bsize);
		  WHILE INSTRC(p_work, v_work , 1, 1) <> 1 LOOP -- a character has been cut in half or in 2/3 or 3/4 by substrb (multibyte can have up to 4 bytes) 
		  --note each left over corrupt byte can be a single character
		   BEGIN
		     v_bsize := LENGTHB(v_work);
		  	 v_work := SUBSTRB(v_work, 1, v_bsize-1);
		   END;
		  END LOOP; 
		  return v_work;
		END;		
        
    FUNCTION is_md_report_table_exists RETURN boolean AS
    	nCount NUMBER;
    	flag boolean := false;
		BEGIN
    		SELECT count(*) into nCount FROM all_tables where owner = 'SQLDEV_MIGREPOS' and table_name = 'MD_REPORT';
    		IF (nCount <= 0) THEN
       			flag := false;
    		ELSE 
       			flag := true;
    	END IF;
    	return flag;
    END is_md_report_table_exists;
 
   PROCEDURE schedule_dataload_job_and_run(PROJECT_ID IN NUMBER, CONNECTION_ID IN NUMBER, CATALOG_NAME IN VARCHAR2, SOURCE_SCHEMA_NAME IN VARCHAR2, SOURCE_TABLE_NAME IN VARCHAR2, 
                                         SCHEMA_NAME IN VARCHAR2, TABLE_NAME IN VARCHAR2, CAPT_VERSION IN NUMBER, CONV_VERSION IN NUMBER, GENERATE_VERSION IN NUMBER, JOBACTION IN VARCHAR2, STARTDATE IN VARCHAR2) AS
            existing_job varchar2(100);
            jobName varchar2(100);
            starting_date varchar2(100);
    BEGIN
            jobName := truncateStringByteSize(SCHEMA_NAME, 49)||'_'||truncateStringByteSize(TABLE_NAME,49);     
            BEGIN
            	SELECT job_name into existing_job FROM user_scheduler_jobs where job_name = upper(jobName);
            	IF existing_job IS NOT NULL then
                	--DBMS_OUTPUT.PUT_LINE ('JOB exists-> '||existing_job);
                	DBMS_SCHEDULER.drop_job (job_name => existing_job);
                	--DBMS_OUTPUT.PUT_LINE ('JOB dropped-> '||existing_job);
                END IF;
    			EXCEPTION WHEN NO_DATA_FOUND THEN
        		 DBMS_OUTPUT.PUT_LINE ('Scheduler job does not exists-> '||jobName);  		
    		END;
    		
    		IF STARTDATE = 'SYSTIMESTAMP' then
               starting_date := SYSTIMESTAMP;
            ELSE 
               starting_date := STARTDATE;
            END IF;
            
     DBMS_SCHEDULER.create_job (
            job_name        => jobName,
            job_type        => 'PLSQL_BLOCK',
            job_action      => JOBACTION,
            start_date      => starting_date, -- use start_date_time substitute value
            enabled         => true,
            auto_drop       => false,
            comments        => 'Data load scheduler job for '||SCHEMA_NAME||'.'||TABLE_NAME
     );
     EXCEPTION WHEN OTHERS THEN
        		 DBMS_OUTPUT.PUT_LINE ('Job creation FAILED for '||SCHEMA_NAME||'.'||TABLE_NAME);  	
        
     END schedule_dataload_job_and_run;  
     
	                    
     PROCEDURE run_data_load( PROJECT_ID IN NUMBER, CONNECTION_ID IN NUMBER, CATALOG_NAME IN VARCHAR2, CAPT_VERSION IN NUMBER, CONV_VERSION IN NUMBER, GENERATE_VERSION IN NUMBER, SOURCE_SCHEMA_NAME IN VARCHAR2, SOURCE_TABLE_NAME IN VARCHAR2, SOURCE_TABLE_ROWS IN NUMBER,
		                TARGET_SCHEMA_NAME IN VARCHAR2, TARGET_TABLE_NAME IN VARCHAR2, CREDENTIAL_NAME VARCHAR2, FILE_URI_LIST IN VARCHAR2, FILE_FORMAT IN VARCHAR2 ) AS
		l_opid NUMBER;
		error_message varchar2(2000);
		source_num_rows NUMBER;
		owner_name1 VARCHAR2(128);
		rows_loaded1 NUMBER;
		status1 VARCHAR2(9);
		logfile_table1 VARCHAR2(128);
		badfile_table1 VARCHAR2(128);
		start_time1 TIMESTAMP(6) WITH TIME ZONE;
		update_time1 TIMESTAMP(6) WITH TIME ZONE;
		
		BEGIN
		
		DBMS_CLOUD.copy_data (
		  schema_name => TARGET_SCHEMA_NAME, 
		  table_name => TARGET_TABLE_NAME, 
		  credential_name => CREDENTIAL_NAME, 
		  file_uri_list => FILE_URI_LIST, 
		  format => FILE_FORMAT, 
		  OPERATION_ID => l_opid 
		);
		
		  SELECT owner_name, rows_loaded, status, logfile_table, badfile_table, start_time, update_time 
		    INTO owner_name1, rows_loaded1, status1, logfile_table1, badfile_table1, start_time1, update_time1 
		    FROM dba_load_operations 
		    WHERE ID = l_opid;
		 
	    IF (is_md_report_table_exists()) THEN
			INSERT into SQLDEV_MIGREPOS.MD_REPORT(PROJECT_ID, CONNECTION_ID, CATALOG_NAME, CAPT_VERSION, CONV_VERSION, GENERATE_VERSION, OPERATION_ID, SOURCE_SCHEMA_NAME, SOURCE_TABLE_NAME, SOURCE_TABLE_ROWS,
		                                      TARGET_SCHEMA_NAME, TARGET_TABLE_NAME, TARGET_TABLE_ROWS_LOADED, LOGFILE_TABLE, BADFILE_TABLE, STATUS, START_TIME, END_TIME, CREATED_BY) 
		                               values(PROJECT_ID, CONNECTION_ID, CATALOG_NAME, CAPT_VERSION, CONV_VERSION, GENERATE_VERSION, l_opid, SOURCE_SCHEMA_NAME, SOURCE_TABLE_NAME, SOURCE_TABLE_ROWS, 
		                                      TARGET_SCHEMA_NAME, TARGET_TABLE_NAME, rows_loaded1, logfile_table1, badfile_table1, status1, start_time1, update_time1, owner_name1 );	                                                                           
		    commit;
		END IF;
		
		  EXCEPTION
		    WHEN OTHERS THEN
		    DBMS_OUTPUT.PUT_LINE ('Data load failed for '||TARGET_SCHEMA_NAME||'.'||TARGET_SCHEMA_NAME);  
		    error_message := SUBSTR(SQLERRM, 1, 2000);
		    DBMS_OUTPUT.PUT_LINE ('error_message '||error_message);
		    
		    IF (is_md_report_table_exists()) THEN
		    	INSERT into SQLDEV_MIGREPOS.MD_REPORT(PROJECT_ID, CONNECTION_ID, CATALOG_NAME, CAPT_VERSION, CONV_VERSION, GENERATE_VERSION, OPERATION_ID, SOURCE_SCHEMA_NAME, SOURCE_TABLE_NAME, SOURCE_TABLE_ROWS,
		                                      TARGET_SCHEMA_NAME, TARGET_TABLE_NAME, LOGFILE_TABLE, BADFILE_TABLE, STATUS, ERROR_MESSAGES, START_TIME, END_TIME, CREATED_BY) 
		                               values(PROJECT_ID, CONNECTION_ID, CATALOG_NAME, CAPT_VERSION, CONV_VERSION, GENERATE_VERSION, -1, SOURCE_SCHEMA_NAME, SOURCE_TABLE_NAME, SOURCE_TABLE_ROWS, 
		                                      TARGET_SCHEMA_NAME, TARGET_TABLE_NAME, logfile_table1, badfile_table1, 'FAILED', error_message, start_time1, update_time1, owner_name1 );
		        commit;
		    END IF;
		END run_data_load;
			                    
	    PROCEDURE run_data_load_datetimestamp( PROJECT_ID IN NUMBER, CONNECTION_ID IN NUMBER, CATALOG_NAME IN VARCHAR2, CAPT_VERSION IN NUMBER, CONV_VERSION IN NUMBER, GENERATE_VERSION IN NUMBER, SOURCE_SCHEMA_NAME IN VARCHAR2, SOURCE_TABLE_NAME IN VARCHAR2, SOURCE_TABLE_ROWS IN NUMBER,
		                TARGET_SCHEMA_NAME IN VARCHAR2, TARGET_TABLE_NAME IN VARCHAR2, CREDENTIAL_NAME VARCHAR2, FILE_URI_LIST IN VARCHAR2, FILE_FORMAT IN VARCHAR2 ) AS
	                  
		l_opid NUMBER := 0;
		l_logtable VARCHAR2(200);
		l_status VARCHAR2(100);
		l_cursor SYS_REFCURSOR;
		l_dttypescur SYS_REFCURSOR;
		l_stmt VARCHAR2(4000);
		l_msg VARCHAR2(4000);
		l_json JSON_OBJECT_T;
		l_datamoved BOOLEAN := FALSE;
		l_dtfmtsIdx NUMBER := 1;
		l_tsfmtsIdx NUMBER := 1;
		l_tstzfmtsIdx NUMBER := 1;
		l_tsltzfmtsIdx NUMBER := 1;
		l_dttype VARCHAR2(200) := NULL;
		l_dtcolumn VARCHAR2(200) := NULL;
		l_curid NUMBER;
		l_desctab    DBMS_SQL.DESC_TAB3;
		l_colcnt     NUMBER;
		l_tgttbl_stmt   VARCHAR2(2000);
		
		TYPE TBLDTTypes IS TABLE OF VARCHAR2(128) INDEX BY VARCHAR2(1000);
    	
		Tbl_to_DTTyp TBLDTTypes;
		
		error_message varchar2(2000);
		source_num_rows NUMBER;
		owner_name1 VARCHAR2(128);
		rows_loaded1 NUMBER;
		status1 VARCHAR2(9);
		logfile_table1 VARCHAR2(128);
		badfile_table1 VARCHAR2(128);
		start_time1 TIMESTAMP(6) WITH TIME ZONE;
		update_time1 TIMESTAMP(6) WITH TIME ZONE;
		
	 BEGIN
	 	 
	    l_tgttbl_stmt := 'SELECT * FROM '||TARGET_SCHEMA_NAME||'.'||TARGET_TABLE_NAME;
		l_curid := DBMS_SQL.OPEN_CURSOR;
		DBMS_SQL.PARSE(l_curid, l_tgttbl_stmt, DBMS_SQL.NATIVE);
		DBMS_SQL.DESCRIBE_COLUMNS3(l_curid, l_colcnt, l_desctab);
		FOR i IN 1 .. l_colcnt LOOP
			IF l_desctab(i).col_type = 12 THEN
				Tbl_to_DTTyp(l_desctab(i).col_name) := 'DATE';
			ELSIF l_desctab(i).col_type = 180 THEN
				Tbl_to_DTTyp(l_desctab(i).col_name) := 'TIMESTAMP';
			ELSIF l_desctab(i).col_type = 181 THEN
				Tbl_to_DTTyp(l_desctab(i).col_name) := 'TIMESTAMP WITH TIME ZONE';
			ELSIF l_desctab(i).col_type = 231 THEN
				Tbl_to_DTTyp(l_desctab(i).col_name) := 'TIMESTAMP WITH LOCAL TIME ZONE';
			END IF;
		END LOOP;
		
		DBMS_SQL.CLOSE_CURSOR(l_curid);
	 
        l_json := JSON_OBJECT_T.parse(FILE_FORMAT);
        l_dtcolumn := Tbl_to_DTTyp.FIRST;
        
        WHILE l_dtcolumn IS NOT NULL LOOP
            IF Tbl_to_DTTyp(l_dtcolumn) = 'DATE' THEN
                l_json.put('dateformat',DT_DTFMTS(l_dtfmtsIdx) );
            ELSIF Tbl_to_DTTyp(l_dtcolumn) = 'TIMESTAMP' THEN
                l_json.put('timestampformat',DT_TSFMTS(l_tsfmtsIdx) );
            ELSIF Tbl_to_DTTyp(l_dtcolumn) = 'TIMESTAMP WITH TIME ZONE' THEN
                l_json.put('timestamptzformat',DT_TSTZTS(l_tstzfmtsIdx) );
            ELSIF Tbl_to_DTTyp(l_dtcolumn) = 'TIMESTAMP WITH LOCAL TIME ZONE' THEN
                l_json.put('timestampltzformat',DT_TSLTZTS(l_tsltzfmtsIdx) );
            END IF;
            l_dtcolumn  := tbl_to_DTTyp.NEXT(l_dtcolumn);
        END LOOP;  
        
        WHILE NOT l_datamoved LOOP
			BEGIN
			  IF l_json.to_string IS JSON THEN 
			        -- DBMS_OUTPUT.PUT_LINE(l_json.to_string);
			        DBMS_CLOUD.COPY_DATA (
			          schema_name => TARGET_SCHEMA_NAME, 
			          table_name => TARGET_TABLE_NAME, 
			          credential_name => CREDENTIAL_NAME, 
			          file_uri_list => FILE_URI_LIST,
			          format => l_json.to_string,
			          operation_id => l_opid
			        );
			  END IF;     
			  l_datamoved := TRUE;
			EXCEPTION
			  WHEN OTHERS THEN
			    --DBMS_OUTPUT.PUT_LINE(DBMS_UTILITY.FORMAT_ERROR_STACK());
			    IF l_opid > 0 THEN
			      l_stmt := 'SELECT STATUS, LOGFILE_TABLE FROM USER_LOAD_OPERATIONS WHERE ID = ' || l_opid ;
			      OPEN l_cursor FOR l_stmt;
			         LOOP
			           FETCH l_cursor INTO l_status,l_logtable;
			           EXIT WHEN l_cursor%notfound;
			         END LOOP;
			      CLOSE l_cursor;

			      IF l_status = 'FAILED' THEN
			        --DBMS_OUTPUT.PUT_LINE('FAILED SO TRY DIFFERENT FORMATS HERE');
			        l_stmt := 'SELECT COUNT(*) FROM ' || l_logtable || ' WHERE REGEXP_INSTR(RECORD,''ORA-26041:|ORA-018\d{2}:'') > 0';
			        OPEN l_cursor FOR l_stmt;
			            LOOP
			              FETCH l_cursor INTO l_msg;
			              EXIT WHEN l_cursor%notfound;
			            END LOOP;
			        CLOSE l_cursor;

			        IF l_msg IS NOT NULL AND TO_NUMBER(l_msg) > 0 THEN
			            l_stmt := 'SELECT REGEXP_SUBSTR(RECORD, ''error processing column\s(\w+).*'', 1, 1, ''i'', 1) COL FROM <LOGTABLE>
			                               WHERE RECORD LIKE ''%error processing column%''';
			            l_stmt := REPLACE(l_stmt, '<LOGTABLE>', l_logtable); 

			           OPEN l_cursor FOR l_stmt;
			            LOOP
			              FETCH l_cursor INTO l_dtcolumn;
			              EXIT WHEN l_cursor%notfound;
			            END LOOP;
			           CLOSE l_cursor;

			           --DBMS_OUTPUT.PUT_LINE('FAILED DATE TYPE IS ' || l_dttype);
			           IF l_dtcolumn IS NULL OR LENGTH(l_dtcolumn) = 0 THEN
			             EXIT;
			           ELSE
			            IF Tbl_to_DTTyp(l_dtcolumn) = 'DATE' THEN
			                IF l_dtfmtsIdx IS NOT NULL THEN
			                    l_dtfmtsIdx := DT_DTFMTS.NEXT(l_dtfmtsIdx);
			                    IF l_dtfmtsIdx IS NULL THEN
			                      EXIT;
			                    END IF;
			                    --DBMS_OUTPUT.PUT_LINE('TRY DIFFERENT DATE FORMAT');
			                    l_json.put('dateformat', DT_DTFMTS(l_dtfmtsIdx));
			                END IF;
			            ELSIF Tbl_to_DTTyp(l_dtcolumn) = 'TIMESTAMP' THEN
			                IF l_tsfmtsIdx IS NOT NULL THEN
			                    l_tsfmtsIdx := DT_TSFMTS.NEXT(l_tsfmtsIdx);
			                    IF l_tsfmtsIdx IS NULL THEN
			                      EXIT;
			                    END IF;
			                    --DBMS_OUTPUT.PUT_LINE('TRY DIFFERENT TIMESTAMP FORMAT');
			                    l_json.put('timestampformat', DT_TSFMTS(l_tsfmtsIdx));
			                END IF;
			            ELSIF Tbl_to_DTTyp(l_dtcolumn) = 'TIMESTAMP WITH TIME ZONE' THEN
			                IF l_tstzfmtsIdx IS NOT NULL THEN
			                    l_tstzfmtsIdx := DT_TSTZTS.NEXT(l_tstzfmtsIdx);
			                    IF l_tstzfmtsIdx IS NULL THEN
			                      EXIT;
			                    END IF;
			                    --DBMS_OUTPUT.PUT_LINE('TRY DIFFERENT TIMESTAMP WITH TIME ZONE FORMAT');
			                    l_json.put('timestamptzformat', DT_TSTZTS(l_tstzfmtsIdx));
			                END IF;
			            ELSIF Tbl_to_DTTyp(l_dtcolumn) = 'TIMESTAMP WITH LOCAL TIME ZONE' THEN
			                IF l_tsltzfmtsIdx IS NOT NULL THEN
			                    l_tsltzfmtsIdx := DT_TSLTZTS.NEXT(l_tsltzfmtsIdx);
			                    IF l_tsltzfmtsIdx IS NULL THEN
			                      EXIT;
			                    END IF;
			                    --DBMS_OUTPUT.PUT_LINE('TRY DIFFERENT TIMESTAMP WITH LOCAL TIME ZONE FORMAT');
			                    l_json.put('timestampltzformat', DT_TSLTZTS(l_tsltzfmtsIdx));
			                END IF;
			            END IF;
			          END IF;
			          CONTINUE;
			        ELSE
			          EXIT;
			        END IF;
			      ELSE
			        EXIT;
			      END IF;
			    ELSE
			      EXIT;
			    END IF;
			END;
		END LOOP;

           select owner_name, rows_loaded, status, logfile_table, badfile_table, start_time, update_time 
	       into owner_name1, rows_loaded1, status1, logfile_table1, badfile_table1, start_time1, update_time1 
	       from dba_load_operations where ID = l_opid;

	       --DBMS_OUTPUT.PUT_LINE(owner_name1||' ' ||rows_loaded1||' ' || status1||' ' || logfile_table1||' ' || badfile_table1||' ' || start_time1||' ' ||update_time1 );
           
           IF (is_md_report_table_exists()) THEN
	           INSERT into SQLDEV_MIGREPOS.MD_REPORT(PROJECT_ID, CONNECTION_ID, CATALOG_NAME, CAPT_VERSION, CONV_VERSION, GENERATE_VERSION, OPERATION_ID, SOURCE_SCHEMA_NAME, SOURCE_TABLE_NAME, SOURCE_TABLE_ROWS,
	                                      TARGET_SCHEMA_NAME, TARGET_TABLE_NAME, TARGET_TABLE_ROWS_LOADED, LOGFILE_TABLE, BADFILE_TABLE, STATUS, START_TIME, END_TIME, CREATED_BY) 
	                               values(PROJECT_ID, CONNECTION_ID, CATALOG_NAME, CAPT_VERSION, CONV_VERSION, GENERATE_VERSION, l_opid, SOURCE_SCHEMA_NAME, SOURCE_TABLE_NAME, SOURCE_TABLE_ROWS, 
	                                      TARGET_SCHEMA_NAME, TARGET_TABLE_NAME, rows_loaded1, logfile_table1, badfile_table1, status1, start_time1, update_time1, owner_name1 );
	           commit;
           END IF;
           
	       EXCEPTION
	          WHEN OTHERS THEN
	          DBMS_OUTPUT.PUT_LINE ('Data load failed for '||TARGET_SCHEMA_NAME||'.'||TARGET_SCHEMA_NAME);
	          error_message := SUBSTR(SQLERRM, 1, 2000);
	          DBMS_OUTPUT.PUT_LINE ('error_message '||error_message);
	          
              IF (is_md_report_table_exists()) THEN
	             INSERT into SQLDEV_MIGREPOS.MD_REPORT(PROJECT_ID, CONNECTION_ID, CATALOG_NAME, CAPT_VERSION, CONV_VERSION, GENERATE_VERSION, OPERATION_ID, SOURCE_SCHEMA_NAME, SOURCE_TABLE_NAME, SOURCE_TABLE_ROWS,
	                                      TARGET_SCHEMA_NAME, TARGET_TABLE_NAME, LOGFILE_TABLE, BADFILE_TABLE, STATUS, ERROR_MESSAGES, START_TIME, END_TIME, CREATED_BY) 
	                               values(PROJECT_ID, CONNECTION_ID, CATALOG_NAME, CAPT_VERSION, CONV_VERSION, GENERATE_VERSION, -1, SOURCE_SCHEMA_NAME, SOURCE_TABLE_NAME, SOURCE_TABLE_ROWS, 
	                                       TARGET_SCHEMA_NAME, TARGET_TABLE_NAME, logfile_table1, badfile_table1, 'FAILED', error_message, start_time1, update_time1, owner_name1 );
	             commit;
              END IF;
              
	   END run_data_load_datetimestamp;		
END;
/

ALTER PACKAGE REDSHIFT_MIGRATION_UTILITIES COMPILE;

