create or replace TYPE data_script IS TABLE OF VARCHAR2(10000);
/

create or replace PACKAGE REDSHIFT_DEPLOY 
AS
   -- PROCEDURE DeployAll;
   FUNCTION deploy_all_objects RETURN data_script;
   PROCEDURE deploy_schema(user_schema varchar2);
   PROCEDURE deploy_all_tables(user_schema varchar2);
   PROCEDURE deploy_table(table_name varchar2, user_schema varchar2);
   
   PROCEDURE deploy_selected_schema(user_schema varchar2);
   PROCEDURE deploy_selected_tables(user_schema varchar2);
   PROCEDURE deploy_selected_table(table_name varchar2, user_schema varchar2);
   FUNCTION  deploy_selected_objects ( schema_name_list varchar2 ) RETURN data_script;   
   
   PROCEDURE deploy_comment_set(user_schema varchar2);
   PROCEDURE deploy_comment(obj_name varchar2, user_schema varchar2);
   FUNCTION  deploy_all_comments RETURN data_script;
   FUNCTION  get_all_comment_scripts RETURN data_script;
   
   PROCEDURE deploy_selected_comment_set(user_schema varchar2);
   PROCEDURE deploy_selected_comment(obj_name varchar2, user_schema varchar2);
   FUNCTION  deploy_selected_comments (schema_name_list varchar2) RETURN data_script;
   FUNCTION  get_selected_comment_scripts (schema_name_list varchar2) RETURN data_script;
   
   FUNCTION get_all_external_tables_scripts RETURN data_script;
   PROCEDURE deploy_all_external_tables(user_schema varchar2);
   PROCEDURE deploy_external_tables(table_name varchar2, user_schema varchar2);
   
   PROCEDURE drop_tables;
   PROCEDURE execute_sqlsript(sqlscript varchar2);
   
   FUNCTION get_all_objects_scripts RETURN data_script;
   FUNCTION get_all_redshift_unload_scripts RETURN data_script;
   FUNCTION get_all_redshift_dataload_scripts RETURN data_script;
   
   FUNCTION get_selected_objects_scripts ( schema_name_list varchar2 ) RETURN data_script;
   
   PROCEDURE deploy_table_defaults(table_name varchar2, user_schema varchar2);
   PROCEDURE deploy_schema_table_defaults(user_schema varchar2);
   FUNCTION deploy_all_default_objects RETURN data_script;
   FUNCTION get_all_default_objects_scripts RETURN data_script;
   FUNCTION deploy_selected_default_objects ( schema_name_list varchar2 ) RETURN data_script;
   FUNCTION get_selected_default_objects_scripts ( schema_name_list varchar2 ) RETURN data_script;
   
   -- file writing procedures.
   PROCEDURE open_write_pwddef;
   PROCEDURE write_pwddef_file;
   PROCEDURE open_write_file;
   PROCEDURE close_write_files;
   PROCEDURE write_drop_schema_sqlscript(generateVersion in NUMBER);
   PROCEDURE write_schema_sqlscript(generateVersion in NUMBER) ;
   PROCEDURE write_all_schema_objects(generateVersion in NUMBER);
   PROCEDURE write_objecttype_sqlscript(user_schema varchar2, type_object varchar2, generateVersion in NUMBER);
   PROCEDURE write_sqlfile_header;
   PROCEDURE open_write_master;
   PROCEDURE write_master_file;
   PROCEDURE write_sqlfile_footer;
   
   PROCEDURE WriteAllObjectToFile(generateVersion in NUMBER);

END REDSHIFT_DEPLOY;
/

create or replace PACKAGE BODY REDSHIFT_DEPLOY AS

  sqlFileHandler UTL_FILE.FILE_TYPE;
  pwdDefFileHandler UTL_FILE.FILE_TYPE;
  masterFileHandler UTL_FILE.FILE_TYPE;
  oracleDirectory varchar2(128) := 'C:\Redshift\generation';
  sqlScriptName varchar2(128) := 'GenerateSQLScripts.sql' ;
  pwdDefName varchar2(128) := 'PasswordDefination.sql' ;
  masterFileName varchar2(128) := 'rundeploy.sql' ;

  object_script_array data_script := data_script();
  selected_object_array data_script := data_script();
  comment_script_array data_script := data_script();
  selected_comment_script_array data_script := data_script();
  external_script_array data_script := data_script();
  default_script_array data_script := data_script(); 

  object_count NUMBER := 0;
  selected_object_count NUMBER := 0;
  comment_count NUMBER := 0;
  selected_comment_count NUMBER := 0;
  default_count NUMBER := 0;
  ext_tab_count NUMBER := 0; 

--
-- This code is to create all objects and run them without writing on files.
--

PROCEDURE execute_sqlsript(sqlscript varchar2) IS
BEGIN
  EXECUTE IMMEDIATE sqlscript;

END execute_sqlsript;

PROCEDURE deploy_schema(user_schema varchar2) IS 
CURSOR schema_cursor IS with inputs(str) as (
      select sql_script from md_generate where object_type = 'SCHEMA' and object_name = user_schema
    )
    SELECT LEVEL AS id,
    REGEXP_SUBSTR( str ,'(.*?)(;|$)', 1, LEVEL, NULL, 1 ) AS sqlscript
    FROM  inputs
    CONNECT BY LEVEL <= regexp_count(str, ';'); 
BEGIN
	FOR schema_rec IN schema_cursor LOOP
        dbms_output.put_line('SQLScript -> ' || schema_rec.sqlscript);

        object_script_array.EXTEND;
        object_count := object_count + 1;
        object_script_array(object_count) := schema_rec.sqlscript ;
        
   END LOOP;
END deploy_schema ;


PROCEDURE deploy_all_tables(user_schema varchar2) IS
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'TABLE' and SCHEMA_NAME = user_schema;
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('table_name -> ' || object_rec.object_name);
          deploy_table(object_rec.object_name, user_schema);
       END LOOP;
END deploy_all_tables ;

PROCEDURE deploy_table(table_name varchar2, user_schema varchar2) IS
CURSOR table_cursor IS 
      select sql_script from md_generate where object_type = 'TABLE' and SCHEMA_NAME = user_schema and object_name = table_name; 
BEGIN
	FOR table_rec IN table_cursor LOOP
        dbms_output.put_line('SQLScript -> ' || REGEXP_REPLACE(table_rec.sql_script, ';', ''));
        -- execute_sqlsript(REGEXP_REPLACE(table_rec.sql_script, ';', ''));
        
        object_script_array.EXTEND;
        object_count := object_count + 1;
        object_script_array(object_count) := table_rec.sql_script ;
        
   END LOOP;
END deploy_table ;

FUNCTION deploy_all_objects RETURN data_script IS 
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'SCHEMA';
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('schema_name -> ' || object_rec.object_name);
          deploy_schema(object_rec.object_name);
          deploy_all_tables(object_rec.object_name);
       END LOOP;
       return object_script_array;
END deploy_all_objects ;

FUNCTION get_all_objects_scripts RETURN data_script IS 
BEGIN
   return deploy_all_objects;
END get_all_objects_scripts ;

-- --- For selected schema (begin)

PROCEDURE deploy_selected_schema(user_schema varchar2) IS 
CURSOR schema_cursor IS with inputs(str) as (
      select sql_script from md_generate where object_type = 'SCHEMA' and object_name = user_schema
    )
    SELECT LEVEL AS id,
    REGEXP_SUBSTR( str ,'(.*?)(;|$)', 1, LEVEL, NULL, 1 ) AS sqlscript
    FROM  inputs
    CONNECT BY LEVEL <= regexp_count(str, ';'); 
BEGIN
	FOR schema_rec IN schema_cursor LOOP
        dbms_output.put_line('SQLScript -> ' || schema_rec.sqlscript);
        selected_object_array.EXTEND;
        selected_object_count := selected_object_count + 1;
        selected_object_array(selected_object_count) := schema_rec.sqlscript ;
   END LOOP;
END deploy_selected_schema ;


PROCEDURE deploy_selected_table(table_name varchar2, user_schema varchar2) IS
CURSOR table_cursor IS 
      select sql_script from md_generate where object_type = 'TABLE' and SCHEMA_NAME = user_schema and object_name = table_name; 
BEGIN
	FOR table_rec IN table_cursor LOOP
        dbms_output.put_line('SQLScript -> ' || REGEXP_REPLACE(table_rec.sql_script, ';', ''));        
        selected_object_array.EXTEND;
        selected_object_count := selected_object_count + 1;
        selected_object_array(selected_object_count) := table_rec.sql_script ;
   END LOOP;
END deploy_selected_table ;

PROCEDURE deploy_selected_tables(user_schema varchar2) IS
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'TABLE' and SCHEMA_NAME = user_schema;
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('table_name -> ' || object_rec.object_name);
          deploy_selected_table(object_rec.object_name, user_schema);
       END LOOP;
END deploy_selected_tables ;


FUNCTION deploy_selected_objects ( schema_name_list varchar2 ) RETURN data_script IS 
   CURSOR object_cursor IS 
      select object_name from MD_GENERATE where OBJECT_TYPE= 'SCHEMA' and SCHEMA_NAME in (  
          WITH DATA AS ( SELECT schema_name_list str FROM dual )
               SELECT trim(regexp_substr(str, '[^,]+', 1, LEVEL)) str
          FROM DATA
          CONNECT BY instr(str, ',', 1, LEVEL - 1) > 0
      );
BEGIN
   FOR object_rec in object_cursor
    LOOP
       DBMS_OUTPUT.PUT_LINE('schema_name -> ' || object_rec.object_name);
       deploy_selected_schema(object_rec.object_name);
       deploy_selected_tables(object_rec.object_name);
    END LOOP;
    return selected_object_array;
END deploy_selected_objects ;


FUNCTION get_selected_objects_scripts ( schema_name_list varchar2 )  RETURN data_script IS 
BEGIN
   return deploy_selected_objects ( schema_name_list ) ;
END get_selected_objects_scripts ;

-- --- For selected schema (end)

-- All Schema Table Columns Default (BEGIN)

-- This is a common call for both all and selected schema
PROCEDURE deploy_table_defaults(table_name varchar2, user_schema varchar2) IS
CURSOR table_cursor IS 
      select sql_script from md_generate where object_type = 'TABLE_DEFAULT' and SCHEMA_NAME = user_schema and object_name = table_name; 
BEGIN
	FOR table_rec IN table_cursor LOOP
        dbms_output.put_line('SQLScript -> ' || REGEXP_REPLACE(table_rec.sql_script, ';', ''));        
        default_script_array.EXTEND;
        default_count := default_count + 1;
        default_script_array(default_count) := table_rec.sql_script ;
   END LOOP;
END deploy_table_defaults ;

PROCEDURE deploy_schema_table_defaults(user_schema varchar2) IS
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'TABLE' and SCHEMA_NAME = user_schema;
BEGIN
       FOR object_rec in object_cursor
       LOOP
          --DBMS_OUTPUT.PUT_LINE('table_name -> ' || object_rec.object_name);
          deploy_table_defaults(object_rec.object_name, user_schema);
       END LOOP;
END deploy_schema_table_defaults ;

FUNCTION deploy_all_default_objects RETURN data_script IS 
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'SCHEMA';
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('schema_name -> ' || object_rec.object_name);
          deploy_schema_table_defaults(object_rec.object_name);
       END LOOP;
       return default_script_array;
END deploy_all_default_objects ;

FUNCTION get_all_default_objects_scripts RETURN data_script IS 
BEGIN
   return deploy_all_default_objects;
END get_all_default_objects_scripts ;

-- All Schema Table Columns Default (END)

-- Selected Schema Table Columns Default (BEGIN)

FUNCTION deploy_selected_default_objects ( schema_name_list varchar2 ) RETURN data_script IS 
   CURSOR object_cursor IS 
      select object_name from MD_GENERATE where OBJECT_TYPE= 'SCHEMA' and SCHEMA_NAME in (  
          WITH DATA AS ( SELECT schema_name_list str FROM dual )
               SELECT trim(regexp_substr(str, '[^,]+', 1, LEVEL)) str
          FROM DATA
          CONNECT BY instr(str, ',', 1, LEVEL - 1) > 0
      );
BEGIN
   FOR object_rec in object_cursor
    LOOP
       DBMS_OUTPUT.PUT_LINE('schema_name -> ' || object_rec.object_name);
       deploy_schema_table_defaults(object_rec.object_name);
    END LOOP;
    return default_script_array;
END deploy_selected_default_objects ;

FUNCTION get_selected_default_objects_scripts ( schema_name_list varchar2 )  RETURN data_script IS 
BEGIN
   return deploy_selected_default_objects ( schema_name_list ) ;
END get_selected_default_objects_scripts ;

-- Selected Schema Table Columns Default (END)

-- ALL COMMENTS (BEGIN)

PROCEDURE deploy_comment_set(user_schema varchar2) IS
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'COMMENT' and SCHEMA_NAME = user_schema;
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('comment_name -> ' || object_rec.object_name);
          deploy_comment(object_rec.object_name, user_schema);
       END LOOP;
END deploy_comment_set ;

PROCEDURE deploy_comment(obj_name varchar2, user_schema varchar2) IS
CURSOR object_cursor IS 
      select sql_script from md_generate where object_type = 'COMMENT' and SCHEMA_NAME = user_schema and object_name = obj_name; 
BEGIN
	FOR obj_rec IN object_cursor LOOP
        dbms_output.put_line('SQLScript -> ' || REGEXP_REPLACE(obj_rec.sql_script, ';', ''));
        -- execute_sqlsript(REGEXP_REPLACE(table_rec.sql_script, ';', ''));
        
        comment_script_array.EXTEND;
        comment_count := comment_count + 1;
        comment_script_array(comment_count) := obj_rec.sql_script ;
   END LOOP;
END deploy_comment ;


FUNCTION deploy_all_comments RETURN data_script IS 
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'SCHEMA';
    
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('schema_name -> ' || object_rec.object_name);
          deploy_comment_set (object_rec.object_name);
       END LOOP;
       return comment_script_array;
END deploy_all_comments ;

FUNCTION get_all_comment_scripts RETURN data_script IS 
BEGIN
   return deploy_all_comments;
END get_all_comment_scripts ;

-- ALL COMMENTS (END)


-- For selected schema comments (begin)

PROCEDURE deploy_selected_comment(obj_name varchar2, user_schema varchar2) IS
CURSOR object_cursor IS 
      select sql_script from md_generate where object_type = 'COMMENT' and SCHEMA_NAME = user_schema and object_name = obj_name; 
BEGIN
	FOR obj_rec IN object_cursor LOOP
        dbms_output.put_line('SQLScript -> ' || REGEXP_REPLACE(obj_rec.sql_script, ';', ''));
        selected_comment_script_array.EXTEND;
        selected_comment_count := selected_comment_count + 1;
        selected_comment_script_array(selected_comment_count) := obj_rec.sql_script ;
   END LOOP;
END deploy_selected_comment ;

PROCEDURE deploy_selected_comment_set(user_schema varchar2) IS
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'COMMENT' and SCHEMA_NAME = user_schema;
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('comment_name -> ' || object_rec.object_name);
          deploy_selected_comment(object_rec.object_name, user_schema);
       END LOOP;
END deploy_selected_comment_set ;


FUNCTION deploy_selected_comments ( schema_name_list varchar2 )  RETURN data_script IS 
   CURSOR object_cursor IS 
      select object_name from MD_GENERATE where OBJECT_TYPE= 'SCHEMA' and SCHEMA_NAME in (  
          WITH DATA AS ( SELECT schema_name_list str FROM dual )
               SELECT trim(regexp_substr(str, '[^,]+', 1, LEVEL)) str
          FROM DATA
          CONNECT BY instr(str, ',', 1, LEVEL - 1) > 0
      );
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('schema_name -> ' || object_rec.object_name);
          deploy_selected_comment_set (object_rec.object_name);
       END LOOP;
       return selected_comment_script_array;
END deploy_selected_comments ;

FUNCTION get_selected_comment_scripts ( schema_name_list varchar2 ) RETURN data_script IS 
BEGIN
   return deploy_selected_comments ( schema_name_list );
END get_selected_comment_scripts ;

-- For selected schema comments (end)


PROCEDURE deploy_external_tables(table_name varchar2, user_schema varchar2) IS
CURSOR table_cursor IS 
      select sql_script from md_generate where object_type = 'EXTERNAL' and SCHEMA_NAME = user_schema and object_name = table_name; 
BEGIN
	FOR table_rec IN table_cursor LOOP
        dbms_output.put_line('SQLScript -> ' || REGEXP_REPLACE(table_rec.sql_script, ';', ''));

        external_script_array.EXTEND;
        ext_tab_count := ext_tab_count + 1;
        external_script_array(ext_tab_count) := table_rec.sql_script ;
   END LOOP;
END deploy_external_tables ;

PROCEDURE deploy_all_external_tables(user_schema varchar2) IS
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'EXTERNAL' and SCHEMA_NAME = user_schema;
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('External Table_name -> ' || object_rec.object_name);
          deploy_external_tables(object_rec.object_name, user_schema);
       END LOOP;
END deploy_all_external_tables ;

FUNCTION get_all_external_tables_scripts RETURN data_script IS 
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'SCHEMA';
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('schema_name -> ' || object_rec.object_name);
          deploy_all_external_tables(object_rec.object_name);
       END LOOP;
       return external_script_array;
END get_all_external_tables_scripts ;

PROCEDURE drop_tables IS
script varchar2(4000);
CURSOR table_object IS select object_name from md_generate where OBJECT_TYPE='TABLE';
BEGIN
  FOR table_rec in table_object
   LOOP
      script := null;
      script := 'DROP TABLE ' || table_rec.object_name ;
      DBMS_OUTPUT.PUT_LINE('sqlscript ->');
      DBMS_OUTPUT.PUT_LINE(script);
      execute_sqlsript(script);
   END LOOP;
END drop_tables;

FUNCTION get_all_redshift_unload_scripts RETURN data_script IS 
    CURSOR unload_cursor IS select sql_script from md_generate where OBJECT_TYPE= 'UNLOAD';
    i_count NUMBER;
    unload_script_array data_script := data_script();   
BEGIN
       i_count := 0;
       FOR unload_rec in unload_cursor
       LOOP
          unload_script_array.EXTEND;
          i_count := i_count + 1;
          DBMS_OUTPUT.PUT_LINE('unload_script -> ' || unload_rec.sql_script);
		  unload_script_array(i_count) := unload_rec.sql_script ;
       END LOOP;
       return unload_script_array;

END get_all_redshift_unload_scripts ;

FUNCTION get_all_redshift_dataload_scripts RETURN data_script IS 
    CURSOR dataload_cursor IS select sql_script from md_generate where OBJECT_TYPE= 'OCA_COPY_DATA';
    i_count NUMBER;
    dataload_script_array data_script := data_script();   
BEGIN
       i_count := 0;
       FOR dataload_rec in dataload_cursor
       LOOP
          dataload_script_array.EXTEND;
          i_count := i_count + 1;
          DBMS_OUTPUT.PUT_LINE('dataload_script -> ' || dataload_rec.sql_script);
		  dataload_script_array(i_count) := dataload_rec.sql_script ;
       END LOOP;
       return dataload_script_array;

END get_all_redshift_dataload_scripts ;


/*
PROCEDURE deploy_all_objects IS
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'SCHEMA';
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('schema_name -> ' || object_rec.object_name);
          deploy_schema(object_rec.object_name);
          deploy_all_tables(object_rec.object_name);
       END LOOP;
END deploy_all_objects ;

PROCEDURE deploy_schema(user_schema varchar2) IS
CURSOR schema_cursor IS with inputs(str) as (
      select sql_script from md_generate where object_type = 'SCHEMA' and object_name = user_schema
    )
    SELECT LEVEL AS id,
    REGEXP_SUBSTR( str ,'(.*?)(;|$)', 1, LEVEL, NULL, 1 ) AS sqlscript
    FROM  inputs
    CONNECT BY LEVEL <= regexp_count(str, ';'); 
BEGIN
	FOR schema_rec IN schema_cursor LOOP
        dbms_output.put_line('SQLScript -> ' || schema_rec.sqlscript);
        execute_sqlsript(schema_rec.sqlscript);
   END LOOP;
END deploy_schema ;

PROCEDURE deploy_all_tables(user_schema varchar2) IS
    CURSOR object_cursor IS select object_name from md_generate where OBJECT_TYPE= 'TABLE' and SCHEMA_NAME = user_schema;
BEGIN
       FOR object_rec in object_cursor
       LOOP
          DBMS_OUTPUT.PUT_LINE('table_name -> ' || object_rec.object_name);
          deploy_table(object_rec.object_name, user_schema);
       END LOOP;
END deploy_all_tables ;

PROCEDURE deploy_table(table_name varchar2, user_schema varchar2) IS
CURSOR table_cursor IS 
      select sql_script from md_generate where object_type = 'TABLE' and SCHEMA_NAME = user_schema and object_name = table_name; 
BEGIN
	FOR table_rec IN table_cursor LOOP
        dbms_output.put_line('SQLScript -> ' || REGEXP_REPLACE(table_rec.sql_script, ';', ''));
        execute_sqlsript(REGEXP_REPLACE(table_rec.sql_script, ';', ''));    
   END LOOP;
END deploy_table ;

PROCEDURE DeployAll IS
BEGIN
   deploy_all_objects;
   -- deploy_all_tables;
END DeployAll ;
*/ 

--
-- This is file writing code 
--  

    PROCEDURE write_to_sqlfile(sqlScript varchar2) IS
    BEGIN
    
      UTL_FILE.PUTF(sqlFileHandler, sqlScript);
      UTL_FILE.PUTF(sqlFileHandler, '\n');
      
    END write_to_sqlfile ;
    
    PROCEDURE write_to_pwddef(sqlScript varchar2) IS
    BEGIN
    
      UTL_FILE.PUTF(pwdDefFileHandler, sqlScript);
      UTL_FILE.PUTF(pwdDefFileHandler, '\n');
      
    END write_to_pwddef ;
    
    PROCEDURE write_to_master(sqlScript varchar2) IS
    BEGIN
    
      UTL_FILE.PUTF(masterFileHandler, sqlScript);
      UTL_FILE.PUTF(masterFileHandler, '\n');
      
    END write_to_master ;

    PROCEDURE open_write_pwddef IS
    BEGIN
      pwdDefFileHandler := UTL_FILE.FOPEN('SQLDEV_DEPLOY', pwdDefName, 'w');
     
     EXCEPTION
       WHEN utl_file.invalid_path THEN
            raise_application_error(-20000, 'ERROR: Invalid PATH FOR file.');
    END open_write_pwddef ;
    
   PROCEDURE write_pwddef_file IS
    CURSOR schema_name IS select object_name from md_generate where OBJECT_TYPE='SCHEMA';
    BEGIN
      write_to_pwddef(
    '/* 
    Please edit this file to define your passwords.
    By default, currently they are same as the user name.
    */'
    );
        FOR schema_rec in schema_name
        LOOP
            write_to_pwddef('-- Password for '|| schema_rec.object_name ||' user');
            write_to_pwddef('define '|| schema_rec.object_name ||'_pwd=' || schema_rec.object_name );
        END LOOP;
        
    END write_pwddef_file ;
    
    PROCEDURE open_write_file IS
    BEGIN
      sqlFileHandler := UTL_FILE.FOPEN('SQLDEV_DEPLOY', sqlScriptName, 'w');
     
     EXCEPTION
       WHEN utl_file.invalid_path THEN
            raise_application_error(-20000, 'ERROR: Invalid PATH FOR file.');
    END open_write_file ;  

    PROCEDURE close_write_files IS
    BEGIN
      UTL_FILE.FCLOSE(sqlFileHandler);
      UTL_FILE.FCLOSE(pwdDefFileHandler);
      UTL_FILE.FCLOSE(masterFileHandler);
      
    END close_write_files ;
    
       PROCEDURE write_schema_sqlscript(generateVersion in NUMBER) IS
    script varchar2(4000);
    CURSOR schema_object IS select sql_script from md_generate where OBJECT_TYPE='SCHEMA' and GENERATE_VERSION=generateVersion;
    BEGIN
       FOR schema_rec in schema_object
       LOOP
          write_to_sqlfile(schema_rec.sql_script);
       END LOOP;
    END write_schema_sqlscript ;
    
    PROCEDURE write_drop_schema_sqlscript(generateVersion in NUMBER) IS
    script varchar2(4000);
    CURSOR schema_object IS select object_name from md_generate where OBJECT_TYPE='SCHEMA' and GENERATE_VERSION=generateVersion;
    BEGIN

       FOR schema_rec in schema_object
       LOOP
          write_to_sqlfile('PROMPT DROP USER ' || schema_rec.object_name);
          write_to_sqlfile('DROP USER ' || schema_rec.object_name || ' CASCADE;');
       END LOOP;
          write_to_sqlfile('\n');
    END write_drop_schema_sqlscript ;
    
    PROCEDURE write_all_schema_objects(generateVersion in NUMBER) IS
    CURSOR schema_name IS select object_name from md_generate where OBJECT_TYPE='SCHEMA' and GENERATE_VERSION=generateVersion;
    BEGIN
       FOR schema_rec in schema_name
       LOOP
          write_to_sqlfile('connect '||schema_rec.object_name|| '/' || '&&'||schema_rec.object_name||'_pwd');
          
          --write_to_sqlfile('REM Generate all Tables for Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'TABLE', generateVersion);
          --write_to_sqlfile('\n');
          
          --write_to_sqlfile('REM Generate all Sequence in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'SEQUENCE', generateVersion);
          --write_to_sqlfile('\n');
          
          --write_to_sqlfile('REM Generate all Comments in Schema ' || schema_rec.object_name);
       --   write_objecttype_sqlscript(schema_rec.object_name, 'COMMENT', generateVersion);
          --write_to_sqlfile('\n');
          
          --write_to_sqlfile('REM Generate all Primary Keys of Tables in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'PRIMARY_KEY', generateVersion);
          --write_to_sqlfile('\n');
        
         -- write_to_sqlfile('REM Generate all Unique Keys of Tables in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'UNIQUE_KEY', generateVersion);
          --write_to_sqlfile('\n');
          
          --write_to_sqlfile('REM Generate all Check Constraints of Tables in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'CHECK', generateVersion);
          --write_to_sqlfile('\n');
          
          --write_to_sqlfile('REM Generate all Table Defaults Tables in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'TABLE_DEFAULT', generateVersion);
          --write_to_sqlfile('\n');
          
          --write_to_sqlfile('REM Generate all Index in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'INDEX', generateVersion);
          --write_to_sqlfile('\n');
          
          --write_to_sqlfile('REM Generate all Views in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'VIEW', generateVersion);
          --write_to_sqlfile('\n');
          
          --write_to_sqlfile('REM Generate all Stored Programs in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'STORED_PROGRAM', generateVersion);
          --write_to_sqlfile('\n');
          
          --write_to_sqlfile('REM Generate all Packages in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'PACKAGE', generateVersion);
          --write_to_sqlfile('\n');
          
          --write_to_sqlfile('REM Generate all Triggers in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'TRIGGER', generateVersion);
          --write_to_sqlfile('\n');
          
          --write_to_sqlfile('REM Generate all Synonyms in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'SYNONYM', generateVersion);
          --write_to_sqlfile('\n');
             
       END LOOP;
       
       FOR schema_rec in schema_name
       LOOP
          write_to_sqlfile('connect '||schema_rec.object_name|| '/' || '&&'||schema_rec.object_name||'_pwd');
          
          write_to_sqlfile('REM Generate all Foreign Keys in Schema ' || schema_rec.object_name);
          write_objecttype_sqlscript(schema_rec.object_name, 'FOREIGN_KEY', generateVersion);
          write_to_sqlfile('\n');
             
       END LOOP;
       
    END write_all_schema_objects ;
    
    PROCEDURE write_objecttype_sqlscript(user_schema varchar2, type_object varchar2, generateVersion in NUMBER) IS
    CURSOR object_cursor IS select sql_script from md_generate where OBJECT_TYPE= type_object and SCHEMA_NAME = user_schema and GENERATE_VERSION=generateVersion;
    BEGIN
       --DBMS_OUTPUT.PUT_LINE('schema_name -> ' || user_schema);
       FOR object_rec in object_cursor
       LOOP
          write_to_sqlfile(object_rec.sql_script);
       END LOOP;
    END write_objecttype_sqlscript ;
    
        PROCEDURE open_write_master IS
    BEGIN
      masterFileHandler := UTL_FILE.FOPEN('SQLDEV_DEPLOY', masterFileName, 'w');
     
     EXCEPTION
       WHEN utl_file.invalid_path THEN
            raise_application_error(-20000, 'ERROR: Invalid PATH FOR file.');
    END open_write_master ;
    
    PROCEDURE write_master_file IS
    BEGIN
      write_to_master('prompt Run PasswordDefination.sql file');
      write_to_master('@@'||pwdDefName);
      
      write_to_master('prompt Run GenerateSQLScripts.sql file');
      write_to_master('@@'||sqlScriptName);
     
    END write_master_file ;
    
    
    PROCEDURE write_sqlfile_header IS
    BEGIN
        write_to_sqlfile('SET ECHO ON');
        write_to_sqlfile('SET VERIFY OFF');
        write_to_sqlfile('SET FEEDBACK ON');
        write_to_sqlfile('SET CLASSIC OFF');
        write_to_sqlfile('set serveroutput on');
        write_to_sqlfile('COLUMN date_time NEW_VAL filename noprint;');
        write_to_sqlfile('SELECT to_char(systimestamp,'|| '''yyyy-mm-dd_hh24-mi-ssxff'''||') date_time FROM DUAL;');
        write_to_sqlfile('spool output.log');
    
    END write_sqlfile_header ;
    
    
    PROCEDURE write_sqlfile_footer IS
    BEGIN
        write_to_sqlfile('spool off');
    
    END write_sqlfile_footer ;

  PROCEDURE WriteAllObjectToFile(generateVersion in NUMBER) IS
    BEGIN
     --  create_oracle_directory;
     DBMS_OUTPUT.PUT_LINE('1');
       open_write_pwddef;
     DBMS_OUTPUT.PUT_LINE('2');
       write_pwddef_file;
     DBMS_OUTPUT.PUT_LINE('3');
       open_write_file;
       write_sqlfile_header;
       write_drop_schema_sqlscript(generateVersion);
       write_schema_sqlscript(generateVersion);
       write_all_schema_objects(generateVersion);
       write_sqlfile_footer;
       open_write_master;
       write_master_file;
       close_write_files;
    END WriteAllObjectToFile ;


END REDSHIFT_DEPLOY;
/