/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.javafx.embed.swing.newimpl;

import com.sun.javafx.embed.swing.FXDnDInterop;
import com.sun.javafx.embed.swing.InteropFactory;
import com.sun.javafx.embed.swing.JFXPanelInterop;
import com.sun.javafx.embed.swing.SwingFXUtilsImplInterop;
import com.sun.javafx.embed.swing.SwingNodeInterop;

public class InteropFactoryN extends InteropFactory {

    public InteropFactoryN() throws Exception {
        Class swiopClass = Class.forName("jdk.swing.interop.LightweightFrameWrapper");
    }

    @Override
    public SwingNodeInterop createSwingNodeImpl() {
        return new SwingNodeInteropN();
    }

    @Override
    public JFXPanelInterop createJFXPanelImpl() {
        return new JFXPanelInteropN();
    }

    @Override
    public FXDnDInterop createFXDnDImpl() {
        return new FXDnDInteropN();
    }

    @Override
    public SwingFXUtilsImplInterop createSwingFXUtilsImpl() {
        return new SwingFXUtilsImplInteropN();
    }
}
