/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.javafx.embed.swing;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.Window;
import javafx.embed.swing.JFXPanel;

public abstract class JFXPanelInterop {
    public abstract void postEvent(JFXPanel panel, AWTEvent e);

    public abstract boolean isUngrabEvent(AWTEvent event);

    public abstract long getMask();

    public abstract void grab(Toolkit toolkit, Window w);

    public abstract void ungrab(Toolkit toolkit, Window w);
}
