 # @(#)master.sh
 #
 # Copyright 2006 by Oracle Corporation,
 # 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 # All rights reserved.
 #
 # This software is the confidential and proprietary information
 # of Oracle Corporation. 
 
#export user=SET_USER_NAME
#export password=SET_THE_PASSWORD
#export host=SET_THE_HOST

export SEED=$RANDOM

ERROR_CONDITION="N"
if [[ "$1" == "" ]]; then 
   ERROR_CONDITION="Y"
fi

if [[ "$2" == "" ]]; then 
   ERROR_CONDITION="Y"   
fi

if [[ "$3" == "" ]]; then 
   ERROR_CONDITION="Y"
fi


if [[ $ERROR_CONDITION = "Y" ]]; then
echo Usage:
echo "master.sh <user> <password> <host>" 

else

echo "SEED="$SEED >> mysql3.ocp

echo "SELECT VERSION()" > version$SEED.sql

mysql -u"$1" -p"$2" -h"$3" < version$SEED.sql >version$SEED.txt

echo SHOW DATABASES > showdatabases.sql

mysql -u"$1" -p"$2" -h"$3" < showdatabases.sql >temp_databases$SEED.txt

temp_db_file=temp_databases$SEED.txt
while read token
do
if [[ "$token" != "mysql" ]]; then
 if [[ "$token" != "Database" ]]; then
      ./get_table.sh "$token" "$1" "$2" "$3"
 fi
fi
done < $temp_db_file

echo table_info=all_tabs$SEED.txt >> mysql3.ocp

echo column_table_info=all_col_data_tabs$SEED.txt >> mysql3.ocp

echo constraint_table_info=all_constraints_tabs$SEED.txt >> mysql3.ocp

echo max_column_info=all_cols_tabs$SEED.txt >> mysql3.ocp

echo index_info=all_index_data_tabs$SEED.txt >> mysql3.ocp

echo version_info=version$SEED.txt >> mysql3.ocp

echo Offline MySQL File Generation Completed

echo Processing completed - files generated for MySQL Offline

fi
