<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:oja="http://xmlns.oracle.com/jdeveloper/1013/audit">
  
  <!-- 
  - Converts Audit report XML to a compiler-like text log in which each
  - violation is described by a line containing file, line number, and
  - message formatted as follows:
  -    file:line: message
  -->
  

  <!--
  - This style sheet outputs plain text, by default using the UTF-8 encoding. 
  - When Audit applies the style sheet, it overrides the encoding attribute to 
  - the global JDeveloper encoding.
  -->
  <xsl:output method="text"/>


  <!--
  - The character sequence to use when outputting a line break.
  -
  - Unlike XML document consumers, some text document consumers expect a
  - particular line terminator sequence. Audit generates the XML document
  - using the line terminator indicated in the JDeveloper environment options,
  - and sets this parameter to the same line terminator sequence so that a 
  - careful style sheet can ensure that the output file has consistent
  - line terminators.
  -->
  <xsl:param name="newline">
<xsl:text>
</xsl:text>
  </xsl:param>

  <!-- 
  -  Apply a template to each violation in the tree.
  -->
  <xsl:template match="/">
    <xsl:if test="string-length(/oja:audit/oja:title) > 0">
      <xsl:value-of select="/oja:audit/oja:title"/>
      <xsl:value-of select="$newline"/>
    </xsl:if>
    <xsl:apply-templates select="/oja:audit/oja:construct/oja:children//oja:violation"/>
  </xsl:template>

  <!--
  - For a violation, apply a template to the location and output the value of
  - the <message> element, followed by a line break.
  -->
  <xsl:template match="oja:violation">
    <xsl:variable name="transforms" select="oja:transforms-applied/oja:transform-applied"/>
    <xsl:apply-templates select="oja:location"/><xsl:text>: </xsl:text>
    <xsl:value-of select="oja:values/oja:value"/><xsl:text>: </xsl:text>
    <xsl:value-of select="oja:rule/oja:name"/>
    <xsl:value-of select="oja:message"/>
    <xsl:if test="count($transforms) > 0">
      <xsl:text> (</xsl:text><xsl:apply-templates select="$transforms"/><xsl:text> applied)</xsl:text>
    </xsl:if>
    <xsl:text> [</xsl:text><xsl:value-of select="id(@rule)/oja:name"/><xsl:text>]</xsl:text>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <!--
  - For a location, output the model file path, line number, and applied 
  - transforms (if any). The model is obtained by dereferencing the model 
  - attribute of the location.
  -->
  <xsl:template match="oja:location">
    <xsl:value-of select="id(@model)/oja:file/oja:path"/>:<xsl:value-of select="oja:line-number"/>
  </xsl:template>
  
  <!--
  - For an applied transform, output the transform name.
  -->
  <xsl:template match="oja:transform-applied">
    <xsl:value-of select="id(@transform)/oja:label"/>
  </xsl:template>
  
</xsl:stylesheet>
