  -- apply result for test
  v_apply_data := generateUniqueName;
  execSQL('CREATE TABLE '||v_apply_data||' <TABLE_PARALLEL_HINT> as SELECT <PARALLEL_HINT> "'||v_caseid||'", ora_dm_partition_name(<MODEL_NAME_PARAM> USING *) PARTITION_NAME, PREDICTION(<MODEL_NAME_PARAM> USING *) PRED FROM '||v_test_data);
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_apply_data, 'TABLE', NULL, 'Apply Data');

  v_index := generateUniqueName;
  execSQL('CREATE INDEX '||v_index||' ON '||v_apply_data||' (PARTITION_NAME) <TABLE_PARALLEL_HINT>');

  -- test metric
  v_test_metric := generateUniqueName;
  execSQL('CREATE TABLE '||v_test_metric||' (METRIC_NAME VARCHAR2(30), PARTITION_NAME VARCHAR2(128), METRIC_VARCHAR_VALUE VARCHAR2(128), METRIC_NUM_VALUE NUMBER) <TABLE_PARALLEL_HINT> <COMPRESSION_METHOD> <PRIORITY_LEVEL>');
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_test_metric, 'TABLE', NULL, 'Test Metric');

  v_index := generateUniqueName;
  execSQL('CREATE INDEX '||v_index||' ON '||v_test_metric||' (PARTITION_NAME) <TABLE_PARALLEL_HINT>');

  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_VARCHAR_VALUE) VALUES (''MODEL_SCHEMA'', NULL, SUBSTR(''<MODEL_NAME_PARAM>'', 1 ,INSTR(''<MODEL_NAME_PARAM>'', ''.'', 1, 1)-1))');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_VARCHAR_VALUE) VALUES (''MODEL_NAME'', NULL, SUBSTR(''<MODEL_NAME_PARAM>'', INSTR(''<MODEL_NAME_PARAM>'',''.'', -1, 1)+1))');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_VARCHAR_VALUE) VALUES (''MINING_FUNCTION'', NULL, ''REGRESSION'')');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_VARCHAR_VALUE) VALUES (''TARGET_ATTRIBUTE'', NULL, '''||v_target||''')');

  v_sql := 
   'INSERT <PARALLEL_HINT> INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE)
    SELECT ''TEST_ROWS'', NVL(ora_dm_partition_name(<MODEL_NAME_PARAM> using *), ''DM$$UNKNOWN''), count(*)
    FROM '||v_test_data||'
    GROUP BY ora_dm_partition_name(<MODEL_NAME_PARAM> using *)
    UNION
    SELECT ''TEST_ROWS'', NULL, count(*) FROM '||v_test_data;
  execSQL(v_sql);

  -- 1. Root Mean Square Error - Sqrt(Mean((x - x')^2))
  v_sql := '
  INSERT <PARALLEL_HINT> INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE)
  SELECT <PARALLEL_HINT> ''MEAN_RMS_ERROR'', NULL, SQRT(AVG(POWER((A.PRED - (B."'||v_target||'")), 2))) rmse
    FROM '||v_apply_data||' A,
         '||v_test_data||' B
  WHERE A."'||v_caseid||'" = B."'||v_caseid||'"
  UNION
  SELECT <PARALLEL_HINT> ''MEAN_RMS_ERROR'', A.PARTITION_NAME, SQRT(AVG(POWER((A.PRED - (B."'||v_target||'")), 2))) rmse
    FROM '||v_apply_data||' A,
         '||v_test_data||' B
  WHERE A."'||v_caseid||'" = B."'||v_caseid||'"
  GROUP BY A.PARTITION_NAME';
  execSQL(v_sql);

  -- 2. Mean Absolute Error - Mean(|(x - x')|)
  v_sql := '
  INSERT <PARALLEL_HINT> INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE)
  SELECT <PARALLEL_HINT> ''MEAN_ABSOLUTE_ERROR'', NULL, AVG(ABS(A.PRED - B."'||v_target||'")) mae
    FROM '||v_apply_data||' A,
         '||v_test_data||' B
    WHERE A."'||v_caseid||'" = B."'||v_caseid||'"
  UNION
  SELECT <PARALLEL_HINT> ''MEAN_ABSOLUTE_ERROR'', A.PARTITION_NAME, AVG(ABS(A.PRED - B."'||v_target||'")) mae
    FROM '||v_apply_data||' A,
         '||v_test_data||' B
    WHERE A."'||v_caseid||'" = B."'||v_caseid||'" 
    GROUP BY A.PARTITION_NAME';
  execSQL(v_sql);

  -- 3. Mean Actual Value
  v_sql := '
  INSERT <PARALLEL_HINT> INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE)
  SELECT <PARALLEL_HINT> ''MEAN_ACTUAL_VALUE'', NULL, AVG("'||v_target||'") as mean_actual_value
    FROM '||v_test_data||'
  UNION
  SELECT <PARALLEL_HINT> ''MEAN_ACTUAL_VALUE'', A.PARTITION_NAME, AVG(B."'||v_target||'") mean_actual_value
    FROM '||v_apply_data||' A,
         '||v_test_data||' B
    WHERE A."'||v_caseid||'" = B."'||v_caseid||'" 
    GROUP BY A.PARTITION_NAME';
  execSQL(v_sql);

  -- 4. Mean Predicted Value
  v_sql := '
  INSERT <PARALLEL_HINT> INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE)
  SELECT <PARALLEL_HINT> ''MEAN_PREDICATED_VALUE'', NULL, AVG(A.PRED) mean_predicted_value
    FROM '||v_apply_data||' A
  UNION
  SELECT <PARALLEL_HINT> ''MEAN_PREDICATED_VALUE'', A.PARTITION_NAME, AVG(A.PRED) mean_predicted_value
    FROM '||v_apply_data||' A
    GROUP BY A.PARTITION_NAME';
  execSQL(v_sql);

  -- Overall predictive Confidence = 1 - ((Error of Predict)/(Error of naive model))
  v_sql := '
  INSERT <PARALLEL_HINT> INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE)
  SELECT <PARALLEL_HINT> ''PREDICTIVE_CONFIDENCE'', NULL, GREATEST(0, ((1 - a.rmse / GREATEST(0.0001, b.ne)) * 100))
  FROM (
    SELECT SQRT(AVG(POWER((A.PRED - (B."'||v_target||'")), 2))) rmse
      FROM '||v_apply_data||' A,
           '||v_test_data||' B
     WHERE A."'||v_caseid||'" = B."'||v_caseid||'"
  ) a, 
  (
    SELECT SQRT(count(*)/GREATEST(0.0001, (count(*)-1)) * variance("'||v_target||'")) ne
      FROM '||v_apply_data||' A,
           '||v_test_data||' B
    WHERE A."'||v_caseid||'" = B."'||v_caseid||'"
  ) b 
  UNION
  SELECT <PARALLEL_HINT> ''PREDICTIVE_CONFIDENCE'', A.PARTITION_NAME, GREATEST(0, ((1 - a.rmse / GREATEST(0.0001, b.ne)) * 100))
  FROM (
    SELECT A.PARTITION_NAME, SQRT(AVG(POWER((A.PRED - (B."'||v_target||'")), 2))) rmse
      FROM '||v_apply_data||' A,
           '||v_test_data||' B
     WHERE A."'||v_caseid||'" = B."'||v_caseid||'" GROUP BY A.PARTITION_NAME          
  ) a, 
  (
    SELECT A.PARTITION_NAME, SQRT(count(*)/GREATEST(0.0001, (count(*)-1)) * variance("'||v_target||'")) ne
      FROM '||v_apply_data||' A,
           '||v_test_data||' B
    WHERE A."'||v_caseid||'" = B."'||v_caseid||'" GROUP BY A.PARTITION_NAME          
  ) b 
  WHERE a.PARTITION_NAME = b.PARTITION_NAME';
  execSQL(v_sql);

<RESIDUAL_PLOT>