  -- data usage view
  v_data_usage := generateUniqueName;
  _START_CHECK_SQL_SIZE_
  v_sql := 
    'CREATE VIEW '||v_data_usage||' AS SELECT <PARALLEL_HINT> "'||v_caseid||'", 
<DATA_USAGE_ATTRIBUTES> 
    FROM '||v_build_data;
  execSQL(v_sql);
  _END_CHECK_SQL_SIZE_
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_data_usage, 'VIEW', NULL, 'Data Usage');
<DATA_USAGE_TRANSFORMATIONS>
<WEIGHTS_SETTING>
  -- build setting
  v_build_setting := generateUniqueName;
<BUILD_SETTING>
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_build_setting, 'TABLE', NULL, 'Build Setting');

  -- model build
  IF (v_drop = 'TRUE') THEN -- delete any existing model?
    BEGIN
      DBMS_DATA_MINING.DROP_MODEL('<MODEL_NAME_PARAM>', TRUE);
    EXCEPTION WHEN OTHERS THEN
      NULL; -- ignore if no existing model to drop
    END;
  END IF;
  DBMS_DATA_MINING.CREATE_MODEL(
    model_name          => '<MODEL_NAME_PARAM>',
    mining_function     => DBMS_DATA_MINING.CLASSIFICATION,
    data_table_name     => v_data_usage,
    case_id_column_name => '"'||v_caseid||'"',
    target_column_name  => '"'||v_target||'"',
    settings_table_name => v_build_setting,
    xform_list          => v_xlst);
<COMMENT_MODEL>
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', '<MODEL_NAME_PARAM>', 'MODEL', NULL, 'Model');

<TEST_MODELS>