-- Upgrade script for Reporting Schema from DM 4.0 (4.0.0.833) to DM 4.1


--==========CREATE TABLES==========
CREATE TABLE DMRS_TABLE_ARCS (
Object_OVID VARCHAR2 (36) NOT NULL,
Object_ID VARCHAR2 (70) NOT NULL,
Arc_Name VARCHAR2 (256) NOT NULL,
Table_OVID VARCHAR2 (36) NOT NULL,
Table_ID VARCHAR2 (36) NOT NULL,
Mandatory CHAR (1) NOT NULL,
Discriminator_Column_ID VARCHAR2 (36),
Model_Name VARCHAR2 (256),
Model_OVID VARCHAR2 (36) NOT NULL,
Design_OVID VARCHAR2 (36) NOT NULL);

CREATE TABLE DMRS_ENTITY_ARCS (
Object_OVID VARCHAR2 (36) NOT NULL,
Object_ID VARCHAR2 (70) NOT NULL,
Arc_Name VARCHAR2 (256) NOT NULL,
Entity_ID VARCHAR2 (36) NOT NULL,
Model_Name VARCHAR2 (256),
Model_OVID VARCHAR2 (36) NOT NULL,
Design_OVID VARCHAR2 (36) NOT NULL);

CREATE TABLE DMRS_SENSITIVE_TYPES (
Object_OVID VARCHAR2 (36) NOT NULL,
Object_ID VARCHAR2 (70) NOT NULL,
Sensitive_Type_Name VARCHAR2 (256) NOT NULL);

CREATE TABLE DMRS_TSDP_POLICIES (
Object_OVID VARCHAR2 (36) NOT NULL,
Object_ID VARCHAR2 (70) NOT NULL,
TSDP_Policy_Name VARCHAR2 (256) NOT NULL);

CREATE TABLE DMRS_TSDP_SUB_POLICIES (
Object_OVID VARCHAR2 (36) NOT NULL,
Object_ID VARCHAR2 (70) NOT NULL,
Container_ID VARCHAR2 (70) NOT NULL,
Container_OVID VARCHAR2 (36) NOT NULL,
Container_Name VARCHAR2 (50) NOT NULL,
TSDP_SubPolicy_Name VARCHAR2 (256) NOT NULL,
Expression VARCHAR2 (256),
Mask_Type VARCHAR2 (10),
Mask_Template VARCHAR2 (50),
Datatype VARCHAR2 (50),
Length VARCHAR2 (10),
Parent_Schema VARCHAR2 (50),
Parent_Table VARCHAR2 (50));

CREATE TABLE DMRS_MASK_TEMPLATES (
Object_OVID VARCHAR2 (36) NOT NULL,
Object_ID VARCHAR2 (70) NOT NULL,
Mask_Template_Name VARCHAR2 (50) NOT NULL,
Function_Type VARCHAR2 (10) NOT NULL,
Data_Type VARCHAR2 (10) NOT NULL,
Input_Format VARCHAR2 (50),
Output_Format VARCHAR2 (50),
Mask_Char VARCHAR2 (50),
Mask_From NUMBER,
Mask_To NUMBER,
Pattern VARCHAR2 (50),
Replace_String VARCHAR2 (50),
Position NUMBER,
Occurrence NUMBER,
Match_Parameter VARCHAR2 (50),
Month VARCHAR2 (10),
Day VARCHAR2 (10),
Year VARCHAR2 (10),
Hour VARCHAR2 (10),
Minute VARCHAR2 (10),
Second VARCHAR2 (10),
Design_OVID VARCHAR2 (36) NOT NULL);

CREATE TABLE DMRS_EXISTENCE_DEP (
Object_OVID VARCHAR2 (36) NOT NULL,
Dependency_Name VARCHAR2 (256) NOT NULL,
Table_OVID VARCHAR2 (36) NOT NULL,
Generation_Level VARCHAR2 (20) NOT NULL,
Discriminator_Column_OVID VARCHAR2 (36),
Discriminator_Column_Name VARCHAR2 (256),
Model_Name VARCHAR2 (256),
Model_OVID VARCHAR2 (36) NOT NULL,
Design_OVID VARCHAR2 (36) NOT NULL);

CREATE TABLE DMRS_EXISTENCE_DEP_COLUMNS (
Dependency_OVID VARCHAR2 (36) NOT NULL,
Discriminator_Value VARCHAR2 (50),
Table_Name VARCHAR2 (256) NOT NULL,
Table_OVID VARCHAR2 (36) NOT NULL,
Column_Name VARCHAR2 (256) NOT NULL,
Column_OVID VARCHAR2 (36) NOT NULL,
Depend_As_Mandatory VARCHAR2 (1),
Depend VARCHAR2 (1),
Design_OVID VARCHAR2 (36) NOT NULL);

CREATE TABLE DMRS_FK_CD_CONSTRAINTS (
Fk_OVID VARCHAR2 (36) NOT NULL,
Constraint_OVID VARCHAR2 (36) NOT NULL,
Constraint_Name VARCHAR2 (256) NOT NULL,
Model_OVID VARCHAR2 (36) NOT NULL,
Design_OVID VARCHAR2 (36) NOT NULL);

CREATE TABLE DMRS_FK_CD_CONSTRAINTS_COLS (
Constraint_OVID VARCHAR2 (36) NOT NULL,
Column_OVID VARCHAR2 (36) NOT NULL,
Depend_As_Mandatory VARCHAR2 (1),
Depend VARCHAR2 (1),
Model_OVID VARCHAR2 (36) NOT NULL,
Design_OVID VARCHAR2 (36) NOT NULL);

CREATE TABLE DMRS_ADDITIONAL_CT_OBJECTS (
Type_OVID VARCHAR2 (36) NOT NULL,
Object_OVID VARCHAR2 (36) NOT NULL,
Object_ID VARCHAR2 (36) NOT NULL,
Object_Type VARCHAR2 (10),
Model_OVID VARCHAR2 (36) NOT NULL,
Design_OVID VARCHAR2 (36) NOT NULL);

--==========ALTER TABLES==========
ALTER TABLE DMRS_COLUMNS ADD (
Sensitive_Type_OVID VARCHAR2 (36), 
Sensitive_Data_Descr VARCHAR2 (256), 
Contains_PII VARCHAR2 (3),
Mask_Type VARCHAR2 (10),
Mask_Tymplate_OVID VARCHAR2 (36));

ALTER TABLE DMRS_ATTRIBUTES ADD (
Sensitive_Type_OVID VARCHAR2 (36), 
Sensitive_Data_Descr VARCHAR2 (256));

ALTER TABLE DMRS_DOMAINS ADD (
Sensitive_Type_OVID VARCHAR2 (36), 
Sensitive_Data_Descr VARCHAR2 (256));

ALTER TABLE DMRS_ENTITIES ADD (
Create_Surrogate_Key VARCHAR2 (1),
Subt_Subtree_Generation VARCHAR2 (30),
Subt_Apply_To_Model_OVID VARCHAR2 (36),
Subt_References VARCHAR2 (30),
Subt_Attributes_Inheritance VARCHAR2 (30),
Subt_Generate_Discriminator VARCHAR2 (1),
Subt_Use_Attribute_ID VARCHAR2 (36),
Subt_Discriminator_Column_Name VARCHAR2 (30),
Subt_Discriminator_Value VARCHAR2 (50),
Subt_Complete_Subtypes VARCHAR2 (1));

ALTER TABLE DMRS_TABLES ADD (
Engineer_As_Relationship VARCHAR2 (1),
Allow_Col_Reorder VARCHAR2 (1),
Redaction_Policy_Name VARCHAR2 (50),
Redaction_Policy_Enabled VARCHAR2 (1),
Redaction_Policy_Expression VARCHAR2 (50));

ALTER TABLE DMRS_FOREIGNKEYS ADD (
Discriminator_Column_OVID VARCHAR2 (36),
Discriminator_Value VARCHAR2 (50));

--=========INDEXES==========
CREATE INDEX ADDITIONAL_CLASS_TYPES_PK_IDX ON DMRS_ADDITIONAL_CT_OBJECTS (Type_OVID ASC) NOLOGGING;
CREATE INDEX TABLE_ARC_NAME_IDX ON DMRS_TABLE_ARCS (Object_OVID, Arc_NAME) NOLOGGING;
CREATE INDEX ENTITY_ARC_NAME_IDX ON DMRS_ENTITY_ARCS (Object_OVID, Arc_NAME) NOLOGGING;
CREATE INDEX SENSITIVE_TYPE_NAME_IDX ON DMRS_SENSITIVE_TYPES (Object_OVID, Sensitive_Type_Name) NOLOGGING;
CREATE INDEX TSDP_POLICY_NAME_IDX ON DMRS_TSDP_POLICIES (Object_OVID, TSDP_Policy_Name) NOLOGGING;
CREATE INDEX TSDP_SP_POLICY_NAME_IDX ON DMRS_TSDP_SUB_POLICIES (Object_OVID, TSDP_SubPolicy_Name) NOLOGGING;
CREATE INDEX MASK_TEMPLATE_NAME_IDX ON DMRS_MASK_TEMPLATES (Object_OVID, Mask_Template_Name) NOLOGGING;
CREATE INDEX EXISTENCE_DEP_NAME_IDX ON DMRS_EXISTENCE_DEP (Object_OVID, Dependency_Name) NOLOGGING;
CREATE INDEX EXISTENCE_DEP_COL_NAME_IDX ON DMRS_EXISTENCE_DEP_COLUMNS (Dependency_OVID, Table_OVID) NOLOGGING;
CREATE INDEX FK_CD_CONSTR_NAME_IDX ON DMRS_FK_CD_CONSTRAINTS (Fk_OVID, Constraint_OVID) NOLOGGING;
CREATE INDEX FK_CD_CONSTR_COL_NAME_IDX ON DMRS_FK_CD_CONSTRAINTS_COLS (Constraint_OVID, Column_OVID) NOLOGGING;