-- Creates a ODMR_MINING_DATA_TEXT table that contains pre 12.2 data from the MINING_DATA_TEXT_BUILD_V, 
-- MINING_DATA_TEXT_TEST_V AND MINING_DATA_TEXT_APPLY_V views. 
-- Paramters:
-- 1. User account - account to load the table into
-- Example:
-- @instMiningDataTxt.sql DMUSER
--------------------------------------------------------

EXECUTE dbms_output.put_line('');
EXECUTE dbms_output.put_line('Load Data Miner demo table ODMR_MINING_DATA_TEXT.');
EXECUTE dbms_output.put_line('');


-- Drop table if it already exists
-- NOTE: ERRORS ARE OK FOR THE DROP TABLE AS IT CONFIRMS THE TABLE DOES NOT EXIST
DECLARE
v_sql varchar2(100); 
user_account_value varchar2(120);
BEGIN

user_account_value := q'[&&1]';

-- Change to the new user schema
BEGIN
v_sql := 'ALTER session set current_schema = "' || user_account_value || '" ' ; -- Enter the user schema
EXECUTE IMMEDIATE v_sql;
DBMS_OUTPUT.PUT_LINE (v_sql ||': succeeded');
EXCEPTION
WHEN OTHERS THEN
DBMS_OUTPUT.PUT_LINE (v_sql ||': ***  Failed ***');
raise;
END;

v_sql := 'DROP TABLE ODMR_MINING_DATA_TEXT';
EXECUTE IMMEDIATE v_sql;
DBMS_OUTPUT.PUT_LINE (v_sql ||': succeeded');
EXCEPTION
WHEN OTHERS THEN
DBMS_OUTPUT.PUT_LINE (v_sql ||': drop unneccessary - no table/view exists');
END;
/

--------------------------------------------------------
--  DDL for Table ODMR_MINING_DATA_TEXT
--------------------------------------------------------

CREATE TABLE ODMR_MINING_DATA_TEXT ( 
CUST_ID                          NUMBER,         
CUST_GENDER                      CHAR(1),        
AGE                              NUMBER,
CUST_MARITAL_STATUS              VARCHAR2(20),
COUNTRY_NAME                     VARCHAR2(40),
CUST_INCOME_LEVEL                VARCHAR2(30),
EDUCATION                        VARCHAR2(21),
OCCUPATION                       VARCHAR2(21),
HOUSEHOLD_SIZE                   VARCHAR2(21),
YRS_RESIDENCE                    NUMBER,
AFFINITY_CARD                    NUMBER(10),
BULK_PACK_DISKETTES              NUMBER(10),
FLAT_PANEL_MONITOR               NUMBER(10),
HOME_THEATER_PACKAGE             NUMBER(10),
BOOKKEEPING_APPLICATION          NUMBER(10),
PRINTER_SUPPLIES                 NUMBER(10),
Y_BOX_GAMES                      NUMBER(10),
OS_DOC_SET_KANJI                 NUMBER(10),
COMMENTS                         VARCHAR2(4000) );

--------------------------------------------------------
--  Insert data from MINING_DATA_TEXT_BUILD_V into ODMR_MINING_DATA_TEXT
--------------------------------------------------------

REM INSERTING into ODMR_MINING_DATA_TEXT from view MINING_DATA_TEXT_BUILD_V

Insert all
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101501,'F',41,'NeverM','United States of America','J: 190,000 - 249,999','Masters','Prof.','2',4,0,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101502,'M',27,'NeverM','United States of America','I: 170,000 - 189,999','Bach.','Sales','2',3,0,1,1,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101503,'F',20,'NeverM','United States of America','H: 150,000 - 169,999','HS-grad','Cleric.','2',2,0,1,0,0,1,1,1,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101504,'M',45,'Married','United States of America','B: 30,000 - 49,999','Bach.','Exec.','3',5,1,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101505,'M',34,'NeverM','United States of America','K: 250,000 - 299,999','Masters','Sales','9+',5,1,1,1,0,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101506,'M',38,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Other','3',4,0,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101507,'M',28,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Sales','3',3,0,1,1,0,1,1,1,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101508,'M',19,'NeverM','United States of America','K: 250,000 - 299,999','HS-grad','Sales','2',2,0,1,1,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101509,'M',52,'Married','Brazil','K: 250,000 - 299,999','Bach.','Other','3',5,0,1,1,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101510,'M',27,'NeverM','United States of America','L: 300,000 and above','Bach.','Sales','2',3,1,1,1,0,1,1,1,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101511,'M',30,'NeverM','United States of America','H: 150,000 - 169,999','Bach.','Sales','2',5,0,1,0,0,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101512,'F',30,'NeverM','United States of America','I: 170,000 - 189,999','Profsc','Prof.','2',4,0,1,1,0,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101513,'M',31,'Married','United States of America','J: 190,000 - 249,999','Bach.','Sales','3',3,0,1,1,0,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101514,'M',45,'NeverM','United States of America','L: 300,000 and above','HS-grad','Sales','2',5,0,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101515,'F',36,'NeverM','United States of America','J: 190,000 - 249,999','11th','Other','9+',2,0,1,1,1,0,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101516,'M',33,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Exec.','3',4,0,0,0,0,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101517,'F',38,'NeverM','United States of America','I: 170,000 - 189,999','HS-grad','Sales','9+',4,0,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101518,'M',22,'NeverM','Argentina','L: 300,000 and above','5th-6th','Farming','6-8',2,0,1,1,0,0,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101519,'F',46,'Divorc.','Brazil','J: 190,000 - 249,999','< Bach.','Sales','9+',5,0,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101520,'M',39,'Married','United States of America','B: 30,000 - 49,999','HS-grad','Transp.','3',5,1,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101521,'M',61,'Married','United States of America','L: 300,000 and above','HS-grad','Other','3',6,0,1,1,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101522,'F',39,'NeverM','United States of America','J: 190,000 - 249,999','Masters','Prof.','2',4,1,1,1,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101523,'M',22,'Mabsent','United States of America','L: 300,000 and above','HS-grad','Sales','2',2,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101524,'M',38,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Machine','3',5,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101525,'F',18,'NeverM','United States of America','K: 250,000 - 299,999','HS-grad','Sales','1',1,0,1,1,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101526,'M',40,'Married','United States of America','I: 170,000 - 189,999','Profsc','Prof.','3',4,1,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101527,'M',19,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Cleric.','1',1,0,1,1,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101528,'M',52,'Separ.','United States of America','K: 250,000 - 299,999','HS-grad','Crafts','2',5,0,1,1,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101529,'M',22,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','Handler','1',2,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101530,'M',34,'Married','United States of America','H: 150,000 - 169,999','Bach.','Prof.','3',3,1,1,0,0,1,1,0,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101531,'M',28,'Married','Argentina','J: 190,000 - 249,999','< Bach.','Transp.','3',3,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101532,'M',37,'Divorc.','United States of America','C: 50,000 - 69,999','HS-grad','Machine','2',4,0,0,0,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101533,'F',48,'Mabsent','United States of America','G: 130,000 - 149,999','Bach.','Cleric.','9+',5,0,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101534,'M',38,'Married','Argentina','E: 90,000 - 109,999','Assoc-A','Other','3',4,0,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101535,'F',33,'NeverM','United States of America','L: 300,000 and above','Bach.','Prof.','2',4,1,1,1,0,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101536,'M',59,'Married','United States of America','E: 90,000 - 109,999','10th','Crafts','3',6,1,0,0,1,0,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101537,'M',31,'Married','United States of America','E: 90,000 - 109,999','< Bach.','Exec.','3',3,0,0,0,0,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101538,'M',39,'Married','Germany','I: 170,000 - 189,999','Assoc-A','Crafts','3',6,1,1,1,1,1,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101539,'F',69,'Widowed','Italy','I: 170,000 - 189,999','Assoc-A','?','2',2,0,1,1,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101540,'F',35,'NeverM','United States of America','L: 300,000 and above','< Bach.','?','9+',4,0,1,1,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101541,'M',48,'Married','United States of America','B: 30,000 - 49,999','Assoc-V','Crafts','3',8,1,0,0,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101542,'F',59,'NeverM','Italy','B: 30,000 - 49,999','Masters','Prof.','2',6,1,0,0,1,1,1,0,0,'I wanted to write you to let you know that I''ve purchased several items at your store recently and have been very satisfied with my purchases. Keep up  the good work.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101543,'M',43,'Divorc.','United States of America','H: 150,000 - 169,999','< Bach.','Cleric.','2',5,1,1,0,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101544,'M',24,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','1',2,0,1,1,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101545,'F',43,'NeverM','United States of America','L: 300,000 and above','< Bach.','Exec.','2',1,0,1,1,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101546,'F',48,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','9+',5,0,1,1,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101547,'M',49,'Mabsent','United States of America','G: 130,000 - 149,999','Masters','Protec.','2',5,0,0,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101548,'F',26,'NeverM','United States of America','C: 50,000 - 69,999','< Bach.','Cleric.','2',3,0,0,0,0,1,1,1,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101549,'M',38,'Married','United States of America','L: 300,000 and above','< Bach.','Exec.','3',6,1,1,1,1,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101550,'F',35,'Divorc.','United States of America','J: 190,000 - 249,999','7th-8th','TechSup','9+',4,0,1,1,1,0,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101551,'M',66,'Married','New Zealand','I: 170,000 - 189,999','PhD','Prof.','3',7,1,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101552,'M',28,'NeverM','United States of America','B: 30,000 - 49,999','Bach.','Prof.','1',3,0,0,0,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101553,'M',52,'Married','United States of America','D: 70,000 - 89,999','HS-grad','Handler','3',1,0,0,0,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101554,'M',64,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Sales','3',6,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101555,'M',41,'Married','Italy','B: 30,000 - 49,999','7th-8th','Crafts','3',4,0,0,0,1,0,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101556,'F',64,'Widowed','United States of America','E: 90,000 - 109,999','< Bach.','?','9+',2,0,0,0,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101557,'M',47,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Sales','3',6,1,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101558,'F',27,'Separ.','United States of America','J: 190,000 - 249,999','9th','?','9+',3,0,1,1,0,0,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101559,'M',38,'Married','United States of America','E: 90,000 - 109,999','Masters','Exec.','3',7,1,0,0,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101560,'M',46,'Married','United States of America','E: 90,000 - 109,999','Profsc','Prof.','3',7,1,0,0,1,1,1,0,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101561,'M',34,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Other','3',3,0,1,1,0,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101562,'M',54,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Crafts','3',5,0,1,1,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101563,'F',47,'NeverM','Brazil','J: 190,000 - 249,999','HS-grad','Exec.','1',6,0,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101564,'M',46,'Married','United States of America','J: 190,000 - 249,999','Masters','Sales','3',7,1,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101565,'F',32,'NeverM','United States of America','K: 250,000 - 299,999','Masters','Exec.','2',5,1,1,1,0,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101566,'M',38,'Divorc.','United States of America','J: 190,000 - 249,999','Bach.','Exec.','2',6,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101567,'M',49,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Transp.','3',5,0,0,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101568,'M',21,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Handler','1',2,0,0,0,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101569,'M',49,'Married','United States of America','I: 170,000 - 189,999','Assoc-A','Sales','3',6,0,1,1,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101570,'M',42,'Married','United States of America','J: 190,000 - 249,999','Profsc','Prof.','3',5,1,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101571,'F',25,'NeverM','United States of America','L: 300,000 and above','Assoc-V','Other','1',1,0,1,1,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101572,'F',46,'Divorc.','United States of America','H: 150,000 - 169,999','HS-grad','Cleric.','9+',5,0,1,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101573,'M',34,'Married','United States of America','I: 170,000 - 189,999','11th','Machine','3',3,0,1,1,0,0,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101574,'M',52,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Sales','3',9,0,0,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101575,'F',28,'Married','Australia','L: 300,000 and above','HS-grad','?','4-5',1,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101576,'F',21,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Other','1',2,0,1,1,0,1,1,1,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101577,'F',33,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Exec.','4-5',3,1,0,0,0,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101578,'M',54,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Crafts','3',5,1,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101579,'M',46,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Machine','3',5,0,1,0,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101580,'M',43,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Machine','3',4,1,0,0,1,1,1,0,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101581,'M',42,'Married','United States of America','I: 170,000 - 189,999','Profsc','Prof.','3',4,1,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101582,'M',35,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',4,0,1,1,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101583,'M',57,'Divorc.','Poland','L: 300,000 and above','1st-4th','Crafts','9+',6,0,1,1,1,0,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101584,'F',27,'NeverM','United States of America','L: 300,000 and above','HS-grad','Exec.','1',3,0,1,1,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101585,'M',21,'NeverM','United States of America','H: 150,000 - 169,999','< Bach.','Handler','1',2,0,1,0,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101586,'F',34,'NeverM','United States of America','L: 300,000 and above','< Bach.','Exec.','2',4,0,1,1,0,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101587,'F',35,'Divorc.','United States of America','L: 300,000 and above','< Bach.','Prof.','9+',4,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101588,'M',21,'NeverM','United States of America','L: 300,000 and above','< Bach.','Prof.','1',1,0,1,1,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101589,'M',42,'Divorc.','United States of America','C: 50,000 - 69,999','HS-grad','Machine','2',4,0,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101590,'M',47,'NeverM','United States of America','K: 250,000 - 299,999','Masters','Prof.','2',5,0,1,1,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101591,'F',40,'Divorc.','United States of America','J: 190,000 - 249,999','< Bach.','Other','2',4,0,1,1,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101592,'F',35,'Married','United States of America','J: 190,000 - 249,999','Assoc-V','Other','4-5',4,1,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101593,'M',53,'Married','United States of America','F: 110,000 - 129,999','Masters','Exec.','3',8,1,0,0,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101594,'F',18,'NeverM','United States of America','G: 130,000 - 149,999','< Bach.','Other','1',1,0,0,0,0,1,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101595,'M',26,'Married','United States of America','I: 170,000 - 189,999','Bach.','Other','3',3,1,1,1,0,1,1,1,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101596,'M',23,'NeverM','United States of America','B: 30,000 - 49,999','HS-grad','Handler','6-8',2,0,0,0,0,1,1,1,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101597,'M',18,'NeverM','United States of America','I: 170,000 - 189,999','11th','Handler','1',1,0,1,1,0,0,1,1,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101598,'F',32,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Cleric.','2',4,0,0,0,0,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101599,'M',51,'Divorc.','United States of America','B: 30,000 - 49,999','HS-grad','Crafts','2',5,0,0,0,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101600,'M',45,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Exec.','3',5,1,0,0,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101601,'M',56,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Crafts','3',6,0,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101602,'F',20,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','Cleric.','1',1,0,1,1,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101603,'M',47,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Crafts','3',5,1,0,0,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101604,'M',42,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',5,0,1,1,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101605,'M',48,'Married','United States of America','K: 250,000 - 299,999','Bach.','Exec.','3',6,1,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101606,'F',39,'Married','United States of America','I: 170,000 - 189,999','Bach.','Exec.','4-5',6,1,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101607,'M',59,'Separ.','United States of America','G: 130,000 - 149,999','< Bach.','Sales','2',9,1,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101608,'M',36,'Divorc.','United States of America','L: 300,000 and above','Assoc-A','Exec.','2',5,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101609,'F',18,'NeverM','United States of America','K: 250,000 - 299,999','11th','Sales','2',1,0,1,1,0,0,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101610,'M',18,'NeverM','United States of America','I: 170,000 - 189,999','11th','Handler','1',0,0,1,1,0,0,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101611,'F',20,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','?','1',2,0,0,0,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101612,'M',26,'Married','United States of America','G: 130,000 - 149,999','Bach.','?','3',3,0,0,0,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101613,'M',33,'NeverM','Saudi Arabia','K: 250,000 - 299,999','HS-grad','Other','9+',3,0,1,1,0,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101614,'M',62,'Married','United States of America','E: 90,000 - 109,999','10th','Machine','3',6,0,0,0,1,0,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101615,'F',27,'Divorc.','United States of America','I: 170,000 - 189,999','< Bach.','Cleric.','1',1,0,1,1,0,1,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101616,'F',23,'NeverM','United States of America','E: 90,000 - 109,999','Bach.','TechSup','1',2,0,0,0,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101617,'F',22,'NeverM','Denmark','B: 30,000 - 49,999','< Bach.','?','1',0,0,0,0,0,1,1,1,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101618,'M',46,'Married','United States of America','E: 90,000 - 109,999','< Bach.','Crafts','3',5,0,0,0,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101619,'F',39,'NeverM','Brazil','J: 190,000 - 249,999','11th','Prof.','9+',3,0,1,1,1,0,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101620,'M',46,'Married','United States of America','H: 150,000 - 169,999','HS-grad','Cleric.','3',7,1,1,0,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101621,'M',46,'Married','United States of America','J: 190,000 - 249,999','Bach.','Protec.','3',5,1,1,1,1,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101622,'M',23,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Machine','2',2,0,1,1,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101623,'F',37,'Separ.','United States of America','J: 190,000 - 249,999','12th','House-s','9+',4,0,1,1,1,0,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101624,'M',37,'NeverM','Japan','B: 30,000 - 49,999','< Bach.','Other','1',4,0,0,0,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101625,'M',55,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Crafts','3',6,0,1,1,1,1,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101626,'F',45,'Divorc.','United States of America','I: 170,000 - 189,999','Masters','Prof.','1',7,0,1,1,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101627,'M',29,'NeverM','United States of America','I: 170,000 - 189,999','Bach.','Sales','2',4,1,1,1,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101628,'M',20,'NeverM','United States of America','H: 150,000 - 169,999','< Bach.','?','1',2,0,1,0,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101629,'M',40,'Married','United States of America','I: 170,000 - 189,999','< Bach.','Sales','3',6,1,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101630,'M',40,'Married','United States of America','D: 70,000 - 89,999','< Bach.','Sales','3',5,0,0,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101631,'F',20,'NeverM','United States of America','L: 300,000 and above','< Bach.','Cleric.','1',1,0,1,1,0,1,1,1,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101632,'M',35,'Separ.','United States of America','H: 150,000 - 169,999','HS-grad','Transp.','1',4,0,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101633,'M',34,'Married','United States of America','I: 170,000 - 189,999','Profsc','Prof.','3',5,1,1,1,0,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101634,'M',24,'Married','United States of America','J: 190,000 - 249,999','Bach.','Sales','3',2,0,1,1,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101635,'M',46,'Married','United States of America','B: 30,000 - 49,999','Bach.','Exec.','3',6,0,0,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101636,'M',17,'NeverM','United States of America','L: 300,000 and above','12th','Other','1',1,0,1,1,0,0,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101637,'M',32,'Married','United States of America','A: Below 30,000','Assoc-V','TechSup','3',3,0,0,0,0,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101638,'M',41,'Married','United States of America','E: 90,000 - 109,999','Bach.','Sales','3',6,0,0,0,1,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101639,'F',33,'Divorc.','China','H: 150,000 - 169,999','HS-grad','?','2',3,0,1,0,0,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101640,'M',29,'NeverM','United States of America','I: 170,000 - 189,999','< Bach.','Exec.','2',4,0,1,1,0,1,1,1,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101641,'M',57,'Married','Germany','G: 130,000 - 149,999','PhD','TechSup','3',6,1,0,0,1,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101642,'F',32,'Married','United States of America','G: 130,000 - 149,999','< Bach.','TechSup','4-5',3,0,0,0,0,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101643,'F',21,'NeverM','United States of America','L: 300,000 and above','10th','Other','2',2,0,1,1,0,0,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101644,'M',36,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Machine','2',5,0,1,1,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101645,'M',52,'Married','United States of America','J: 190,000 - 249,999','HS-grad','?','3',5,0,1,1,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101646,'M',41,'Married','United States of America','B: 30,000 - 49,999','Bach.','TechSup','3',4,0,0,0,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101647,'M',51,'Married','United States of America','H: 150,000 - 169,999','HS-grad','Prof.','3',5,1,1,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101648,'M',51,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Sales','2',6,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101649,'F',46,'NeverM','United States of America','H: 150,000 - 169,999','< Bach.','Cleric.','1',5,0,1,1,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101650,'M',20,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Other','1',1,0,1,1,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101651,'M',73,'Married','United States of America','G: 130,000 - 149,999','Bach.','?','3',2,0,0,0,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101652,'M',42,'Married','United States of America','D: 70,000 - 89,999','Bach.','Farming','3',7,0,0,0,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101653,'M',30,'Married','United States of America','L: 300,000 and above','HS-grad','?','3',3,0,1,1,0,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101654,'M',47,'Married','United States of America','L: 300,000 and above','HS-grad','Cleric.','3',5,1,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101655,'F',30,'NeverM','United States of America','B: 30,000 - 49,999','HS-grad','Cleric.','9+',3,0,0,0,0,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101656,'M',33,'Married','United States of America','D: 70,000 - 89,999','< Bach.','Sales','3',2,0,0,0,0,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101657,'M',31,'Mabsent','United States of America','G: 130,000 - 149,999','11th','Handler','2',3,0,0,0,0,0,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101658,'M',23,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Sales','2',3,0,1,1,0,1,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101659,'F',20,'NeverM','United States of America','I: 170,000 - 189,999','HS-grad','Sales','1',2,0,1,1,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101660,'M',37,'Married','United States of America','A: Below 30,000','HS-grad','TechSup','3',3,0,0,0,1,1,1,0,1,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101661,'F',23,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Other','1',2,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101662,'M',45,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',7,1,1,1,1,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101663,'F',38,'Divorc.','United States of America','C: 50,000 - 69,999','< Bach.','Sales','2',4,0,0,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101664,'M',47,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Exec.','3',9,1,0,0,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101665,'M',18,'NeverM','United States of America','H: 150,000 - 169,999','11th','Protec.','1',0,0,1,0,0,0,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101666,'M',44,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Transp.','3',4,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101667,'F',45,'Married','United States of America','I: 170,000 - 189,999','9th','Machine','4-5',5,1,1,1,1,0,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101668,'M',34,'NeverM','Italy','L: 300,000 and above','< Bach.','Handler','2',4,0,1,1,0,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101669,'F',19,'NeverM','United States of America','B: 30,000 - 49,999','< Bach.','Other','6-8',1,0,0,0,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101670,'M',35,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Other','3',4,0,1,1,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101671,'F',24,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Sales','9+',2,0,1,1,0,1,1,1,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101672,'F',26,'NeverM','United States of America','H: 150,000 - 169,999','Bach.','Sales','2',4,0,1,0,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101673,'F',47,'Married','Italy','E: 90,000 - 109,999','HS-grad','Other','4-5',9,0,0,0,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101674,'M',18,'NeverM','United States of America','L: 300,000 and above','< Bach.','Sales','1',2,0,1,1,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101675,'M',23,'NeverM','United States of America','L: 300,000 and above','HS-grad','Sales','2',3,0,1,1,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101676,'M',41,'Married','United States of America','K: 250,000 - 299,999','Masters','Exec.','3',7,1,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101677,'F',29,'Divorc.','United States of America','B: 30,000 - 49,999','HS-grad','Prof.','2',3,0,0,0,0,1,1,1,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101678,'M',36,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Machine','3',4,1,1,1,1,1,1,0,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101679,'M',44,'Married','United States of America','E: 90,000 - 109,999','< Bach.','Crafts','3',7,1,0,0,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101680,'M',31,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Farming','3',3,0,0,0,0,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101681,'M',59,'Married','United States of America','H: 150,000 - 169,999','HS-grad','Crafts','3',7,0,1,1,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101682,'M',34,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Handler','3',3,0,1,1,0,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101683,'M',25,'NeverM','United States of America','B: 30,000 - 49,999','HS-grad','Handler','2',3,0,0,0,0,1,1,1,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101684,'M',37,'NeverM','United States of America','B: 30,000 - 49,999','Bach.','Exec.','2',5,0,0,0,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101685,'M',54,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Crafts','3',7,0,1,1,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101686,'M',47,'Married','Italy','J: 190,000 - 249,999','Masters','Prof.','3',5,1,1,1,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101687,'F',50,'Widowed','United States of America','H: 150,000 - 169,999','HS-grad','TechSup','9+',5,0,1,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101688,'F',32,'NeverM','Argentina','L: 300,000 and above','HS-grad','House-s','9+',3,0,1,1,0,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101689,'M',44,'Married','Italy','F: 110,000 - 129,999','Bach.','Sales','3',6,1,0,0,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101690,'M',61,'Married','United States of America','J: 190,000 - 249,999','Bach.','Prof.','3',8,1,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101691,'F',23,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','Other','2',2,0,1,1,0,1,1,1,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101692,'F',38,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Protec.','2',4,1,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101693,'F',79,'Married','United States of America','E: 90,000 - 109,999','Assoc-A','?','4-5',0,1,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101694,'F',45,'Married','United States of America','H: 150,000 - 169,999','12th','Cleric.','4-5',5,1,1,1,1,0,1,0,0,'Thank you! But I am very unhappy with all the junk mail you keep sending.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101695,'M',56,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',6,0,1,1,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101696,'F',39,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','1',2,0,1,1,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101697,'M',44,'Married','United States of America','E: 90,000 - 109,999','Profsc','Prof.','3',7,1,0,0,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101698,'M',34,'Divorc.','United States of America','H: 150,000 - 169,999','HS-grad','Handler','1',3,0,1,0,0,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101699,'M',49,'Married','United States of America','J: 190,000 - 249,999','Bach.','Sales','3',7,1,1,1,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101700,'F',30,'NeverM','United States of America','K: 250,000 - 299,999','Assoc-A','Machine','9+',3,0,1,1,0,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101701,'F',20,'NeverM','United States of America','A: Below 30,000','< Bach.','?','1',2,0,0,0,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101702,'M',64,'Married','United States of America','L: 300,000 and above','Bach.','Sales','3',6,0,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101703,'F',27,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','9+',3,0,1,1,0,1,1,1,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101704,'F',20,'NeverM','United States of America','D: 70,000 - 89,999','< Bach.','Exec.','1',1,0,0,0,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101705,'F',21,'NeverM','United States of America','J: 190,000 - 249,999','Assoc-V','TechSup','1',2,0,1,1,0,1,1,1,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101706,'M',22,'Mabsent','United States of America','A: Below 30,000','< Bach.','TechSup','9+',1,0,0,0,0,1,1,1,1,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101707,'M',43,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Other','2',4,0,1,1,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101708,'M',67,'Married','United States of America','J: 190,000 - 249,999','PhD','Prof.','3',7,1,1,1,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101709,'M',29,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Sales','9+',3,0,1,1,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101710,'M',25,'NeverM','United States of America','E: 90,000 - 109,999','12th','Handler','9+',3,0,0,0,0,0,1,1,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101711,'F',23,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Cleric.','2',2,0,1,1,0,1,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101712,'M',47,'Married','United States of America','J: 190,000 - 249,999','Assoc-A','Cleric.','3',5,1,1,1,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101713,'M',51,'Mabsent','United States of America','H: 150,000 - 169,999','HS-grad','?','2',3,1,1,0,1,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101714,'M',26,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Handler','1',3,0,1,1,0,1,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101715,'F',49,'NeverM','United States of America','B: 30,000 - 49,999','Bach.','Prof.','1',6,0,0,0,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101716,'F',34,'Separ.','United States of America','F: 110,000 - 129,999','HS-grad','Exec.','9+',3,0,0,0,0,1,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101717,'M',26,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','3',3,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101718,'F',19,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Other','6-8',2,0,0,0,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101719,'M',29,'NeverM','United States of America','K: 250,000 - 299,999','Assoc-V','Machine','2',3,0,1,1,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101720,'F',17,'NeverM','United States of America','G: 130,000 - 149,999','10th','Other','1',1,0,0,0,0,0,1,1,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101721,'M',67,'Married','United States of America','E: 90,000 - 109,999','PhD','Sales','3',7,1,0,0,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101722,'M',57,'Married','United States of America','L: 300,000 and above','HS-grad','Exec.','3',6,0,1,1,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101723,'F',53,'Divorc.','United States of America','A: Below 30,000','< Bach.','Prof.','2',5,0,0,0,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101724,'M',28,'NeverM','Brazil','J: 190,000 - 249,999','HS-grad','Machine','1',4,0,1,1,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101725,'M',23,'NeverM','United States of America','K: 250,000 - 299,999','HS-grad','Protec.','1',2,0,1,1,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101726,'M',40,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Exec.','3',5,0,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101727,'M',34,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Crafts','6-8',3,0,0,0,0,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101728,'M',26,'NeverM','Argentina','J: 190,000 - 249,999','11th','Other','6-8',2,0,1,1,0,0,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101729,'M',22,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',1,0,1,1,0,1,1,1,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101730,'M',71,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Exec.','3',9,1,0,0,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101731,'M',55,'Married','United States of America','B: 30,000 - 49,999','< Bach.','Sales','3',7,0,0,0,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101732,'F',59,'Widowed','United States of America','J: 190,000 - 249,999','HS-grad','Exec.','9+',7,0,1,1,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101733,'M',39,'Married','United States of America','J: 190,000 - 249,999','Masters','Exec.','3',5,0,1,1,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101734,'F',38,'Divorc.','United States of America','B: 30,000 - 49,999','< Bach.','Protec.','9+',4,1,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101735,'M',63,'Married','United States of America','E: 90,000 - 109,999','Assoc-A','Sales','3',6,1,0,0,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101736,'F',29,'Divorc.','United States of America','H: 150,000 - 169,999','< Bach.','?','9+',2,0,1,1,0,1,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101737,'M',44,'Married','United States of America','K: 250,000 - 299,999','Bach.','Exec.','3',4,1,1,1,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101738,'F',41,'Divorc.','Canada','D: 70,000 - 89,999','12th','?','2',4,0,0,0,1,0,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101739,'M',29,'Married','Germany','J: 190,000 - 249,999','HS-grad','Sales','3',3,0,1,1,0,1,1,1,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101740,'F',42,'Divorc.','United States of America','D: 70,000 - 89,999','< Bach.','Exec.','9+',4,0,0,0,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101741,'M',34,'Married','United States of America','L: 300,000 and above','< Bach.','Prof.','3',4,1,1,1,0,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101742,'M',31,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Machine','2',3,0,1,1,0,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101743,'M',46,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Exec.','3',6,1,0,0,1,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101744,'F',28,'NeverM','United States of America','G: 130,000 - 149,999','Bach.','Cleric.','2',4,0,0,0,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101745,'M',33,'Married','United States of America','E: 90,000 - 109,999','12th','Protec.','3',3,0,0,0,0,0,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101746,'M',60,'Married','United States of America','B: 30,000 - 49,999','HS-grad','Transp.','3',9,1,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101747,'M',53,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Protec.','3',5,1,1,1,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101748,'M',35,'Married','United States of America','B: 30,000 - 49,999','< Bach.','Protec.','3',4,0,0,0,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101749,'M',32,'Married','United States of America','B: 30,000 - 49,999','HS-grad','Crafts','3',3,1,0,0,0,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101750,'F',23,'NeverM','United States of America','I: 170,000 - 189,999','Assoc-V','Cleric.','6-8',2,0,1,1,0,1,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101751,'F',34,'NeverM','United States of America','F: 110,000 - 129,999','HS-grad','Cleric.','2',3,0,0,0,0,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101752,'F',20,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Prof.','1',1,0,0,0,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101753,'F',39,'Widowed','United States of America','J: 190,000 - 249,999','Assoc-A','Cleric.','9+',5,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101754,'M',45,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Exec.','3',6,1,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101755,'M',38,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Exec.','3',4,1,1,1,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101756,'F',30,'NeverM','United Kingdom','I: 170,000 - 189,999','< Bach.','Exec.','2',3,0,1,1,0,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101757,'M',52,'Mabsent','United States of America','J: 190,000 - 249,999','Bach.','Other','2',7,0,1,1,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101758,'M',26,'Married','United States of America','K: 250,000 - 299,999','Assoc-V','Farming','3',4,0,1,1,0,1,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101759,'F',21,'NeverM','United States of America','F: 110,000 - 129,999','HS-grad','Sales','1',2,0,0,0,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101760,'M',28,'NeverM','United States of America','L: 300,000 and above','Assoc-V','Sales','2',4,0,1,1,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101761,'M',23,'NeverM','United States of America','K: 250,000 - 299,999','Assoc-V','Crafts','1',2,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101762,'F',17,'NeverM','United States of America','I: 170,000 - 189,999','10th','Protec.','1',2,0,1,1,0,0,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101763,'M',50,'Married','United States of America','G: 130,000 - 149,999','Masters','Prof.','3',5,1,0,0,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101764,'F',46,'Divorc.','United States of America','J: 190,000 - 249,999','Bach.','Cleric.','2',5,1,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101765,'M',71,'Married','United States of America','I: 170,000 - 189,999','HS-grad','?','3',7,0,1,1,1,1,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101766,'F',34,'NeverM','United States of America','G: 130,000 - 149,999','< Bach.','Cleric.','2',3,0,0,0,0,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101767,'M',27,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Crafts','3',5,0,0,0,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101768,'M',29,'Married','United States of America','C: 50,000 - 69,999','< Bach.','Crafts','3',3,0,0,0,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101769,'M',41,'Married','United States of America','A: Below 30,000','HS-grad','Farming','3',4,1,0,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101770,'F',39,'NeverM','United States of America','H: 150,000 - 169,999','< Bach.','Other','9+',4,0,1,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101771,'M',48,'Married','United States of America','E: 90,000 - 109,999','Bach.','Crafts','3',7,0,0,0,1,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101772,'M',23,'NeverM','United States of America','I: 170,000 - 189,999','Assoc-V','Sales','1',2,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101773,'F',32,'Married','United States of America','E: 90,000 - 109,999','Bach.','Exec.','4-5',3,1,0,0,0,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101774,'F',47,'NeverM','United States of America','G: 130,000 - 149,999','Masters','Prof.','2',6,0,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101775,'M',24,'NeverM','United States of America','L: 300,000 and above','Bach.','Cleric.','2',1,0,1,1,0,1,1,1,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101776,'M',43,'Married','United States of America','D: 70,000 - 89,999','HS-grad','Machine','3',4,0,0,0,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101777,'M',55,'Widowed','United States of America','B: 30,000 - 49,999','< Bach.','Farming','2',8,1,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101778,'F',17,'NeverM','United States of America','H: 150,000 - 169,999','10th','Other','1',1,0,1,1,0,0,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101779,'M',32,'Divorc.','United States of America','I: 170,000 - 189,999','HS-grad','Sales','1',5,0,1,1,0,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101780,'M',31,'Married','Germany','L: 300,000 and above','< Bach.','Exec.','3',4,1,1,1,0,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101781,'M',35,'Married','United States of America','B: 30,000 - 49,999','Masters','Exec.','3',5,1,0,0,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101782,'M',54,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Exec.','3',5,1,1,1,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101783,'M',23,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Machine','3',3,0,1,1,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101784,'F',34,'Separ.','United States of America','E: 90,000 - 109,999','Masters','Prof.','9+',3,0,0,0,0,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101785,'M',21,'NeverM','United States of America','L: 300,000 and above','HS-grad','Transp.','1',2,0,1,1,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101786,'F',34,'Divorc.','United States of America','H: 150,000 - 169,999','< Bach.','Other','9+',3,0,1,0,0,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101787,'F',37,'NeverM','United States of America','G: 130,000 - 149,999','Assoc-V','Cleric.','2',4,0,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101788,'M',18,'NeverM','United States of America','C: 50,000 - 69,999','10th','Other','1',1,0,0,0,0,0,1,1,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101789,'M',56,'NeverM','United States of America','L: 300,000 and above','Masters','Sales','2',3,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101790,'F',38,'Married','Canada','E: 90,000 - 109,999','7th-8th','Machine','4-5',5,1,0,0,1,0,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101791,'F',48,'Divorc.','United States of America','F: 110,000 - 129,999','Masters','Exec.','9+',5,1,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101792,'F',46,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Farming','4-5',2,0,1,1,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101793,'M',38,'Married','United States of America','D: 70,000 - 89,999','Bach.','Prof.','3',5,1,0,0,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101794,'F',39,'NeverM','United States of America','I: 170,000 - 189,999','Assoc-A','TechSup','2',4,0,1,1,1,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101795,'M',33,'Mabsent','Italy','I: 170,000 - 189,999','< Bach.','Crafts','2',3,0,1,1,0,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101796,'M',33,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Prof.','2',3,0,1,1,0,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101797,'M',52,'Married','United States of America','K: 250,000 - 299,999','Bach.','Prof.','3',5,0,1,1,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101798,'M',43,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Exec.','3',5,1,0,0,1,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101799,'M',59,'Divorc.','United Kingdom','J: 190,000 - 249,999','HS-grad','Prof.','2',3,0,1,1,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101800,'M',45,'Married','United States of America','G: 130,000 - 149,999','Assoc-V','Crafts','3',5,1,0,0,1,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101801,'M',44,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Exec.','3',6,1,1,0,1,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101802,'F',51,'Separ.','United States of America','J: 190,000 - 249,999','Bach.','Cleric.','9+',5,0,1,1,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101803,'M',33,'Married','United States of America','B: 30,000 - 49,999','11th','Exec.','3',6,0,0,0,0,0,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101804,'F',32,'Divorc.','United States of America','K: 250,000 - 299,999','Assoc-A','Machine','2',4,0,1,1,0,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101805,'M',36,'Married','United States of America','H: 150,000 - 169,999','HS-grad','Exec.','3',4,0,1,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101806,'F',37,'Divorc.','Italy','F: 110,000 - 129,999','HS-grad','?','2',4,0,0,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101807,'F',35,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Cleric.','4-5',3,0,0,0,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101808,'M',43,'Married','United States of America','B: 30,000 - 49,999','< Bach.','Farming','3',5,0,0,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101809,'M',41,'Divorc.','United States of America','C: 50,000 - 69,999','< Bach.','Crafts','2',4,0,0,0,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101810,'M',27,'NeverM','Argentina','J: 190,000 - 249,999','HS-grad','Other','1',3,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101811,'M',38,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Crafts','3',4,0,1,1,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101812,'F',42,'NeverM','United States of America','E: 90,000 - 109,999','Assoc-A','?','6-8',4,0,0,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101813,'M',54,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Crafts','3',7,1,0,0,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101814,'M',29,'NeverM','United States of America','H: 150,000 - 169,999','Bach.','TechSup','2',3,0,1,0,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101815,'M',27,'NeverM','United States of America','F: 110,000 - 129,999','HS-grad','Crafts','2',3,0,0,0,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101816,'M',44,'Married','United States of America','B: 30,000 - 49,999','Bach.','Exec.','3',4,1,0,0,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101817,'F',46,'Divorc.','United States of America','K: 250,000 - 299,999','PhD','Prof.','9+',8,1,1,1,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101818,'F',48,'Divorc.','United States of America','L: 300,000 and above','< Bach.','Cleric.','2',6,0,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101819,'M',38,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',4,0,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101820,'M',62,'NeverM','United States of America','H: 150,000 - 169,999','Bach.','Farming','2',5,0,1,0,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101821,'M',39,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Crafts','3',6,1,1,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101822,'M',47,'Married','United States of America','J: 190,000 - 249,999','Masters','Exec.','3',5,1,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101823,'M',45,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',5,1,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101824,'M',40,'Married','United States of America','J: 190,000 - 249,999','Bach.','Sales','3',6,1,1,1,1,1,1,0,0,'I wanted to write you to let you know that I''ve purchased several items at your store recently and have been very satisfied with my purchases. Keep up  the good work.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101825,'F',52,'Divorc.','United States of America','B: 30,000 - 49,999','HS-grad','Cleric.','9+',5,0,0,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101826,'M',43,'Married','United States of America','I: 170,000 - 189,999','Assoc-A','Exec.','3',5,1,1,1,1,1,1,0,0,'Thank you! But I am very unhappy with all the junk mail you keep sending.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101827,'M',31,'Married','United States of America','J: 190,000 - 249,999','10th','Crafts','3',3,0,1,1,0,0,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101828,'M',53,'Married','United States of America','B: 30,000 - 49,999','< Bach.','Transp.','3',5,1,0,0,1,1,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101829,'M',31,'Married','Argentina','L: 300,000 and above','Bach.','Machine','3',3,0,1,1,0,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101830,'M',29,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Exec.','1',3,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101831,'M',46,'Married','United States of America','B: 30,000 - 49,999','Profsc','Exec.','3',7,1,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101832,'M',43,'Married','United States of America','L: 300,000 and above','Assoc-V','Crafts','3',4,0,1,1,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101833,'M',48,'Married','United States of America','H: 150,000 - 169,999','HS-grad','Crafts','3',8,1,1,0,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101834,'F',41,'Married','United States of America','C: 50,000 - 69,999','< Bach.','Transp.','4-5',3,0,0,0,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101835,'F',25,'NeverM','Italy','F: 110,000 - 129,999','Profsc','Prof.','2',1,0,0,0,0,1,1,1,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101836,'F',64,'Separ.','United States of America','K: 250,000 - 299,999','Assoc-A','Prof.','2',6,1,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101837,'M',26,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Machine','3',3,1,1,1,0,1,1,1,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101838,'M',45,'Divorc.','United States of America','I: 170,000 - 189,999','Masters','Exec.','2',5,1,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101839,'F',27,'NeverM','United States of America','J: 190,000 - 249,999','PhD','Cleric.','1',3,0,1,1,0,1,1,1,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101840,'M',66,'Married','United States of America','E: 90,000 - 109,999','< Bach.','?','3',7,0,0,0,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101841,'M',33,'Married','United States of America','K: 250,000 - 299,999','9th','Machine','3',4,0,1,1,0,0,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101842,'M',19,'NeverM','United States of America','H: 150,000 - 169,999','< Bach.','?','1',2,0,1,1,0,1,1,1,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101843,'F',53,'NeverM','United States of America','F: 110,000 - 129,999','Bach.','Prof.','2',5,0,0,0,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101844,'M',56,'Married','Poland','D: 70,000 - 89,999','7th-8th','Crafts','3',6,0,0,0,1,0,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101845,'F',49,'NeverM','United States of America','E: 90,000 - 109,999','Bach.','Prof.','2',5,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101846,'M',51,'Married','United States of America','H: 150,000 - 169,999','Bach.','Cleric.','3',5,1,1,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101847,'F',45,'Separ.','United States of America','H: 150,000 - 169,999','11th','Cleric.','9+',3,0,1,0,1,0,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101848,'M',51,'Married','United States of America','C: 50,000 - 69,999','HS-grad','Crafts','3',5,0,0,0,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101849,'M',31,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Sales','3',3,0,1,1,0,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101850,'F',51,'Separ.','Argentina','J: 190,000 - 249,999','5th-6th','Machine','9+',5,0,1,1,1,0,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101851,'F',54,'Mabsent','United States of America','K: 250,000 - 299,999','HS-grad','Exec.','2',5,0,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101852,'F',31,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Cleric.','1',3,0,1,1,0,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101853,'F',24,'NeverM','United States of America','L: 300,000 and above','Bach.','Prof.','2',2,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101854,'M',33,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',3,1,1,1,0,1,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101855,'M',23,'Married','United States of America','A: Below 30,000','< Bach.','Machine','3',2,0,0,0,0,1,1,1,1,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101856,'F',70,'Widowed','United States of America','J: 190,000 - 249,999','< Bach.','Sales','2',5,0,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101857,'F',43,'Divorc.','United States of America','E: 90,000 - 109,999','< Bach.','Protec.','9+',4,0,0,0,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101858,'M',49,'Married','Germany','H: 150,000 - 169,999','Assoc-V','Prof.','3',5,1,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101859,'M',35,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Machine','3',5,1,0,0,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101860,'M',57,'Married','United States of America','K: 250,000 - 299,999','10th','Crafts','3',1,0,1,1,1,0,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101861,'M',44,'Married','United States of America','C: 50,000 - 69,999','PhD','Prof.','3',7,0,0,0,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101862,'F',56,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Sales','4-5',7,0,0,0,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101863,'M',51,'Married','United States of America','F: 110,000 - 129,999','Profsc','Prof.','3',9,1,0,0,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101864,'F',23,'NeverM','United States of America','I: 170,000 - 189,999','Bach.','Exec.','2',2,0,1,1,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101865,'M',55,'Married','United States of America','H: 150,000 - 169,999','HS-grad','Transp.','3',10,1,1,0,1,1,1,0,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101866,'F',22,'NeverM','United States of America','L: 300,000 and above','HS-grad','Other','9+',2,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101867,'M',30,'NeverM','Italy','K: 250,000 - 299,999','HS-grad','Crafts','9+',3,0,1,1,0,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101868,'F',43,'NeverM','Poland','C: 50,000 - 69,999','9th','Sales','1',4,0,0,0,1,0,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101869,'F',24,'NeverM','Italy','J: 190,000 - 249,999','HS-grad','Other','1',1,0,1,1,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101870,'M',27,'NeverM','United States of America','G: 130,000 - 149,999','HS-grad','Transp.','2',4,0,0,0,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101871,'M',25,'NeverM','United States of America','F: 110,000 - 129,999','9th','Crafts','9+',3,0,0,0,0,0,1,1,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101872,'M',55,'Married','United States of America','G: 130,000 - 149,999','11th','Exec.','3',7,0,0,0,1,0,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101873,'F',19,'NeverM','United States of America','L: 300,000 and above','HS-grad','?','9+',2,0,1,1,0,1,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101874,'F',23,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','Cleric.','1',2,0,1,1,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101875,'F',22,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Other','9+',2,0,1,1,0,1,1,1,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101876,'F',26,'NeverM','United States of America','H: 150,000 - 169,999','Bach.','Prof.','1',3,0,1,0,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101877,'M',38,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Machine','3',4,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101878,'M',42,'Married','Singapore','G: 130,000 - 149,999','PhD','Prof.','3',4,1,0,0,1,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101879,'F',44,'Divorc.','United States of America','D: 70,000 - 89,999','< Bach.','Cleric.','9+',4,0,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101880,'M',34,'Married','United States of America','L: 300,000 and above','< Bach.','Crafts','3',3,0,1,1,0,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101881,'F',27,'NeverM','United States of America','I: 170,000 - 189,999','HS-grad','Other','2',3,0,1,1,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101882,'M',53,'Married','United States of America','F: 110,000 - 129,999','7th-8th','Machine','3',5,0,0,0,1,0,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101883,'F',48,'Divorc.','United States of America','F: 110,000 - 129,999','Bach.','Sales','9+',5,0,0,0,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101884,'M',37,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','2',5,0,1,1,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101885,'F',39,'Married','United States of America','L: 300,000 and above','Profsc','Exec.','4-5',5,1,1,1,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101886,'M',17,'NeverM','United States of America','E: 90,000 - 109,999','10th','Other','1',1,0,0,0,0,0,1,1,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101887,'F',68,'Widowed','Italy','K: 250,000 - 299,999','7th-8th','?','2',7,0,1,1,1,0,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101888,'F',23,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Sales','4-5',2,0,0,0,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101889,'M',29,'Married','United States of America','K: 250,000 - 299,999','Bach.','Sales','3',3,1,1,1,0,1,1,1,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101890,'F',19,'NeverM','United States of America','C: 50,000 - 69,999','HS-grad','Sales','1',1,0,0,0,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101891,'M',47,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',5,1,1,1,1,1,1,0,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101892,'M',48,'Married','United States of America','L: 300,000 and above','HS-grad','Cleric.','3',6,1,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101893,'M',27,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Crafts','1',3,0,0,0,0,1,1,1,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101894,'M',42,'Married','United States of America','A: Below 30,000','Bach.','Sales','3',5,0,0,0,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101895,'F',58,'Widowed','United States of America','J: 190,000 - 249,999','11th','Other','2',6,0,1,1,1,0,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101896,'F',20,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Cleric.','1',1,0,1,1,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101897,'M',34,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Protec.','3',3,0,1,1,0,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101898,'F',47,'Mabsent','Brazil','J: 190,000 - 249,999','< Bach.','Exec.','9+',5,0,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101899,'M',60,'Married','United States of America','E: 90,000 - 109,999','7th-8th','Sales','3',9,0,0,0,1,0,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101900,'M',53,'Married','United States of America','C: 50,000 - 69,999','HS-grad','Transp.','3',5,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101901,'M',25,'Married','United States of America','L: 300,000 and above','< Bach.','Sales','3',3,0,1,1,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101902,'M',24,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Machine','3',2,0,1,0,0,1,1,1,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101903,'F',22,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Sales','1',2,0,1,1,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101904,'M',39,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Crafts','3',4,0,0,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101905,'F',19,'NeverM','United States of America','I: 170,000 - 189,999','< Bach.','Other','1',1,0,1,1,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101906,'F',29,'Married','United States of America','E: 90,000 - 109,999','< Bach.','Cleric.','4-5',3,1,0,0,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101907,'M',56,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Exec.','2',7,1,1,1,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101908,'M',19,'NeverM','United States of America','L: 300,000 and above','HS-grad','Crafts','1',2,0,1,1,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101909,'F',44,'NeverM','United States of America','C: 50,000 - 69,999','Masters','Prof.','2',7,0,0,0,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101910,'M',53,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Other','3',5,0,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101911,'M',22,'NeverM','United States of America','L: 300,000 and above','HS-grad','Machine','2',3,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101912,'F',62,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Crafts','2',6,1,0,0,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101913,'M',71,'Separ.','United States of America','L: 300,000 and above','< Bach.','Sales','9+',0,0,1,1,1,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101914,'M',63,'Married','United States of America','B: 30,000 - 49,999','Bach.','?','3',2,1,0,0,1,1,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101915,'F',31,'Married','Argentina','K: 250,000 - 299,999','HS-grad','?','4-5',2,0,1,1,0,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101916,'M',41,'Married','United States of America','H: 150,000 - 169,999','Bach.','Exec.','3',5,1,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101917,'M',49,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Crafts','3',5,1,1,1,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101918,'M',58,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',7,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101919,'M',36,'Divorc.','United States of America','L: 300,000 and above','10th','Crafts','6-8',4,0,1,1,1,0,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101920,'M',34,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','2',3,0,1,1,0,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101921,'F',25,'NeverM','New Zealand','L: 300,000 and above','Bach.','Other','2',1,0,1,1,0,1,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101922,'M',62,'Married','United States of America','G: 130,000 - 149,999','12th','Crafts','3',6,1,0,0,1,0,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101923,'M',23,'NeverM','United States of America','H: 150,000 - 169,999','< Bach.','Armed-F','6-8',2,0,1,0,0,1,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101924,'F',26,'NeverM','United States of America','I: 170,000 - 189,999','Bach.','Cleric.','1',3,1,1,1,0,1,1,1,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101925,'F',23,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Other','2',2,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101926,'M',20,'NeverM','United States of America','G: 130,000 - 149,999','< Bach.','Other','1',1,0,0,0,0,1,1,1,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101927,'F',25,'NeverM','United States of America','I: 170,000 - 189,999','< Bach.','Exec.','2',4,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101928,'M',39,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',4,0,1,1,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101929,'M',36,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Machine','2',4,0,1,1,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101930,'F',36,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','2',4,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101931,'F',51,'Separ.','United States of America','E: 90,000 - 109,999','Assoc-A','Other','2',5,0,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101932,'M',51,'Married','United States of America','I: 170,000 - 189,999','HS-grad','?','3',5,0,1,1,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101933,'M',45,'NeverM','United States of America','I: 170,000 - 189,999','9th','Other','1',5,0,1,1,1,0,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101934,'F',17,'NeverM','United States of America','J: 190,000 - 249,999','11th','Sales','1',1,0,1,1,0,0,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101935,'M',38,'Married','United States of America','G: 130,000 - 149,999','Profsc','Prof.','3',6,1,0,0,1,1,1,0,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101936,'M',27,'NeverM','United States of America','H: 150,000 - 169,999','Bach.','Exec.','2',3,0,1,1,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101937,'M',59,'Married','United States of America','H: 150,000 - 169,999','Assoc-A','Crafts','3',3,1,1,0,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101938,'F',36,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Sales','2',4,0,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101939,'M',38,'Divorc.','United States of America','I: 170,000 - 189,999','HS-grad','Machine','2',5,0,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101940,'M',22,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','?','1',2,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101941,'M',27,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','1',1,0,1,1,0,1,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101942,'M',27,'NeverM','United States of America','L: 300,000 and above','Bach.','Prof.','9+',3,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101943,'F',53,'NeverM','United States of America','G: 130,000 - 149,999','< Bach.','Protec.','2',5,0,0,0,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101944,'F',46,'Separ.','United States of America','F: 110,000 - 129,999','9th','Machine','2',5,0,0,0,1,0,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101945,'F',24,'Separ.','United States of America','F: 110,000 - 129,999','< Bach.','Sales','9+',3,0,0,0,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101946,'F',28,'NeverM','United States of America','L: 300,000 and above','Masters','Prof.','2',3,1,1,1,0,1,1,1,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101947,'M',48,'Married','United States of America','F: 110,000 - 129,999','9th','Crafts','3',5,0,0,0,1,0,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101948,'F',27,'NeverM','United States of America','F: 110,000 - 129,999','Bach.','Prof.','2',3,0,0,0,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101949,'F',50,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Sales','9+',9,0,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101950,'F',24,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','2',2,0,1,1,0,1,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101951,'M',38,'NeverM','Canada','L: 300,000 and above','HS-grad','Crafts','2',4,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101952,'M',55,'Married','United States of America','F: 110,000 - 129,999','Profsc','Exec.','3',6,1,0,0,1,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101953,'F',33,'NeverM','United States of America','D: 70,000 - 89,999','Bach.','Prof.','2',4,0,0,0,0,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101954,'F',22,'NeverM','United States of America','L: 300,000 and above','HS-grad','Cleric.','2',3,0,1,1,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101955,'M',33,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Transp.','3',3,0,1,1,0,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101956,'F',17,'NeverM','Brazil','J: 190,000 - 249,999','11th','Prof.','1',1,0,1,1,0,0,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101957,'M',25,'NeverM','Italy','J: 190,000 - 249,999','HS-grad','Transp.','6-8',3,0,1,1,0,1,1,1,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101958,'M',50,'Mabsent','United States of America','B: 30,000 - 49,999','Bach.','Prof.','2',5,0,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101959,'M',62,'NeverM','United States of America','E: 90,000 - 109,999','HS-grad','Crafts','2',6,0,0,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101960,'M',32,'Separ.','Italy','J: 190,000 - 249,999','HS-grad','Exec.','2',3,0,1,1,0,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101961,'M',23,'Married','United States of America','E: 90,000 - 109,999','Bach.','Other','3',1,0,0,0,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101962,'F',45,'Divorc.','United States of America','J: 190,000 - 249,999','< Bach.','Sales','2',7,0,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101963,'M',39,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Farming','3',5,0,1,1,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101964,'M',47,'Married','United States of America','E: 90,000 - 109,999','7th-8th','Transp.','3',5,0,0,0,1,0,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101965,'M',38,'Divorc.','United States of America','L: 300,000 and above','9th','Crafts','2',4,0,1,1,1,0,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101966,'M',28,'Married','United States of America','B: 30,000 - 49,999','< Bach.','Cleric.','3',3,1,0,0,0,1,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101967,'F',63,'Married','United States of America','C: 50,000 - 69,999','HS-grad','Transp.','4-5',3,0,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101968,'M',30,'Married','Denmark','I: 170,000 - 189,999','< Bach.','Exec.','3',3,1,1,1,0,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101969,'M',34,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',4,1,1,1,0,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101970,'F',30,'Divorc.','United States of America','A: Below 30,000','< Bach.','TechSup','1',3,0,0,0,0,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101971,'M',54,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Farming','3',5,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101972,'M',53,'Married','United States of America','J: 190,000 - 249,999','PhD','Prof.','3',5,1,1,1,1,1,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101973,'M',30,'NeverM','United States of America','L: 300,000 and above','PhD','Prof.','2',5,0,1,1,0,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101974,'M',34,'Married','United States of America','A: Below 30,000','HS-grad','Farming','3',7,0,0,0,0,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101975,'F',41,'Divorc.','United States of America','B: 30,000 - 49,999','HS-grad','Other','9+',3,0,0,0,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101976,'M',35,'NeverM','Argentina','J: 190,000 - 249,999','5th-6th','Crafts','2',4,0,1,1,1,0,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101977,'F',36,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Crafts','2',4,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101978,'M',46,'Married','United States of America','L: 300,000 and above','< Bach.','Transp.','3',6,1,1,1,1,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101979,'M',24,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Exec.','2',3,0,1,1,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101980,'F',62,'Divorc.','United States of America','E: 90,000 - 109,999','10th','Prof.','9+',6,0,0,0,1,0,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101981,'M',18,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Other','1',1,0,1,1,0,1,1,1,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101982,'F',60,'Divorc.','United States of America','I: 170,000 - 189,999','Assoc-A','Other','2',6,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101983,'M',43,'Married','United States of America','I: 170,000 - 189,999','Bach.','Sales','3',4,1,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101984,'M',21,'NeverM','United States of America','G: 130,000 - 149,999','HS-grad','Farming','1',1,0,0,0,0,1,1,1,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101985,'M',25,'NeverM','United States of America','I: 170,000 - 189,999','Assoc-A','Farming','2',3,0,1,1,0,1,1,1,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101986,'M',51,'Married','United States of America','D: 70,000 - 89,999','HS-grad','Crafts','3',5,0,0,0,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101987,'F',19,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Other','1',1,0,1,1,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101988,'M',33,'Married','United States of America','G: 130,000 - 149,999','Profsc','Prof.','3',3,1,0,0,0,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101989,'M',59,'NeverM','United States of America','I: 170,000 - 189,999','7th-8th','Other','6-8',4,0,1,1,1,0,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101990,'M',35,'Married','United States of America','E: 90,000 - 109,999','Profsc','Prof.','3',5,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101991,'M',38,'Married','United States of America','I: 170,000 - 189,999','10th','Machine','3',4,1,1,1,1,0,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101992,'M',25,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Other','1',2,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101993,'M',39,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Exec.','2',5,0,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101994,'F',63,'Divorc.','United States of America','G: 130,000 - 149,999','HS-grad','Exec.','2',6,0,0,0,1,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101995,'F',25,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Other','1',3,0,0,0,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101996,'M',29,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Crafts','3',3,0,0,0,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101997,'M',17,'NeverM','United States of America','G: 130,000 - 149,999','10th','Other','1',1,0,0,0,0,0,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101998,'M',26,'Married','Italy','L: 300,000 and above','< Bach.','Sales','3',3,0,1,1,0,1,1,1,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (101999,'M',49,'Married','United States of America','D: 70,000 - 89,999','Assoc-V','Crafts','3',5,0,0,0,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102000,'F',43,'Mabsent','United States of America','L: 300,000 and above','HS-grad','Exec.','9+',4,0,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102001,'F',41,'Divorc.','United States of America','B: 30,000 - 49,999','< Bach.','Exec.','2',4,0,0,0,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102002,'M',60,'Married','Poland','F: 110,000 - 129,999','7th-8th','Machine','3',6,0,0,0,1,0,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102003,'M',61,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Machine','3',6,0,0,0,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102004,'M',44,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',4,0,1,1,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102005,'M',29,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Crafts','3',3,0,0,0,0,1,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102006,'F',49,'Divorc.','United States of America','G: 130,000 - 149,999','HS-grad','Other','9+',5,0,0,0,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102007,'F',57,'Widowed','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','2',6,0,1,1,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102008,'M',23,'NeverM','United States of America','B: 30,000 - 49,999','< Bach.','Prof.','2',3,0,0,0,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102009,'M',41,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Crafts','3',4,1,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102010,'F',34,'Divorc.','United States of America','K: 250,000 - 299,999','HS-grad','House-s','9+',3,0,1,1,0,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102011,'M',90,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',11,0,1,1,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102012,'F',26,'NeverM','Poland','L: 300,000 and above','Bach.','Exec.','2',3,0,1,1,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102013,'M',73,'Married','United States of America','J: 190,000 - 249,999','Bach.','?','3',5,0,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102014,'M',35,'Married','Italy','E: 90,000 - 109,999','7th-8th','Machine','3',4,1,0,0,1,0,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102015,'M',61,'Married','United States of America','L: 300,000 and above','HS-grad','Protec.','3',6,0,1,1,1,1,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102016,'M',27,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','2',3,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102017,'M',64,'NeverM','United States of America','C: 50,000 - 69,999','9th','Cleric.','6-8',6,0,0,0,1,0,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102018,'M',33,'Divorc.','United States of America','J: 190,000 - 249,999','< Bach.','Sales','2',3,0,1,1,0,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102019,'F',47,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','4-5',5,1,1,1,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102020,'M',71,'Widowed','United States of America','J: 190,000 - 249,999','Presch.','Crafts','9+',2,0,1,1,1,0,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102021,'M',28,'Married','United States of America','C: 50,000 - 69,999','HS-grad','Crafts','3',4,0,0,0,0,1,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102022,'M',38,'Married','United States of America','B: 30,000 - 49,999','Bach.','Prof.','3',7,1,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102023,'M',39,'NeverM','United States of America','I: 170,000 - 189,999','Masters','Prof.','2',6,1,1,1,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102024,'M',20,'NeverM','United States of America','C: 50,000 - 69,999','HS-grad','Crafts','9+',2,0,0,0,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102025,'M',36,'Married','United States of America','L: 300,000 and above','Profsc','Prof.','3',5,1,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102026,'F',18,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Cleric.','6-8',1,0,0,0,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102027,'M',47,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','TechSup','6-8',6,0,1,1,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102028,'M',28,'NeverM','United States of America','L: 300,000 and above','< Bach.','Crafts','1',4,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102029,'F',22,'NeverM','United States of America','H: 150,000 - 169,999','HS-grad','Sales','9+',2,0,1,1,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102030,'M',38,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Machine','3',5,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102031,'M',34,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Transp.','3',4,0,1,1,0,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102032,'M',39,'NeverM','United States of America','A: Below 30,000','HS-grad','Handler','1',5,0,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102033,'M',37,'Married','United States of America','G: 130,000 - 149,999','PhD','Prof.','3',6,0,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102034,'M',49,'Married','Denmark','G: 130,000 - 149,999','Bach.','Sales','3',6,1,0,0,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102035,'F',46,'Mabsent','United States of America','K: 250,000 - 299,999','< Bach.','Sales','9+',5,0,1,1,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102036,'F',36,'Divorc.','United States of America','E: 90,000 - 109,999','Assoc-V','TechSup','9+',4,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102037,'M',49,'Married','United States of America','L: 300,000 and above','Profsc','Prof.','3',5,1,1,1,1,1,1,0,0,'I wanted to write you to let you know that I''ve purchased several items at your store recently and have been very satisfied with my purchases. Keep up  the good work.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102038,'F',22,'NeverM','United States of America','L: 300,000 and above','< Bach.','Cleric.','1',2,0,1,1,0,1,1,1,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102039,'M',37,'NeverM','United States of America','C: 50,000 - 69,999','Bach.','Farming','2',3,0,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102040,'M',37,'Married','United States of America','L: 300,000 and above','Assoc-A','Transp.','3',5,1,1,1,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102041,'F',52,'Separ.','United States of America','K: 250,000 - 299,999','Assoc-V','Exec.','9+',8,0,1,1,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102042,'M',28,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Sales','2',3,0,1,1,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102043,'F',41,'Divorc.','United States of America','B: 30,000 - 49,999','< Bach.','Other','2',2,0,0,0,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102044,'M',40,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',6,0,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102045,'M',22,'NeverM','United States of America','G: 130,000 - 149,999','Bach.','Sales','1',2,0,0,0,0,1,1,1,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102046,'M',65,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Exec.','3',7,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102047,'M',42,'Married','United States of America','F: 110,000 - 129,999','Bach.','TechSup','3',5,1,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102048,'F',31,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Machine','9+',3,0,1,1,0,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102049,'M',46,'NeverM','United States of America','C: 50,000 - 69,999','< Bach.','Exec.','2',5,0,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102050,'F',32,'Divorc.','United States of America','J: 190,000 - 249,999','Bach.','Sales','9+',2,0,1,1,0,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102051,'F',59,'Widowed','United States of America','L: 300,000 and above','HS-grad','Cleric.','9+',9,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102052,'F',49,'Divorc.','United States of America','F: 110,000 - 129,999','HS-grad','Cleric.','9+',5,0,0,0,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102053,'M',53,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Farming','3',7,0,1,1,1,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102054,'F',22,'NeverM','United States of America','F: 110,000 - 129,999','HS-grad','Cleric.','1',2,0,0,0,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102055,'F',43,'Divorc.','United States of America','K: 250,000 - 299,999','HS-grad','Cleric.','9+',5,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102056,'M',29,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Crafts','3',3,0,1,1,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102057,'F',36,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','1',4,0,1,1,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102058,'F',45,'Divorc.','United States of America','H: 150,000 - 169,999','< Bach.','Cleric.','9+',6,0,1,0,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102059,'M',37,'Married','United States of America','H: 150,000 - 169,999','11th','Transp.','3',5,0,1,0,1,0,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102060,'M',25,'NeverM','United States of America','L: 300,000 and above','HS-grad','Handler','6-8',3,0,1,1,0,1,1,1,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102061,'F',50,'Separ.','United States of America','L: 300,000 and above','HS-grad','Other','9+',5,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102062,'M',59,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Transp.','3',6,1,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102063,'F',26,'NeverM','United States of America','E: 90,000 - 109,999','< Bach.','TechSup','1',3,0,0,0,0,1,1,1,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102064,'M',41,'NeverM','United States of America','C: 50,000 - 69,999','Bach.','Handler','2',4,0,0,0,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102065,'M',34,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Crafts','3',3,0,1,1,0,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102066,'F',46,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Cleric.','2',5,0,0,0,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102067,'M',49,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Other','3',2,0,0,0,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102068,'F',50,'Married','United States of America','J: 190,000 - 249,999','Assoc-V','Prof.','4-5',5,1,1,1,1,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102069,'M',30,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Transp.','3',4,0,1,1,0,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102070,'M',28,'NeverM','United States of America','B: 30,000 - 49,999','Bach.','Exec.','1',3,0,0,0,0,1,1,1,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102071,'M',48,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',6,0,1,1,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102072,'M',27,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','3',3,0,1,1,0,1,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102073,'M',19,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','Other','1',1,0,1,1,0,1,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102074,'F',33,'Divorc.','United States of America','L: 300,000 and above','HS-grad','Cleric.','9+',3,0,1,1,0,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102075,'M',67,'Married','United States of America','D: 70,000 - 89,999','HS-grad','Exec.','3',7,1,0,0,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102076,'M',35,'Married','United States of America','L: 300,000 and above','Bach.','Sales','3',4,1,1,1,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102077,'M',43,'Divorc.','United States of America','C: 50,000 - 69,999','Bach.','Sales','9+',4,1,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102078,'F',28,'NeverM','United States of America','J: 190,000 - 249,999','Profsc','Prof.','2',6,0,1,1,0,1,1,1,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102079,'M',50,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Protec.','3',5,0,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102080,'M',49,'Married','United States of America','C: 50,000 - 69,999','PhD','Prof.','3',7,0,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102081,'M',29,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Exec.','2',3,0,1,1,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102082,'M',52,'Married','United States of America','A: Below 30,000','10th','Crafts','3',7,1,0,0,1,0,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102083,'M',45,'Married','United States of America','G: 130,000 - 149,999','Masters','Exec.','3',6,1,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102084,'M',52,'Married','United States of America','J: 190,000 - 249,999','Bach.','Prof.','3',5,1,1,1,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102085,'M',47,'Separ.','United States of America','L: 300,000 and above','HS-grad','Crafts','9+',5,0,1,1,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102086,'M',49,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Cleric.','3',6,1,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102087,'M',50,'Married','United States of America','A: Below 30,000','< Bach.','Exec.','3',10,1,0,0,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102088,'F',60,'Widowed','United States of America','I: 170,000 - 189,999','HS-grad','Machine','9+',6,0,1,1,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102089,'M',19,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','Exec.','2',2,0,1,1,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102090,'M',54,'NeverM','United States of America','B: 30,000 - 49,999','HS-grad','Sales','2',5,0,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102091,'M',34,'Married','United Kingdom','B: 30,000 - 49,999','Assoc-V','Crafts','3',3,0,0,0,0,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102092,'M',23,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Prof.','2',2,0,1,1,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102093,'M',59,'NeverM','United States of America','D: 70,000 - 89,999','Assoc-V','Crafts','2',6,0,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102094,'M',22,'Mabsent','Argentina','L: 300,000 and above','9th','Other','6-8',2,0,1,1,0,0,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102095,'M',27,'NeverM','United States of America','I: 170,000 - 189,999','Assoc-V','Crafts','6-8',3,0,1,1,0,1,1,1,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102096,'F',47,'Divorc.','United States of America','D: 70,000 - 89,999','HS-grad','Other','2',5,0,0,0,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102097,'M',67,'Married','United States of America','E: 90,000 - 109,999','Masters','Exec.','3',7,1,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102098,'M',47,'Married','United States of America','F: 110,000 - 129,999','Bach.','Sales','3',5,1,0,0,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102099,'M',20,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','?','1',2,0,0,0,0,1,1,1,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102100,'F',20,'NeverM','United States of America','F: 110,000 - 129,999','HS-grad','Other','2',2,0,0,0,0,1,1,1,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102101,'M',43,'Married','United States of America','E: 90,000 - 109,999','Masters','Prof.','3',4,1,0,0,1,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102102,'M',43,'Divorc.','United States of America','G: 130,000 - 149,999','HS-grad','Crafts','2',4,0,0,0,1,1,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102103,'M',49,'Separ.','United States of America','K: 250,000 - 299,999','HS-grad','Other','2',6,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102104,'M',31,'Married','Argentina','J: 190,000 - 249,999','HS-grad','Prof.','3',3,0,1,1,0,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102105,'M',62,'Married','China','D: 70,000 - 89,999','HS-grad','?','3',3,0,0,0,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102106,'F',20,'NeverM','United States of America','G: 130,000 - 149,999','< Bach.','Cleric.','1',1,0,0,0,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102107,'M',61,'Married','United States of America','J: 190,000 - 249,999','12th','Crafts','3',6,0,1,1,1,0,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102108,'M',22,'NeverM','United States of America','L: 300,000 and above','HS-grad','Handler','1',2,0,1,1,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102109,'F',20,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Other','1',1,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102110,'M',36,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Sales','3',4,0,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102111,'F',29,'NeverM','United States of America','I: 170,000 - 189,999','Bach.','Prof.','1',3,0,1,1,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102112,'F',25,'Married','United States of America','G: 130,000 - 149,999','Assoc-A','Cleric.','4-5',3,1,0,0,0,1,1,1,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102113,'M',63,'Married','United States of America','I: 170,000 - 189,999','HS-grad','?','3',0,0,1,1,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102114,'F',42,'Divorc.','United States of America','F: 110,000 - 129,999','Bach.','Prof.','9+',2,0,0,0,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102115,'F',20,'NeverM','United States of America','I: 170,000 - 189,999','< Bach.','Cleric.','1',2,0,1,1,0,1,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102116,'M',58,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Sales','2',7,0,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102117,'M',19,'NeverM','United States of America','B: 30,000 - 49,999','HS-grad','Farming','1',0,0,0,0,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102118,'F',45,'Divorc.','United States of America','I: 170,000 - 189,999','HS-grad','Cleric.','9+',5,0,1,1,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102119,'M',27,'NeverM','United States of America','G: 130,000 - 149,999','< Bach.','Exec.','2',3,0,0,0,0,1,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102120,'M',45,'Married','United States of America','E: 90,000 - 109,999','Masters','Cleric.','3',5,0,0,0,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102121,'M',32,'NeverM','United States of America','L: 300,000 and above','11th','Crafts','6-8',3,0,1,1,0,0,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102122,'F',43,'NeverM','Argentina','J: 190,000 - 249,999','5th-6th','Machine','9+',4,0,1,1,1,0,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102123,'M',32,'Married','United States of America','H: 150,000 - 169,999','HS-grad','Farming','3',5,1,1,0,0,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102124,'M',32,'Married','Canada','L: 300,000 and above','< Bach.','Handler','3',4,1,1,1,0,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102125,'M',43,'Separ.','United States of America','L: 300,000 and above','< Bach.','?','2',4,0,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102126,'M',17,'NeverM','United States of America','E: 90,000 - 109,999','10th','?','6-8',0,0,0,0,0,0,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102127,'M',49,'Married','United States of America','I: 170,000 - 189,999','< Bach.','Sales','3',10,1,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102128,'F',49,'Divorc.','United States of America','L: 300,000 and above','HS-grad','Other','9+',4,0,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102129,'M',30,'Married','Saudi Arabia','H: 150,000 - 169,999','Bach.','Crafts','3',3,1,1,0,0,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102130,'M',26,'Married','United States of America','C: 50,000 - 69,999','< Bach.','Other','3',3,0,0,0,0,1,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102131,'M',62,'Married','United States of America','D: 70,000 - 89,999','HS-grad','?','3',6,1,0,0,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102132,'F',26,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Prof.','2',3,0,1,1,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102133,'M',61,'Married','United States of America','B: 30,000 - 49,999','HS-grad','Farming','3',9,1,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102134,'M',18,'NeverM','United States of America','J: 190,000 - 249,999','10th','?','1',2,0,1,1,0,0,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102135,'M',27,'NeverM','United States of America','L: 300,000 and above','HS-grad','Machine','1',3,0,1,1,0,1,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102136,'F',21,'NeverM','Argentina','I: 170,000 - 189,999','< Bach.','Cleric.','2',2,0,1,1,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102137,'M',20,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Sales','1',1,0,0,0,0,1,1,1,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102138,'M',35,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Other','2',4,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102139,'M',52,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Sales','3',5,1,0,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102140,'M',44,'Married','United States of America','L: 300,000 and above','HS-grad','Transp.','3',4,0,1,1,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102141,'F',48,'Divorc.','United States of America','I: 170,000 - 189,999','Assoc-A','?','2',5,1,1,1,1,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102142,'M',47,'Married','United States of America','F: 110,000 - 129,999','PhD','Prof.','3',6,1,0,0,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102143,'F',30,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','2',4,0,1,1,0,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102144,'M',75,'Mabsent','United States of America','J: 190,000 - 249,999','< Bach.','Crafts','2',6,0,1,1,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102145,'M',29,'NeverM','Argentina','J: 190,000 - 249,999','HS-grad','Cleric.','9+',3,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102146,'M',28,'NeverM','United States of America','E: 90,000 - 109,999','HS-grad','Crafts','2',3,0,0,0,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102147,'M',46,'NeverM','United States of America','A: Below 30,000','Bach.','Exec.','2',6,0,0,0,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102148,'M',31,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Transp.','3',5,0,1,1,0,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102149,'M',28,'Mabsent','United States of America','J: 190,000 - 249,999','HS-grad','Machine','1',3,0,1,1,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102150,'M',50,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Exec.','3',5,1,0,0,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102151,'F',68,'NeverM','United States of America','E: 90,000 - 109,999','HS-grad','Sales','2',7,0,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102152,'M',72,'Married','Brazil','I: 170,000 - 189,999','HS-grad','?','3',7,0,1,1,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102153,'F',25,'NeverM','United States of America','I: 170,000 - 189,999','< Bach.','Exec.','6-8',3,0,1,1,0,1,1,1,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102154,'M',25,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','?','2',1,0,1,1,0,1,1,1,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102155,'F',43,'NeverM','United States of America','F: 110,000 - 129,999','HS-grad','Cleric.','9+',4,1,0,0,1,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102156,'M',42,'Married','United States of America','H: 150,000 - 169,999','HS-grad','Sales','3',5,0,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102157,'M',34,'NeverM','United States of America','C: 50,000 - 69,999','< Bach.','Sales','6-8',3,0,0,0,0,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102158,'F',62,'Widowed','United States of America','J: 190,000 - 249,999','< Bach.','Other','2',3,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102159,'M',27,'Married','United States of America','E: 90,000 - 109,999','< Bach.','Crafts','3',4,0,0,0,0,1,1,1,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102160,'M',48,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Other','3',6,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102161,'M',34,'Married','United States of America','B: 30,000 - 49,999','Masters','Prof.','3',4,1,0,0,0,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102162,'F',30,'Married','United States of America','D: 70,000 - 89,999','Assoc-V','Cleric.','4-5',2,0,0,0,0,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102163,'F',35,'NeverM','United States of America','B: 30,000 - 49,999','Bach.','Prof.','2',4,0,0,0,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102164,'F',34,'NeverM','United States of America','L: 300,000 and above','HS-grad','Exec.','9+',3,0,1,1,0,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102165,'F',45,'Married','United States of America','D: 70,000 - 89,999','< Bach.','Cleric.','4-5',5,1,0,0,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102166,'F',33,'Divorc.','United States of America','J: 190,000 - 249,999','< Bach.','TechSup','9+',3,0,1,1,0,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102167,'M',36,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Protec.','3',4,1,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102168,'M',27,'NeverM','United States of America','L: 300,000 and above','HS-grad','Transp.','1',3,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102169,'M',59,'Married','United States of America','E: 90,000 - 109,999','Profsc','Sales','3',4,0,0,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102170,'M',46,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Machine','3',6,0,1,1,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102171,'F',25,'NeverM','United States of America','C: 50,000 - 69,999','< Bach.','Cleric.','1',2,0,0,0,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102172,'M',52,'NeverM','United States of America','L: 300,000 and above','< Bach.','Cleric.','9+',7,0,1,1,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102173,'M',43,'Married','United States of America','L: 300,000 and above','HS-grad','Crafts','3',4,1,1,1,1,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102174,'M',20,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Crafts','1',2,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102175,'M',46,'Divorc.','Italy','I: 170,000 - 189,999','Bach.','Machine','2',5,0,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102176,'F',64,'Widowed','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','2',6,0,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102177,'M',54,'Married','United States of America','J: 190,000 - 249,999','Masters','Exec.','3',5,1,1,1,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102178,'F',27,'NeverM','Saudi Arabia','F: 110,000 - 129,999','5th-6th','Sales','1',1,0,0,0,0,0,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102179,'M',44,'Married','Italy','K: 250,000 - 299,999','HS-grad','Handler','3',4,0,1,1,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102180,'F',63,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Sales','4-5',6,0,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102181,'M',23,'NeverM','United States of America','D: 70,000 - 89,999','HS-grad','Sales','1',2,0,0,0,0,1,1,1,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102182,'M',51,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Cleric.','3',5,1,0,0,1,1,1,0,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102183,'M',47,'Married','United States of America','E: 90,000 - 109,999','< Bach.','Prof.','3',8,0,0,0,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102184,'M',51,'Married','United States of America','F: 110,000 - 129,999','Masters','Sales','3',5,1,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102185,'M',32,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Other','3',2,0,0,0,0,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102186,'M',28,'Married','United States of America','K: 250,000 - 299,999','10th','Machine','3',3,0,1,1,0,0,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102187,'M',22,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Prof.','2',2,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102188,'F',36,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','4-5',4,1,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102189,'M',44,'Married','Singapore','G: 130,000 - 149,999','Profsc','Prof.','3',7,1,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102190,'M',57,'Married','United States of America','C: 50,000 - 69,999','< Bach.','Exec.','3',7,1,0,0,1,1,1,0,0,'I wanted to write you to let you know that I''ve purchased several items at your store recently and have been very satisfied with my purchases. Keep up  the good work.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102191,'M',33,'Married','United States of America','L: 300,000 and above','HS-grad','Cleric.','3',3,0,1,1,0,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102192,'F',25,'NeverM','United States of America','F: 110,000 - 129,999','HS-grad','Sales','6-8',3,0,0,0,0,1,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102193,'F',43,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Other','4-5',2,0,1,1,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102194,'F',72,'Divorc.','Canada','B: 30,000 - 49,999','11th','Cleric.','2',2,0,0,0,1,0,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102195,'M',41,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Machine','3',3,0,0,0,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102196,'M',37,'Married','United States of America','I: 170,000 - 189,999','Profsc','Prof.','3',5,1,1,1,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102197,'M',27,'Married','United States of America','E: 90,000 - 109,999','< Bach.','Crafts','3',3,0,0,0,0,1,1,1,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102198,'F',38,'Married','United States of America','L: 300,000 and above','< Bach.','?','4-5',2,0,1,1,1,1,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102199,'M',19,'NeverM','United States of America','K: 250,000 - 299,999','HS-grad','Handler','1',2,0,1,1,0,1,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102200,'M',36,'Married','United States of America','C: 50,000 - 69,999','HS-grad','Crafts','3',4,0,0,0,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102201,'F',54,'Divorc.','United States of America','J: 190,000 - 249,999','11th','Crafts','1',7,1,1,1,1,0,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102202,'M',29,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Crafts','3',4,1,1,1,0,1,1,1,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102203,'M',61,'Married','Italy','F: 110,000 - 129,999','Masters','Crafts','3',0,0,0,0,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102204,'M',30,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Sales','3',3,1,0,0,0,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102205,'M',50,'Married','Argentina','F: 110,000 - 129,999','Assoc-A','Cleric.','3',8,0,0,0,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102206,'M',22,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Handler','3',2,0,0,0,0,1,1,1,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102207,'M',22,'NeverM','United States of America','G: 130,000 - 149,999','HS-grad','Other','1',2,0,0,0,0,1,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102208,'F',17,'NeverM','United States of America','E: 90,000 - 109,999','10th','Sales','1',1,0,0,0,0,0,1,1,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102209,'F',60,'Mabsent','United States of America','I: 170,000 - 189,999','HS-grad','Other','9+',3,0,1,1,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102210,'F',53,'Married','United States of America','K: 250,000 - 299,999','Masters','Cleric.','4-5',5,1,1,1,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102211,'M',22,'NeverM','United States of America','A: Below 30,000','12th','Farming','2',3,0,0,0,0,0,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102212,'M',43,'Married','United States of America','J: 190,000 - 249,999','Bach.','Machine','3',4,1,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102213,'M',28,'NeverM','United States of America','K: 250,000 - 299,999','HS-grad','Machine','6-8',2,0,1,1,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102214,'M',69,'Married','United States of America','C: 50,000 - 69,999','Bach.','Prof.','3',9,1,0,0,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102215,'M',28,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Machine','3',3,1,1,1,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102216,'M',24,'Married','United States of America','K: 250,000 - 299,999','11th','Sales','3',2,0,1,1,0,0,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102217,'M',35,'Divorc.','United States of America','D: 70,000 - 89,999','HS-grad','Farming','1',5,0,0,0,1,1,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102218,'M',30,'NeverM','Saudi Arabia','G: 130,000 - 149,999','Assoc-V','Cleric.','6-8',3,0,0,0,0,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102219,'M',69,'Married','United States of America','L: 300,000 and above','Bach.','?','3',7,1,1,1,1,1,1,0,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102220,'M',45,'Divorc.','United States of America','G: 130,000 - 149,999','< Bach.','Crafts','2',7,1,0,0,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102221,'M',47,'Married','United States of America','G: 130,000 - 149,999','Bach.','TechSup','3',5,1,0,0,1,1,1,0,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102222,'M',47,'Married','United States of America','I: 170,000 - 189,999','Bach.','Sales','3',7,1,1,1,1,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102223,'M',33,'Divorc.','United States of America','I: 170,000 - 189,999','12th','Crafts','2',3,0,1,1,0,0,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102224,'M',80,'Married','Canada','I: 170,000 - 189,999','HS-grad','?','3',2,0,1,1,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102225,'M',24,'NeverM','United States of America','L: 300,000 and above','< Bach.','Prof.','2',2,0,1,1,0,1,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102226,'M',34,'Married','United States of America','D: 70,000 - 89,999','< Bach.','Farming','3',6,0,0,0,0,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102227,'M',51,'Married','United States of America','C: 50,000 - 69,999','HS-grad','Crafts','3',5,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102228,'M',33,'NeverM','United States of America','L: 300,000 and above','HS-grad','Crafts','2',3,1,1,1,0,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102229,'F',24,'Married','Argentina','L: 300,000 and above','HS-grad','?','4-5',2,0,1,1,0,1,1,1,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102230,'M',52,'Married','United States of America','K: 250,000 - 299,999','PhD','Prof.','3',8,1,1,1,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102231,'M',30,'Separ.','United States of America','K: 250,000 - 299,999','< Bach.','Transp.','2',2,0,1,1,0,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102232,'M',48,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Crafts','3',5,1,0,0,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102233,'M',35,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Handler','3',5,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102234,'F',35,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Other','2',5,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102235,'M',27,'Married','United States of America','G: 130,000 - 149,999','Bach.','Exec.','6-8',3,0,0,0,0,1,1,1,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102236,'F',24,'Married','United States of America','H: 150,000 - 169,999','HS-grad','?','4-5',2,0,1,0,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102237,'M',28,'NeverM','United States of America','J: 190,000 - 249,999','Profsc','Prof.','2',4,0,1,1,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102238,'F',19,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','?','1',2,0,1,1,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102239,'M',42,'Married','United States of America','D: 70,000 - 89,999','HS-grad','Exec.','3',4,1,0,0,1,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102240,'M',49,'Married','United States of America','L: 300,000 and above','7th-8th','Machine','3',5,0,1,1,1,0,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102241,'F',22,'Married','Germany','H: 150,000 - 169,999','< Bach.','Sales','4-5',2,0,1,0,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102242,'M',32,'Married','United States of America','L: 300,000 and above','Masters','Exec.','3',3,1,1,1,0,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102243,'F',31,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','4-5',3,1,1,1,0,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102244,'F',24,'Married','South Africa','L: 300,000 and above','< Bach.','Cleric.','4-5',2,0,1,1,0,1,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102245,'F',37,'Divorc.','United States of America','E: 90,000 - 109,999','Assoc-A','Prof.','9+',4,0,0,0,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102246,'M',36,'NeverM','United States of America','L: 300,000 and above','Bach.','Exec.','2',4,1,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102247,'M',42,'Married','United States of America','F: 110,000 - 129,999','Profsc','Prof.','3',5,1,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102248,'M',41,'Married','United States of America','I: 170,000 - 189,999','< Bach.','Crafts','3',4,1,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102249,'M',40,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Sales','3',6,1,0,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102250,'M',33,'Married','United States of America','H: 150,000 - 169,999','Bach.','Prof.','3',3,1,1,0,0,1,1,0,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102251,'F',37,'Divorc.','United States of America','J: 190,000 - 249,999','< Bach.','Other','9+',4,0,1,1,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102252,'F',57,'Widowed','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','2',6,0,1,1,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102253,'M',51,'Married','United States of America','D: 70,000 - 89,999','HS-grad','Machine','3',5,0,0,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102254,'M',47,'Separ.','United States of America','L: 300,000 and above','Masters','TechSup','2',5,1,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102255,'F',29,'NeverM','United States of America','A: Below 30,000','HS-grad','Other','2',3,0,0,0,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102256,'M',23,'NeverM','United States of America','G: 130,000 - 149,999','< Bach.','Cleric.','2',1,0,0,0,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102257,'M',47,'Married','United States of America','I: 170,000 - 189,999','Bach.','Sales','3',5,1,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102258,'F',90,'NeverM','United States of America','G: 130,000 - 149,999','9th','Cleric.','2',9,0,0,0,1,0,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102259,'M',39,'Divorc.','United States of America','L: 300,000 and above','< Bach.','Other','2',4,0,1,1,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102260,'F',28,'Divorc.','United States of America','L: 300,000 and above','< Bach.','Crafts','9+',3,0,1,1,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102261,'M',35,'Married','United States of America','C: 50,000 - 69,999','HS-grad','Sales','3',4,0,0,0,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102262,'M',31,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Crafts','3',3,0,1,1,0,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102263,'F',75,'Widowed','Argentina','L: 300,000 and above','Assoc-V','Cleric.','2',4,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102264,'M',36,'Married','United States of America','J: 190,000 - 249,999','Bach.','Cleric.','3',4,0,1,1,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102265,'M',22,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','?','1',2,0,0,0,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102266,'M',41,'Married','United States of America','A: Below 30,000','Masters','Prof.','3',4,1,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102267,'M',58,'Married','United States of America','L: 300,000 and above','HS-grad','Exec.','3',6,1,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102268,'F',30,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Cleric.','2',3,0,1,1,0,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102269,'F',33,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Crafts','4-5',3,0,1,1,0,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102270,'M',33,'Separ.','Australia','K: 250,000 - 299,999','7th-8th','Handler','2',3,0,1,1,0,0,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102271,'M',31,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Farming','3',4,1,0,0,0,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102272,'M',24,'NeverM','Italy','K: 250,000 - 299,999','HS-grad','Crafts','6-8',2,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102273,'M',31,'NeverM','United States of America','E: 90,000 - 109,999','HS-grad','Exec.','1',5,0,0,0,0,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102274,'F',64,'Widowed','United States of America','J: 190,000 - 249,999','11th','?','2',6,0,1,1,1,0,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102275,'M',45,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',5,1,1,1,1,1,1,0,0,'Thank you! But I am very unhappy with all the junk mail you keep sending.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102276,'M',31,'Married','United States of America','J: 190,000 - 249,999','Bach.','Sales','3',4,1,1,1,0,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102277,'M',70,'Married','United States of America','E: 90,000 - 109,999','Bach.','Sales','3',12,1,0,0,1,1,1,0,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102278,'F',31,'Married','Canada','I: 170,000 - 189,999','Bach.','?','4-5',2,0,1,1,0,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102279,'F',25,'Married','United States of America','J: 190,000 - 249,999','Bach.','Cleric.','4-5',3,0,1,1,0,1,1,1,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102280,'M',34,'Divorc.','United States of America','B: 30,000 - 49,999','Bach.','Sales','2',5,1,0,0,0,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102281,'M',41,'Divorc.','United States of America','D: 70,000 - 89,999','HS-grad','Crafts','2',4,0,0,0,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102282,'M',44,'Married','United States of America','L: 300,000 and above','Assoc-V','Protec.','3',6,1,1,1,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102283,'M',46,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Exec.','3',7,1,1,0,1,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102284,'M',61,'Married','United States of America','G: 130,000 - 149,999','7th-8th','Transp.','3',6,0,0,0,1,0,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102285,'M',70,'Married','United States of America','I: 170,000 - 189,999','11th','Transp.','3',7,0,1,1,1,0,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102286,'M',75,'NeverM','United States of America','B: 30,000 - 49,999','PhD','?','2',8,0,0,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102287,'F',75,'Mar-AF','United States of America','J: 190,000 - 249,999','HS-grad','?','4-5',2,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102288,'M',34,'Married','United States of America','E: 90,000 - 109,999','7th-8th','Transp.','3',3,0,0,0,0,0,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102289,'M',61,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Cleric.','3',6,1,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102290,'M',32,'Married','Argentina','K: 250,000 - 299,999','Bach.','Crafts','3',6,0,1,1,0,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102291,'M',26,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Cleric.','3',3,0,1,1,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102292,'M',30,'Mabsent','Italy','I: 170,000 - 189,999','< Bach.','Crafts','2',3,0,1,1,0,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102293,'M',24,'NeverM','United States of America','K: 250,000 - 299,999','11th','Other','2',3,0,1,1,0,0,1,1,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102294,'M',37,'Married','Argentina','J: 190,000 - 249,999','5th-6th','Machine','3',4,0,1,1,1,0,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102295,'M',60,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Sales','3',8,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102296,'M',32,'Divorc.','United States of America','G: 130,000 - 149,999','HS-grad','Handler','2',3,0,0,0,0,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102297,'M',23,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','2',2,0,1,1,0,1,1,1,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102298,'M',47,'Married','Brazil','J: 190,000 - 249,999','12th','Cleric.','3',5,0,1,1,1,0,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102299,'F',49,'Divorc.','United States of America','H: 150,000 - 169,999','HS-grad','Exec.','9+',5,0,1,0,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102300,'M',31,'Married','United States of America','G: 130,000 - 149,999','12th','Crafts','3',3,0,0,0,0,0,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102301,'F',23,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Cleric.','2',1,0,1,1,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102302,'F',52,'Widowed','Italy','G: 130,000 - 149,999','< Bach.','Other','9+',5,0,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102303,'M',24,'NeverM','United States of America','K: 250,000 - 299,999','HS-grad','Farming','2',2,0,1,1,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102304,'M',46,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Cleric.','3',5,0,0,0,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102305,'F',27,'Divorc.','United States of America','K: 250,000 - 299,999','10th','Other','2',3,0,1,1,0,0,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102306,'M',43,'Married','United States of America','I: 170,000 - 189,999','< Bach.','Sales','3',6,1,1,1,1,1,1,0,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102307,'M',38,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Cleric.','3',4,1,0,0,1,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102308,'M',23,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Prof.','2',2,0,1,1,0,1,1,1,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102309,'M',42,'Married','Italy','I: 170,000 - 189,999','Masters','Sales','3',5,1,1,1,1,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102310,'M',52,'NeverM','United States of America','F: 110,000 - 129,999','PhD','Exec.','2',5,1,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102311,'M',17,'NeverM','United States of America','I: 170,000 - 189,999','11th','Handler','1',1,0,1,1,0,0,1,1,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102312,'M',19,'NeverM','United States of America','I: 170,000 - 189,999','HS-grad','Sales','1',2,0,1,1,0,1,1,1,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102313,'M',58,'Widowed','United States of America','J: 190,000 - 249,999','HS-grad','Exec.','2',7,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102314,'F',19,'NeverM','United States of America','B: 30,000 - 49,999','< Bach.','Sales','1',1,0,0,0,0,1,1,1,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102315,'F',23,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Sales','1',3,0,1,1,0,1,1,1,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102316,'F',51,'Divorc.','United States of America','I: 170,000 - 189,999','< Bach.','Sales','2',8,0,1,1,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102317,'M',56,'NeverM','United States of America','C: 50,000 - 69,999','HS-grad','Machine','2',4,0,0,0,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102318,'M',18,'NeverM','United States of America','I: 170,000 - 189,999','HS-grad','Crafts','1',2,0,1,1,0,1,1,1,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102319,'F',27,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Prof.','2',3,0,1,1,0,1,1,1,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102320,'M',37,'Married','United States of America','C: 50,000 - 69,999','< Bach.','Crafts','3',5,0,0,0,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102321,'M',36,'Divorc.','United States of America','E: 90,000 - 109,999','Assoc-V','Crafts','2',4,0,0,0,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102322,'F',57,'Divorc.','United States of America','H: 150,000 - 169,999','HS-grad','Sales','2',4,0,1,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102323,'M',52,'Married','United States of America','I: 170,000 - 189,999','Profsc','Prof.','3',9,1,1,1,1,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102324,'M',43,'Married','New Zealand','L: 300,000 and above','< Bach.','TechSup','3',4,1,1,1,1,1,1,0,0,'Thank you! But I am very unhappy with all the junk mail you keep sending.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102325,'M',30,'Married','Italy','I: 170,000 - 189,999','Bach.','Sales','3',5,0,1,1,0,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102326,'M',49,'Married','United States of America','H: 150,000 - 169,999','Profsc','Prof.','3',11,1,1,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102327,'M',35,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Sales','2',4,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102328,'F',34,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','Exec.','2',2,0,1,1,0,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102329,'F',74,'Widowed','United States of America','B: 30,000 - 49,999','< Bach.','Transp.','2',4,0,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102330,'M',38,'Married','United States of America','L: 300,000 and above','Masters','Prof.','3',5,0,1,1,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102331,'F',54,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Other','4-5',5,0,1,1,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102332,'M',27,'NeverM','United States of America','K: 250,000 - 299,999','HS-grad','Cleric.','2',3,0,1,1,0,1,1,1,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102333,'M',46,'Married','United States of America','C: 50,000 - 69,999','< Bach.','TechSup','3',5,1,0,0,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102334,'M',25,'Married','United States of America','J: 190,000 - 249,999','Bach.','Prof.','3',3,1,1,1,0,1,1,1,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102335,'M',28,'Married','Brazil','H: 150,000 - 169,999','7th-8th','Handler','3',3,0,1,1,0,0,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102336,'M',31,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Crafts','3',3,0,1,0,0,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102337,'M',27,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','TechSup','1',3,0,1,1,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102338,'M',27,'NeverM','United States of America','K: 250,000 - 299,999','Assoc-A','Transp.','2',3,0,1,1,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102339,'M',17,'NeverM','United States of America','J: 190,000 - 249,999','10th','Crafts','2',1,0,1,1,0,0,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102340,'M',51,'Married','United States of America','A: Below 30,000','Bach.','Crafts','3',5,1,0,0,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102341,'M',38,'NeverM','United States of America','H: 150,000 - 169,999','HS-grad','Handler','2',4,0,1,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102342,'F',46,'Divorc.','United States of America','I: 170,000 - 189,999','Masters','Prof.','2',7,0,1,1,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102343,'M',31,'Married','United States of America','C: 50,000 - 69,999','< Bach.','Cleric.','3',4,0,0,0,0,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102344,'F',24,'Divorc.','United States of America','G: 130,000 - 149,999','< Bach.','Cleric.','2',2,0,0,0,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102345,'M',44,'Married','United States of America','L: 300,000 and above','Bach.','Sales','3',7,1,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102346,'M',41,'Married','United States of America','J: 190,000 - 249,999','Masters','Exec.','3',6,1,1,1,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102347,'F',46,'Divorc.','United States of America','F: 110,000 - 129,999','HS-grad','Exec.','2',5,0,0,0,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102348,'F',50,'Married','United States of America','B: 30,000 - 49,999','Bach.','Exec.','4-5',5,1,0,0,1,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102349,'M',36,'Divorc.','United States of America','F: 110,000 - 129,999','10th','Sales','1',4,0,0,0,1,0,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102350,'F',34,'Divorc.','United States of America','I: 170,000 - 189,999','Assoc-V','TechSup','9+',3,0,1,1,0,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102351,'M',39,'Married','Japan','L: 300,000 and above','Bach.','Prof.','3',5,1,1,1,1,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102352,'M',22,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Crafts','2',3,0,0,0,0,1,1,1,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102353,'M',53,'Married','United States of America','J: 190,000 - 249,999','Bach.','?','3',4,1,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102354,'F',25,'NeverM','United States of America','L: 300,000 and above','HS-grad','Cleric.','6-8',3,0,1,1,0,1,1,1,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102355,'M',26,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Other','1',3,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102356,'M',34,'Married','United States of America','J: 190,000 - 249,999','Bach.','Cleric.','3',3,0,1,1,0,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102357,'F',44,'Divorc.','United States of America','J: 190,000 - 249,999','10th','Cleric.','9+',4,0,1,1,1,0,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102358,'F',38,'Married','United States of America','J: 190,000 - 249,999','11th','Cleric.','4-5',3,0,1,1,1,0,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102359,'M',46,'Divorc.','United States of America','E: 90,000 - 109,999','HS-grad','Crafts','2',5,0,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102360,'M',33,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','2',3,0,1,1,0,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102361,'M',80,'NeverM','United States of America','G: 130,000 - 149,999','HS-grad','Exec.','2',4,0,0,0,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102362,'M',28,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Machine','3',3,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102363,'F',34,'Married','United States of America','F: 110,000 - 129,999','11th','Machine','1',3,0,0,0,0,0,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102364,'F',31,'NeverM','United States of America','I: 170,000 - 189,999','Bach.','Exec.','2',4,0,1,1,0,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102365,'M',44,'Married','United States of America','I: 170,000 - 189,999','< Bach.','Exec.','3',6,0,1,1,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102366,'F',28,'Divorc.','United Kingdom','L: 300,000 and above','Bach.','Other','9+',4,1,1,1,0,1,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102367,'F',40,'NeverM','United States of America','A: Below 30,000','Masters','Prof.','2',4,0,0,0,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102368,'M',35,'Married','United States of America','E: 90,000 - 109,999','Bach.','TechSup','3',4,1,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102369,'F',62,'Divorc.','United States of America','J: 190,000 - 249,999','Assoc-V','Cleric.','2',6,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102370,'M',72,'Married','United States of America','F: 110,000 - 129,999','PhD','?','3',2,1,0,0,1,1,1,0,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102371,'F',47,'Divorc.','United States of America','J: 190,000 - 249,999','Assoc-V','Cleric.','2',5,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102372,'F',21,'Married','United States of America','K: 250,000 - 299,999','< Bach.','?','4-5',2,0,1,1,0,1,1,1,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102373,'F',51,'Separ.','United States of America','J: 190,000 - 249,999','< Bach.','Sales','2',5,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102374,'M',50,'Married','United States of America','F: 110,000 - 129,999','Bach.','Exec.','3',8,1,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102375,'F',18,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','Sales','1',1,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102376,'M',58,'Married','United States of America','D: 70,000 - 89,999','Assoc-V','Exec.','3',6,1,0,0,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102377,'F',17,'NeverM','United States of America','G: 130,000 - 149,999','10th','Sales','1',0,0,0,0,0,0,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102378,'M',60,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Transp.','3',6,0,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102379,'F',45,'Mabsent','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','9+',3,0,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102380,'M',42,'Married','United States of America','H: 150,000 - 169,999','Masters','Prof.','3',4,1,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102381,'M',47,'Divorc.','United States of America','F: 110,000 - 129,999','Assoc-V','?','2',5,0,0,0,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102382,'F',19,'NeverM','United States of America','L: 300,000 and above','HS-grad','Cleric.','1',1,0,1,1,0,1,1,1,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102383,'M',33,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Prof.','3',3,0,0,0,0,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102384,'M',62,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Handler','3',5,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102385,'M',43,'Married','Italy','L: 300,000 and above','Bach.','Prof.','3',4,1,1,1,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102386,'F',29,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','2',3,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102387,'F',25,'Divorc.','United States of America','L: 300,000 and above','HS-grad','Cleric.','2',3,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102388,'M',58,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',6,1,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102389,'M',36,'Divorc.','United States of America','I: 170,000 - 189,999','< Bach.','Cleric.','2',5,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102390,'M',56,'Divorc.','United States of America','H: 150,000 - 169,999','< Bach.','Protec.','2',7,0,1,0,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102391,'F',62,'Widowed','United States of America','L: 300,000 and above','HS-grad','Sales','2',5,0,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102392,'M',18,'NeverM','United States of America','G: 130,000 - 149,999','11th','Other','1',1,0,0,0,0,0,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102393,'M',22,'NeverM','United States of America','F: 110,000 - 129,999','HS-grad','Handler','1',2,0,0,0,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102394,'M',42,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',4,1,1,1,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102395,'M',58,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Machine','3',6,0,1,1,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102396,'M',31,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Cleric.','3',5,0,1,1,0,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102397,'M',38,'Married','Italy','F: 110,000 - 129,999','Bach.','Exec.','3',4,1,0,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102398,'F',26,'NeverM','United States of America','D: 70,000 - 89,999','Bach.','Prof.','2',3,0,0,0,0,1,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102399,'M',17,'NeverM','United States of America','K: 250,000 - 299,999','10th','Other','1',1,0,1,1,0,0,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102400,'M',36,'Married','United States of America','L: 300,000 and above','Bach.','Exec.','3',5,1,1,1,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102401,'M',37,'Married','United States of America','L: 300,000 and above','Bach.','Exec.','3',7,1,1,1,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102402,'M',30,'Married','United States of America','J: 190,000 - 249,999','Bach.','Sales','3',3,1,1,1,0,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102403,'M',23,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Transp.','1',2,0,1,1,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102404,'M',49,'Divorc.','United States of America','K: 250,000 - 299,999','Masters','Sales','2',6,1,1,1,1,1,1,0,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102405,'F',27,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Cleric.','1',3,0,1,1,0,1,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102406,'M',35,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Exec.','3',4,1,1,1,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102407,'M',40,'Married','United States of America','J: 190,000 - 249,999','9th','Handler','3',4,0,1,1,1,0,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102408,'M',23,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','1',2,0,1,1,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102409,'F',22,'NeverM','United States of America','F: 110,000 - 129,999','Bach.','Prof.','1',2,0,0,0,0,1,1,1,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102410,'F',18,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','?','1',1,0,1,1,0,1,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102411,'F',69,'Married','United States of America','H: 150,000 - 169,999','HS-grad','Sales','4-5',7,0,1,1,1,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102412,'F',37,'NeverM','Argentina','J: 190,000 - 249,999','9th','House-s','2',3,0,1,1,1,0,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102413,'F',41,'NeverM','United States of America','I: 170,000 - 189,999','Masters','Prof.','1',4,0,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102414,'F',36,'NeverM','United States of America','I: 170,000 - 189,999','< Bach.','Sales','2',4,0,1,1,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102415,'M',36,'Divorc.','United States of America','J: 190,000 - 249,999','Bach.','Prof.','9+',5,0,1,1,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102416,'M',35,'Married','United States of America','I: 170,000 - 189,999','Assoc-A','Protec.','3',4,1,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102417,'M',74,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Exec.','3',7,1,1,1,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102418,'F',33,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Machine','4-5',4,1,0,0,0,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102419,'F',63,'Widowed','United States of America','F: 110,000 - 129,999','7th-8th','Farming','9+',2,0,0,0,1,0,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102420,'M',68,'NeverM','United States of America','L: 300,000 and above','11th','Farming','9+',3,0,1,1,1,0,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102421,'M',35,'Divorc.','United States of America','H: 150,000 - 169,999','10th','?','2',9,0,1,0,1,0,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102422,'M',52,'Divorc.','United States of America','J: 190,000 - 249,999','Profsc','Exec.','2',8,1,1,1,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102423,'M',50,'Divorc.','United States of America','L: 300,000 and above','HS-grad','Crafts','2',5,0,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102424,'F',35,'Divorc.','United States of America','C: 50,000 - 69,999','HS-grad','Other','9+',4,0,0,0,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102425,'F',26,'Married','United States of America','E: 90,000 - 109,999','Bach.','Exec.','4-5',3,1,0,0,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102426,'M',48,'Divorc.','United States of America','J: 190,000 - 249,999','< Bach.','Exec.','2',5,0,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102427,'M',41,'NeverM','United States of America','C: 50,000 - 69,999','< Bach.','Protec.','1',4,0,0,0,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102428,'M',41,'Married','United States of America','F: 110,000 - 129,999','Assoc-V','Exec.','3',4,1,0,0,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102429,'M',39,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Machine','9+',4,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102430,'F',23,'Divorc.','United States of America','G: 130,000 - 149,999','HS-grad','Other','9+',5,0,0,0,0,1,1,1,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102431,'F',19,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','Other','1',1,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102432,'F',33,'Divorc.','United States of America','H: 150,000 - 169,999','< Bach.','Cleric.','9+',3,0,1,0,0,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102433,'F',34,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Prof.','2',3,0,1,1,0,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102434,'M',34,'Married','United States of America','I: 170,000 - 189,999','Masters','Exec.','3',3,0,1,1,0,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102435,'M',45,'Married','United States of America','J: 190,000 - 249,999','Masters','Prof.','3',6,1,1,1,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102436,'F',44,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Cleric.','4-5',6,1,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102437,'M',49,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Crafts','3',5,1,0,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102438,'M',42,'Married','United States of America','L: 300,000 and above','Bach.','Prof.','3',4,1,1,1,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102439,'F',26,'NeverM','United States of America','B: 30,000 - 49,999','10th','Cleric.','2',3,0,0,0,0,0,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102440,'M',20,'Married','United States of America','L: 300,000 and above','HS-grad','Sales','1',2,0,1,1,0,1,1,1,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102441,'M',62,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Crafts','3',6,0,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102442,'M',23,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Handler','2',2,0,1,1,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102443,'M',17,'NeverM','Argentina','K: 250,000 - 299,999','HS-grad','Other','6-8',2,0,1,1,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102444,'M',33,'Married','United States of America','B: 30,000 - 49,999','Assoc-V','Farming','3',6,0,0,0,0,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102445,'M',53,'Married','United States of America','L: 300,000 and above','HS-grad','Sales','3',5,0,1,1,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102446,'M',27,'Married','Argentina','J: 190,000 - 249,999','HS-grad','Machine','3',3,0,1,1,0,1,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102447,'M',44,'Married','United States of America','C: 50,000 - 69,999','Bach.','Exec.','3',6,0,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102448,'F',19,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Cleric.','1',1,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102449,'F',51,'Divorc.','United States of America','D: 70,000 - 89,999','Assoc-A','Exec.','9+',13,0,0,0,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102450,'M',42,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Sales','3',1,0,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102451,'M',78,'Widowed','United States of America','J: 190,000 - 249,999','HS-grad','Sales','2',10,1,1,1,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102452,'M',42,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','9+',4,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102453,'F',43,'Divorc.','Germany','J: 190,000 - 249,999','Bach.','Cleric.','9+',4,0,1,1,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102454,'F',43,'Married','United States of America','I: 170,000 - 189,999','Bach.','Prof.','4-5',4,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102455,'M',21,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','Handler','1',1,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102456,'M',45,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Exec.','3',3,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102457,'M',44,'Divorc.','United States of America','J: 190,000 - 249,999','Bach.','Cleric.','2',8,0,1,1,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102458,'M',27,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Farming','2',5,0,1,1,0,1,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102459,'F',26,'NeverM','United States of America','L: 300,000 and above','HS-grad','Other','6-8',3,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102460,'M',49,'NeverM','United States of America','E: 90,000 - 109,999','Bach.','House-s','2',4,0,0,0,1,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102461,'M',44,'Married','United States of America','L: 300,000 and above','Bach.','Exec.','3',6,1,1,1,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102462,'F',41,'Married','United States of America','I: 170,000 - 189,999','Bach.','Prof.','4-5',4,1,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102463,'M',19,'NeverM','United States of America','L: 300,000 and above','< Bach.','?','1',2,0,1,1,0,1,1,1,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102464,'M',47,'Married','United States of America','G: 130,000 - 149,999','Bach.','Exec.','3',6,1,0,0,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102465,'M',32,'NeverM','United States of America','J: 190,000 - 249,999','Assoc-V','Other','2',4,0,1,1,0,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102466,'M',33,'Married','United States of America','J: 190,000 - 249,999','Masters','Prof.','3',4,0,1,1,0,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102467,'M',70,'Married','Brazil','K: 250,000 - 299,999','Bach.','Exec.','3',4,0,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102468,'F',51,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Prof.','4-5',5,1,1,0,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102469,'M',28,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',3,1,1,1,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102470,'M',40,'Married','United States of America','C: 50,000 - 69,999','Bach.','Sales','3',5,1,0,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102471,'F',28,'Separ.','United States of America','L: 300,000 and above','< Bach.','Cleric.','2',3,0,1,1,0,1,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102472,'M',64,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Crafts','3',3,0,1,0,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102473,'M',38,'Married','United States of America','B: 30,000 - 49,999','Bach.','Prof.','3',6,1,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102474,'M',52,'Married','United States of America','J: 190,000 - 249,999','11th','Other','3',5,0,1,1,1,0,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102475,'F',40,'NeverM','United States of America','A: Below 30,000','Assoc-A','Cleric.','2',4,0,0,0,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102476,'M',42,'Married','United States of America','I: 170,000 - 189,999','Assoc-A','Exec.','3',4,1,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102477,'M',34,'Married','United States of America','I: 170,000 - 189,999','< Bach.','Machine','3',3,0,1,1,0,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102478,'F',19,'NeverM','United States of America','L: 300,000 and above','< Bach.','Other','1',1,0,1,1,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102479,'F',46,'Married','Argentina','J: 190,000 - 249,999','Presch.','Machine','4-5',5,0,1,1,1,0,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102480,'M',37,'Married','United States of America','B: 30,000 - 49,999','HS-grad','Crafts','3',4,0,0,0,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102481,'M',49,'Married','United States of America','G: 130,000 - 149,999','5th-6th','Other','3',5,0,0,0,1,0,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102482,'M',53,'Married','United States of America','E: 90,000 - 109,999','11th','Crafts','3',5,0,0,0,1,0,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102483,'F',39,'Divorc.','United States of America','F: 110,000 - 129,999','HS-grad','Cleric.','9+',4,0,0,0,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102484,'M',51,'Married','United States of America','J: 190,000 - 249,999','Assoc-V','Handler','3',5,1,1,1,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102485,'M',21,'NeverM','United States of America','L: 300,000 and above','HS-grad','Handler','1',2,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102486,'M',47,'Married','United States of America','L: 300,000 and above','Profsc','Prof.','3',7,1,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102487,'M',47,'Married','United States of America','F: 110,000 - 129,999','< Bach.','TechSup','3',6,0,0,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102488,'M',33,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Farming','3',7,0,1,1,0,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102489,'M',40,'Married','United States of America','J: 190,000 - 249,999','Assoc-A','Exec.','3',4,1,1,1,1,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102490,'M',53,'Married','Argentina','I: 170,000 - 189,999','5th-6th','Other','3',5,0,1,1,1,0,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102491,'M',37,'Married','United States of America','L: 300,000 and above','< Bach.','Crafts','3',4,0,1,1,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102492,'M',37,'Married','Italy','L: 300,000 and above','< Bach.','Crafts','3',6,0,1,1,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
select * from dual;

Insert all
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102493,'M',27,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Transp.','6-8',3,0,1,1,0,1,1,1,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102494,'M',44,'Married','United States of America','L: 300,000 and above','< Bach.','Sales','3',8,1,1,1,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102495,'F',30,'NeverM','France','B: 30,000 - 49,999','Masters','Cleric.','2',3,0,0,0,0,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102496,'M',42,'Married','United States of America','C: 50,000 - 69,999','Masters','Prof.','3',4,1,0,0,1,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102497,'F',22,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Cleric.','1',2,0,1,1,0,1,1,1,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102498,'M',32,'Married','United States of America','H: 150,000 - 169,999','Masters','Prof.','3',4,0,1,1,0,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102499,'M',40,'Married','United States of America','C: 50,000 - 69,999','HS-grad','Exec.','3',6,1,0,0,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102500,'M',62,'Divorc.','United States of America','G: 130,000 - 149,999','HS-grad','Transp.','6-8',6,0,0,0,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102501,'M',48,'Married','United States of America','B: 30,000 - 49,999','Bach.','Exec.','3',6,1,0,0,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102502,'M',20,'NeverM','United States of America','B: 30,000 - 49,999','< Bach.','Exec.','2',3,0,0,0,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102503,'M',34,'NeverM','United States of America','H: 150,000 - 169,999','HS-grad','Cleric.','1',3,0,1,0,0,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102504,'F',41,'Separ.','United States of America','I: 170,000 - 189,999','Bach.','Sales','9+',3,0,1,1,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102505,'M',27,'NeverM','United States of America','L: 300,000 and above','HS-grad','Machine','9+',3,0,1,1,0,1,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102506,'F',51,'Divorc.','United States of America','F: 110,000 - 129,999','< Bach.','Exec.','9+',5,0,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102507,'F',30,'Divorc.','United States of America','I: 170,000 - 189,999','HS-grad','Other','9+',3,0,1,1,0,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102508,'M',32,'Married','United States of America','L: 300,000 and above','HS-grad','Crafts','3',3,1,1,1,0,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102509,'M',28,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',3,0,1,1,0,1,1,1,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102510,'M',47,'Married','United States of America','L: 300,000 and above','Assoc-A','Protec.','3',5,1,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102511,'M',28,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Crafts','3',3,0,0,0,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102512,'M',28,'NeverM','United States of America','B: 30,000 - 49,999','Bach.','Crafts','1',3,1,0,0,0,1,1,1,0,'I wanted to write you to let you know that I''ve purchased several items at your store recently and have been very satisfied with my purchases. Keep up  the good work.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102513,'M',41,'NeverM','Poland','G: 130,000 - 149,999','HS-grad','Transp.','2',4,0,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102514,'F',39,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Machine','9+',4,0,1,1,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102515,'M',45,'Married','Italy','L: 300,000 and above','12th','Machine','3',5,0,1,1,1,0,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102516,'F',51,'Divorc.','United States of America','J: 190,000 - 249,999','< Bach.','Prof.','2',5,0,1,1,1,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102517,'M',35,'Married','United States of America','F: 110,000 - 129,999','Assoc-A','Crafts','3',4,0,0,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102518,'M',45,'Married','United States of America','E: 90,000 - 109,999','< Bach.','Exec.','3',5,0,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102519,'M',46,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',5,1,1,1,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102520,'F',22,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','Prof.','1',2,0,1,1,0,1,1,1,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102521,'M',53,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Crafts','3',5,0,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102522,'F',22,'NeverM','United States of America','L: 300,000 and above','HS-grad','?','2',3,0,1,1,0,1,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102523,'F',58,'Divorc.','United States of America','J: 190,000 - 249,999','12th','Sales','2',7,0,1,1,1,0,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102524,'M',29,'NeverM','Italy','B: 30,000 - 49,999','10th','Crafts','2',3,0,0,0,0,0,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102525,'M',44,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Machine','3',4,1,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102526,'F',19,'NeverM','United States of America','C: 50,000 - 69,999','< Bach.','Machine','2',2,0,0,0,0,1,1,1,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102527,'F',44,'Divorc.','United States of America','F: 110,000 - 129,999','HS-grad','Other','9+',4,0,0,0,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102528,'F',22,'NeverM','United States of America','C: 50,000 - 69,999','Bach.','Prof.','1',2,0,0,0,0,1,1,1,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102529,'M',41,'Married','United States of America','D: 70,000 - 89,999','Bach.','Exec.','3',4,0,0,0,1,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102530,'M',23,'NeverM','Brazil','I: 170,000 - 189,999','HS-grad','Crafts','2',2,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102531,'M',32,'Married','United States of America','L: 300,000 and above','< Bach.','Sales','3',4,0,1,1,0,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102532,'M',53,'Divorc.','United States of America','K: 250,000 - 299,999','HS-grad','Machine','9+',4,0,1,1,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102533,'M',31,'Married','United States of America','B: 30,000 - 49,999','Assoc-V','Crafts','3',3,0,0,0,0,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102534,'M',29,'Married','United States of America','E: 90,000 - 109,999','Bach.','Machine','3',4,0,0,0,0,1,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102535,'M',25,'NeverM','Singapore','J: 190,000 - 249,999','Bach.','Prof.','1',3,0,1,1,0,1,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102536,'M',20,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Machine','1',2,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102537,'F',32,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Protec.','9+',3,0,1,1,0,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102538,'F',54,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Exec.','9+',7,0,1,1,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102539,'M',59,'Married','United States of America','B: 30,000 - 49,999','9th','Transp.','3',9,1,0,0,1,0,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102540,'M',55,'NeverM','United States of America','F: 110,000 - 129,999','HS-grad','Handler','2',6,0,0,0,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102541,'M',35,'Married','United States of America','L: 300,000 and above','HS-grad','Machine','3',4,0,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102542,'M',41,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Transp.','2',4,0,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102543,'F',29,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Sales','4-5',2,0,1,1,0,1,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102544,'F',72,'Widowed','United States of America','B: 30,000 - 49,999','HS-grad','Other','9+',4,0,0,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102545,'F',21,'NeverM','United States of America','L: 300,000 and above','Assoc-V','Cleric.','2',2,0,1,1,0,1,1,1,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102546,'F',29,'NeverM','United States of America','I: 170,000 - 189,999','Bach.','Exec.','2',4,1,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102547,'F',17,'NeverM','United States of America','I: 170,000 - 189,999','10th','Other','1',0,0,1,1,0,0,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102548,'F',37,'NeverM','United States of America','G: 130,000 - 149,999','Bach.','Prof.','2',4,0,0,0,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102549,'F',30,'Separ.','United States of America','K: 250,000 - 299,999','HS-grad','Cleric.','2',3,0,1,1,0,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102550,'F',41,'Separ.','Italy','J: 190,000 - 249,999','HS-grad','Cleric.','9+',4,0,1,1,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102551,'M',65,'Married','Argentina','I: 170,000 - 189,999','Bach.','Exec.','3',7,1,1,1,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102552,'M',41,'NeverM','United States of America','F: 110,000 - 129,999','Bach.','Crafts','2',4,0,0,0,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102553,'M',50,'Married','United States of America','I: 170,000 - 189,999','Assoc-V','TechSup','3',5,1,1,1,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102554,'M',22,'NeverM','United States of America','L: 300,000 and above','< Bach.','?','1',2,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102555,'M',90,'NeverM','United States of America','B: 30,000 - 49,999','Bach.','Exec.','2',14,0,0,0,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102556,'M',46,'Married','United States of America','L: 300,000 and above','Masters','Armed-F','3',5,1,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102557,'M',70,'Married','United States of America','A: Below 30,000','HS-grad','?','3',11,0,0,0,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102558,'M',28,'Married','Argentina','L: 300,000 and above','7th-8th','Farming','3',3,0,1,1,0,0,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102559,'F',37,'NeverM','United States of America','B: 30,000 - 49,999','HS-grad','Other','2',4,0,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102560,'M',46,'Married','United States of America','L: 300,000 and above','HS-grad','Prof.','3',5,0,1,1,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102561,'F',49,'Separ.','United States of America','F: 110,000 - 129,999','10th','Other','9+',5,0,0,0,1,0,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102562,'M',33,'NeverM','United States of America','D: 70,000 - 89,999','HS-grad','Farming','2',2,0,0,0,0,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102563,'M',32,'NeverM','United States of America','I: 170,000 - 189,999','HS-grad','Cleric.','2',3,0,1,1,0,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102564,'M',43,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Exec.','3',6,1,1,1,1,1,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102565,'F',66,'Widowed','United States of America','I: 170,000 - 189,999','7th-8th','Other','2',3,0,1,1,1,0,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102566,'F',27,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','TechSup','1',3,0,1,1,0,1,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102567,'M',23,'NeverM','United States of America','L: 300,000 and above','< Bach.','Other','1',2,0,1,1,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102568,'F',20,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','?','1',2,0,1,1,0,1,1,1,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102569,'M',44,'Married','Argentina','L: 300,000 and above','HS-grad','Other','3',3,0,1,1,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102570,'M',53,'Mabsent','United States of America','H: 150,000 - 169,999','10th','Transp.','2',13,0,1,0,1,0,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102571,'F',33,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Exec.','2',3,0,0,0,0,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102572,'M',55,'Married','United States of America','J: 190,000 - 249,999','Bach.','Other','6-8',6,0,1,1,1,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102573,'M',51,'Married','United States of America','E: 90,000 - 109,999','Masters','Protec.','3',5,1,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102574,'F',45,'Separ.','United States of America','F: 110,000 - 129,999','HS-grad','Machine','9+',2,0,0,0,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102575,'M',27,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Sales','2',3,1,1,1,0,1,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102576,'F',34,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Exec.','4-5',3,1,1,1,0,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102577,'M',29,'NeverM','United States of America','I: 170,000 - 189,999','Profsc','Prof.','6-8',4,0,1,1,0,1,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102578,'M',50,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Crafts','3',5,0,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102579,'M',39,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Machine','3',4,0,1,1,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102580,'M',31,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Machine','3',4,0,0,0,0,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102581,'M',46,'Married','United States of America','L: 300,000 and above','< Bach.','Cleric.','3',5,0,1,1,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102582,'M',26,'NeverM','Italy','L: 300,000 and above','5th-6th','Transp.','2',3,0,1,1,0,0,1,1,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102583,'M',37,'NeverM','United States of America','K: 250,000 - 299,999','HS-grad','Machine','2',4,0,1,1,1,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102584,'F',35,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Sales','2',3,0,1,1,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102585,'M',53,'Married','United States of America','D: 70,000 - 89,999','PhD','Prof.','3',5,0,0,0,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102586,'F',20,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Other','2',1,0,0,0,0,1,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102587,'M',68,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Cleric.','3',7,0,0,0,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102588,'M',30,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Exec.','3',5,1,1,0,0,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102589,'M',30,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','TechSup','2',5,0,1,1,0,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102590,'F',41,'Widowed','United States of America','A: Below 30,000','< Bach.','?','2',2,0,0,0,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102591,'F',21,'NeverM','United States of America','L: 300,000 and above','HS-grad','?','1',1,0,1,1,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102592,'M',27,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Sales','3',3,0,1,1,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102593,'F',23,'NeverM','United States of America','L: 300,000 and above','HS-grad','TechSup','2',2,0,1,1,0,1,1,1,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102594,'F',44,'Divorc.','United States of America','L: 300,000 and above','< Bach.','Farming','2',4,0,1,1,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102595,'M',37,'Married','United States of America','J: 190,000 - 249,999','Masters','Cleric.','3',5,1,1,1,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102596,'F',56,'Married','United States of America','E: 90,000 - 109,999','7th-8th','Machine','4-5',7,0,0,0,1,0,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102597,'M',34,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Sales','2',3,0,1,1,0,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102598,'M',22,'NeverM','United States of America','D: 70,000 - 89,999','9th','Handler','1',2,0,0,0,0,0,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102599,'M',23,'Married','United States of America','J: 190,000 - 249,999','12th','Handler','1',2,0,1,1,0,0,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102600,'F',30,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Sales','2',3,0,1,1,0,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102601,'F',51,'Divorc.','United States of America','G: 130,000 - 149,999','HS-grad','Prof.','9+',5,1,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102602,'M',27,'NeverM','United States of America','J: 190,000 - 249,999','Bach.','Crafts','1',3,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102603,'M',27,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Handler','3',3,0,1,1,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102604,'M',18,'NeverM','United States of America','H: 150,000 - 169,999','HS-grad','Cleric.','1',2,0,1,0,0,1,1,1,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102605,'M',33,'Married','United States of America','F: 110,000 - 129,999','Bach.','Exec.','3',3,1,0,0,0,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102606,'F',28,'Married','United States of America','J: 190,000 - 249,999','Assoc-A','Cleric.','4-5',3,1,1,1,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102607,'F',46,'Married','United States of America','E: 90,000 - 109,999','< Bach.','Cleric.','4-5',5,1,0,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102608,'M',29,'NeverM','United States of America','C: 50,000 - 69,999','Assoc-A','TechSup','2',4,0,0,0,0,1,1,1,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102609,'F',40,'Divorc.','United States of America','C: 50,000 - 69,999','< Bach.','Cleric.','9+',4,0,0,0,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102610,'F',19,'NeverM','United States of America','H: 150,000 - 169,999','HS-grad','Sales','1',1,0,1,1,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102611,'M',31,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',3,0,1,1,0,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102612,'M',70,'Married','United States of America','B: 30,000 - 49,999','Masters','Prof.','3',5,1,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102613,'M',39,'Married','Argentina','L: 300,000 and above','5th-6th','Other','3',4,0,1,1,1,0,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102614,'M',43,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Protec.','3',4,0,0,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102615,'M',35,'Married','United States of America','F: 110,000 - 129,999','Masters','Exec.','3',4,0,0,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102616,'M',52,'Married','United States of America','D: 70,000 - 89,999','HS-grad','Sales','3',5,1,0,0,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102617,'F',33,'Widowed','United States of America','G: 130,000 - 149,999','HS-grad','Other','9+',3,0,0,0,0,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102618,'F',39,'NeverM','United States of America','G: 130,000 - 149,999','HS-grad','Machine','2',5,0,0,0,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102619,'M',68,'Married','United States of America','J: 190,000 - 249,999','PhD','Prof.','3',10,1,1,1,1,1,1,0,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102620,'F',39,'Divorc.','United States of America','L: 300,000 and above','Bach.','Sales','9+',4,0,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102621,'F',29,'NeverM','Argentina','L: 300,000 and above','5th-6th','Other','1',3,0,1,1,0,0,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102622,'M',32,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Sales','3',3,1,1,0,0,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102623,'M',32,'Married','United States of America','G: 130,000 - 149,999','11th','Crafts','3',3,0,0,0,0,0,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102624,'M',32,'Married','China','L: 300,000 and above','Bach.','Exec.','3',4,1,1,1,0,1,1,0,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102625,'M',35,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Machine','3',4,0,1,1,1,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102626,'F',26,'Married','United States of America','I: 170,000 - 189,999','< Bach.','Machine','4-5',3,0,1,1,0,1,1,1,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102627,'F',21,'NeverM','United States of America','B: 30,000 - 49,999','HS-grad','Sales','1',2,0,0,0,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102628,'F',38,'NeverM','United States of America','C: 50,000 - 69,999','< Bach.','Cleric.','1',4,0,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102629,'F',46,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Sales','1',5,1,1,1,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102630,'M',23,'NeverM','United States of America','D: 70,000 - 89,999','< Bach.','Exec.','2',2,0,0,0,0,1,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102631,'M',34,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Exec.','3',3,0,1,1,0,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102632,'M',25,'Married','United States of America','J: 190,000 - 249,999','Bach.','Prof.','3',3,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102633,'M',41,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Exec.','3',4,0,0,0,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102634,'M',32,'Married','United States of America','A: Below 30,000','< Bach.','Machine','3',6,1,0,0,0,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102635,'M',25,'Married','United States of America','L: 300,000 and above','< Bach.','Cleric.','3',3,0,1,1,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102636,'F',57,'Widowed','Argentina','L: 300,000 and above','< Bach.','Cleric.','9+',6,0,1,1,1,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102637,'F',36,'Separ.','Argentina','F: 110,000 - 129,999','12th','Other','9+',4,0,0,0,1,0,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102638,'F',22,'NeverM','United States of America','F: 110,000 - 129,999','Bach.','Cleric.','1',2,0,0,0,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102639,'F',24,'NeverM','United Kingdom','L: 300,000 and above','HS-grad','House-s','2',3,0,1,1,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102640,'F',21,'NeverM','United States of America','I: 170,000 - 189,999','< Bach.','Cleric.','2',2,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102641,'M',44,'Married','United States of America','H: 150,000 - 169,999','HS-grad','Exec.','3',7,1,1,1,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102642,'M',25,'NeverM','Argentina','J: 190,000 - 249,999','HS-grad','Transp.','9+',3,0,1,1,0,1,1,1,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102643,'M',42,'Married','United States of America','J: 190,000 - 249,999','Bach.','Prof.','3',5,1,1,1,1,1,1,0,0,'Thank you! But I am very unhappy with all the junk mail you keep sending.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102644,'M',36,'NeverM','Denmark','H: 150,000 - 169,999','HS-grad','Crafts','2',6,0,1,0,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102645,'M',57,'Divorc.','United States of America','L: 300,000 and above','7th-8th','Other','2',6,0,1,1,1,0,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102646,'M',28,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Transp.','3',4,0,1,1,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102647,'M',59,'Divorc.','United States of America','J: 190,000 - 249,999','HS-grad','Exec.','2',9,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102648,'M',34,'Married','United States of America','G: 130,000 - 149,999','Masters','Prof.','3',5,1,0,0,0,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102649,'F',43,'Divorc.','United States of America','H: 150,000 - 169,999','Assoc-V','Prof.','9+',4,0,1,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102650,'M',37,'NeverM','United States of America','B: 30,000 - 49,999','Bach.','Crafts','2',8,1,0,0,1,1,1,0,0,'I wanted to write you to let you know that I''ve purchased several items at your store recently and have been very satisfied with my purchases. Keep up  the good work.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102651,'M',51,'Married','United States of America','F: 110,000 - 129,999','Masters','Prof.','3',5,1,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102652,'M',26,'NeverM','United States of America','C: 50,000 - 69,999','12th','Sales','6-8',3,0,0,0,0,0,1,1,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102653,'M',46,'Married','United States of America','J: 190,000 - 249,999','Profsc','Prof.','3',7,1,1,1,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102654,'F',39,'NeverM','United States of America','G: 130,000 - 149,999','Assoc-V','Exec.','9+',5,0,0,0,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102655,'M',36,'Married','United States of America','J: 190,000 - 249,999','Bach.','Sales','3',4,1,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102656,'F',39,'NeverM','United States of America','F: 110,000 - 129,999','Bach.','Exec.','1',4,0,0,0,1,1,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102657,'M',22,'NeverM','United States of America','G: 130,000 - 149,999','11th','Other','6-8',2,0,0,0,0,0,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102658,'F',34,'NeverM','United States of America','L: 300,000 and above','HS-grad','Machine','9+',3,0,1,1,0,1,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102659,'F',57,'Divorc.','United States of America','E: 90,000 - 109,999','< Bach.','Sales','2',7,0,0,0,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102660,'M',52,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Exec.','3',5,1,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102661,'M',51,'Married','United States of America','L: 300,000 and above','Profsc','Prof.','3',6,1,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102662,'F',34,'Divorc.','United States of America','L: 300,000 and above','HS-grad','Machine','9+',3,0,1,1,0,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102663,'M',37,'Divorc.','United States of America','B: 30,000 - 49,999','HS-grad','Crafts','2',6,0,0,0,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102664,'M',25,'NeverM','United States of America','B: 30,000 - 49,999','HS-grad','Crafts','1',2,0,0,0,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102665,'F',32,'NeverM','United States of America','F: 110,000 - 129,999','HS-grad','Transp.','1',3,0,0,0,0,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102666,'M',33,'NeverM','United States of America','E: 90,000 - 109,999','< Bach.','?','1',3,0,0,0,0,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102667,'M',65,'Married','United States of America','I: 170,000 - 189,999','HS-grad','?','3',7,0,1,1,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102668,'M',38,'Married','United States of America','J: 190,000 - 249,999','12th','Crafts','3',4,1,1,1,1,0,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102669,'M',60,'Married','United States of America','L: 300,000 and above','Profsc','Prof.','3',6,1,1,1,1,1,1,0,0,'I wanted to write you to let you know that I''ve purchased several items at your store recently and have been very satisfied with my purchases. Keep up  the good work.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102670,'M',47,'Married','Italy','L: 300,000 and above','HS-grad','Transp.','3',6,1,1,1,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102671,'M',27,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Exec.','3',2,0,0,0,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102672,'F',21,'NeverM','United States of America','C: 50,000 - 69,999','< Bach.','Cleric.','2',2,0,0,0,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102673,'M',46,'Separ.','United States of America','H: 150,000 - 169,999','Assoc-V','Prof.','2',5,0,1,0,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102674,'M',28,'NeverM','Argentina','E: 90,000 - 109,999','< Bach.','Crafts','2',3,0,0,0,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102675,'M',37,'Married','United States of America','L: 300,000 and above','< Bach.','Crafts','3',6,0,1,1,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102676,'M',55,'Married','Canada','E: 90,000 - 109,999','< Bach.','TechSup','3',7,1,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102677,'F',32,'Divorc.','Canada','E: 90,000 - 109,999','Bach.','Exec.','9+',3,0,0,0,0,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102678,'M',61,'Married','United States of America','H: 150,000 - 169,999','7th-8th','Transp.','3',6,0,1,0,1,0,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102679,'M',42,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Crafts','3',5,1,1,1,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102680,'F',33,'Divorc.','United States of America','J: 190,000 - 249,999','< Bach.','TechSup','2',3,0,1,1,0,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102681,'M',48,'Married','United States of America','K: 250,000 - 299,999','Assoc-A','Prof.','3',5,0,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102682,'F',45,'NeverM','United States of America','H: 150,000 - 169,999','HS-grad','Sales','1',2,0,1,0,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102683,'M',34,'Separ.','United States of America','L: 300,000 and above','HS-grad','Cleric.','2',4,1,1,1,0,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102684,'F',22,'Mabsent','United States of America','J: 190,000 - 249,999','< Bach.','?','9+',2,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102685,'M',43,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Machine','3',4,1,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102686,'M',48,'Married','United States of America','I: 170,000 - 189,999','< Bach.','Prof.','3',5,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102687,'M',46,'Married','United States of America','J: 190,000 - 249,999','PhD','Prof.','3',8,0,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102688,'M',27,'Married','United States of America','B: 30,000 - 49,999','Bach.','TechSup','3',2,0,0,0,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102689,'M',46,'Divorc.','United States of America','K: 250,000 - 299,999','Profsc','Farming','9+',6,0,1,1,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102690,'F',47,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Machine','4-5',5,1,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102691,'F',32,'Separ.','Argentina','L: 300,000 and above','9th','Other','9+',3,0,1,1,0,0,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102692,'F',21,'NeverM','United States of America','I: 170,000 - 189,999','< Bach.','Cleric.','1',2,0,1,1,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102693,'M',61,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Protec.','3',6,0,0,0,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102694,'F',25,'NeverM','United States of America','C: 50,000 - 69,999','Bach.','Cleric.','1',3,0,0,0,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102695,'M',39,'Married','United States of America','G: 130,000 - 149,999','Bach.','Prof.','3',4,1,0,0,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102696,'M',36,'Married','United States of America','H: 150,000 - 169,999','< Bach.','Exec.','3',4,1,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102697,'M',21,'NeverM','United States of America','L: 300,000 and above','HS-grad','Handler','1',2,0,1,1,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102698,'M',22,'NeverM','United States of America','I: 170,000 - 189,999','Assoc-A','Handler','1',2,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102699,'M',35,'Married','United States of America','H: 150,000 - 169,999','Bach.','Cleric.','3',4,1,1,0,1,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102700,'M',42,'Married','United States of America','K: 250,000 - 299,999','Bach.','Exec.','3',6,0,1,1,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102701,'F',50,'Separ.','United States of America','E: 90,000 - 109,999','1st-4th','Prof.','9+',5,0,0,0,1,0,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102702,'F',51,'Divorc.','United States of America','H: 150,000 - 169,999','< Bach.','Handler','2',5,0,1,1,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102703,'M',20,'NeverM','United States of America','K: 250,000 - 299,999','< Bach.','Cleric.','1',2,0,1,1,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102704,'M',37,'NeverM','United States of America','G: 130,000 - 149,999','HS-grad','Handler','2',3,0,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102705,'M',29,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Protec.','3',3,0,1,1,0,1,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102706,'F',32,'Separ.','United States of America','I: 170,000 - 189,999','HS-grad','Other','2',2,0,1,1,0,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102707,'F',65,'Divorc.','United States of America','E: 90,000 - 109,999','11th','?','2',3,0,0,0,1,0,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102708,'F',36,'Married','Germany','L: 300,000 and above','Bach.','Cleric.','4-5',4,1,1,1,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102709,'M',63,'Widowed','United States of America','A: Below 30,000','HS-grad','Sales','2',11,0,0,0,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102710,'M',48,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Sales','3',2,0,0,0,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102711,'M',44,'Married','United States of America','H: 150,000 - 169,999','Masters','Prof.','3',7,1,1,0,1,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102712,'M',43,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','2',4,0,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102713,'M',51,'Married','United States of America','E: 90,000 - 109,999','7th-8th','Exec.','3',6,0,0,0,1,0,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102714,'F',46,'Divorc.','United States of America','E: 90,000 - 109,999','< Bach.','Machine','1',2,0,0,0,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102715,'M',27,'Married','United States of America','K: 250,000 - 299,999','Assoc-A','Crafts','3',3,1,1,1,0,1,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102716,'M',43,'Separ.','United States of America','L: 300,000 and above','< Bach.','Transp.','9+',5,1,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102717,'M',63,'Married','United States of America','L: 300,000 and above','Assoc-V','Other','3',8,0,1,1,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102718,'M',24,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Handler','1',2,0,1,1,0,1,1,1,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102719,'M',35,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Prof.','3',4,1,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102720,'M',46,'Married','United States of America','L: 300,000 and above','HS-grad','Protec.','3',12,1,1,1,1,1,1,0,0,'Thank you! But I am very unhappy with all the junk mail you keep sending.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102721,'F',25,'NeverM','Argentina','H: 150,000 - 169,999','10th','Machine','2',3,0,1,1,0,0,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102722,'M',29,'NeverM','United States of America','I: 170,000 - 189,999','Bach.','Prof.','6-8',3,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102723,'M',41,'Married','Saudi Arabia','D: 70,000 - 89,999','Bach.','Other','3',3,0,0,0,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102724,'M',22,'NeverM','United States of America','L: 300,000 and above','< Bach.','?','1',2,0,1,1,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102725,'M',29,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Machine','3',3,0,0,0,0,1,1,1,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102726,'F',21,'NeverM','Italy','G: 130,000 - 149,999','< Bach.','Other','1',2,0,0,0,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102727,'F',29,'NeverM','United States of America','L: 300,000 and above','< Bach.','Other','2',1,0,1,1,0,1,1,1,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102728,'M',56,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Transp.','3',6,0,0,0,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102729,'F',47,'Married','Italy','I: 170,000 - 189,999','Assoc-A','Cleric.','4-5',5,1,1,1,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102730,'M',41,'Married','United States of America','D: 70,000 - 89,999','< Bach.','Farming','3',4,1,0,0,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102731,'M',45,'Married','United States of America','K: 250,000 - 299,999','Masters','Exec.','3',6,1,1,1,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102732,'M',46,'Married','United States of America','I: 170,000 - 189,999','Assoc-V','Exec.','3',7,1,1,1,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102733,'M',41,'Married','United States of America','L: 300,000 and above','Masters','Exec.','3',4,1,1,1,1,1,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102734,'M',44,'Married','United States of America','F: 110,000 - 129,999','PhD','Exec.','3',7,1,0,0,1,1,1,0,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102735,'M',37,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Machine','3',4,0,1,1,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102736,'F',23,'Separ.','United States of America','G: 130,000 - 149,999','HS-grad','Handler','6-8',2,0,0,0,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102737,'F',22,'NeverM','United States of America','L: 300,000 and above','< Bach.','Cleric.','1',2,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102738,'M',36,'Married','United States of America','L: 300,000 and above','7th-8th','Crafts','3',4,0,1,1,1,0,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102739,'M',42,'Divorc.','United States of America','K: 250,000 - 299,999','< Bach.','Crafts','1',4,0,1,1,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102740,'F',74,'Divorc.','United States of America','K: 250,000 - 299,999','10th','Other','2',0,0,1,1,1,0,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102741,'M',33,'Married','United States of America','L: 300,000 and above','Masters','Prof.','3',2,1,1,1,0,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102742,'F',53,'Married','Denmark','G: 130,000 - 149,999','Bach.','Cleric.','4-5',7,0,0,0,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102743,'M',25,'Married','Argentina','K: 250,000 - 299,999','9th','Machine','3',3,0,1,1,0,0,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102744,'M',44,'Married','United States of America','H: 150,000 - 169,999','Bach.','Sales','3',4,0,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102745,'M',37,'Separ.','United States of America','J: 190,000 - 249,999','< Bach.','?','9+',4,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102746,'M',18,'NeverM','United States of America','I: 170,000 - 189,999','HS-grad','Other','6-8',2,0,1,1,0,1,1,1,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102747,'F',40,'NeverM','United States of America','B: 30,000 - 49,999','< Bach.','Cleric.','2',5,0,0,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102748,'M',28,'Married','United States of America','J: 190,000 - 249,999','Bach.','Prof.','3',4,1,1,1,0,1,1,1,0,'This Affinity Card is great.I am delighted that you sent me one as I ''ve only shopped at your store once. I was so pleased to be included in your program that I immediately purchased a new flat panel monitor.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102749,'M',47,'Married','United States of America','H: 150,000 - 169,999','Bach.','Sales','3',8,0,1,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102750,'M',32,'Married','United States of America','B: 30,000 - 49,999','7th-8th','Other','3',3,0,0,0,0,0,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102751,'M',25,'NeverM','United States of America','F: 110,000 - 129,999','Bach.','Exec.','2',3,0,0,0,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102752,'F',39,'Divorc.','United States of America','D: 70,000 - 89,999','HS-grad','Exec.','9+',5,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102753,'M',53,'Divorc.','United States of America','D: 70,000 - 89,999','PhD','Prof.','2',7,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102754,'M',66,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',7,1,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102755,'M',31,'Married','United States of America','D: 70,000 - 89,999','Assoc-A','Sales','3',5,0,0,0,0,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102756,'M',48,'Married','United States of America','B: 30,000 - 49,999','HS-grad','Farming','3',8,0,0,0,1,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102757,'M',26,'Married','United States of America','I: 170,000 - 189,999','Bach.','Sales','3',5,1,1,1,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102758,'F',25,'Divorc.','United States of America','I: 170,000 - 189,999','Assoc-V','Cleric.','9+',3,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102759,'F',36,'Divorc.','United States of America','E: 90,000 - 109,999','HS-grad','Transp.','2',4,0,0,0,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102760,'M',18,'NeverM','United States of America','B: 30,000 - 49,999','11th','Farming','1',1,0,0,0,0,0,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102761,'F',18,'NeverM','United States of America','A: Below 30,000','11th','Other','6-8',2,0,0,0,0,0,1,1,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102762,'M',47,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Crafts','3',5,0,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102763,'M',47,'Married','United States of America','A: Below 30,000','< Bach.','Farming','3',11,0,0,0,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102764,'M',79,'Married','United States of America','I: 170,000 - 189,999','Bach.','Sales','3',4,1,1,1,1,1,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102765,'M',61,'Married','United States of America','D: 70,000 - 89,999','HS-grad','Crafts','3',8,1,0,0,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102766,'M',31,'NeverM','United States of America','I: 170,000 - 189,999','Bach.','Exec.','2',5,0,1,1,0,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102767,'M',51,'Married','United States of America','E: 90,000 - 109,999','Bach.','Exec.','3',8,1,0,0,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102768,'M',37,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Machine','3',4,0,1,1,1,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102769,'M',35,'NeverM','United States of America','L: 300,000 and above','9th','Handler','2',4,0,1,1,1,0,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102770,'F',36,'Widowed','United States of America','D: 70,000 - 89,999','HS-grad','Other','9+',2,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102771,'F',20,'NeverM','United States of America','J: 190,000 - 249,999','12th','Sales','2',3,0,1,1,0,0,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102772,'M',30,'Married','United States of America','J: 190,000 - 249,999','11th','Transp.','3',3,0,1,1,0,0,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102773,'M',50,'Married','Argentina','B: 30,000 - 49,999','HS-grad','Sales','3',8,1,0,0,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102774,'M',53,'Married','United States of America','J: 190,000 - 249,999','10th','Other','3',4,0,1,1,1,0,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102775,'M',25,'NeverM','United States of America','E: 90,000 - 109,999','< Bach.','Machine','1',3,0,0,0,0,1,1,1,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102776,'F',54,'Divorc.','United States of America','E: 90,000 - 109,999','< Bach.','Cleric.','2',5,0,0,0,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102777,'M',21,'NeverM','United States of America','I: 170,000 - 189,999','Assoc-A','Handler','1',1,0,1,1,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102778,'M',25,'Separ.','United States of America','J: 190,000 - 249,999','< Bach.','Cleric.','1',3,0,1,1,0,1,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102779,'M',54,'Married','United States of America','E: 90,000 - 109,999','< Bach.','Transp.','3',4,0,0,0,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102780,'M',58,'Married','United States of America','J: 190,000 - 249,999','< Bach.','Prof.','3',6,0,1,1,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102781,'M',36,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Crafts','3',4,0,0,0,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102782,'M',28,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Crafts','3',4,0,1,1,0,1,1,1,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102783,'M',59,'Married','United States of America','E: 90,000 - 109,999','PhD','Prof.','3',9,1,0,0,1,1,1,0,0,'I run a small convenience store. Any chance that I would be eligible for larger discounts if I purchase a large quantity of items (bulk purchase)?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102784,'M',77,'NeverM','United States of America','G: 130,000 - 149,999','HS-grad','Machine','2',4,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102785,'M',57,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Cleric.','3',7,0,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102786,'M',53,'Married','United States of America','B: 30,000 - 49,999','Masters','Exec.','3',5,1,0,0,1,1,1,0,0,'I wanted to write you to let you know that I''ve purchased several items at your store recently and have been very satisfied with my purchases. Keep up  the good work.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102787,'F',38,'Divorc.','United States of America','I: 170,000 - 189,999','< Bach.','Other','9+',4,0,1,1,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102788,'M',27,'Married','United States of America','J: 190,000 - 249,999','Bach.','Sales','3',3,1,1,1,0,1,1,1,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102789,'M',48,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Machine','3',6,1,1,1,1,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102790,'F',40,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Cleric.','4-5',2,1,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102791,'F',47,'Divorc.','United States of America','H: 150,000 - 169,999','Assoc-V','Prof.','2',5,0,1,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102792,'M',33,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Cleric.','3',3,0,1,1,0,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102793,'F',26,'NeverM','United States of America','J: 190,000 - 249,999','Masters','Prof.','2',3,0,1,1,0,1,1,1,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102794,'M',59,'Divorc.','United States of America','I: 170,000 - 189,999','Masters','Prof.','2',6,1,1,1,1,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102795,'M',43,'Separ.','Argentina','J: 190,000 - 249,999','HS-grad','Transp.','9+',4,0,1,1,1,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102796,'M',39,'Married','United States of America','K: 250,000 - 299,999','PhD','Exec.','3',5,1,1,1,1,1,1,0,0,'Thank you! But I am very unhappy with all the junk mail you keep sending.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102797,'F',62,'Divorc.','United States of America','F: 110,000 - 129,999','HS-grad','Other','2',6,0,0,0,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102798,'M',31,'NeverM','United States of America','L: 300,000 and above','HS-grad','Other','9+',2,0,1,1,0,1,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102799,'M',39,'Divorc.','United States of America','L: 300,000 and above','HS-grad','Cleric.','2',4,0,1,1,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102800,'M',30,'Divorc.','United States of America','J: 190,000 - 249,999','< Bach.','Machine','2',3,0,1,1,0,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102801,'M',56,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Exec.','3',7,0,0,0,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102802,'F',64,'NeverM','United States of America','I: 170,000 - 189,999','Assoc-A','Prof.','6-8',5,0,1,1,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102803,'F',25,'NeverM','United States of America','E: 90,000 - 109,999','HS-grad','Cleric.','1',3,0,0,0,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102804,'M',71,'Married','United States of America','I: 170,000 - 189,999','Bach.','?','3',2,1,1,1,1,1,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102805,'F',59,'Married','United States of America','F: 110,000 - 129,999','10th','Exec.','4-5',6,0,0,0,1,0,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102806,'M',39,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','3',6,1,1,1,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102807,'F',20,'NeverM','United States of America','H: 150,000 - 169,999','HS-grad','?','1',1,0,1,0,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102808,'F',65,'Widowed','United States of America','J: 190,000 - 249,999','< Bach.','Other','9+',3,0,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102809,'M',20,'NeverM','United States of America','L: 300,000 and above','< Bach.','Transp.','1',2,0,1,1,0,1,1,1,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102810,'F',29,'NeverM','United States of America','G: 130,000 - 149,999','< Bach.','Other','2',3,1,0,0,0,1,1,1,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102811,'M',51,'Married','Argentina','J: 190,000 - 249,999','1st-4th','Crafts','3',5,0,1,1,1,0,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102812,'M',42,'Married','United States of America','C: 50,000 - 69,999','< Bach.','Machine','3',4,0,0,0,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102813,'M',22,'Divorc.','United States of America','L: 300,000 and above','10th','Crafts','1',2,0,1,1,0,0,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102814,'M',41,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Prof.','3',4,1,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102815,'M',33,'Married','Brazil','L: 300,000 and above','HS-grad','Sales','3',3,1,1,1,0,1,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102816,'F',42,'NeverM','United States of America','G: 130,000 - 149,999','Assoc-V','Cleric.','2',4,0,0,0,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102817,'M',55,'Married','United States of America','J: 190,000 - 249,999','Bach.','Prof.','3',6,1,1,1,1,1,1,0,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102818,'F',40,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Other','2',4,0,1,1,1,1,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102819,'M',31,'Married','United States of America','C: 50,000 - 69,999','< Bach.','Other','3',4,0,0,0,0,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102820,'F',27,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','1',3,0,1,1,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102821,'M',34,'Married','United States of America','L: 300,000 and above','PhD','Prof.','3',4,1,1,1,0,1,1,0,0,'Does this discount work if you live in Australia?I''ve moved and I would like to purchase a few items as gifts but want the discount.  Have you ever considered offering free shipping?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102822,'M',19,'NeverM','United States of America','L: 300,000 and above','HS-grad','Crafts','2',2,0,1,1,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102823,'M',38,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Transp.','3',4,1,0,0,1,1,1,0,0,'Can I apply my discount to a purchase I made last month? Excellent program.  Thanks')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102824,'M',43,'Married','United Kingdom','K: 250,000 - 299,999','Bach.','Exec.','3',4,1,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102825,'M',63,'Separ.','United States of America','I: 170,000 - 189,999','10th','Machine','2',6,0,1,1,1,0,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102826,'F',33,'NeverM','United States of America','J: 190,000 - 249,999','10th','Crafts','9+',3,0,1,1,0,0,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102827,'M',21,'NeverM','United States of America','L: 300,000 and above','< Bach.','?','1',2,0,1,1,0,1,1,1,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102828,'F',36,'NeverM','United States of America','E: 90,000 - 109,999','HS-grad','Machine','1',4,0,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102829,'M',24,'NeverM','United States of America','G: 130,000 - 149,999','HS-grad','Crafts','1',3,0,0,0,0,1,1,1,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102830,'M',37,'Married','United States of America','J: 190,000 - 249,999','Bach.','Exec.','6-8',5,0,1,1,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102831,'M',39,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Cleric.','3',5,0,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102832,'M',29,'Married','United States of America','B: 30,000 - 49,999','Assoc-V','Handler','3',3,0,0,0,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102833,'M',34,'Divorc.','United States of America','C: 50,000 - 69,999','11th','Crafts','9+',3,0,0,0,0,0,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102834,'F',18,'NeverM','United States of America','E: 90,000 - 109,999','< Bach.','Other','1',0,0,0,0,0,1,1,1,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102835,'F',35,'NeverM','United States of America','I: 170,000 - 189,999','Assoc-V','Other','9+',3,0,1,1,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102836,'F',69,'Widowed','United States of America','D: 70,000 - 89,999','< Bach.','Farming','2',2,0,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102837,'F',48,'Separ.','United States of America','C: 50,000 - 69,999','9th','?','2',2,0,0,0,1,0,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102838,'M',53,'NeverM','United States of America','E: 90,000 - 109,999','HS-grad','Cleric.','6-8',5,0,0,0,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102839,'M',51,'Married','United States of America','F: 110,000 - 129,999','7th-8th','Crafts','3',5,0,0,0,1,0,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102840,'M',28,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Crafts','3',3,0,1,1,0,1,1,1,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102841,'M',56,'Married','United States of America','L: 300,000 and above','Assoc-V','Crafts','3',8,1,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102842,'M',35,'Married','United States of America','L: 300,000 and above','9th','Crafts','3',4,0,1,1,1,0,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102843,'M',37,'Married','United States of America','L: 300,000 and above','< Bach.','Machine','3',4,0,1,1,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102844,'M',58,'Married','United States of America','G: 130,000 - 149,999','Bach.','Prof.','3',6,0,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102845,'M',59,'Married','Italy','I: 170,000 - 189,999','Bach.','Handler','3',6,1,1,1,1,1,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102846,'F',30,'NeverM','United States of America','L: 300,000 and above','< Bach.','Transp.','9+',3,0,1,1,0,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102847,'M',41,'Married','China','I: 170,000 - 189,999','7th-8th','Crafts','3',4,0,1,1,1,0,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102848,'M',50,'Divorc.','United States of America','J: 190,000 - 249,999','< Bach.','?','9+',5,0,1,1,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102849,'M',42,'Married','United States of America','E: 90,000 - 109,999','Assoc-V','Exec.','3',5,0,0,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102850,'M',33,'Married','United States of America','J: 190,000 - 249,999','Bach.','Sales','3',5,1,1,1,0,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102851,'M',37,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Crafts','3',5,1,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102852,'M',41,'Married','United States of America','B: 30,000 - 49,999','< Bach.','Farming','3',5,1,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102853,'F',33,'Mabsent','United States of America','K: 250,000 - 299,999','HS-grad','Other','9+',3,0,1,1,0,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102854,'M',60,'Divorc.','United States of America','J: 190,000 - 249,999','< Bach.','Crafts','1',6,1,1,1,1,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102855,'M',39,'Married','United States of America','L: 300,000 and above','HS-grad','Machine','3',4,1,1,1,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102856,'F',68,'Widowed','United States of America','G: 130,000 - 149,999','HS-grad','Other','9+',3,0,0,0,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102857,'F',41,'Separ.','United States of America','D: 70,000 - 89,999','Bach.','Prof.','9+',4,0,0,0,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102858,'M',24,'NeverM','Argentina','J: 190,000 - 249,999','Presch.','Farming','2',2,0,1,1,0,0,1,1,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102859,'F',48,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Handler','4-5',2,1,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102860,'M',28,'Married','United States of America','G: 130,000 - 149,999','HS-grad','Other','3',3,0,0,0,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102861,'M',40,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Transp.','3',4,0,1,1,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102862,'M',51,'Divorc.','United States of America','C: 50,000 - 69,999','Assoc-V','TechSup','2',5,1,0,0,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102863,'F',43,'Divorc.','United States of America','J: 190,000 - 249,999','Bach.','Cleric.','2',4,0,1,1,1,1,1,0,0,'A lousy idea.  I threw your card away. If you want to know what I buy, I''ll shop elsewhere.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102864,'F',41,'Widowed','United States of America','L: 300,000 and above','11th','Other','9+',4,0,1,1,1,0,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102865,'M',22,'Married','United States of America','B: 30,000 - 49,999','< Bach.','Sales','3',2,0,0,0,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102866,'F',39,'Separ.','United States of America','L: 300,000 and above','HS-grad','Machine','9+',2,0,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102867,'M',23,'Married','United States of America','C: 50,000 - 69,999','< Bach.','Sales','3',3,0,0,0,0,1,1,1,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102868,'M',42,'Married','United States of America','I: 170,000 - 189,999','Bach.','Exec.','3',4,1,1,1,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102869,'M',61,'Married','United States of America','J: 190,000 - 249,999','HS-grad','?','3',6,1,1,1,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102870,'M',34,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Handler','1',3,0,1,1,0,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102871,'M',41,'Divorc.','United States of America','F: 110,000 - 129,999','Bach.','Other','2',4,0,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102872,'M',44,'NeverM','United States of America','J: 190,000 - 249,999','Assoc-V','TechSup','2',4,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102873,'F',53,'Divorc.','United States of America','G: 130,000 - 149,999','Bach.','Cleric.','9+',5,0,0,0,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102874,'M',22,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Machine','1',2,0,1,1,0,1,1,1,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102875,'F',40,'Divorc.','United States of America','J: 190,000 - 249,999','9th','Other','2',4,0,1,1,1,0,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102876,'F',53,'Divorc.','United States of America','I: 170,000 - 189,999','Masters','Prof.','9+',7,0,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102877,'M',32,'Married','United States of America','F: 110,000 - 129,999','HS-grad','Transp.','3',3,1,0,0,0,1,1,0,0,'My brother uses the affinity card a lot. I think the competitor has better prices without it.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102878,'M',49,'Divorc.','United States of America','B: 30,000 - 49,999','< Bach.','TechSup','6-8',5,0,0,0,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102879,'M',32,'Married','United States of America','K: 250,000 - 299,999','Bach.','Sales','3',3,0,1,1,0,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102880,'M',34,'Married','United States of America','I: 170,000 - 189,999','< Bach.','Machine','3',4,1,1,1,0,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102881,'M',42,'Married','United States of America','D: 70,000 - 89,999','Profsc','Prof.','3',4,1,0,0,1,1,1,0,0,'I love it. Will never shop at other shops again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102882,'M',61,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Exec.','3',3,1,1,1,1,1,1,0,0,'If I forget my affinity card, can I still shop here and get the discount?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102883,'M',20,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Sales','3',2,0,1,1,0,1,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102884,'F',24,'Separ.','United States of America','F: 110,000 - 129,999','< Bach.','Cleric.','9+',2,0,0,0,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102885,'M',29,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Machine','3',3,0,1,1,0,1,1,1,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102886,'F',21,'NeverM','United States of America','I: 170,000 - 189,999','< Bach.','Sales','1',1,0,1,1,0,1,1,1,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102887,'F',28,'NeverM','United States of America','K: 250,000 - 299,999','Bach.','TechSup','2',3,0,1,1,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102888,'F',45,'NeverM','United States of America','I: 170,000 - 189,999','Assoc-A','Cleric.','2',5,0,1,1,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102889,'F',33,'Divorc.','United States of America','L: 300,000 and above','< Bach.','?','2',3,0,1,1,0,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102890,'F',31,'NeverM','United States of America','I: 170,000 - 189,999','HS-grad','Other','2',3,0,1,1,0,1,1,0,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102891,'F',21,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Sales','2',2,0,1,1,0,1,1,1,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102892,'M',36,'Married','United States of America','G: 130,000 - 149,999','9th','Crafts','3',3,0,0,0,1,0,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102893,'F',46,'Divorc.','United States of America','G: 130,000 - 149,999','< Bach.','Cleric.','9+',5,0,0,0,1,1,1,0,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102894,'M',35,'Divorc.','United States of America','H: 150,000 - 169,999','HS-grad','Exec.','2',5,0,1,1,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102895,'M',49,'Separ.','United States of America','I: 170,000 - 189,999','10th','Exec.','2',12,0,1,1,1,0,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102896,'F',60,'Widowed','United States of America','I: 170,000 - 189,999','HS-grad','Handler','2',6,0,1,1,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102897,'M',35,'NeverM','United States of America','L: 300,000 and above','Bach.','Exec.','2',4,0,1,1,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102898,'M',41,'Married','United States of America','L: 300,000 and above','HS-grad','Exec.','3',5,0,1,1,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102899,'F',31,'Married','United States of America','E: 90,000 - 109,999','HS-grad','Machine','4-5',5,0,0,0,0,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102900,'M',25,'NeverM','United States of America','C: 50,000 - 69,999','12th','Other','6-8',3,0,0,0,0,0,1,1,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102901,'M',55,'Married','United States of America','C: 50,000 - 69,999','9th','Farming','3',4,0,0,0,1,0,1,0,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102902,'F',45,'Divorc.','Poland','H: 150,000 - 169,999','< Bach.','TechSup','2',5,0,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102903,'M',50,'Married','United States of America','L: 300,000 and above','HS-grad','Machine','3',5,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102904,'M',26,'Married','United States of America','I: 170,000 - 189,999','< Bach.','Prof.','3',3,0,1,1,0,1,1,1,0,'Affinity card is great. I think it is a hassle to have to remember to bring it in every time though.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102905,'M',30,'Separ.','United States of America','L: 300,000 and above','7th-8th','Transp.','2',3,0,1,1,0,0,1,0,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102906,'M',38,'Married','Italy','L: 300,000 and above','HS-grad','Machine','3',7,0,1,1,1,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102907,'M',64,'Divorc.','United States of America','K: 250,000 - 299,999','Bach.','TechSup','2',6,0,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102908,'M',29,'NeverM','United States of America','K: 250,000 - 299,999','12th','Crafts','9+',3,0,1,1,0,0,1,1,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102909,'M',23,'Divorc.','United States of America','K: 250,000 - 299,999','Assoc-V','TechSup','2',3,0,1,1,0,1,1,1,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102910,'M',52,'Married','United States of America','G: 130,000 - 149,999','Bach.','Sales','3',7,1,0,0,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102911,'F',48,'NeverM','Argentina','L: 300,000 and above','Bach.','Prof.','2',6,0,1,1,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102912,'M',43,'NeverM','United States of America','I: 170,000 - 189,999','HS-grad','Crafts','2',5,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102913,'M',39,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Protec.','3',4,0,0,0,1,1,1,0,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102914,'M',17,'NeverM','United States of America','J: 190,000 - 249,999','10th','Other','1',1,0,1,1,0,0,1,1,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102915,'M',40,'Divorc.','United States of America','E: 90,000 - 109,999','HS-grad','Crafts','2',5,0,0,0,1,1,1,0,0,'The more times that I shop at your store, the more times I am impressed.  Don''t change anything')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102916,'M',19,'NeverM','United States of America','J: 190,000 - 249,999','HS-grad','Handler','6-8',2,0,1,1,0,1,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102917,'M',43,'Married','United States of America','D: 70,000 - 89,999','HS-grad','Crafts','3',6,0,0,0,1,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102918,'M',56,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Prof.','3',6,0,1,1,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102919,'M',28,'Married','United States of America','C: 50,000 - 69,999','HS-grad','Crafts','3',3,1,0,0,0,1,1,1,0,'Thank you! But I am very unhappy with all the junk mail you keep sending.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102920,'M',29,'Married','United States of America','C: 50,000 - 69,999','Assoc-V','Cleric.','3',3,0,0,0,0,1,1,1,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102921,'M',24,'Married','Argentina','L: 300,000 and above','HS-grad','Sales','3',2,0,1,1,0,1,1,1,0,'I shop your store a lot.  I love your weekly specials.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102922,'F',72,'Widowed','United States of America','E: 90,000 - 109,999','< Bach.','TechSup','2',4,0,0,0,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102923,'M',57,'Married','United States of America','B: 30,000 - 49,999','HS-grad','Crafts','3',7,0,0,0,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102924,'M',35,'Married','United States of America','L: 300,000 and above','HS-grad','Machine','3',4,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102925,'M',20,'NeverM','United States of America','F: 110,000 - 129,999','HS-grad','Cleric.','6-8',1,0,0,0,0,1,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102926,'F',77,'Married','United States of America','L: 300,000 and above','9th','House-s','4-5',2,0,1,1,1,0,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102927,'M',40,'NeverM','United States of America','I: 170,000 - 189,999','< Bach.','Exec.','2',5,1,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102928,'M',34,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Machine','3',4,0,1,1,0,1,1,0,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102929,'M',48,'Married','United States of America','H: 150,000 - 169,999','Assoc-A','Transp.','3',6,0,1,0,1,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102930,'M',31,'NeverM','United States of America','G: 130,000 - 149,999','HS-grad','Exec.','1',3,0,0,0,0,1,1,0,0,'How much would it cost to upgrade my computer to the latest model you advertised this week?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102931,'M',32,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Sales','3',4,0,1,1,0,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102932,'M',54,'Married','United States of America','F: 110,000 - 129,999','< Bach.','Sales','3',5,0,0,0,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102933,'M',38,'Divorc.','Turkey','J: 190,000 - 249,999','< Bach.','Crafts','2',4,0,1,1,1,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102934,'F',54,'Widowed','United States of America','H: 150,000 - 169,999','HS-grad','Handler','9+',5,0,1,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102935,'M',64,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Sales','3',3,0,1,1,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102936,'M',31,'Married','United States of America','L: 300,000 and above','HS-grad','Crafts','3',3,0,1,1,0,1,1,0,0,null)
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102937,'M',24,'NeverM','United States of America','B: 30,000 - 49,999','Bach.','Sales','2',3,0,0,0,0,1,1,1,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102938,'F',25,'NeverM','United States of America','G: 130,000 - 149,999','HS-grad','Cleric.','2',3,0,0,0,0,1,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102939,'M',33,'Mabsent','United States of America','J: 190,000 - 249,999','Assoc-A','Crafts','2',2,0,1,1,0,1,1,0,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102940,'M',37,'Divorc.','United States of America','D: 70,000 - 89,999','HS-grad','Farming','2',4,0,0,0,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102941,'M',47,'Married','United States of America','G: 130,000 - 149,999','< Bach.','Exec.','3',5,0,0,0,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102942,'M',32,'Married','Argentina','J: 190,000 - 249,999','< Bach.','Cleric.','3',3,0,1,1,0,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102943,'F',18,'NeverM','United States of America','J: 190,000 - 249,999','11th','Other','1',0,0,1,1,0,0,1,1,0,'Thanks a lot for my new affinity card. I love the discounts and have since started shopping at your store for everything.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102944,'M',38,'Married','United States of America','K: 250,000 - 299,999','HS-grad','Crafts','3',5,0,1,1,1,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102945,'M',38,'Married','Argentina','J: 190,000 - 249,999','7th-8th','Crafts','3',4,0,1,1,1,0,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102946,'F',47,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Other','4-5',5,0,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102947,'M',23,'NeverM','United States of America','L: 300,000 and above','< Bach.','?','2',2,0,1,1,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102948,'F',76,'Widowed','United States of America','E: 90,000 - 109,999','10th','Sales','9+',2,0,0,0,1,0,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102949,'M',20,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Other','1',1,0,1,1,0,1,1,1,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102950,'M',42,'Married','United States of America','J: 190,000 - 249,999','Assoc-A','Crafts','3',5,1,1,1,1,1,1,0,0,'I wanted to write you to let you know that I''ve purchased several items at your store recently and have been very satisfied with my purchases. Keep up  the good work.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102951,'M',32,'Married','United States of America','F: 110,000 - 129,999','Bach.','Exec.','3',5,1,0,0,0,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102952,'M',19,'NeverM','United States of America','H: 150,000 - 169,999','< Bach.','Other','1',1,0,1,1,0,1,1,1,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102953,'F',50,'Married','United States of America','H: 150,000 - 169,999','Assoc-A','Sales','4-5',5,0,1,1,1,1,1,0,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102954,'F',21,'NeverM','United States of America','F: 110,000 - 129,999','< Bach.','Other','1',2,0,0,0,0,1,1,1,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102955,'M',82,'Married','Brazil','J: 190,000 - 249,999','HS-grad','Crafts','3',8,0,1,1,1,1,1,0,0,'I used to shop at your store, but have stopped now. I tried to return some electronic items and your store manager was a pain to deal with.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102956,'M',19,'NeverM','United States of America','K: 250,000 - 299,999','7th-8th','Cleric.','1',4,0,1,1,0,0,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102957,'F',54,'NeverM','United States of America','H: 150,000 - 169,999','Masters','?','2',5,0,1,1,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102958,'M',41,'Separ.','United States of America','L: 300,000 and above','12th','Crafts','2',4,0,1,1,1,0,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102959,'M',41,'Married','Singapore','F: 110,000 - 129,999','Masters','Prof.','3',6,1,0,0,1,1,1,0,0,'Shopping at your store is a hassle. I rarely shop there and usually forget to bring your new loyalty card and hence never get the items at the sale price.  Can a store manager look up my account on-line?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102960,'M',39,'Married','United States of America','K: 250,000 - 299,999','Assoc-V','Crafts','3',5,0,1,1,1,1,1,0,0,'I am not going to waste my time filling up this three page form. Lousy idea.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102961,'M',38,'Married','United States of America','K: 250,000 - 299,999','Bach.','Sales','3',4,1,1,1,1,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102962,'M',60,'Married','United States of America','E: 90,000 - 109,999','Assoc-V','TechSup','3',6,1,0,0,1,1,1,0,0,'I purchased a new computer recently, but the manuals weren''t included.  Could you ship them to me directly?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102963,'F',46,'Widowed','United States of America','H: 150,000 - 169,999','HS-grad','Cleric.','9+',5,0,1,0,1,1,1,0,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102964,'M',47,'Married','United States of America','K: 250,000 - 299,999','< Bach.','Exec.','3',9,0,1,1,1,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102965,'M',37,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Crafts','3',4,0,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102966,'M',27,'NeverM','United States of America','H: 150,000 - 169,999','Assoc-V','Protec.','2',4,0,1,0,0,1,1,1,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102967,'F',40,'Married','United States of America','J: 190,000 - 249,999','Profsc','Prof.','4-5',3,1,1,1,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102968,'M',24,'Married','United States of America','K: 250,000 - 299,999','7th-8th','Crafts','3',2,0,1,1,0,0,1,1,0,'I love shopping with my Affinity Card! Thank you. I used it to purchase a new flat panel monitor. It is amazing. Thank you again!')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102969,'M',42,'NeverM','United States of America','J: 190,000 - 249,999','Masters','Exec.','2',5,1,1,1,1,1,1,0,0,'I don''t like your new Affinity Card program.  Too little, too late.  I am very happy with your competitor''s stores.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102970,'M',40,'NeverM','United States of America','I: 170,000 - 189,999','Bach.','TechSup','2',4,0,1,1,1,1,1,0,0,'Can I use my Affinity card to buy bulk purchases and ship them to my mother in Arizona?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102971,'M',65,'Married','United States of America','A: Below 30,000','HS-grad','Crafts','3',7,0,0,0,1,1,1,0,0,'Thank you, But please remove my name from your list.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102972,'M',40,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Handler','3',4,0,1,1,1,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102973,'M',25,'NeverM','Argentina','J: 190,000 - 249,999','< Bach.','TechSup','1',1,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102974,'F',19,'NeverM','United States of America','E: 90,000 - 109,999','10th','Other','6-8',1,0,0,0,0,0,1,1,0,'I just purchased a computer from your store last month.  Why didn''t you offer this discount then?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102975,'M',31,'NeverM','United States of America','C: 50,000 - 69,999','10th','Other','2',3,0,0,0,0,0,1,0,0,'Why didn''t you start a program like this before? Everyone else has been offering discounts like this for years.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102976,'M',35,'NeverM','United States of America','I: 170,000 - 189,999','HS-grad','Handler','1',5,0,1,1,1,1,1,0,0,'I love the new on-line documentation.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102977,'F',36,'Married','United States of America','I: 170,000 - 189,999','HS-grad','Other','4-5',4,0,1,1,1,1,1,0,0,'Forget it. I ''m not giving you all my personal information.  I wish you''d give up and respect a customer''s privacy.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102978,'M',60,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Exec.','3',6,1,1,1,1,1,1,0,0,'Could you send an Affinity Card to my mother in France?  Let me know and I''ll send you here address.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102979,'M',78,'Married','United States of America','I: 170,000 - 189,999','Bach.','Exec.','3',8,1,1,1,1,1,1,0,0,'A great idea.  Thank you!  Signed, happy in Texas')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102980,'F',19,'NeverM','United States of America','L: 300,000 and above','< Bach.','Cleric.','1',1,0,1,1,0,1,1,1,0,'It is a good way to attract new shoppers. After shopping at your store for more than a month, I am ready to move on though. Not enough variety')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102981,'F',43,'Married','United States of America','J: 190,000 - 249,999','Assoc-V','Prof.','4-5',4,1,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102982,'F',33,'NeverM','United States of America','J: 190,000 - 249,999','Assoc-V','Prof.','9+',2,0,1,1,0,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102983,'M',32,'Married','United States of America','G: 130,000 - 149,999','Bach.','Machine','3',4,0,0,0,0,1,1,0,0,'I love the discounts. But I mostly end upbuying  things I do not need.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102984,'F',30,'Separ.','United States of America','D: 70,000 - 89,999','< Bach.','Other','9+',3,0,0,0,0,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102985,'M',27,'NeverM','United States of America','L: 300,000 and above','HS-grad','Cleric.','2',3,0,1,1,0,1,1,1,0,'A great program but I have to complain just a bit. Why do you need to know how many children I have, where I shop, etc.?  Give us a discount for shopping at your store, but don''t ask too many personal questions.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102986,'M',19,'NeverM','United States of America','A: Below 30,000','< Bach.','Prof.','1',0,0,0,0,0,1,1,1,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102987,'M',51,'Married','United States of America','L: 300,000 and above','HS-grad','Crafts','3',5,1,1,1,1,1,1,0,0,'Even with the new 10% card, your prices are still too expensive. I am tired of your gimmicks.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102988,'F',31,'Separ.','United States of America','J: 190,000 - 249,999','HS-grad','Other','2',3,0,1,1,0,1,1,0,0,'Don''t send me any more promotions.  I get too much lousy junk mail already')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102989,'M',35,'NeverM','United States of America','E: 90,000 - 109,999','Bach.','Sales','2',4,0,0,0,1,1,1,0,0,'Affinity card is a great idea. But your store is still too expensive. I am tired of your lousy junk mail.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102990,'M',35,'NeverM','United States of America','K: 250,000 - 299,999','Masters','Sales','2',5,0,1,1,1,1,1,0,0,'Great program.  Love the discount. Signed happy customer.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102991,'M',52,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Sales','3',5,0,1,1,1,1,1,0,0,'I purchased the new mouse pads and love them. I also purchased one for my sister and one for my brother.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102992,'M',31,'Married','United States of America','H: 150,000 - 169,999','HS-grad','Crafts','3',4,0,1,0,0,1,1,0,0,'Thanks but even with your discounts, your products are too expensive. Sorry.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102993,'M',69,'Married','United States of America','F: 110,000 - 129,999','9th','?','3',3,0,0,0,1,0,1,0,0,'I am unhappy with the service at your store. Do not consider me a loyal customer just because I use your Affinity Card')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102994,'M',44,'Married','United States of America','C: 50,000 - 69,999','HS-grad','Transp.','3',4,1,0,0,1,1,1,0,0,'Thank you! But I am very unhappy with all the junk mail you keep sending.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102995,'F',19,'NeverM','United States of America','J: 190,000 - 249,999','< Bach.','Other','1',0,0,1,1,0,1,1,1,0,'Affinity card makese sense only for bulk purchases. For all others, driving so far is not worth the discount. Either offer free shipping or build a store close by.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102996,'M',17,'NeverM','United States of America','C: 50,000 - 69,999','10th','Other','1',1,0,0,0,0,0,1,1,0,'I purchased a new computer from your store recently and then received the new discount membership card.  Could I speak with a store manager about getting discounts for my past purchases?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102997,'M',41,'Married','Spain','L: 300,000 and above','Bach.','Exec.','3',4,0,1,1,1,1,1,0,0,'The new affinity card is great. Thank you. I do  have to say that it is a hassle to remember to bring it  with me when I shop as I only shop at your store  for sale items. Could you keep my record in your computer?')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102998,'M',53,'Married','United States of America','J: 190,000 - 249,999','HS-grad','Exec.','3',8,1,1,1,1,1,1,0,0,'I wanted to write you to let you know that I''ve purchased several items at your store recently and have been very satisfied with my purchases. Keep up  the good work.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (102999,'M',55,'Married','United States of America','C: 50,000 - 69,999','HS-grad','Cleric.','3',7,1,0,0,1,1,1,0,0,'My sister told me about your store and I was impressed. Now I use it for all my shopping here.')
into ODMR_MINING_DATA_TEXT (CUST_ID,CUST_GENDER,AGE,CUST_MARITAL_STATUS,COUNTRY_NAME,CUST_INCOME_LEVEL,EDUCATION,OCCUPATION,HOUSEHOLD_SIZE,YRS_RESIDENCE,AFFINITY_CARD,BULK_PACK_DISKETTES,FLAT_PANEL_MONITOR,HOME_THEATER_PACKAGE,BOOKKEEPING_APPLICATION,PRINTER_SUPPLIES,Y_BOX_GAMES,OS_DOC_SET_KANJI,COMMENTS) values (103000,'F',40,'Divorc.','United States of America','E: 90,000 - 109,999','HS-grad','Cleric.','2',3,0,0,0,1,1,1,0,0,'Dear store manager, please do not send me any more Affinity cards. I do not shop at your store very often and I feel that your new card imposes an invasion on my privacy.')
select * from dual;

COMMIT;