/*
 * Licensed Materials - Property of Rogue Wave Software, Inc. 
 * © Copyright Rogue Wave Software, Inc. 2014, 2015 
 * © Copyright IBM Corp. 2009, 2014
 * © Copyright ILOG 1996, 2009
 * All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * The Software and Documentation were developed at private expense and
 * are "Commercial Items" as that term is defined at 48 CFR 2.101,
 * consisting of "Commercial Computer Software" and
 * "Commercial Computer Software Documentation", as such terms are
 * used in 48 CFR 12.212 or 48 CFR 227.7202-1 through 227.7202-4,
 * as applicable.
 */

if (typeof(IlvConstants) == "undefined" || typeof(IlvConstants.FrameworkBundleDefined) == "undefined") {
if(typeof (IlvFrameworkConstants)=="undefined"){
IlvFrameworkConstants={};
IlvFrameworkConstants.basePath="script/images/";
IlvFrameworkConstants.frameworkPath="script/framework/images/";
}
IlvConstants.FrameworkBundleDefined=true;
IlvView=function(_1,_2,_3,_4,_5){
if(!window.IlvAbstractView){
alert(jviews.messages.IlvView.IlvViewRequiresIlvAbstractView);
}
this.superConstructor(_1,_2,_3,_4,_5);
this.format="JPEG";
this.imageMap=false;
this.canProgressiveZoom=false;
this.qbboxx=0;
this.qbboxy=0;
this.qbboxw=100;
this.qbboxh=100;
this.minx=0;
this.maxx=0;
this.maxy=0;
this.miny=0;
this.requestURL=null;
this.maxZoom=-1;
this.minZoom=1;
this.capabilitiesLoaded=false;
this.constrainedOnContents=true;
this.panFactor=0.5;
this.zoomFactor=1.5;
this.imagePanel=new IlvImageView(_1,_2,_3,_4);
this.imagePanel.ilvView=this;
this.imagePanel.setImageSize(3,3);
this.imagePanel.addErrorListener(IlvView.onImageError);
this.imagePanel.addImagePreloadListener(IlvView.onImagePreloaded);
this.imagePanel.addImageLoadListener(IlvView.onImageLoaded);
this.imagePanel.addTimeoutErrorListener(IlvView.onImageTimeoutError);
this.hitmap=null;
this.drawPanel=null;
this.imageMapVisible=false;
this.allLayers=null;
this.visibleLayers=null;
this.overviewLayers=null;
this.updateIntervalID=null;
this.autoUpdateCapabilities=false;
this.interactor=null;
this.updateInterval=0;
this.error=false;
this.sessionDelay=120;
this.sessionMaxInactiveInterval=-1;
this.sessionExpirationHandler=null;
this.errorListeners=new IlvListenerList();
this.capabilitiesListeners=new IlvListenerList();
this.interactorListeners=new IlvListenerList();
this.updateListeners=new IlvListenerList();
this.beforeSwapListeners=new IlvListenerList();
this.timeOutListeners=new IlvListenerList();
this.imgbgcolor=null;
this.initialized=false;
this.waitingImage=IlvFrameworkConstants.basePath+jviews.messages.IlvUtil.waitIcon;
this.errorMessage=jviews.messages.IlvView.serviceNotAvailable;
this.deleteCookieOnDispose=false;
this.registerDispose();
};
IlvView.prototype=new IlvAbstractView();
IlvView.prototype.setClassName("IlvView");
IlvView.basePath=IlvFrameworkConstants.basePath;
IlvView.frameworkPath=IlvFrameworkConstants.frameworkPath;
IlvView.prototype.getAllVBBox=function(){
var x=this.minx,y=this.miny,w=this.maxx-this.minx,h=this.maxy-this.miny;
var _a;
var _b=this.getWidth()/this.getHeight();
if(w<h*_b){
_a=w-h*_b;
w=h*_b;
x+=_a/2;
}else{
_a=h-w/_b;
h=w/_b;
y+=_a/2;
}
return this.allVbbox={left:x,top:y,width:w,height:h};
};
IlvView.prototype.setErrorMessage=function(_c){
this.errorMessage=_c;
};
IlvView.prototype.getErrorMessage=function(){
return this.errorMessage;
};
IlvView.prototype.removeHTML=function(){
this.superInvoke("removeHTML");
this.imagePanel.removeHTML();
if(this.waitPanel){
this.waitPanel.removeHTML();
}
if(this.imageMapPanel){
this.imageMapPanel.removeHTML();
}
if(this.rectPanel){
this.rectPanel.removeHTML();
}
};
IlvView.prototype.updateVisibility=function(){
this.superInvoke("updateVisibility");
this.imagePanel.updateVisibility();
if(this.waitPanel){
this.waitPanel.updateVisibility();
}
if(this.imageMapPanel){
this.imageMapPanel.updateVisibility();
}
if(this.rectPanel){
this.rectPanel.updateVisibility();
}
};
IlvView.prototype.setPopupMenu=function(_d){
this.popupMenu=_d;
this.popupMenu.setViewInternal(this);
};
IlvView.prototype.getPopupMenu=function(){
return this.popupMenu;
};
IlvView.prototype.setRequestURL=function(_e){
this.requestURL=_e;
};
IlvView.prototype.setProgressiveZoom=function(_f){
this.canProgressiveZoom=_f;
};
IlvView.prototype.progressiveZoom=function(x,y,w,h){
if(this.canProgressiveZoom==false){
return;
}
if(this.isMoveTo||this.isShowAll||this.isCenterAt){
this.isMoveTo=false;
this.isShowAll=false;
this.isCenterAt=false;
return;
}
var _14=this.imagePanel.getImage();
if(_14){
var _15=this.imagePanel.getImageSize();
var _16=this.qbboxx-x;
var _17=this.qbboxy-y;
var _18=this.qbboxw/w;
var _19=this.qbboxh/h;
var _1a=_15.width*_18;
var _1b=_15.height*_19;
var zx=_16/this.qbboxw;
var zy=_17/this.qbboxh;
var _1e=_1a*zx;
var top=_1b*zy;
this.imagePanel.setImageSize(_1a,_1b,false,_1e,top);
}
};
IlvView.prototype.getRequestURL=function(){
return this.requestURL;
};
IlvView.prototype.init=function(){
this.getCapabilities(true,true,false);
this.initialized=true;
};
IlvView.prototype.setDeletingCookieOnDispose=function(del){
if(del){
this.deleteCookieOnDispose=true;
}else{
this.deleteCookieOnDispose=false;
}
};
IlvView.prototype.isDeletingCookieOnDispose=function(){
return this.deleteCookieOnDispose;
};
IlvView.prototype.setImageFormat=function(_21){
this.format=_21;
};
IlvView.prototype.getImageFormat=function(){
return this.format;
};
IlvView.prototype.setWaitingImage=function(_22){
this.waitingImage=_22;
if(this.waitPanel){
this.waitPanel.setContent(this.getWaitPanelHTML());
}
};
IlvView.prototype.getWaitingImage=function(){
return this.waitingImage;
};
IlvView.prototype.setBlendTransform=function(set){
this.imagePanel.setBlendTransform(set);
};
IlvView.prototype.getBlendTransform=function(){
return this.imagePanel.getBlendTransform();
};
IlvView.prototype.setTimeoutErrorInterval=function(_24){
this.imagePanel.setTimeoutInterval(_24);
};
IlvView.prototype.getTimeoutErrorInterval=function(){
return this.imagePanel.getTimeoutInterval();
};
IlvView.prototype.addInteractorListener=function(_25){
this.interactorListeners.addListener(_25);
};
IlvView.prototype.removeInteractorListener=function(_26){
this.interactorListeners.removeListener(_26);
};
IlvView.prototype.setUpdateInterval=function(_27){
if(this.inHTML){
if(this.updateIntervalID!=null){
clearTimeout(this.updateIntervalID);
}
if(_27!=0){
if(!this.updateIntervalFunction){
var _28=this;
this.updateIntervalFunction=function(){
_28.doRefresh();
};
}
this.updateIntervalID=window.setTimeout(this.updateIntervalFunction,_27*1000);
}
}
this.updateInterval=_27;
};
IlvView.prototype.getUpdateInterval=function(){
return this.updateInterval;
};
IlvView.prototype.setMessagePanel=function(_29){
this.infoPanel=_29;
};
IlvView.prototype.getMessagePanel=function(){
return this.infoPanel;
};
IlvView.prototype.getLayers=function(){
var _2a=[];
for(var i=0;i<this.allLayers.length;i++){
_2a[_2a.length]=this.allLayers[i];
}
return _2a;
};
IlvView.prototype.getVisibleLayers=function(){
var _2c=[];
for(var i=0;i<this.allLayers.length;i++){
if(this.isLayerVisible(this.allLayers[i])){
_2c[_2c.length]=this.allLayers[i];
}
}
return _2c;
};
IlvView.prototype.getOverviewLayers=function(){
var _2e=[];
for(var i=0;i<this.allLayers.length;i++){
if(this.overviewLayers[i]){
_2e[_2e.length]=this.allLayers[i];
}
}
return _2e;
};
IlvView.prototype.setLayerVisible=function(_30,_31,_32){
if(typeof (_32)!="boolean"){
_32=true;
}
for(var i=0;i<this.allLayers.length;i++){
if(this.allLayers[i]==_30&&(this.visibleLayers[i]!=_31)){
this.visibleLayers[i]=_31;
if(_32){
this.updateImage();
}
}
}
};
IlvView.prototype.isLayerVisible=function(_34){
for(var i=0;i<this.allLayers.length;i++){
if(this.allLayers[i]==_34){
return this.visibleLayers[i];
}
}
return false;
};
IlvView.prototype.isTiled=function(){
return false;
};
IlvView.prototype.getSelectionManager=function(){
if(!this.selectManager){
if(!window.IlvSelectionManager){
alert(jviews.messages.IlvView.mustImportJSFile);
}else{
this.selectManager=new IlvSelectionManager();
this.selectManager.setViewInternal(this);
}
}
return this.selectManager;
};
IlvView.prototype.getContentsBounds=function(){
return this.getBounds();
};
IlvView.prototype.setConstrainedOnContents=function(_36){
this.constrainedOnContents=_36;
};
IlvView.prototype.isConstrainedOnContents=function(){
return this.constrainedOnContents;
};
IlvView.prototype.moveTo=function(x,y){
this.isMoveTo=true;
this.setViewBBoxNoCheck(x,y,this.qbboxw,this.qbboxh);
};
IlvView.prototype.panEast=function(){
this.moveTo(this.qbboxx+this.qbboxw*this.panFactor,this.qbboxy);
};
IlvView.prototype.panWest=function(){
this.moveTo(this.qbboxx-this.qbboxw*this.panFactor,this.qbboxy);
};
IlvView.prototype.panSouth=function(){
this.moveTo(this.qbboxx,this.qbboxy+this.qbboxh*this.panFactor);
};
IlvView.prototype.panNorth=function(){
this.moveTo(this.qbboxx,this.qbboxy-this.qbboxh*this.panFactor);
};
IlvView.prototype.panSouthEast=function(){
this.moveTo(this.qbboxx+this.qbboxw*this.panFactor,this.qbboxy+this.qbboxh*this.panFactor);
};
IlvView.prototype.panNorthEast=function(){
this.moveTo(this.qbboxx+this.qbboxw*this.panFactor,this.qbboxy-this.qbboxh*this.panFactor);
};
IlvView.prototype.panSouthWest=function(){
this.moveTo(this.qbboxx-this.qbboxw*this.panFactor,this.qbboxy+this.qbboxh*this.panFactor);
};
IlvView.prototype.panNorthWest=function(){
this.moveTo(this.qbboxx-this.qbboxw*this.panFactor,this.qbboxy-this.qbboxh*this.panFactor);
};
IlvView.prototype.setPanFactor=function(_39){
this.panFactor=_39;
};
IlvView.prototype.getPanFactor=function(){
return this.panFactor;
};
IlvView.prototype.setZoomFactor=function(_3a){
this.zoomFactor=_3a;
};
IlvView.prototype.getZoomFactor=function(){
return this.zoomFactor;
};
IlvView.prototype.showAll=function(){
this.isShowAll=true;
if(this.zoomLevels){
var _3b=this.getManagerBBox();
var _3c=this.zoomLevels[this.getNearestZoomLevel(1)];
var _3d={};
_3d.width=_3b.width/_3c;
_3d.height=_3b.height/_3c;
var dif=_3b.width-_3d.width;
_3d.left=_3b.left+dif/2;
dif=_3b.height-_3d.height;
_3d.top=_3b.top+dif/2;
this.setViewBBox(_3d.left,_3d.top,_3d.width,_3d.height,true);
}else{
this.setViewBBoxNoCheck(this.minx,this.miny,this.maxx-this.minx,this.maxy-this.miny);
}
var _3f=this.getViewBBox();
this.allVbbox=_3f;
};
IlvView.prototype.centerAt=function(x,y){
this.isCenterAt=true;
this.setViewBBoxNoCheck(x-this.qbboxw/2,y-this.qbboxh/2,this.qbboxw,this.qbboxh);
};
IlvView.prototype.setViewBBox=function(x,y,w,h){
if(this.zoomLevels){
var _46=w/h;
var _47=this.getManagerBBox();
var a=_47.width/w;
var b=_47.height/h;
var _4a=a>b?a:b;
var _4b=this.getNearestZoomLevel(_4a);
var _4c=this.zoomLevels[_4b];
if(_4a!=_4c){
var ow=w;
var oh=h;
if(a>b){
w=_47.width/_4c;
h=w/_46;
}else{
h=_47.height/_4c;
w=h*_46;
}
var dif=ow-w;
x+=dif/2;
dif=oh-h;
y+=dif/2;
}
}
this.setViewBBoxNoCheck(x,y,w,h);
};
IlvView.prototype.setViewBBoxNoCheck=function(x,y,w,h){
this.progressiveZoom(x,y,w,h);
this.qbboxx=x;
this.qbboxy=y;
this.qbboxw=w;
this.qbboxh=h;
this.recenter(this.constrainedOnContents);
if(this.canProgressiveZoom){
var _54=new Image();
var _55=this;
var _56=function(){
var _57=_55.getWidth();
var _58=_55.getHeight();
_55.imagePanel.setImage(_54.src,_57,_58);
};
_54.onload=_56;
_54.src=this.getRequest();
}else{
this.updateImage();
}
};
IlvView.prototype.getNearestZoomLevel=function(_59){
var _5a=Math.abs(_59-this.zoomLevels[0]);
var _5b=0;
for(var i=1;i<this.zoomLevels.length;i++){
var _5d=Math.abs(_59-this.zoomLevels[i]);
if(_5d<_5a){
_5a=_5d;
_5b=i;
}
}
return _5b;
};
IlvView.prototype._getCurrentZoomLevel=function(){
var res={};
var _5f=this.getCurrentZoomLevel();
var _60=this.getNearestZoomLevel(_5f);
res.index=_60;
res.realValue=_5f;
res.value=this.zoomLevels[_60];
return res;
};
IlvView.prototype.applyZoomlevel=function(_61){
var _62=this.getViewBBox();
var _63=this.getManagerBBox();
var _64=Math.max(_63.width/_62.width,_63.height/_62.height);
this.zoomByNoCheck(_61/_64);
};
IlvView.prototype.zoomToIdentity=function(_65){
var _66=this.getViewBBox();
var ok=true;
this.qbboxx=0;
this.qbboxy=0;
this.qbboxw=this.getWidth();
this.qbboxh=this.getHeight();
var zl=this.getCurrentZoomLevel();
if(this.zoomLevels){
if(!_65){
ok=zl==this.zoomLevels[this.getNearestZoomLevel(zl)];
}
}else{
ok=(this.minZoom==-1||zl>=this.minZoom)&&(this.maxZoom==-1||zl<=this.maxZoom);
}
if(ok){
this.setViewBBox(0,0,this.getWidth(),this.getHeight());
}else{
this.qbboxx=_66.left;
this.qbboxy=_66.top;
this.qbboxw=_66.width;
this.qbboxh=_66.height;
}
return ok;
};
IlvView.prototype.zoomIn=function(){
if(this.zoomLevels){
var _69=this._getCurrentZoomLevel();
var _6a=_69.index;
if(_6a+1<this.zoomLevels.length){
var _6b=this.zoomLevels[_6a+1];
this.applyZoomlevel(_6b);
}
}else{
this.zoomBy(this.zoomFactor);
}
};
IlvView.prototype.zoomOut=function(){
if(this.zoomLevels){
var _6c=this._getCurrentZoomLevel();
var _6d=_6c.index;
var _6e;
if(_6d-1>=0){
_6e=this.zoomLevels[_6d-1];
this.applyZoomlevel(_6e);
}
}else{
this.zoomBy(1/this.zoomFactor);
}
};
IlvView.prototype.zoomBy=function(z){
if(this.zoomLevels){
var a=(this.maxx-this.minx)/this.qbboxw;
var b=((this.maxy-this.miny)/this.qbboxh);
var _72=a>b?a:b;
var _73=z*_72;
var _74=this.getNearestZoomLevel(_73);
_73=this.zoomLevels[_74];
this.zoomByNoCheck(_73/_72);
}else{
this.zoomByNoCheck(z);
}
};
IlvView.prototype.zoomByNoCheck=function(z){
this.setViewBBoxNoCheck(this.qbboxx+this.qbboxw*(1-1/z)/2,this.qbboxy+this.qbboxh*(1-1/z)/2,this.qbboxw/z,this.qbboxh/z);
};
IlvView.prototype.getMaxZoomLevel=function(){
return this.maxZoom;
};
IlvView.prototype.getMinZoomLevel=function(){
return this.minZoom;
};
IlvView.prototype.isAutoUpdateCapabilities=function(){
return this.autoUpdateCapabilities;
};
IlvView.prototype.setAutoUpdateCapabilities=function(set){
this.autoUpdateCapabilities=set;
};
IlvView.prototype.getManagerBBox=function(){
return {left:this.minx,top:this.miny,width:this.maxx-this.minx,height:this.maxy-this.miny};
};
IlvView.prototype.getViewBBox=function(){
return {left:this.qbboxx,top:this.qbboxy,width:this.qbboxw,height:this.qbboxh};
};
IlvView.prototype.isCapabilitiesLoaded=function(){
return this.capabilitiesLoaded;
};
IlvView.prototype.updateAll=function(_77,_78){
this.capabilitiesLoaded=false;
this.stopErrorTimer();
this.getCapabilities(false,_77,_78);
};
IlvView.prototype.updateImage=function(){
if(!this.capabilitiesLoaded||this.error){
return;
}
if(this.updateIntervalID!=null){
window.clearTimeout(this.updateIntervalID);
}
if(this.waitPanel){
this.waitPanel.setVisible(true);
}
var _79=this.imagePanel.getImageSize();
var _7a=this.getWidth();
var _7b=this.getHeight();
var _7c=(_79.width!=_7a||_79.height!=_7b);
var _7d=this.getRequest();
if(_7c){
this.imagePanel.setImage(_7d,_7a,_7b);
}else{
this.imagePanel.setImage(_7d);
}
if(this.isStateInCookie()){
IlvUtil.setCookie(this.cookieName+"url",unescape(_7d));
}else{
this.saveState(this);
}
};
IlvView.onImageError=function(_7e){
var _7f=_7e.ilvView;
_7f.error=true;
_7f.waitPanel.setVisible(false);
_7f.errorListeners.notify(_7f);
};
IlvView.onImageTimeoutError=function(_80){
var _81=_80.ilvView;
_81.timeoutError();
};
IlvView.onImagePreloaded=function(_82){
var _83=_82.ilvView;
_83.beforeSwapListeners.notify(_83);
};
IlvView.onImageLoaded=function(_84){
var _85=_84.ilvView;
if(_85.waitPanel){
_85.waitPanel.setVisible(false);
}
_85.updateListeners.notify(_85);
_85.setUpdateInterval(_85.updateInterval);
_85.imagePanel.setVisible(true);
_85.updateImageMap();
if(!_85.hitmapLayers){
_85.hitmapLayers=IlvUtil.getEncodedVisibleLayers(_85,_85.allLayers);
}
var _86=_85.createHitmapRequestURL(_85.qbboxx,_85.qbboxy,_85.qbboxw,_85.qbboxh,_85.getWidth(),_85.getHeight(),_85.hitmapLayers);
_85.updateHitmap(_86);
_85.resetSessionExpirationTimer();
};
IlvView.prototype.setGenerateImageMap=function(set){
this.imageMap=set;
};
IlvView.prototype.isGenerateImageMap=function(){
return this.imageMap;
};
IlvView.prototype.updateImageMap=function(){
if(!this.imageMap){
return;
}
this.imageMapPanel.setVisible(false);
this.waitPanel.setVisible(true);
this.imageMapRequest.send(this.createImageMapRequestURL(this.qbboxx,this.qbboxy,this.qbboxw,this.qbboxh,this.getWidth(),this.getHeight(),IlvUtil.getEncodedVisibleLayers(this,this.allLayers)));
};
IlvView.prototype.createImageMapRequestURL=function(qx,qy,qw,qh,_8c,_8d,_8e){
var _8f=[this.requestURL,"?request=imagemap","&layer=",_8e,"&bbox=",escape([qx,qy,qw,qh].join(",")),"&format=",this.format,"&width=",_8c,"&height=",_8d,"&again=",this.againString(),this.getAdditionalParameters()];
if(this.emptyImagePath==null){
var tmp=new Image();
tmp.src=IlvFrameworkConstants.basePath+jviews.messages.IlvUtil.emptyIcon;
this.emptyImagePath=tmp.src;
}
if(this.imgbgcolor){
_8f.push("&bgcolor=0x");
_8f.push(this.imgbgcolor);
}
_8f.push("&image=");
_8f.push(escape(this.emptyImagePath));
return _8f.join("");
};
IlvView.prototype.imageMapUpdated=function(_91){
if(IlvBrowserInfo.instance.webkit){
this.imageMapPanel.setContent("<b></b>");
}
this.imageMapPanel.setContent(_91);
if(this.imageMapVisible){
this.imageMapPanel.setVisible(true);
}
this.waitPanel.setVisible(false);
};
IlvView.prototype.showImageMap=function(){
this.imageMapVisible=true;
if(this.imageMapPanel){
this.imageMapPanel.setVisible(true);
}
};
IlvView.prototype.hideImageMap=function(){
this.imageMapVisible=false;
if(this.imageMapPanel){
this.imageMapPanel.setVisible(false);
}
};
IlvView.prototype.addCapabilitiesOnLoadListener=function(_92){
this.capabilitiesListeners.addListener(_92);
};
IlvView.prototype.removeCapabilitiesOnLoadListener=function(_93){
this.capabilitiesListeners.removeListener(_93);
};
IlvView.prototype.addBeforeImageOnLoadListener=function(_94){
this.beforeSwapListeners.addListener(_94);
};
IlvView.prototype.removeBeforeImageOnLoadListener=function(_95){
this.beforeSwapListeners.removeListener(_95);
};
IlvView.prototype.addImageOnLoadListener=function(_96){
this.updateListeners.addListener(_96);
};
IlvView.prototype.removeImageOnLoadListener=function(_97){
this.updateListeners.removeListener(_97);
};
IlvView.prototype.addTimeoutErrorListener=function(_98){
this.timeOutListeners.addListener(_98);
};
IlvView.prototype.removeTimeoutErrorListener=function(_99){
this.timeOutListeners.removeListener(_99);
};
IlvView.prototype.addErrorListener=function(_9a){
this.errorListeners.addListener(_9a);
};
IlvView.prototype.removeErrorListener=function(_9b){
this.errorListeners.removeListener(_9b);
};
IlvView.prototype.startErrorTimer=function(){
this.stopErrorTimer();
if(!this.timeOutFunction){
var _9c=this;
this.timeOutFunction=function(){
_9c.timeoutError();
};
}
this.errorInterval=window.setTimeout(this.timeOutFunction,this.getTimeoutErrorInterval()*1000);
};
IlvView.prototype.stopErrorTimer=function(){
var _9d=this.errorInterval;
this.errorInterval=null;
if(_9d){
clearTimeout(_9d);
}
};
IlvView.prototype.timeoutError=function(){
this.error=true;
this.imagePanel.setVisible(false);
this.waitPanel.setContent(this.errorMessage);
this.waitPanel.setVisible(true);
this.timeOutListeners.notify(this.view);
};
IlvView.prototype.doRefresh=function(){
if(this.autoUpdateCapabilities){
this.updateAll(false,true);
}else{
this.updateImage();
}
};
IlvView.prototype.createCapabilitiesRequestURL=function(){
var _9e=[this.requestURL,"?request=capabilities&format=json&width=",this.getWidth(),"&height=",this.getHeight(),this.getAdditionalParameters(),"&again=",this.againString()];
return _9e.join("");
};
IlvView.prototype.readAdditionalCapabilities=function(_9f){
};
IlvView.prototype.getCapabilities=function(_a0,_a1,_a2){
var _a3=this.createCapabilitiesRequestURL();
var _a4=function(_a5){
this.endCapabilitiesLoaded(_a5,_a0,_a1,_a2);
};
var _a6=new IlvAjax.JSRequest(this,_a4);
_a6.send(_a3);
_a4=null;
_a3=null;
_a6=null;
this.startErrorTimer();
};
IlvView.prototype.resetSessionExpirationTimer=function(){
if(this.sessionTimer){
clearTimeout(this.sessionTimer);
}
if(!this.error&&this.sessionMaxInactiveInterval&&this.sessionMaxInactiveInterval!=-1&&this.sessionExpirationHandler){
this.sessionTimer=setTimeout(this.sessionListener,(this.sessionMaxInactiveInterval-this.sessionDelay)*1000);
}
};
IlvView.prototype.setSessionExpirationHandler=function(_a7){
this.sessionExpirationHandler=_a7;
if(_a7&&!this.sessionListener){
var v=this;
this.sessionListener=function(){
if(v.sessionExpirationHandler){
v.sessionExpirationHandler(v);
}
};
}
};
IlvView.prototype.endCapabilitiesLoaded=function(_a9,_aa,_ab,_ac){
this.stopErrorTimer();
this.minx=_a9.minx;
this.maxx=_a9.maxx;
this.miny=_a9.miny;
this.maxy=_a9.maxy;
this.readMaxZoomLevel(_a9);
this.readMinZoomLevel(_a9);
this.readZoomLevels(_a9);
this.sessionMaxInactiveInterval=_a9.sessionMaxInactiveInterval;
this.resetSessionExpirationTimer();
var i;
var _ae=this.allLayers;
var _af=this.visibleLayers;
this.allLayers=[];
this.visibleLayers=[];
this.overviewLayers=[];
for(i=0;i<_a9.themes.length;i++){
this.allLayers[i]=_a9.themes[i];
this.visibleLayers[i]=true;
this.overviewLayers[i]=_a9.overviewthemes[i];
}
this.readAdditionalCapabilities(_a9);
this.capabilitiesLoaded=true;
if(_aa){
if(IlvUtil.getCookie(this.cookieName+"url")||!this.isStateInCookie()){
if(IlvUtil.getCookie(this.cookieName+"url")){
this.capabilitiesListeners.notify(this);
this.initFromCookie();
this.recenter(this.constrainedOnContents);
this.updateImage();
}else{
this.restoreState(this);
}
}else{
this.capabilitiesListeners.notify(this);
this.showAll();
}
}else{
this.capabilitiesListeners.notify(this);
if(_ac&&_ae!=null){
for(i=0;i<_ae.length;i++){
if(!_af[i]){
this.setLayerVisible(_ae[i],false,false);
}
}
}
if(_ab){
this.showAll();
}else{
this.recenter(this.constrainedOnContents);
this.updateImage();
}
}
};
IlvView.prototype.getCurrentZoomLevel=function(){
var _b0=this.getManagerBBox();
var _b1=this.getViewBBox();
var a=_b0.width/_b1.width;
var b=_b0.height/_b1.height;
return a>b?a:b;
};
IlvView.prototype.readMaxZoomLevel=function(_b4){
this.maxZoom=_b4.maxZoom;
};
IlvView.prototype.readMinZoomLevel=function(_b5){
this.minZoom=_b5.minZoom?_b5.minZoom:1;
};
IlvView.prototype.readZoomLevels=function(_b6){
this.zoomLevels=_b6.zoomLevels;
if(this.zoomLevels){
this.maxZoom=this.zoomLevels[this.zoomLevels.length-1];
this.minZoom=this.zoomLevels[0];
}
};
IlvView.prototype.initFromUrl=function(url){
var _b8=this;
var _b9=this.parseValue(url,"bbox");
var s=0;
var e=_b9.indexOf(",",s);
_b8.qbboxx=parseFloat(_b9.substring(s,e));
s=e+1;
e=_b9.indexOf(",",s);
_b8.qbboxy=parseFloat(_b9.substring(s,e));
s=e+1;
e=_b9.indexOf(",",s);
_b8.qbboxw=parseFloat(_b9.substring(s,e));
s=e+1;
e=_b9.length;
_b8.qbboxh=parseFloat(_b9.substring(s,e));
for(var i=0;i<_b8.allLayers.length;i++){
_b8.visibleLayers[i]=false;
}
var _bd=unescape(this.parseValue(url,"layer"));
var _be;
s=0;
e=0;
var _bf=false;
while(true){
e=_bd.indexOf(",",s);
if(e==-1){
e=_bd.length;
_bf=true;
}
_be=_bd.substring(s,e);
var l=_b8.allLayers.length;
for(i=0;i<l;i++){
if(_b8.allLayers[i]==_be){
_b8.visibleLayers[i]=true;
}
}
if(_bf){
break;
}
s=e+1;
}
};
IlvView.prototype.initFromCookie=function(){
var _c1=this;
var url=IlvUtil.getCookie(_c1.cookieName+"url");
_c1.initFromUrl(url);
};
IlvView.prototype.parseValue=function(str,_c4){
var s=str.indexOf(_c4,0);
if(s==-1){
return -1;
}
var e=str.indexOf("&",s+1);
if(e==-1){
e=str.length;
}
return str.substring(s+_c4.length+1,e);
};
IlvView.prototype.getRequest=function(){
if(this.allLayers){
return this.createRequestURL(this.qbboxx,this.qbboxy,this.qbboxw,this.qbboxh,this.getWidth(),this.getHeight(),IlvUtil.getEncodedVisibleLayers(this,this.allLayers));
}else{
return "";
}
};
IlvView.prototype.setImageBackgroundColor=function(_c7){
this.imgbgcolor=_c7;
};
IlvView.prototype.getImageBackgroundColor=function(){
return this.imgbgcolor;
};
IlvView.prototype.createRequestURL=function(qx,qy,qw,qh,_cc,_cd,_ce){
var _cf=[this.requestURL,"?request=image","&layer=",_ce,"&bbox=",escape([qx,qy,qw,qh].join(",")),"&format=",this.format,"&width=",_cc,"&height=",_cd,"&again=",this.againString(),this.getAdditionalParameters()];
if(this.getImageBackgroundColor()){
_cf.push("&bgcolor=0x");
_cf.push(this.getImageBackgroundColor());
}
return _cf.join("");
};
IlvView.prototype.againString=function(){
var _d0=new Date();
var str=_d0.toUTCString();
str=str+" "+_d0.getMilliseconds();
return escape(str);
};
IlvView.prototype.setChildrenBounds=function(_d2,top,_d4,_d5){
var h=this.hScrollBar&&this.hScrollBar.isVisible()?_d5-this.hScrollBar.getHeight():_d5;
var w=this.vScrollBar&&this.vScrollBar.isVisible()?_d4-this.vScrollBar.getWidth():_d4;
this.superInvoke("setChildrenBounds",_d2,top,w,h);
if(this._resized){
this.imagePanel.setVisible(false);
}
this.imagePanel.setBounds(_d2,top,w,h);
if(this.inHTML){
this.waitPanel.setBounds(_d2,top,w,h);
this.imageMapPanel.setBounds(_d2,top,w,h);
if(this.drawPanel){
this.drawPanel.setBounds(_d2,top,w,h);
}
this.waitPanel.setContent(this.getWaitPanelHTML());
this.recenter(this.constrainedOnContents);
if(this._resized){
this.updateImage();
}
}
};
IlvView.prototype.childrenToHTML=function(_d8){
this.imagePanel.setVisible(false);
this.imagePanel.toHTML(_d8);
this.waitPanel=new IlvHTMLPanel(this.getWaitPanelHTML(),_d8);
this.waitPanel.setZIndex(5);
this.waitPanel.setBounds(this.getLeft(),this.getTop(),this.getWidth(),this.getHeight());
if(IlvBrowserInfo.instance.ff4&&typeof iceSubmit!="undefined"){
this.waitPanel.setVisible(false);
}else{
this.waitPanel.setVisible(true);
}
this.rectPanel=new IlvRectangle(null,_d8);
this.superInvoke("childrenToHTML",_d8);
this.imageMapRequest=new IlvAjax.HTMLRequest(this,this.imageMapUpdated);
this.hitmapRequest=new IlvAjax.HTMLRequest(this,this.hitmapUpdated);
this.imageMapPanel=new IlvHTMLPanel("",_d8);
this.imageMapPanel.setBounds(this.getLeft(),this.getTop(),this.getWidth(),this.getHeight());
this.imageMapPanel.setZIndex(5);
};
IlvView.prototype.getWaitPanelHTML=function(){
return "<table width=\""+this.getWidth()+"\" height=\""+this.getHeight()+"\"><tr><td style=\"text-align:center\" align=\"center\" valign=\"middle\">"+"<img style=\"-webkit-user-drag:none\" src=\""+this.waitingImage+"\" galleryimg=\"false\"/></td></tr></table>";
};
IlvView.prototype.mouseMove=function(e){
if(this.interactor!=null){
if(this.interactor.mouseMove){
return this.interactor.mouseMove(e);
}else{
if(this.interactor.onmousemove){
return this.interactor.onmousemove(e);
}
}
}
return true;
};
IlvView.prototype.mouseDrag=function(e){
if(this.interactor!=null){
if(this.interactor.mouseDrag){
return this.interactor.mouseDrag(e);
}else{
if(this.interactor.onmousemove){
return this.interactor.onmousemove(e);
}
}
}
return true;
};
IlvView.prototype.keyPress=function(e){
if(this.interactor!=null){
if(this.interactor.keyPress){
return this.interactor.keyPress(e);
}else{
if(this.interactor.onkeypress){
return this.interactor.onkeypress(e);
}
}
}
return true;
};
IlvView.prototype.keyUp=function(e){
if(this.interactor!=null){
if(this.interactor.keyUp){
return this.interactor.keyUp(e);
}else{
if(this.interactor.onkeyup){
return this.interactor.onkeyup(e);
}
}
}
return true;
};
IlvView.prototype.keyDown=function(e){
if(this.interactor!=null){
if(this.interactor.keyDown){
return this.interactor.keyDown(e);
}else{
if(this.interactor.onkeydown){
return this.interactor.onkeydown(e);
}
}
}
return true;
};
IlvView.prototype.mouseUp=function(e){
var _df=this.interactor;
var _e0=this.popupMenu;
if(_e0!=null&&_e0.isPopupTrigger(e)){
if(this.imagePanel.isImageLoaded()){
var _e1;
if(_df!=null){
_e1=_df.getMenuModelId();
}
return _e0.displayPopupMenu(this,e,_e1);
}else{
e.preventDefault();
return false;
}
}else{
if(this.interactor!=null){
if(this.interactor.mouseUp){
return this.interactor.mouseUp(e);
}else{
if(this.interactor.onmouseup){
return this.interactor.onmouseup(e);
}
}
}
}
return true;
};
IlvView.prototype.mouseDown=function(e){
var _e3=this.interactor;
var _e4=this.popupMenu;
if(_e4!=null&&_e4.isPopupTrigger(e)){
this.eventPanel._dragging=false;
return true;
}else{
if(_e4!=null){
_e4.internalResetEvent();
_e4.hidePopupMenu();
}
if(this.capabilitiesLoaded){
if(_e3!=null){
if(_e3.mouseDown){
return _e3.mouseDown(e);
}else{
if(_e3.onmousedown){
return _e3.onmousedown(e);
}
}
}
}
}
return true;
};
IlvView.prototype.mouseOver=function(e){
var _e6=this.interactor;
if(_e6!=null){
if(_e6.message){
window.status=_e6.message;
if(this.initialized&&this.infoPanel){
this.infoPanel.setContent(_e6.message);
}
}
if(_e6.mouseOver){
return _e6.mouseOver(e);
}else{
if(_e6.onmouseover){
return _e6.onmouseover(e);
}
}
}
return true;
};
IlvView.prototype.mouseOut=function(e){
var _e8=this.interactor;
if(_e8!=null){
window.status="";
if(this.initialized&&this.infoPanel){
this.infoPanel.setContent("");
}
if(_e8.mouseOut){
return _e8.mouseOut(e);
}else{
if(_e8.onmouseout){
return _e8.onmouseout(e);
}
}
}
return true;
};
IlvView.prototype.mouseWheel=function(e){
if(this.interactor!=null){
if(this.interactor.mouseWheel){
return this.interactor.mouseWheel(e);
}else{
if(this.interactor.onmousewheel){
return this.interactor.onmousewheel(e);
}
}
}
return true;
};
IlvView.prototype._fixZoom=function(_ea,a,b,_ed){
if(this.qbboxx==0&&this.qbboxy==0&&this.qbboxw==this.getWidth()&&this.qbboxh==this.getHeight()){
return;
}
var d;
if(a>b||a==1&&b==1){
d=this.qbboxw-(this.maxx-this.minx)/_ea;
this.qbboxw=(this.maxx-this.minx)/_ea;
this.qbboxx+=d/2;
d=this.qbboxh-this.qbboxw/_ed;
this.qbboxh=this.qbboxw/_ed;
this.qbboxy+=d/2;
}else{
d=this.qbboxh-(this.maxy-this.miny)/_ea;
this.qbboxh=(this.maxy-this.miny)/_ea;
if(_ea>1){
this.qbboxy+=d/2;
}
d=this.qbboxw-this.qbboxh*_ed;
this.qbboxw=this.qbboxh*_ed;
this.qbboxx+=d/2;
}
};
IlvView.prototype.recenter=function(_ef){
if(this.getHeight()==0||this.getWidth()==0){
return;
}
var a=(this.maxx-this.minx)/this.qbboxw;
var b=((this.maxy-this.miny)/this.qbboxh);
var _f2=this.getWidth()/this.getHeight();
var _f3=a>b?a:b;
if(this.qbboxw==0&&this.qbboxh==0){
this.qbboxx=0;
this.qbboxy=0;
this.qbboxw=this.getWidth();
this.qbboxh=this.getHeight();
}else{
if(this.maxZoom&&this.maxZoom!=-1&&_f3>this.maxZoom){
this._fixZoom(this.maxZoom,a,b,_f2);
}
if(this.minZoom&&this.minZoom!=-1&&_f3<this.minZoom){
this._fixZoom(this.minZoom,a,b,_f2);
}
}
if(_ef){
if(this.qbboxx<this.minx){
this.qbboxx=this.minx;
}
if(this.qbboxy<this.miny){
this.qbboxy=this.miny;
}
if(this.qbboxw>this.maxx-this.minx){
this.qbboxw=this.maxx-this.minx;
}
if(this.qbboxh>this.maxy-this.miny){
this.qbboxh=this.maxy-this.miny;
}
if(this.qbboxx+this.qbboxw>this.maxx){
this.qbboxx=this.maxx-this.qbboxw;
}
if(this.qbboxy+this.qbboxh>this.maxy){
this.qbboxy=this.maxy-this.qbboxh;
}
}
this.resizeQbbox(_f2);
};
IlvView.prototype.resizeQbbox=function(_f4){
var dif;
if(this.qbboxw<this.qbboxh*_f4){
dif=this.qbboxw-this.qbboxh*_f4;
this.qbboxw=this.qbboxh*_f4;
this.qbboxx+=dif/2;
}else{
dif=this.qbboxh-this.qbboxw/_f4;
this.qbboxh=this.qbboxw/_f4;
this.qbboxy+=dif/2;
}
};
IlvView.prototype.isFitToContent=function(){
var _f6=this.getCurrentZoomLevel();
var _f7=_f6>0.999&&_f6<1.001;
if(!_f7){
return false;
}
var _f8=this.getViewBBox();
var _f9=this.getManagerBBox();
var _fa=this.getWidth()/this.getHeight();
var dif;
if(_f9.width<_f9.height*_fa){
dif=_f9.width-_f9.height*_fa;
_f9.width=_f9.height*_fa;
_f9.left+=dif/2;
}else{
dif=_f9.height-_f9.width/_fa;
_f9.height=_f9.width/_fa;
_f9.top+=dif/2;
}
_f7=(_f8.left==_f9.left&&_f8.width==_f9.width&&_f8.top==_f9.top&&_f8.height==_f9.height);
return _f7;
};
IlvView.prototype.performAction=function(_fc,_fd,_fe,_ff){
var buf=_fc+"(";
if(_fd!=null){
buf+=_fd.join(",");
}
buf+=")";
this.setAdditionalParameters("action",buf);
if(_fe){
if(!_ff){
_ff=[false,false,true];
}
var c=_ff;
this.getCapabilities(c[0],c[1],c[2]);
}else{
this.updateImage();
}
this.setAdditionalParameters("action",null);
};
IlvView.prototype.removeAdditionalParameter=function(key){
IlvRequestParameters.removeParameter(this.additionalParams,key);
};
IlvView.prototype.getRectangle=function(){
return this.rectPanel;
};
IlvView.prototype.getZoomLevels=function(){
return this.zoomLevels;
};
IlvView.prototype.dispose=function(){
this.errorListeners.dispose();
this.capabilitiesListeners.dispose();
this.interactorListeners.dispose();
this.updateListeners.dispose();
this.beforeSwapListeners.dispose();
this.timeOutListeners.dispose();
this.superInvoke("dispose");
if(this.isDeletingCookieOnDispose()){
IlvUtil.deleteCookie(this.cookieName+"url");
}
if(this.rectPanel){
if(this.rectPanel.parentNode){
this.rectPanel.parentNode=null;
}
this.rectPanel.dispose();
}
if(this.waitPanel){
this.waitPanel.dispose();
}
if(this.imageMapPanel){
this.imageMapPanel.dispose();
}
if(this.imagePanel){
this.imagePanel.dispose();
}
if(this.popupMenu){
this.popupMenu.dispose();
}
};
if(typeof (IlvFrameworkConstants)=="undefined"){
IlvFrameworkConstants={};
IlvFrameworkConstants.basePath="script/images/";
IlvFrameworkConstants.frameworkPath="script/framework/images/";
}
IlvHTMLContainerPanel=function(left,top,_105,_106,_107){
this.superConstructor(left,top,_105,_106);
this.overflow=_107;
this.name=this.toString();
this.inHTML=false;
this.objects=[];
this.bgcolor=null;
};
IlvHTMLContainerPanel.prototype=new IlvPanel();
IlvHTMLContainerPanel.prototype.setClassName("IlvHTMLContainerPanel");
IlvHTMLContainerPanel.prototype.dispose=function(){
if(this.objects&&this.objects.length){
var _108=this.objects.length;
for(var k=0;k<_108;k++){
if(this.objects[k]){
this.objects[k].dispose();
this.objects[k]=null;
delete (this.objects[k]);
}
}
}
this.objects=null;
this.superInvoke("dispose");
this.overflow=null;
};
IlvHTMLContainerPanel.prototype.setBackgroundColor=function(_10a){
this.bgcolor="#"+_10a;
if(this.inHTML){
this._div.backgroundColor=this.bgcolor;
}
};
IlvHTMLContainerPanel.prototype.getBackgroundColor=function(){
return this.bgcolor;
};
IlvHTMLContainerPanel.prototype.toHTML=function(_10b){
return this.childrenToHTML(_10b);
};
IlvHTMLContainerPanel.prototype.childrenToHTML=function(_10c){
if(_10c){
var div=document.createElement("div");
div.id=this.name;
div.style.position="absolute";
div.style.zIndex=1;
div.style.top=this.getTop()+"px";
div.style.left=this.getLeft()+"px";
if(this.getWidth()!=0){
div.style.width=this.getWidth()+"px";
div.style.height=this.getHeight()+"px";
}
if(this.overflow){
div.style.overflow=this.overflow;
}
if(this.bgcolor){
div.style.backgroundColor=this.bgcolor;
}
div.style["-moz-user-select"]="none";
_10c.appendChild(div);
this._div=div;
}else{
document.write("<div id = \""+this.name+"\" ");
document.write("style = \"");
if(this.overflow){
document.write("overflow:"+this.overflow+";");
}
document.write("position:absolute;");
document.write(" z-index:1;");
document.write("left:"+this.getLeft()+"px;");
document.write("top:"+this.getTop()+"px;");
if(this.getWidth()!=0){
document.write("width:"+this.getWidth()+"px;");
document.write("height:"+this.getHeight()+"px;");
}
if(this.bgcolor){
document.write("background-color:"+this.bgcolor+";");
}
document.write("-moz-user-select:none;");
document.write("\">");
}
var k;
var _10f=this.objects.length;
for(k=0;k<_10f;k++){
this.objects[k].toHTML(_10c?this._div:null);
}
if(!_10c){
document.write("</div>");
this._div=document.getElementById(this.name);
}
this.inHTML=true;
_10f=this.objects.length;
for(k=0;k<_10f;k++){
if(this.objects[k].getHTMLFragment){
this._div.appendChild(this.objects[k].getHTMLFragment());
}
}
};
IlvHTMLContainerPanel.prototype.removeHTML=function(){
if(this._div){
this._div.parentNode.removeChild(this._div);
}
};
IlvHTMLContainerPanel.prototype.addObject=function(_110){
this.objects.push(_110);
if(this.inHTML&&_110.getHTMLFragment){
this._div.appendChild(_110.getHTMLFragment());
}
};
IlvHTMLContainerPanel.prototype.setLocation=function(x,y){
this.superInvoke("setLocation",x,y);
if(this._div){
this._div.style.left=x+"px";
this._div.style.top=y+"px";
}
};
IlvHTMLContainerPanel.prototype.setSize=function(w,h){
this.superInvoke("setSize",w,h);
if(this._div){
this._div.style.width=w+"px";
this._div.style.height=h+"px";
}
};
IlvTile=function(_115,_116,idX,idY,size){
this.superConstructor(0,0,size,size);
this.init=true;
this.name=this.toString();
this.manager=_115;
this.view=this.manager.view;
this.idX=idX;
this.idY=idY;
this.debug=false;
this.visible=true;
this._img=null;
this.visibilityListeners=new IlvListenerList();
this.registerDispose();
};
IlvTile.prototype=new IlvEmptyView();
IlvTile.prototype.setClassName("IlvTile");
IlvTile.formatID=function(idX,idY){
return idX+"."+idY;
};
IlvTile.prototype.addVisibilityListener=function(_11c){
this.visibilityListeners.addListener(_11c);
};
IlvTile.prototype.dispose=function(){
if(this.visibilityListeners){
this.visibilityListeners.dispose();
this.visibilityListeners=null;
}
this.view=null;
this.manager=null;
this.pivot=null;
if(this._img){
if(this._img.style.cssText){
this._img.style.cssText=null;
}
if(this._img.onload){
this._img.onload=null;
}
this.clear();
this._img=null;
}
this.request=null;
this.superInvoke("dispose");
};
IlvTile.prototype.removeVisibilityListener=function(_11d){
this.visibilityListeners.removeListener(_11d);
};
IlvTile.prototype.setSize=function(_11e,_11f,_120){
};
IlvTile.prototype.getID=function(){
return IlvTile.formatID(this.idX,this.idY);
};
IlvTile.prototype.setID=function(idX,idY){
this.visible=true;
this.idX=idX;
this.idY=idY;
var img=this.getImageNode();
if(img){
img.title=this.getID();
}
};
IlvTile.prototype.checkVisibility=function(){
var _124=this.visible;
var b=this.manager.getVisibleTiles();
this.visible=b.minX<=this.idX&&b.maxX>=this.idX&&b.minY<=this.idY&&b.maxY>=this.idY;
if(_124&&!this.visible){
this.visibilityListeners.notify(this,false);
}else{
if(!_124&&this.visible){
this.visibilityListeners.notify(this,true);
}
}
};
IlvTile.prototype.clear=function(){
var img=this.getImageNode();
if(img){
this.empty=true;
this.request="";
img.src=IlvTiledView.getEmptyImage();
}
};
IlvTile.prototype.update=function(_127,_128,_129){
if(!_128){
this.checkVisibility();
}
if(!_127){
var img;
img=this.getImageNode();
if(img){
var _12b=this.manager.createTileRequestURL(this.idX,this.idY);
if(_129||_12b!=this.request){
this.request=_12b;
img.src=IlvTiledView.getEmptyImage();
img.src=this.request;
this.empty=false;
}
}
}else{
this.clear();
}
};
IlvTile.prototype.updateLocation=function(_12c){
var size=this.manager.size;
this.setLocation(this.idX*size,this.idY*size,this.visible);
};
IlvTile.prototype.setLocation=function(x,y,_130){
var _131=(this.getLeft()!=x||this.getTop()!=y);
if(_131||this.init){
this.init=false;
this.superInvoke("setLocation",x,y);
var img=this.getImageNode();
this.update(false,_130,true);
if(img){
img.style.left=x+"px";
img.style.top=y+"px";
}
}
};
IlvTile.prototype.getImageNode=function(){
if(!this._img){
this._img=document.getElementById(this.name);
}
return this._img;
};
IlvTile.prototype.getHTMLFragment=function(){
var _133=document.createElement("img");
_133.id=this.name;
var _134=["position:absolute;-moz-user-select:none;","left:",this.getLeft(),"px;","height:",this.getHeight(),"px;","top:",this.getTop(),"px;","width:",this.getWidth(),"px;"];
if(this.debug){
_134.push("opacity:.75;border:1px solid black;");
}
_133.style.cssText=_134.join("");
_133.src=IlvTiledView.getEmptyImage();
_133.onload=function(){
this.style.visibility="inherit";
};
return _133;
};
IlvTile.prototype.onPoolAdd=function(){
var img=this.getImageNode();
if(img){
img.style.display="none";
}
};
IlvTile.prototype.onPoolRemove=function(){
var img=this.getImageNode();
if(img){
img.style.display="block";
}
};
IlvTile.prototype.isVisible=function(){
return this.visible;
};
IlvTilePool=function(){
this.refs={};
this.count=0;
this.registerDispose();
};
IlvTilePool.prototype=new IlvObject();
IlvTilePool.prototype.setClassName("IlvTilePool");
IlvTilePool.prototype.dispose=function(){
this.superInvoke("dispose");
while(this.count>0){
var tile=this.pop();
tile.dispose();
delete this.refs[IlvTile.formatID(tile.idX,tile.idY)];
tile=null;
this.count--;
}
this.refs=null;
};
IlvTilePool.prototype.add=function(tile){
tile.onPoolAdd();
if(this.exists(tile)){
return false;
}
this.refs[tile.toString()]=tile;
this.count++;
return true;
};
IlvTilePool.prototype.pop=function(){
var key=null;
for(key in this.refs){
break;
}
var tile=this.refs[key];
delete this.refs[tile.toString()];
this.count--;
tile.onPoolRemove();
return tile;
};
IlvTilePool.prototype.remove=function(tile){
tile.onPoolRemove();
if(!this.refs[tile.toString()]){
return false;
}
delete this.refs[tile.toString()];
this.count--;
return true;
};
IlvTilePool.prototype.exists=function(tile){
return this.refs[tile.toString()]?true:false;
};
IlvTilePool.prototype.size=function(){
return this.count;
};
IlvTileManager=function(view,size){
this.name=this.toString();
this.view=view;
this.size=size;
this.current=0;
this.updatePending=false;
this.tiles=[];
this.pivot=new IlvHTMLContainerPanel(0,0);
this.refs={};
this.tilesPool=new IlvTilePool();
var pool=this.tilesPool;
var refs=this.refs;
this.tileVisibilityChanged=function(tile,_142){
if(!_142){
pool.add(tile);
}else{
pool.remove(tile);
}
};
this.registerDispose();
};
IlvTileManager.prototype=new IlvObject();
IlvTileManager.prototype.setClassName("IlvTileManager");
IlvTileManager.prototype.dispose=function(){
this.superInvoke("dispose");
this.tilesPool.dispose();
this.pivot.dispose();
this.view=null;
this.current=0;
if(this.tiles){
for(var i=0;i<this.tiles.length;i++){
if(this.tiles[i]){
this.tiles[i].dispose();
this.tiles[i]=null;
}
}
this.tiles=null;
}
for(var key in this.refs){
if(this.refs[key]){
this.refs[key].dispose();
this.refs[key]=null;
}
}
this.refs=null;
this.tileVisibilityChanged=null;
};
IlvTileManager.prototype.setStaticLayers=function(_145){
this.staticLayers=_145.join(",");
};
IlvTileManager.prototype.createTileRequestURL=function(x,y){
var buf=[this.view.requestURL,"?request=image","&layer=",IlvUtil.encodeStringAttribute(this.staticLayers),"&tile=",[this.view.tileSizeT,x,y].join(","),"&format=",(this.format?this.format:this.view.format),"&width=",this.size,"&height=",this.size];
if(this.view.getImageBackgroundColor()){
buf.push("&bgcolor=0x");
buf.push(this.view.getImageBackgroundColor());
}
buf.push(this.view.getAdditionalParameters());
return buf.join("");
};
IlvTileManager.prototype.setVisibleTiles=function(minX,maxX,minY,maxY,_14d){
if(_14d||this.minX!=minX||this.minY!=minY||this.maxX!=maxX||this.maxY!=maxY){
this.minX=minX;
this.maxX=maxX;
this.minY=minY;
this.maxY=maxY;
this.updatePending=true;
this.scale=_14d;
if(_14d){
this.clearTilesImage();
}
}
};
IlvTileManager.prototype.getVisibleTiles=function(){
return {minX:this.minX,maxX:this.maxX,minY:this.minY,maxY:this.maxY};
};
IlvTileManager.prototype.getOrCreateTile=function(idX,idY){
var tile=null;
if(this.tilesPool.size()>0){
tile=this.tilesPool.pop();
delete this.refs[IlvTile.formatID(tile.idX,tile.idY)];
tile.setID(idX,idY);
tile.init=true;
tile.updateLocation(true);
this.refs[IlvTile.formatID(idX,idY)]=tile;
}else{
tile=new IlvTile(this,this.pivot,idX,idY,this.size);
tile.addVisibilityListener(this.tileVisibilityChanged);
this.pivot.addObject(tile);
tile.updateLocation();
this.tiles[this.current++]=tile;
this.refs[IlvTile.formatID(idX,idY)]=tile;
}
return tile;
};
IlvTileManager.prototype.getTilesContainer=function(){
return this.pivot;
};
IlvTileManager.prototype.clearTilesImage=function(){
var _151=this.tiles.length;
for(var k=0;k<_151;k++){
this.tiles[k].clear();
}
};
IlvTileManager.prototype.organizeTiles=function(_153){
var _154=this.tiles.length;
for(var k=0;k<_154;k++){
this.tiles[k].checkVisibility();
}
if(this.updatePending){
this.updatePending=false;
for(var x=this.minX;x<=this.maxX;x++){
for(var y=this.minY;y<=this.maxY;y++){
var t=this.refs[IlvTile.formatID(x,y)];
if(t){
if(this.scale){
t.update(false,true,true);
}else{
if(t._img.src.indexOf(jviews.messages.IlvUtil.emptyIcon)!=-1){
t.update(false,true,true);
}
}
}else{
this.getOrCreateTile(x,y);
}
}
}
}
};
IlvDynamicListenerList=function(){
};
IlvDynamicListenerList.prototype=new IlvListenerList();
IlvDynamicListenerList.prototype.setClassName("IlvDynamicListenerList");
IlvDynamicListenerList.prototype.notify=function(obj){
this.superInvoke("notify",obj.view);
};
IlvDynamicLayer=function(view,_15b){
if(view){
this.superConstructor(0,0,view.container.getWidth(),view.container.getHeight());
this.name=this.toString();
this.view=view;
this.layers=_15b;
this.format="PNG";
this.request="";
this.qx=0;
this.qy=0;
this.qw=0;
this.qh=0;
this.updateInterval=0;
this.updateIntervalID=null;
this.visible=true;
this.zindex=2;
this.timestamp=0;
this.imagesBuffer=[];
this.blendTransform=false;
var _15c=this;
this.imageScrollListeners=new IlvDynamicListenerList();
this.imageLoadingListeners=new IlvDynamicListenerList();
this.imagePreloadListeners=new IlvDynamicListenerList();
this.imageLoadListeners=new IlvDynamicListenerList();
this.errorListeners=new IlvDynamicListenerList();
this.timeoutListeners=new IlvDynamicListenerList();
this.imageLoadListeners.addListener(function(view){
var _15e=view.getDynamicLayer();
view.resetSessionExpirationTimer();
_15e.setUpdateInterval(_15e.updateInterval);
if(!_15e.panning){
_15e.setVisible(true);
}
});
IlvDynamicLayer.delayedTimeout=300;
}
};
IlvDynamicLayer.prototype=new IlvImageView();
IlvDynamicLayer.prototype.setClassName("IlvDynamicLayer");
IlvDynamicLayer.prototype.setVisible=function(_15f){
this.visible=_15f;
if(this.imagePanel){
this.imagePanel.setVisible(_15f);
}
};
IlvDynamicLayer.prototype.dispose=function(){
this.superInvoke("dispose");
this.imageScrollListeners.dispose();
this.imageLoadingListeners.dispose();
this.imagePreloadListeners.dispose();
this.imageLoadListeners.dispose();
this.errorListeners.dispose();
this.timeoutListeners.dispose();
};
IlvDynamicLayer.prototype.setBounds=function(left,top,_162,_163){
this.superInvoke("setBounds",0,0,_162,_163);
var img=this.getImageNode();
if(img){
img.style.width=_162;
img.style.height=_163;
}
};
IlvDynamicLayer.prototype.setLocation=function(x,y){
};
IlvDynamicLayer.prototype.setPanning=function(_167){
this.panning=_167;
};
IlvDynamicLayer.prototype.isPanning=function(){
return this.panning;
};
IlvDynamicLayer.prototype.setLayers=function(_168){
this.layers=_168;
};
IlvDynamicLayer.prototype.getImageNode=function(){
return document.getElementById(this.imageID);
};
IlvDynamicLayer.prototype.endActionLoaded=function(_169){
this.updateImage(this.getImageNode(),false);
};
IlvDynamicLayer.prototype.sendAction=function(req){
var _16b=req.indexOf("?request=")+9;
req=req.substring(0,_16b)+"dynamicAction"+req.substring(req.indexOf("&",_16b),req.length);
if(!this.urlRequest){
this.urlRequest=new IlvAjax.HTMLRequest(this,this.endActionLoaded);
}
this.urlRequest.send(req);
};
IlvDynamicLayer.prototype.updateImage=function(img,_16d){
if(IlvBrowserInfo.instance.ie&&!IlvBrowserInfo.instance.ie7up){
var req=this.request;
var _16f=this.request.indexOf("&action=")!=-1;
if(_16f){
if(_16d){
this.sendAction(req);
return;
}else{
var _170=req.indexOf("&action=");
req=req.substring(0,_170)+req.substring(req.indexOf("&",_170+1),req.length);
}
}
var w=this.getWidth();
var h=this.getHeight();
var _173=document.createElement("img");
_173.id=this.imageID;
_173.style.cssText="border-size:0;width:"+w+";height:"+h+";";
img.parentNode.replaceChild(_173,img);
var v=this;
_173.onload=function(){
v.imageLoadListeners.notify(v);
};
_173.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src=\""+escape(req)+"\",sizingMethod='scale')";
_173.src=IlvTiledView.getEmptyImage();
}else{
if(this.view){
this.view.parentNode.style["-webkit-transform"]="scale(1)";
}
this.setImage(this.request,this.getWidth,this.getHeight());
}
};
IlvDynamicLayer.prototype.cancelUpdateTimer=function(){
if(this.updateTimer){
clearTimeout(this.updateTimer);
}
};
IlvDynamicLayer.prototype.update=function(_175,_176){
if(_176){
if(this.updateTimer){
clearTimeout(this.updateTimer);
}
var view=this;
this.updateTimer=setTimeout(function(){
view.update(_175,false);
},IlvDynamicLayer.delayedTimeout);
}else{
if(this.layers){
var v=this.view;
this.request=v.createRequestURL(v.qbboxx,v.qbboxy,v.qbboxw,v.qbboxh,this.getWidth(),this.getHeight(),IlvUtil.getEncodedVisibleLayers(this.view,this.layers),this.format)+"&transparent=true&dynamic=true";
if(this.updateIntervalID!=null){
window.clearTimeout(this.updateIntervalID);
}
this.updateImage(this.getImageNode(),true);
}
}
};
IlvDynamicLayer.prototype.setUpdateInterval=function(rate){
if(this.inHTML){
if(this.updateIntervalID!=null){
window.clearTimeout(this.updateIntervalID);
}
if(rate!=0){
if(!this.updateIntervalFunction){
var view=this;
this.updateIntervalFunction=function(){
view.doRefresh();
};
}
this.updateIntervalID=setTimeout(this.updateIntervalFunction,rate*1000);
}
}
this.updateInterval=rate;
};
IlvDynamicLayer.prototype.getUpdateInterval=function(){
return this.updateInterval;
};
IlvDynamicLayer.prototype.doRefresh=function(){
if(this.view.isAutoUpdateCapabilities()){
this.view.getCapabilities(true,false,true,true);
}else{
this.update();
}
};
IlvTiledView=function(left,top,_17d,_17e,_17f,_180){
if(!window.IlvAbstractView){
alert(jviews.messages.IlvTiledView.requiresIlvAbstractView);
}
if(_17d){
this.superConstructor(left,top,_17d,_17e,_180);
this.format="JPEG";
this.capabilitiesLoaded=false;
this.autoUpdateCapabilities=false;
this.initialized=false;
this.requestURL=null;
this.tileSize=_17f?_17f:256;
this.imageMap=false;
this.imageMapVisible=false;
this.interactor=null;
this.rectPanel=null;
this.qbboxx=0;
this.qbboxy=0;
this.qbboxw=100;
this.qbboxh=100;
this.minx=0;
this.maxx=0;
this.maxy=0;
this.miny=0;
this.zoom=0;
this.maxZoom=0;
this.minZoom=1;
this.panFactor=0.5;
this.zoomFactor=1.5;
this.constrainedOnContents=true;
this.error=false;
this.errorMessage=jviews.messages.IlvTiledView.serviceNotAvailable;
this.timeout=600;
this.allLayers=[];
this.visibleLayers=[];
this.overviewLayers=[];
this.dynLayers=[];
this.capabilitiesListeners=new IlvListenerList();
this.interactorListeners=new IlvListenerList();
this.sessionDelay=120;
this.sessionMaxInactiveInterval=-1;
this.sessionExpirationHandler=null;
this.container=new IlvHTMLContainerPanel(left,top,_17d,_17e,"hidden");
this.tilesManager=new IlvTileManager(this,this.tileSize);
this.container.addObject(this.tilesManager.getTilesContainer());
this.dLayer=new IlvDynamicLayer(this);
this.dLayer.addImageLoadListener(function(view){
if(view.isCapabilitiesLoaded()){
view.updateImageMap();
}
});
this.dLayer.addImageLoadListener(function(view){
if(view.isCapabilitiesLoaded()){
view.updateHitmap();
}
});
this.container.addObject(this.dLayer);
this.bboxListeners=new IlvListenerList();
this.panAnimListeners=new IlvListenerList();
this.setAdditionalParameters("tiled",true);
}
this.registerDispose();
};
IlvTiledView.prototype=new IlvAbstractView();
IlvTiledView.prototype.setClassName("IlvTiledView");
IlvTiledView.prototype.dispose=function(){
if(this.capabilitiesListeners){
this.capabilitiesListeners.dispose();
}
if(this.interactorListeners){
this.interactorListeners.dispose();
}
if(this.bboxListeners){
this.bboxListeners.dispose();
}
if(this.panAnimListeners){
this.panAnimListeners.dispose();
}
this.superInvoke("dispose");
if(this.dLayer){
this.dLayer.dispose();
}
if(this.container){
this.container.dispose();
}
if(this.tilesManager){
this.tilesManager.dispose();
}
if(this.imageMapPanel){
this.imageMapPanel.dispose();
}
if(this.rectPanel){
this.rectPanel.dispose();
}
};
IlvTiledView.prototype.removeHTML=function(){
this.imagePanel.removeHTML();
if(this.rectPanel){
this.rectPanel.removeHTML();
}
if(this.container){
this.container.removeHTML();
}
if(this.imageMapPanel){
this.imageMapPanel.removeHTML();
}
if(this.dLayer){
this.dLayer.removeHTML();
}
};
IlvTiledView.getEmptyImage=function(){
if(!IlvTiledView.emptyImage){
var img=IlvFrameworkConstants.basePath+jviews.messages.IlvUtil.emptyIcon;
IlvTiledView.emptyImage=img.replace(/&amp;/g,"&");
}
return IlvTiledView.emptyImage;
};
IlvTiledView.prototype.setChildrenBounds=function(left,top,_186,_187){
this.superInvoke("setChildrenBounds",left,top,_186,_187);
this.container.setBounds(left,top,_186,_187);
this.imageMapPanel.setBounds(left,top,_186,_187);
if(this.dLayer){
this.dLayer.setBounds(0,0,_186,_187);
}
this.setViewBBoxNoCheck(this.qbboxx,this.qbboxy,this.qbboxw,this.qbboxh,true,false);
};
IlvTiledView.prototype.getLayers=function(){
var list=[];
var _189=this.allLayers.length;
for(var i=0;i<_189;i++){
list[list.length]=this.allLayers[i];
}
return list;
};
IlvTiledView.prototype.getVisibleLayers=function(){
var list=[];
var _18c=this.allLayers.length;
for(var i=0;i<_18c;i++){
if(this.visibleLayers[i]){
list[list.length]=this.allLayers[i];
}
}
return list;
};
IlvTiledView.prototype.getDynamicVisibleLayers=function(){
var list=[];
var _18f=this.allLayers.length;
for(var i=0;i<_18f;i++){
if(this.visibleLayers[i]&&this.dynLayers[this.allLayers[i]]){
list[list.length]=this.allLayers[i];
}
}
return list;
};
IlvTiledView.prototype.getStaticVisibleLayers=function(){
var list=[];
var _192=this.allLayers.length;
for(var i=0;i<_192;i++){
if(this.visibleLayers[i]&&!this.dynLayers[this.allLayers[i]]){
list[list.length]=this.allLayers[i];
}
}
return list;
};
IlvTiledView.prototype.setLayerVisible=function(_194,_195){
var _196=this.allLayers.length;
for(var i=0;i<_196;i++){
if(this.allLayers[i]==_194&&(this.visibleLayers[i]!=_195)&&this.isDynamicLayer(_194)){
this.visibleLayers[i]=_195;
this.overviewLayers[i]=_195;
}
}
this.update(false);
};
IlvTiledView.prototype.isDynamicLayer=function(_198){
return this.dynLayers[_198];
};
IlvTiledView.prototype.getDynamicLayers=function(){
var _199=[];
for(var key in this.dynLayers){
_199.push(key);
}
return _199;
};
IlvTiledView.prototype.isTiled=function(){
return true;
};
IlvTiledView.prototype.isLayerVisible=function(_19b){
var _19c=this.allLayers.length;
for(var i=0;i<_19c;i++){
if(this.allLayers[i]==_19b){
return this.visibleLayers[i];
}
}
return false;
};
IlvTiledView.prototype.init=function(){
this.getCapabilities(true,true,false,false);
this.initialized=true;
};
IlvTiledView.prototype.setGenerateImageMap=function(set){
this.imageMap=set;
};
IlvTiledView.prototype.isGenerateImageMap=function(){
return this.imageMap;
};
IlvTiledView.prototype.setImageFormat=function(_19f){
this.format=_19f;
};
IlvTiledView.prototype.updateImageMap=function(){
if(!this.imageMap){
return;
}
this.imageMapPanel.setVisible(false);
this.imageMapRequest.send(this.createImageMapRequestURL(this.qbboxx,this.qbboxy,this.qbboxw,this.qbboxh,this.getWidth(),this.getHeight(),IlvUtil.getEncodedVisibleLayers(this,this.allLayers)));
};
IlvTiledView.prototype.createImageMapRequestURL=function(qx,qy,qw,qh,_1a4,_1a5,_1a6){
var _1a7=[this.requestURL,"?request=imagemap","&layer=",_1a6,"&bbox=",escape([qx,qy,qw,qh].join(",")),"&format=",this.format,"&width=",_1a4,"&height=",_1a5,"&again=",this.againString(),this.getAdditionalParameters()];
if(this.emptyImagePath==null){
var tmp=new Image();
tmp.src=IlvTiledView.getEmptyImage();
this.emptyImagePath=tmp.src;
}
_1a7.push("&image=");
_1a7.push(escape(this.emptyImagePath));
return _1a7.join("");
};
IlvTiledView.prototype.imageMapUpdated=function(_1a9){
if(IlvBrowserInfo.instance.webkit){
this.imageMapPanel.setContent("<b></b>");
}
this.imageMapPanel.setContent(_1a9);
if(this.imageMapVisible){
this.imageMapPanel.setVisible(true);
}
};
IlvTiledView.prototype.showImageMap=function(){
this.imageMapVisible=true;
if(this.imageMapPanel){
this.imageMapPanel.setVisible(true);
}
};
IlvTiledView.prototype.hideImageMap=function(){
this.imageMapVisible=false;
if(this.imageMapPanel){
this.imageMapPanel.setVisible(false);
}
};
IlvTiledView.prototype.getImageFormat=function(){
return this.format;
};
IlvTiledView.prototype.setMessagePanel=function(_1aa){
this.infoPanel=_1aa;
};
IlvTiledView.prototype.getMessagePanel=function(){
return this.infoPanel;
};
IlvTiledView.prototype.addCapabilitiesOnLoadListener=function(_1ab){
this.capabilitiesListeners.addListener(_1ab);
};
IlvTiledView.prototype.removeCapabilitiesOnLoadListener=function(_1ac){
this.capabilitiesListeners.removeListener(_1ac);
};
IlvTiledView.prototype.addBeforeImageOnLoadListener=function(_1ad){
this.dLayer.addImagePreloadListener(_1ad);
};
IlvTiledView.prototype.removeBeforeImageOnLoadListener=function(_1ae){
this.dLayer.removeImagePreloadListener(_1ae);
};
IlvTiledView.prototype.addImageOnLoadListener=function(_1af){
this.dLayer.addImageLoadListener(_1af);
};
IlvTiledView.prototype.removeImageOnLoadListener=function(_1b0){
this.dLayer.removeImageLoadListener(_1b0);
};
IlvTiledView.prototype.addViewBBoxListener=function(_1b1){
this.bboxListeners.addListener(_1b1);
};
IlvTiledView.prototype.removeViewBBoxLoadListener=function(_1b2){
this.bboxListeners.removeListener(_1b2);
};
IlvTiledView.prototype.addEndPanAnimationListener=function(_1b3){
this.panAnimListeners.addListener(_1b3);
};
IlvTiledView.prototype.removeEndPanAnimationListener=function(_1b4){
this.panAnimListeners.removeListener(_1b4);
};
IlvTiledView.prototype.updateVisibility=function(){
this.superInvoke("updateVisibility");
if(this.rectPanel){
this.rectPanel.updateVisibility();
}
};
IlvTiledView.prototype.isCapabilitiesLoaded=function(){
return this.capabilitiesLoaded;
};
IlvTiledView.prototype.createCapabilitiesRequestURL=function(){
var _1b5=[this.requestURL,"?request=capabilities&format=json","&width=",this.getWidth(),"&height=",this.getHeight(),this.getAdditionalParameters(),"&again=",this.againString()];
return _1b5.join("");
};
IlvTiledView.prototype.createRequestURL=function(qx,qy,qw,qh,_1ba,_1bb,_1bc,_1bd){
var _1be=[this.requestURL,"?request=image","&layer=",_1bc,"&bbox=",escape([qx,qy,qw,qh].join(",")),"&format=",(_1bd?_1bd:this.format),"&width=",_1ba,"&height=",_1bb,"&again=",this.againString()];
if(this.getImageBackgroundColor()){
_1be.push("&bgcolor=0x");
_1be.push(this.getImageBackgroundColor());
}
_1be.push(this.getAdditionalParameters());
return _1be.join("");
};
IlvTiledView.prototype.performAction=function(_1bf,_1c0,_1c1,_1c2){
var buf=_1bf+"(";
if(_1c0!=null){
buf+=_1c0.join(",");
}
buf+=")";
this.setAdditionalParameters("action",buf);
if(_1c1){
if(!_1c2){
_1c2=[false,false,true,true];
}
var c=_1c2;
this.getCapabilities(c[0],c[1],c[2],c[3]);
}else{
this.dLayer.update(false);
}
this.removeAdditionalParameter("action");
};
IlvTiledView.prototype.readAdditionalCapabilities=function(_1c5){
};
IlvTiledView.prototype.resetSessionExpirationTimer=function(){
if(this.sessionTimer){
clearTimeout(this.sessionTimer);
}
if(this.sessionMaxInactiveInterval&&this.sessionMaxInactiveInterval!=-1&&this.sessionExpirationHandler){
this.sessionTimer=setTimeout(this.sessionListener,(this.sessionMaxInactiveInterval-this.sessionDelay)*1000);
}
};
IlvTiledView.prototype.setSessionExpirationHandler=function(_1c6){
this.sessionExpirationHandler=_1c6;
if(_1c6&&!this.sessionListener){
var v=this;
this.sessionListener=function(){
if(v.sessionExpirationHandler){
v.sessionExpirationHandler(v);
}
};
}
};
IlvTiledView.prototype.getCapabilities=function(_1c8,_1c9,_1ca,_1cb){
var _1cc=this.createCapabilitiesRequestURL();
var fRef=function(_1ce){
this.endCapabilitiesLoaded(_1ce,_1c8,_1c9,_1ca);
};
var _1cf=new IlvAjax.JSRequest(this,fRef);
_1cf.send(_1cc);
};
IlvTiledView.prototype.endCapabilitiesLoaded=function(_1d0,_1d1,_1d2,_1d3,_1d4){
var _1d5=this.allLayers;
var _1d6=this.visibleLayers;
this.allLayers=[];
this.visibleLayers=[];
this.overviewLayers=[];
this.minx=_1d0.minx;
this.maxx=_1d0.maxx;
this.miny=_1d0.miny;
this.maxy=_1d0.maxy;
this.readMaxZoomLevel(_1d0);
this.readZoomLevels(_1d0);
this.sessionMaxInactiveInterval=_1d0.sessionMaxInactiveInterval;
this.resetSessionExpirationTimer();
var _1d7=_1d0.themes.length;
var i;
for(i=0;i<_1d7;i++){
this.allLayers[i]=_1d0.themes[i];
this.visibleLayers[i]=true;
this.overviewLayers[i]=_1d0.overviewthemes[i];
}
if(_1d0.dynLayers){
var _1d9=[];
_1d7=_1d0.dynLayers.length;
for(i=0;i<_1d7;i++){
this.dynLayers[_1d0.dynLayers[i]]=true;
_1d9[i]=_1d0.dynLayers[i];
}
this.dLayer.setLayers(_1d9);
this.dLayer.setVisible(true);
}
this.tilesManager.setStaticLayers(this.getStaticVisibleLayers());
this.readAdditionalCapabilities(_1d0);
this.capabilitiesLoaded=true;
this.capabilitiesListeners.notify(this);
if(_1d1){
if(IlvUtil.getCookie(this.cookieName+"url")||!this.isStateInCookie()){
if(IlvUtil.getCookie(this.cookieName+"url")){
this.initFromCookie();
this.recenter(this.constrainedOnContents);
this.updateImage();
}else{
this.restoreState(this);
}
}else{
this.showAll();
}
}else{
if(_1d3&&_1d5!=null){
_1d7=_1d5.length;
for(i=0;i<_1d7;i++){
if(!_1d6[i]){
this.setLayerVisible(_1d5[i],false,false);
}
}
if(_1d4){
this.dLayer.update();
}else{
if(_1d2){
this.showAll();
}else{
this.recenter(this.constrainedOnContents);
this.updateImage();
}
}
}
}
};
IlvTiledView.prototype.initFromUrl=function(url){
var view=this;
var bbox=this.parseValue(url,"bbox");
var s=0;
var e=bbox.indexOf(",",s);
view.qbboxx=parseFloat(bbox.substring(s,e));
s=e+1;
e=bbox.indexOf(",",s);
view.qbboxy=parseFloat(bbox.substring(s,e));
s=e+1;
e=bbox.indexOf(",",s);
view.qbboxw=parseFloat(bbox.substring(s,e));
s=e+1;
e=bbox.length;
view.qbboxh=parseFloat(bbox.substring(s,e));
var _1df=view.allLayers.length;
var i;
for(i=0;i<_1df;i++){
view.visibleLayers[i]=false;
}
var _1e1=unescape(this.parseValue(url,"layer"));
var _1e2;
s=0;
e=0;
var stop=false;
while(true){
e=_1e1.indexOf(",",s);
if(e==-1){
e=_1e1.length;
stop=true;
}
_1e2=_1e1.substring(s,e);
for(i=0;i<_1df;i++){
if(view.allLayers[i]==_1e2){
view.visibleLayers[i]=true;
}
}
if(stop){
break;
}
s=e+1;
}
};
IlvTiledView.prototype.initFromCookie=function(){
var view=this;
var url=IlvUtil.getCookie(view.cookieName+"url");
view.initFromUrl(url);
};
IlvTiledView.prototype.parseValue=function(str,_1e7){
var s=str.indexOf(_1e7,0);
if(s==-1){
return -1;
}
var e=str.indexOf("&",s+1);
if(e==-1){
e=str.length;
}
return str.substring(s+_1e7.length+1,e);
};
IlvTiledView.prototype.getCurrentZoomLevel=function(){
var _1ea=this.getManagerBBox();
var _1eb=this.getViewBBox();
var a=_1ea.width/_1eb.width;
var b=_1ea.height/_1eb.height;
return a>b?a:b;
};
IlvTiledView.prototype.readMaxZoomLevel=function(_1ee){
this.maxZoom=_1ee.maxZoom;
};
IlvTiledView.prototype.readZoomLevels=function(_1ef){
this.zoomLevels=_1ef.zoomLevels;
if(this.zoomLevels){
this.maxZoom=this.zoomLevels[this.zoomLevels.length-1];
}
};
IlvTiledView.prototype.getOverviewLayers=function(){
var list=[];
var _1f1=this.allLayers.length;
for(var i=0;i<_1f1;i++){
if(this.overviewLayers[i]){
list[list.length]=this.allLayers[i];
}
}
return list;
};
IlvTiledView.prototype.setRequestURL=function(_1f3){
this.requestURL=_1f3;
};
IlvTiledView.prototype.getRequestURL=function(){
return this.requestURL;
};
IlvTiledView.prototype.getRequest=function(){
if(this.allLayers.length>0){
return this.createRequestURL(this.qbboxx,this.qbboxy,this.qbboxw,this.qbboxh,this.getWidth(),this.getHeight(),IlvUtil.getEncodedVisibleLayers(this,this.allLayers));
}else{
return "";
}
};
IlvTiledView.prototype.childrenToHTML=function(_1f4){
this.superInvoke("childrenToHTML",_1f4);
this.rectPanel=new IlvRectangle(null,_1f4);
this.rectPanel.setZIndex(3);
this.imageMapRequest=new IlvAjax.HTMLRequest(this,this.imageMapUpdated);
this.imageMapPanel=new IlvHTMLPanel("",_1f4);
this.imageMapPanel.setBounds(this.getLeft(),this.getTop(),this.getWidth(),this.getHeight());
this.imageMapPanel.setZIndex(5);
if(this.container){
this.container.toHTML(_1f4);
}
};
IlvTiledView.prototype.addInteractorListener=function(_1f5){
this.interactorListeners.addListener(_1f5);
};
IlvTiledView.prototype.removeInteractorListener=function(_1f6){
this.interactorListeners.removeListener(_1f6);
};
IlvTiledView.prototype.mouseMove=function(e){
if(this.interactor!=null){
if(this.interactor.mouseMove){
return this.interactor.mouseMove(e);
}else{
if(this.interactor.onmousemove){
return this.interactor.onmousemove(e);
}
}
}
return true;
};
IlvTiledView.prototype.mouseDrag=function(e){
if(this.interactor!=null){
if(this.interactor.mouseDrag){
return this.interactor.mouseDrag(e);
}else{
if(this.interactor.onmousemove){
return this.interactor.onmousemove(e);
}
}
}
return true;
};
IlvTiledView.prototype.keyPress=function(e){
if(this.interactor!=null){
if(this.interactor.keyPress){
return this.interactor.keyPress(e);
}else{
if(this.interactor.onkeypress){
return this.interactor.onkeypress(e);
}
}
}
return true;
};
IlvTiledView.prototype.keyUp=function(e){
if(this.interactor!=null){
if(this.interactor.keyUp){
return this.interactor.keyUp(e);
}else{
if(this.interactor.onkeyup){
return this.interactor.onkeyup(e);
}
}
}
return true;
};
IlvTiledView.prototype.keyDown=function(e){
if(this.interactor!=null){
if(this.interactor.keyDown){
return this.interactor.keyDown(e);
}else{
if(this.interactor.onkeydown){
return this.interactor.onkeydown(e);
}
}
}
return true;
};
IlvTiledView.prototype.mouseUp=function(e){
var _1fd=this.interactor;
var _1fe=this.popupMenu;
if(_1fe!=null&&_1fe.isPopupTrigger(e)){
var _1ff;
if(_1fd!=null){
_1ff=_1fd.getMenuModelId();
}
return _1fe.displayPopupMenu(this,e,_1ff);
}else{
if(this.interactor!=null){
if(this.interactor.mouseUp){
return this.interactor.mouseUp(e);
}else{
if(this.interactor.onmouseup){
return this.interactor.onmouseup(e);
}
}
}
}
return true;
};
IlvTiledView.prototype.mouseDown=function(e){
var _201=this.interactor;
var _202=this.popupMenu;
if(_202!=null&&_202.isPopupTrigger(e)){
this.eventPanel._dragging=false;
return true;
}else{
if(_202!=null){
_202.internalResetEvent();
_202.hidePopupMenu();
}
if(this.capabilitiesLoaded){
if(_201!=null){
if(_201.mouseDown){
return _201.mouseDown(e);
}else{
if(_201.onmousedown){
return _201.onmousedown(e);
}
}
}
}
}
return true;
};
IlvTiledView.prototype.mouseWheel=function(e){
if(this.interactor!=null){
if(this.interactor.mouseWheel){
return this.interactor.mouseWheel(e);
}else{
if(this.interactor.onmousewheel){
return this.interactor.onmousewheel(e);
}
}
}
return true;
};
IlvTiledView.prototype.mouseOver=function(e){
var _205=this.interactor;
if(_205!=null){
if(_205.message){
window.status=_205.message;
if(this.initialized&&this.infoPanel){
this.infoPanel.setContent(_205.message);
}
}
if(_205.mouseOver){
return _205.mouseOver(e);
}else{
if(_205.onmouseover){
return _205.onmouseover(e);
}
}
}
return true;
};
IlvTiledView.prototype.mouseOut=function(e){
var _207=this.interactor;
if(_207!=null){
window.status="";
if(this.initialized&&this.infoPanel){
this.infoPanel.setContent("");
}
if(_207.mouseOut){
return _207.mouseOut(e);
}else{
if(_207.onmouseout){
return _207.onmouseout(e);
}
}
}
return true;
};
IlvTiledView.prototype.getRectangle=function(){
return this.rectPanel;
};
IlvTiledView.prototype.getViewBBox=function(){
return {left:this.qbboxx,top:this.qbboxy,width:this.qbboxw,height:this.qbboxh};
};
IlvTiledView.prototype.setViewBBox=function(x,y,w,h,_20c,_20d){
if(this.zoomLevels){
var _20e=w/h;
var _20f=this.getManagerBBox();
var a=_20f.width/w;
var b=_20f.height/h;
var _212=a>b?a:b;
var _213=this.getNearestZoomLevel(_212);
var _214=this.zoomLevels[_213];
if(_212!=_214){
var ow=w;
var oh=h;
if(a>b){
w=_20f.width/_214;
h=w/_20e;
}else{
h=_20f.height/_214;
w=h*_20e;
}
var dif=ow-w;
x+=dif/2;
dif=oh-h;
y+=dif/2;
}
}
this.setViewBBoxNoCheck(x,y,w,h,_20c,_20d);
};
IlvTiledView.prototype.setViewBBoxNoCheck=function(x,y,w,h,_21c,_21d,_21e){
if(this.capabilitiesLoaded){
if(!_21e){
this.stopPanAnimation();
}
var _21f=this.getViewBBox();
var _220=this.tilesManager.getTilesContainer();
this.qbboxx=x;
this.qbboxy=y;
this.qbboxw=w;
this.qbboxh=h;
this.recenter(this.constrainedOnContents);
var _221=this.getViewBBox();
var _222=this.getManagerBBox();
var _223=0;
var _224=0;
var _225=0;
var _226=0;
if(_21c){
this.sx=this.getWidth()/_221.width;
this.sy=this.getHeight()/_221.height;
this.tx=0-this.sx*_221.left;
this.ty=0-this.sy*_221.top;
this.tileSizeT=this.tileSize/this.sx;
this.managerBBoxT={x:this.sx*_222.left+this.tx,y:this.sy*_222.top+this.ty,width:_222.width*this.sx,height:_222.height*this.sy};
this.countX=Math.floor(_222.width/this.tileSizeT)+1;
this.countY=Math.floor(_222.height/this.tileSizeT)+1;
this.viewBBoxT={x:-this.managerBBoxT.x,y:-this.managerBBoxT.y,width:this.getWidth()*1,height:this.getHeight()*1};
}else{
var dx=(_221.left-_21f.left)*this.sx;
var dy=(_221.top-_21f.top)*this.sy;
this.viewBBoxT.x+=dx;
this.viewBBoxT.y+=dy;
_226=(dx<0)?1:0;
_224=(dx>0)?1:0;
_223=(dy<0)?1:0;
_225=(dy>0)?1:0;
}
var xmin=Math.floor(this.viewBBoxT.x/this.tileSize)-_226;
var xmax=Math.ceil((this.viewBBoxT.x+this.viewBBoxT.width)/this.tileSize)-1+_224;
var ymin=Math.floor(this.viewBBoxT.y/this.tileSize)-_223;
var ymax=Math.ceil((this.viewBBoxT.y+this.viewBBoxT.height)/this.tileSize)-1+_225;
if(xmin<0){
xmin=0;
}
if(xmax>=this.countX){
xmax=this.countX-1;
}
if(ymin<0){
ymin=0;
}
if(ymax>=this.countY){
ymax=this.countY-1;
}
this.tilesManager.setVisibleTiles(xmin,xmax,ymin,ymax,_21c);
_220.setLocation(Math.round(-this.viewBBoxT.x),Math.round(-this.viewBBoxT.y));
this.bboxListeners.notify(this);
if(!_21d){
if(window.IlvSelectionManager){
this.getSelectionManager().hideAll();
}
if(this.getDynamicLayer()){
this.getDynamicLayer().setVisible(false);
}
this.update(false,true);
}
}
};
IlvTiledView.prototype._fixZoom=function(zoom,a,b,_230){
var d;
if(a>b){
d=this.qbboxw-(this.maxx-this.minx)/zoom;
this.qbboxw=(this.maxx-this.minx)/zoom;
this.qbboxx+=d/2;
d=this.qbboxh-this.qbboxw/_230;
this.qbboxh=this.qbboxw/_230;
this.qbboxy+=d/2;
}else{
d=this.qbboxh-(this.maxy-this.miny)/zoom;
this.qbboxh=(this.maxy-this.miny)/zoom;
this.qbboxy+=d/2;
d=this.qbboxw-this.qbboxh*_230;
this.qbboxw=this.qbboxh*_230;
this.qbboxx+=d/2;
}
};
IlvTiledView.prototype.recenter=function(_232){
if(this.getHeight()==0||this.getWidth()==0){
return;
}
var a=(this.maxx-this.minx)/this.qbboxw;
var b=((this.maxy-this.miny)/this.qbboxh);
var _235=this.getWidth()/this.getHeight();
var _236=a>b?a:b;
if(this.maxZoom&&this.maxZoom!=-1&&_236>this.maxZoom){
this._fixZoom(this.maxZoom,a,b,_235);
}
if(this.minZoom&&this.minZoom!=-1&&_236<this.minZoom){
this._fixZoom(this.minZoom,a,b,_235);
}
if(_232){
if(this.qbboxx<this.minx){
this.qbboxx=this.minx;
}
if(this.qbboxy<this.miny){
this.qbboxy=this.miny;
}
if(this.qbboxw>this.maxx-this.minx){
this.qbboxw=this.maxx-this.minx;
}
if(this.qbboxh>this.maxy-this.miny){
this.qbboxh=this.maxy-this.miny;
}
if(this.qbboxx+this.qbboxw>this.maxx){
this.qbboxx=this.maxx-this.qbboxw;
}
if(this.qbboxy+this.qbboxh>this.maxy){
this.qbboxy=this.maxy-this.qbboxh;
}
}
var dif;
if(this.qbboxw<this.qbboxh*_235){
dif=this.qbboxw-this.qbboxh*_235;
this.qbboxw=this.qbboxh*_235;
this.qbboxx+=dif/2;
}else{
dif=this.qbboxh-this.qbboxw/_235;
this.qbboxh=this.qbboxw/_235;
this.qbboxy+=dif/2;
}
};
IlvTiledView.prototype.isFitToContent=function(){
var _238=this.getCurrentZoomLevel();
var _239=_238>0.999&&_238<1.001;
if(!_239){
return false;
}
var _23a=this.getViewBBox();
var _23b=this.getManagerBBox();
var _23c=this.getWidth()/this.getHeight();
var dif;
if(_23b.width<_23b.height*_23c){
dif=_23b.width-_23b.height*_23c;
_23b.width=_23b.height*_23c;
_23b.left+=dif/2;
}else{
dif=_23b.height-_23b.width/_23c;
_23b.height=_23b.width/_23c;
_23b.top+=dif/2;
}
_239=(_23a.left==_23b.left&&_23a.width==_23b.width&&_23a.top==_23b.top&&_23a.height==_23b.height);
return _239;
};
IlvTiledView.prototype.centerAt=function(x,y){
this.setViewBBoxNoCheck(x-this.qbboxw/2,y-this.qbboxh/2,this.qbboxw,this.qbboxh);
};
IlvTiledView.prototype.getManagerBBox=function(){
return {left:this.minx,top:this.miny,width:this.maxx-this.minx,height:this.maxy-this.miny};
};
IlvTiledView.prototype.stopPanAnimation=function(){
if(this.panTimer){
clearTimeout(this.panTimer);
this.panAnimListeners.notify(this,false);
this.dLayer.setPanning(false);
}
};
IlvTiledView.prototype.createPanAnimation=function(_240,_241){
if(this.panTimer){
clearTimeout(this.panTimer);
}
var _242=this.getViewBBox();
var _243=this.getManagerBBox();
var dx=_242.left-_240;
var dy=_242.top-_241;
if((dx==0&&dy==0)||isNaN(dx)||isNaN(dx)){
this.panAnimListeners.notify(this,false);
return;
}
var d=Math.sqrt(dx*dx+dy*dy);
var dMax=Math.sqrt(_243.width*_243.width+_243.height*_243.height);
var time=3000*d/dMax;
var _249=50;
var curX=this.qbboxx;
var curY=this.qbboxy;
dx=((_240-curX)*_249)/time;
dy=((_241-curY)*_249)/time;
var step=0;
var _24d=Math.floor(time/_249);
this.dLayer.setPanning(true);
this.dLayer.setVisible(false);
if(window.IlvSelectionManager){
this.getSelectionManager().hideAll();
}
var view=this;
this.panTimer=setTimeout(function(){
view.panAnimation(_240,_241,dx,dy,step,_24d,_249);
},_249);
};
IlvTiledView.prototype.panAnimation=function(fX,fY,dx,dy,step,_254,_255){
if(this.panTimer){
clearTimeout(this.panTimer);
}
step++;
if(step<_254){
this.moveTo(this.qbboxx+dx,this.qbboxy+dy,true,true);
this.tilesManager.organizeTiles();
var view=this;
this.panTimer=setTimeout(function(){
view.panAnimation(fX,fY,dx,dy,step,_254,_255);
},_255);
}else{
this.moveTo(fX,fY,true,false);
this.update(false,false);
this.panAnimListeners.notify(this,true);
}
};
IlvTiledView.prototype.setConstrainedOnContents=function(_257){
this.constrainedOnContents=_257;
};
IlvTiledView.prototype.isConstrainedOnContents=function(){
return this.constrainedOnContents;
};
IlvTiledView.prototype.moveTo=function(x,y,_25a,_25b){
this.setViewBBoxNoCheck(x,y,this.qbboxw,this.qbboxh,false,_25a,_25b);
};
IlvTiledView.prototype.panEast=function(){
this.moveTo(this.qbboxx+this.qbboxw*this.panFactor,this.qbboxy);
};
IlvTiledView.prototype.panWest=function(){
this.moveTo(this.qbboxx-this.qbboxw*this.panFactor,this.qbboxy);
};
IlvTiledView.prototype.panSouth=function(){
this.moveTo(this.qbboxx,this.qbboxy+this.qbboxh*this.panFactor);
};
IlvTiledView.prototype.panNorth=function(){
this.moveTo(this.qbboxx,this.qbboxy-this.qbboxh*this.panFactor);
};
IlvTiledView.prototype.panSouthEast=function(){
this.moveTo(this.qbboxx+this.qbboxw*this.panFactor,this.qbboxy+this.qbboxh*this.panFactor);
};
IlvTiledView.prototype.panNorthEast=function(){
this.moveTo(this.qbboxx+this.qbboxw*this.panFactor,this.qbboxy-this.qbboxh*this.panFactor);
};
IlvTiledView.prototype.panSouthWest=function(){
this.moveTo(this.qbboxx-this.qbboxw*this.panFactor,this.qbboxy+this.qbboxh*this.panFactor);
};
IlvTiledView.prototype.panNorthWest=function(){
this.moveTo(this.qbboxx-this.qbboxw*this.panFactor,this.qbboxy-this.qbboxh*this.panFactor);
};
IlvTiledView.prototype.setPanFactor=function(_25c){
this.panFactor=_25c;
};
IlvTiledView.prototype.getPanFactor=function(){
return this.panFactor;
};
IlvTiledView.prototype.setZoomFactor=function(_25d){
this.zoomFactor=_25d;
};
IlvTiledView.prototype.getZoomFactor=function(){
return this.zoomFactor;
};
IlvTiledView.prototype.getNearestZoomLevel=function(_25e){
var diff=Math.abs(_25e-this.zoomLevels[0]);
var _260=0;
for(var i=1;i<this.zoomLevels.length;i++){
var _262=Math.abs(_25e-this.zoomLevels[i]);
if(_262<diff){
diff=_262;
_260=i;
}
}
return _260;
};
IlvTiledView.prototype.getCurrentFixedZoomLevel=function(){
var a=(this.maxx-this.minx)/this.qbboxw;
var b=((this.maxy-this.miny)/this.qbboxh);
var _265=a>b?a:b;
var _266=this.getNearestZoomLevel(_265);
return {index:_266,realValue:_265,value:this.zoomLevels[_266]};
};
IlvTiledView.prototype.applyZoomlevel=function(_267){
var bbox=this.getViewBBox();
var _269=this.getManagerBBox();
var zoom=Math.max(_269.width/bbox.width,_269.height/bbox.height);
this.zoomByNoCheck(_267/zoom);
};
IlvTiledView.prototype.zoomToIdentity=function(_26b){
var _26c=this.getViewBBox();
var ok=true;
this.qbboxx=0;
this.qbboxy=0;
this.qbboxw=this.getWidth();
this.qbboxh=this.getHeight();
var zl=this.getCurrentZoomLevel();
if(this.zoomLevels){
if(!_26b){
ok=zl==this.zoomLevels[this.getNearestZoomLevel(zl)];
}
}else{
ok=(this.minZoom==-1||zl>=this.minZoom)&&(this.maxZoom==-1||zl<=this.maxZoom);
}
if(ok){
this.setViewBBox(0,0,this.getWidth(),this.getHeight());
}else{
this.qbboxx=_26c.left;
this.qbboxy=_26c.top;
this.qbboxw=_26c.width;
this.qbboxh=_26c.height;
}
return ok;
};
IlvTiledView.prototype.zoomIn=function(){
if(this.zoomLevels){
var _26f=this.getCurrentFixedZoomLevel();
var _270=_26f.index;
if(_270+1<this.zoomLevels.length){
var _271=this.zoomLevels[_270+1];
this.applyZoomlevel(_271);
}
}else{
this.zoomBy(this.zoomFactor);
}
};
IlvTiledView.prototype.zoomOut=function(){
if(this.zoomLevels){
var _272=this.getCurrentFixedZoomLevel();
var _273=_272.index;
if(_273-1>=0){
var _274=this.zoomLevels[_273-1];
this.applyZoomlevel(_274);
}
}else{
this.zoomBy(1/this.zoomFactor);
}
};
IlvTiledView.prototype.zoomBy=function(z){
if(this.zoomLevels){
var a=(this.maxx-this.minx)/this.qbboxw;
var b=((this.maxy-this.miny)/this.qbboxh);
var _278=a>b?a:b;
var _279=z*_278;
var _27a=this.getNearestZoomLevel(_279);
_279=this.zoomLevels[_27a];
this.zoomByNoCheck(_279/_278);
}else{
this.zoomByNoCheck(z);
}
};
IlvTiledView.prototype.zoomByNoCheck=function(z){
this.setViewBBoxNoCheck(this.qbboxx+this.qbboxw*(1-1/z)/2,this.qbboxy+this.qbboxh*(1-1/z)/2,this.qbboxw/z,this.qbboxh/z,true);
};
IlvTiledView.prototype.getMaxZoomLevel=function(){
return this.maxZoom;
};
IlvTiledView.prototype.showAll=function(){
if(this.zoomLevels){
var _27c=this.getManagerBBox();
var _27d=this.zoomLevels[this.getNearestZoomLevel(1)];
var _27e={};
_27e.width=_27c.width/_27d;
_27e.height=_27c.height/_27d;
var dif=_27c.width-_27e.width;
_27e.left=_27c.left+dif/2;
dif=_27c.height-_27e.height;
_27e.top=_27c.top+dif/2;
this.setViewBBoxNoCheck(_27e.left,_27e.top,_27e.width,_27e.height,true);
}else{
this.setViewBBoxNoCheck(this.minx,this.miny,this.maxx-this.minx,this.maxy-this.miny,true);
}
};
IlvTiledView.prototype.getAllVBBox=function(){
var x=this.minx,y=this.miny,w=this.maxx-this.minx,h=this.maxy-this.miny;
var dif;
var _285=this.getWidth()/this.getHeight();
if(w<h*_285){
dif=w-h*_285;
w=h*_285;
x+=dif/2;
}else{
dif=h-w/_285;
h=w/_285;
y+=dif/2;
}
return this.allVbbox={left:x,top:y,width:w,height:h};
};
IlvTiledView.prototype.updateImage=function(){
this.setViewBBox(this.qbboxx,this.qbboxy,this.qbboxw,this.qbboxh,true);
};
IlvTiledView.prototype.updateAll=function(_286,_287,_288){
this.capabilitiesLoaded=false;
this.getCapabilities(false,_286,_287,_288);
};
IlvTiledView.prototype.update=function(_289,_28a){
if(this.dLayer){
this.dLayer.update(_289,_28a);
}
this.tilesManager.organizeTiles(_289);
if(this.isStateInCookie()){
var _28b=this.getRequest();
IlvUtil.setCookie(this.cookieName+"url",unescape(_28b));
}else{
this.saveState(this);
}
};
IlvTiledView.prototype.againString=function(){
var date=new Date();
var str=date.toUTCString();
str=str+" "+date.getMilliseconds();
return escape(str);
};
IlvTiledView.prototype.removeAdditionalParameter=function(key){
IlvRequestParameters.removeParameter(this.additionalParams,key);
};
IlvTiledView.prototype.setPopupMenu=function(_28f){
this.popupMenu=_28f;
this.popupMenu.setViewInternal(this);
};
IlvTiledView.prototype.getSelectionManager=function(){
if(!this.selectManager){
if(!window.IlvSelectionManager){
alert(jviews.messages.IlvTiledView.mustImportJSFile);
}else{
this.selectManager=new IlvSelectionManager();
this.selectManager.setViewInternal(this);
}
}
return this.selectManager;
};
IlvTiledView.prototype.getPopupMenu=function(){
return this.popupMenu;
};
IlvTiledView.prototype.getZoomLevels=function(){
return this.zoomLevels;
};
IlvTiledView.prototype.setImageBackgroundColor=function(_290){
this.imgbgcolor=_290;
this.container.setBackgroundColor(_290);
};
IlvTiledView.prototype.getImageBackgroundColor=function(){
return this.imgbgcolor;
};
IlvTiledView.prototype.setWaitingImage=function(_291){
};
IlvTiledView.prototype.getWaitingImage=function(){
return null;
};
IlvTiledView.prototype.setUpdateInterval=function(rate){
this.dLayer.setUpdateInterval(rate);
};
IlvTiledView.prototype.getUpdateInterval=function(){
return this.dLayer.getUpdateInterval();
};
IlvTiledView.prototype.getDynamicLayer=function(){
return this.dLayer;
};
IlvTiledView.prototype.isAutoUpdateCapabilities=function(){
return this.autoUpdateCapabilities;
};
IlvTiledView.prototype.setAutoUpdateCapabilities=function(set){
this.autoUpdateCapabilities=set;
};
IlvTiledView.prototype.getContentsBounds=function(){
return this.getBounds();
};
IlvOverview=function(left,top,_296,_297,view,_299){
if(!window.IlvAbstractView){
alert(jviews.messages.IlvOverview.requiresIlvAbstractView);
}
this.superConstructor(left,top,_296,_297);
this.eventPanel.setZIndex(5);
this.lineWidth=2;
this.staticImage=(typeof (_299)=="string")?_299:null;
this.color="black";
this.visible=false;
this.ghostW=0;
this.ghostH=0;
this.imageH=_297;
this.imageW=_296;
this.overviewRefresh=false;
this.firstTime=true;
this.fill=false;
this.fixedSize=false;
this.opacity=0.5;
this.imagePanel=new IlvImageView(left,top,_296,_297);
this.imagePanel.setImageSize(3,3);
this.setMessage(jviews.messages.IlvOverview.moveRectangleToRecenterView);
this.animated=false;
if(view){
this.setViewInternal(view);
}
};
IlvOverview.prototype=new IlvAbstractView();
IlvOverview.prototype.setClassName("IlvOverview");
IlvOverview.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.imagePanel){
this.imagePanel.dispose();
}
if(this.rect){
this.rect.dispose();
}
if(this.rect2){
this.rect2.dispose();
}
if(this.infoPanel){
this.infoPanel.dispose();
}
};
IlvOverview.prototype.setViewInternal=function(view){
if(view){
var _29b=this;
this.view=view;
view.addImageOnLoadListener(function(view){
_29b.onImageLoaded(view);
});
view.addCapabilitiesOnLoadListener(function(view){
_29b.onCapabilitiesLoaded(view);
});
if(view.isTiled()){
view.addViewBBoxListener(function(view){
_29b.onViewBBoxChanged(view);
});
view.addEndPanAnimationListener(function(view,_2a0){
_29b.onEndPanAnimation(view,_2a0);
});
}
}
};
IlvOverview.prototype.removeHTML=function(){
this.superInvoke("removeHTML");
this.imagePanel.removeHTML();
if(this.rect!=null){
this.rect.removeHTML();
}
};
IlvOverview.prototype.updateVisibility=function(){
this.superInvoke("updateVisibility");
this.imagePanel.updateVisibility();
if(this.rect!=null){
this.rect.updateVisibility();
}
};
IlvOverview.prototype.getTargetView=function(){
return this.view;
};
IlvOverview.prototype.setMessage=function(_2a1){
this.message=_2a1;
};
IlvOverview.prototype.getMessage=function(){
return this.message;
};
IlvOverview.prototype.setMessagePanel=function(_2a2){
this.infoPanel=_2a2;
};
IlvOverview.prototype.getMessagePanel=function(){
return this.infoPanel;
};
IlvOverview.prototype.setColor=function(_2a3){
this.color=_2a3;
if(this.rect){
this.rect.setColor(_2a3);
}
if(this.rect2){
this.rect2.setColor(_2a3);
}
};
IlvOverview.prototype.getColor=function(){
return this.color;
};
IlvOverview.prototype.setFillOn=function(fill){
this.fill=fill;
if(this.rect){
this.rect.setFillOn(fill);
}
};
IlvOverview.prototype.isFillOn=function(){
return this.fill;
};
IlvOverview.prototype.setOpacity=function(_2a5){
this.opacity=_2a5;
if(this.rect){
this.rect.setOpacity(_2a5);
}
};
IlvOverview.prototype.getOpacity=function(){
return this.opacity;
};
IlvOverview.prototype.setIgnoreContentAspectRatio=function(_2a6){
this.ignoreContentAspectRatio=_2a6;
};
IlvOverview.prototype.isIgnoreContentAspectRatio=function(){
return this.ignoreContentAspectRatio;
};
IlvOverview.prototype.setLineWidth=function(lw){
this.lineWidth=lw;
if(this.rect){
this.rect.setThickness(lw);
this.adjust();
}
if(this.rect2){
this.rect2.setThickness(lw+1);
}
};
IlvOverview.prototype.getLineWidth=function(){
return this.lineWidth;
};
IlvOverview.prototype.setAnimatedPan=function(anim){
this.animated=anim;
};
IlvOverview.prototype.isAnimatedPan=function(){
return this.animated;
};
IlvOverview.prototype.setAutoRefresh=function(set){
this.overviewRefresh=set;
};
IlvOverview.prototype.isAutoRefresh=function(){
return this.overviewRefresh;
};
IlvOverview.prototype.mouseDown=function(e){
this.dragging=true;
return this.mouseDrag(e);
};
IlvOverview.prototype.mouseOver=function(e){
if(this.message){
window.status=this.message;
if(this.view.initialized&&this.infoPanel){
this.infoPanel.setContent(this.message);
}
}
};
IlvOverview.prototype.mouseOut=function(e){
if(this.message){
window.status="";
if(this.view.initialized&&this.infoPanel){
this.infoPanel.setContent("");
}
}
};
IlvOverview.prototype.mouseDrag=function(e){
var x=e.mouseX;
var y=e.mouseY;
var h=this.ghostH;
var w=this.ghostW;
if(x<w/2){
x=w/2;
}
if(y<h/2){
y=h/2;
}
if(x+w/2>this.imageW){
x=this.imageW-w/2;
}
if(y+h/2>this.imageH){
y=this.imageH-h/2;
}
this.drawRect(x-w/2,y-h/2,x+w/2,y+h/2);
return true;
};
IlvOverview.prototype.mouseUp=function(e){
if(this.dragging==false){
return false;
}
this.dragging=false;
var _2b3=e.mouseX;
var _2b4=e.mouseY;
var v=this.view;
var bbox=v.getManagerBBox();
_2b3=bbox.left+_2b3*(bbox.width)/this.imageW;
_2b4=bbox.top+_2b4*(bbox.height)/this.imageH;
var h=this.ghostH;
var w=this.ghostW;
if(this.view!=null){
if(this.animated&&this.view.isTiled()){
var b=this.rect.getBounds();
this.rect2.setBounds(b.left,b.top,b.width,b.height);
this.rect2.setVisible(true);
var _2ba=this.view.getViewBBox();
this.view.qbboxx=_2b3-_2ba.width/2;
this.view.qbboxy=_2b4-_2ba.height/2;
this.view.recenter(true);
var _2bb=this.view.getViewBBox();
this.view.qbboxx=_2ba.left;
this.view.qbboxy=_2ba.top;
this.view.createPanAnimation(_2bb.left,_2bb.top);
}else{
this.view.centerAt(_2b3,_2b4,true);
}
}
return false;
};
IlvOverview.prototype.drawRect=function(left,top,_2be,_2bf){
if(left<0){
left=0;
}
if(left>this.imageW){
left=this.imageW;
}
if(_2be<0){
_2be=0;
}
if(_2be>this.imageW){
_2be=this.imageW;
}
if(top<0){
top=0;
}
if(top>this.imageH){
top=this.imageH;
}
if(_2bf<0){
_2bf=0;
}
if(_2bf>this.imageH){
_2bf=this.imageH;
}
this.rect.setBounds(this.getLeft()+left,this.getTop()+top,_2be-left,_2bf-top);
};
IlvOverview.prototype.adjust=function(){
var bbox=this.view.getViewBBox();
if(this.isIgnoreContentAspectRatio()){
var _2c1=this.view.getAllVBBox();
}else{
var _2c1=this.view.getManagerBBox();
}
var x=bbox.left;
var y=bbox.top;
var w=bbox.width;
var h=bbox.height;
var _2c6=_2c1.height;
var _2c7=_2c1.width;
var _2c8=parseInt((x-_2c1.left)*this.imageW/_2c7);
var _2c9=parseInt((x+w-_2c1.left)*this.imageW/_2c7);
var ztop=parseInt((y-_2c1.top)*this.imageH/_2c6);
var _2cb=parseInt((y+h-_2c1.top)*this.imageH/_2c6);
if(isNaN(_2c8)){
_2c8=0;
}
if(isNaN(_2c9)){
_2c9=0;
}
if(isNaN(ztop)){
ztop=0;
}
if(isNaN(_2cb)){
_2cb=0;
}
this.ghostW=_2c9-_2c8;
this.ghostH=_2cb-ztop;
this.drawRect(_2c8,ztop,_2c9,_2cb);
if(!this.visible){
this.rect.setVisible(true);
this.visible=true;
}
};
IlvOverview.prototype.onCapabilitiesLoaded=function(view){
this.updateOverviewImage(true);
this.updatedFromCapabilities=true;
};
IlvOverview.prototype.updateOverviewImage=function(_2cd){
if(this.staticImage!=null){
return;
}
if(!this.view.isCapabilitiesLoaded()){
return;
}
if(!_2cd){
this.updatedFromCapabilities=false;
return;
}
if(this.isIgnoreContentAspectRatio()){
var _2ce=this.view.getAllVBBox();
}else{
var _2ce=this.view.getManagerBBox();
}
var newH=parseInt(_2ce.height*this.getWidth()/_2ce.width);
if(newH<=this.getHeight()){
this.imageW=this.getWidth();
this.imageH=newH;
}else{
this.imageH=this.getHeight();
this.imageW=parseInt(_2ce.width*this.imageH/_2ce.height);
}
if(isNaN(this.imageH)||this.imageH==0){
this.imageH=this.getHeight();
}
if(isNaN(this.imageW)||this.imageW==0){
this.imageW=this.getWidth();
}
var _2d0=this.imagePanel.getImageSize();
var _2d1=(_2d0.width!=this.imageW||_2d0.height!=this.imageH);
var _2d2=this.view.createRequestURL(_2ce.left,_2ce.top,_2ce.width,_2ce.height,this.imageW,this.imageH,IlvUtil.encodeStringAttribute(this.view.getOverviewLayers().join(",")))+"&overview=true";
if(_2d1){
this.imagePanel.setImage(_2d2,this.imageW,this.imageH);
}else{
this.imagePanel.setImage(_2d2);
}
};
IlvOverview.prototype.onImageLoaded=function(view){
if(this.isAutoRefresh()&&!this.dragging){
if(this.updatedFromCapabilities){
this.updateOverviewImage();
}else{
this.updateOverviewImage(true);
}
}
this.adjust();
};
IlvOverview.prototype.onViewBBoxChanged=function(view){
if(!this.dragging){
this.adjust();
}
};
IlvOverview.prototype.onEndPanAnimation=function(view,_2d6){
this.rect2.setVisible(false);
};
IlvOverview.prototype.setChildrenBounds=function(left,top,_2d9,_2da){
this.superInvoke("setChildrenBounds",left,top,_2d9,_2da);
this.imagePanel.setBounds(left,top,_2d9,_2da);
if(this.inHTML){
this.updateOverviewImage();
if(this.view){
this.view.updateImage();
}
this.adjust();
}
};
IlvOverview.prototype.childrenToHTML=function(_2db){
if(!this.staticImage){
this.imagePanel.setImage(this.staticImage);
}
this.imagePanel.toHTML(_2db);
this.rect=new IlvRectangle(null,_2db,true);
this.rect.setThickness(this.lineWidth);
this.rect.setZIndex(3);
this.rect.setFillOn(this.fill);
this.rect.setOpacity(this.opacity);
this.rect2=new IlvRectangle(null,_2db);
this.rect2.setThickness(this.lineWidth+1);
this.rect2.setZIndex(3);
this.rect2.setVisible(false);
this.setColor(this.color);
this.superInvoke("childrenToHTML",_2db);
this.imagePanel.imagePanel.setZIndex(2);
};
IlvDragRectangleInteractor=function(){
this.superConstructor();
this.setCursor("crosshair");
this.listeners=new IlvListenerList();
this.color="black";
this.zleft=0;
this.ztop=0;
this.zbottom=0;
this.zright=0;
this.startx=0;
this.starty=0;
this.lineWidth=2;
this.dragging=false;
this.ratio=0;
};
IlvDragRectangleInteractor.prototype=new IlvInteractor();
IlvDragRectangleInteractor.prototype.setClassName("IlvDragRectangleInteractor");
IlvDragRectangleInteractor.prototype.addRectangleDraggedListener=function(_2dc){
this.listeners.addListener(_2dc);
};
IlvDragRectangleInteractor.prototype.removeRectangleDraggedListener=function(_2dd){
this.listeners.removeListener(_2dd);
};
IlvDragRectangleInteractor.prototype.setColor=function(_2de){
this.color=_2de;
};
IlvDragRectangleInteractor.prototype.getColor=function(){
return this.color;
};
IlvDragRectangleInteractor.prototype.setLineWidth=function(_2df){
this.lineWidth=_2df;
this.adjust();
};
IlvDragRectangleInteractor.prototype.getLineWidth=function(){
return this.lineWidth;
};
IlvDragRectangleInteractor.prototype.getXYRatio=function(){
return this.ratio;
};
IlvDragRectangleInteractor.prototype.setXYRatio=function(r){
this.ratio=r;
};
IlvDragRectangleInteractor.prototype.adjust=function(){
if(this.view&&this.view.getRectangle()){
var view=this.view;
var _2e2=this.zleft+view.getLeft();
var _2e3=this.zright+view.getLeft();
var ztop=this.ztop+view.getTop();
var _2e5=this.zbottom+view.getTop();
_2e2=Math.max(_2e2,view.getLeft());
ztop=Math.max(ztop,view.getTop());
_2e3=Math.min(_2e3,view.getLeft()+view.getWidth());
_2e5=Math.min(_2e5,view.getTop()+view.getHeight());
view.getRectangle().setColor(this.color);
view.getRectangle().setThickness(this.lineWidth);
view.getRectangle().setBounds(_2e2,ztop,_2e3-_2e2,_2e5-ztop);
}
};
IlvDragRectangleInteractor.prototype.startDragging=function(e){
var x=e.mouseX,y=e.mouseY;
this.startx=x;
this.starty=y;
this.whileDragging(e);
this.view.getRectangle().setVisible(true);
return false;
};
IlvDragRectangleInteractor.prototype.getRectangle=function(){
return this.view.getRectangle().getBounds();
};
IlvDragRectangleInteractor.prototype.whileDragging=function(e){
var _2ea=e.mouseX;
var _2eb=e.mouseY;
var _2ec=this.getXYRatio();
if(_2ec!=0){
var dx=_2ea-this.startx;
var dy=_2eb-this.starty;
var sgnX=(dx!=0)?dx/Math.abs(dx):1;
var sgnY=(dy!=0)?dy/Math.abs(dy):1;
dx=Math.abs(dx);
dy=Math.abs(dy);
if(dx<dy*_2ec){
dx=parseInt(dy*_2ec);
}else{
dy=parseInt(dx/_2ec);
}
if(isNaN(dx)){
dx=0;
}
if(isNaN(dy)){
dy=0;
}
dx*=sgnX;
dy*=sgnY;
_2ea=dx+this.startx;
_2eb=dy+this.starty;
}
if(_2ea>this.startx){
this.zleft=this.startx;
this.zright=_2ea;
}else{
this.zleft=_2ea;
this.zright=this.startx;
}
if(_2eb>this.starty){
this.ztop=this.starty;
this.zbottom=_2eb;
}else{
this.ztop=_2eb;
this.zbottom=this.starty;
}
this.adjust();
return false;
};
IlvDragRectangleInteractor.prototype.stopDragging=function(e){
this.dragging=false;
this.view.getRectangle().setVisible(false);
var _2f2=0;
if(this.zleft==this.startx&&this.ztop==this.starty){
_2f2=0;
}else{
if(this.zright==this.startx&&this.ztop==this.starty){
_2f2=3;
}else{
if(this.zright==this.startx&&this.zbottom==this.starty){
_2f2=2;
}else{
if(this.zleft==this.startx&&this.zbottom==this.starty){
_2f2=1;
}
}
}
}
this.dragevent={left:this.zleft,top:this.ztop,width:this.zright-this.zleft,height:this.zbottom-this.ztop,corner:_2f2,mouseEvent:e};
this.listeners.notify(this.dragevent);
return false;
};
IlvDragRectangleInteractor.prototype.onmousedown=function(e){
var x=e.mouseX,y=e.mouseY;
var _2f6=this.view.hitmap;
if(_2f6&&this.view.isMultiInteractor){
this.view.setCursor("crosshair");
}
if(!this.view.isMultiInteractor||!_2f6||_2f6.hittest(x,y)==0){
if(this.view!=null){
if(!this.dragging){
this.dragging=true;
return this.startDragging(e);
}else{
return this.stopDragging(e);
}
}
}
return false;
};
IlvDragRectangleInteractor.prototype.onmousemove=function(e){
var x=e.mouseX,y=e.mouseY;
var _2fa=this.view.hitmap;
if(!this.view.isMultiInteractor||!_2fa||_2fa.hittest(x,y)==0){
if(this.dragging){
return this.whileDragging(e);
}
}
return false;
};
IlvDragRectangleInteractor.prototype.onmouseup=function(e){
var _2fc=this.view.hitmap;
if(this.view.getInteractor()!=this&&_2fc&&this.view.isMultiInteractor){
this.view.setCursor("default");
}
if(this.dragging){
this.stopDragging(e);
return false;
}
return false;
};
IlvZoomInteractor=function(){
this.superConstructor();
var _2fd=this;
this.addRectangleDraggedListener(function(_2fe){
_2fd.onEndDrag(_2fe);
});
this.setMessage(jviews.messages.IlvZoomInteractor.selectAnArea);
};
IlvZoomInteractor.prototype=new IlvDragRectangleInteractor();
IlvZoomInteractor.prototype.setClassName("IlvZoomInteractor");
IlvZoomInteractor.prototype.onEndDrag=function(_2ff){
var x=_2ff.left;
var y=_2ff.top;
var w=_2ff.width;
var h=_2ff.height;
var bbox=this.view.getViewBBox();
var _305=this.view.getWidth();
var _306=this.view.getHeight();
var s1=bbox.width/_305;
var s2=bbox.height/_306;
x=bbox.left+x*s1;
y=bbox.top+y*s2;
if(w>=3&&h>=3){
h=h*s2;
var _309=this.getXYRatio();
if(_309!=0){
w=h*_309;
}else{
w=w*s1;
}
this.view.setViewBBox(x,y,w,h,true);
}
};
IlvZoomInteractor.prototype.getXYRatio=function(){
if(this.view.height!=0){
return this.view.getWidth()/this.view.getHeight();
}else{
return 0;
}
};
IlvZoomInteractor.prototype.mouseWheel=function(e){
if(e.wheelDelta>0){
this.view.zoomIn();
}else{
this.view.zoomOut();
}
return false;
};
IlvPanInteractor=function(){
this.superConstructor();
this.setCursor("move");
this.setMessage(jviews.messages.IlvPanInteractor.clickMapToPanView);
this.duringpan=false;
this.startx=0;
this.starty=0;
this.x=0;
this.y=0;
this.panTimer=null;
this.taskTimer=null;
this.tiledView=false;
var _30b=this;
this.needRefreshLayer=false;
this.beforeImageloadedListener=function(view){
_30b.onBeforeImageLoaded(view);
};
this.imageloadedListener=function(view){
_30b.onImageLoaded(view);
};
};
IlvPanInteractor.prototype=new IlvInteractor();
IlvPanInteractor.prototype.setClassName("IlvPanInteractor");
IlvPanInteractor.instances={};
IlvPanInteractor.prototype.setView=function(view){
if(this.view!=null){
this.view.needHitmap=false;
IlvPanInteractor.instances[this.view]=null;
this.view.removeBeforeImageOnLoadListener(this.beforeImageloadedListener);
this.view.removeImageOnLoadListener(this.imageloadedListener);
}
if(view!=null){
this.tiledView=view.isTiled();
IlvPanInteractor.instances[view]=this;
view.addBeforeImageOnLoadListener(this.beforeImageloadedListener);
view.addImageOnLoadListener(this.imageloadedListener);
}
};
IlvPanInteractor.prototype.onmousedown=function(e){
var x=e.mouseX,y=e.mouseY;
var _312=this.view.hitmap;
if(_312&&this.view.isMultiInteractor){
this.view.setCursor("move");
}
var _313=this.view.getDrawPanel();
_313.clear();
if(!this.view.isMultiInteractor||!_312||_312.hittest(x,y)==0||this.view.forcePan){
if(this.tiledView){
if(!this.duringpan){
this.bx=-this.view.qbboxx;
this.by=-this.view.qbboxy;
this.startx=this.x=(e.mouseX/-this.view.sx+this.bx)-this.view.qbboxx;
this.starty=this.y=(e.mouseY/-this.view.sy+this.by)-this.view.qbboxy;
this.view.getDynamicLayer().setVisible(false);
this.view.getDynamicLayer().setPanning(true);
this.view.getDynamicLayer().cancelUpdateTimer();
if(typeof (IlvSelectionManager)=="function"){
this.view.getSelectionManager().hideAll();
}
this.duringpan=true;
if(this.taskTimer){
clearInterval(this.taskTimer);
}
this.taskTimer=setInterval("IlvPanInteractor.instances[\""+this.view.toString()+"\"].processUpdate(true)",50);
this.pan();
}
}else{
if(this.needRefreshLayer){
return false;
}
if(!this.duringpan){
this.startx=e.mouseX;
this.starty=e.mouseY;
this.duringpan=true;
}else{
this.onmouseup(e);
}
}
}
return false;
};
IlvPanInteractor.prototype.onmousemove=function(e){
var x=e.mouseX,y=e.mouseY;
var _317=this.view.hitmap;
if(!this.view.isMultiInteractor||!_317||_317.hittest(x,y)==0||this.view.forcePan){
if(this.tiledView){
if(!this.duringpan){
return false;
}
this.x=(e.mouseX/-this.view.sx+this.bx);
this.y=(e.mouseY/-this.view.sy+this.by);
}else{
if(!this.duringpan||this.needRefreshLayer){
return false;
}
var view=this.view;
var dx=this.startx-e.mouseX;
var dy=this.starty-e.mouseY;
view.imagePanel.setScrollPosition(dx,dy);
}
}
return false;
};
IlvPanInteractor.prototype.onmouseup=function(e){
var _31c=this.view.hitmap;
if(_31c&&this.view.isMultiInteractor&&this.view.getInteractor()!=this){
this.view.setCursor("default");
}
if(this.tiledView){
if(!this.duringpan){
return false;
}
this.x=(e.mouseX/-this.view.sx+this.bx);
this.y=(e.mouseY/-this.view.sy+this.by);
this.duringpan=false;
if(this.taskTimer){
clearInterval(this.taskTimer);
}
this.cancelPan();
}else{
if(!this.duringpan||this.needRefreshLayer){
return false;
}
var view=this.view;
var x=e.mouseX;
var y=e.mouseY;
var dx=x-this.startx;
var dy=y-this.starty;
this.needRefreshLayer=true;
var bbox=view.getViewBBox();
view.moveTo(bbox.left-dx*bbox.width/view.getWidth(),bbox.top-dy*bbox.height/view.getHeight());
this.duringpan=false;
}
return false;
};
IlvPanInteractor.prototype.onBeforeImageLoaded=function(view){
if(!this.tiledView&&this.needRefreshLayer){
view.imagePanel.setVisible(false);
view.imagePanel.setScrollPosition(0,0);
}
};
IlvPanInteractor.prototype.onImageLoaded=function(view){
if(!this.tiledView&&this.needRefreshLayer){
this.needRefreshLayer=false;
}
};
IlvPanInteractor.prototype.pan=function(){
if(this.panTimer){
clearTimeout(this.panTimer);
}
var dx=this.x-this.startx;
var dy=this.y-this.starty;
if(this.x!=this.startx||this.y!=this.starty){
this.view.moveTo(dx,dy,true);
this.view.getDynamicLayer().setVisible(false);
}
var _327=this;
this.panTimer=setTimeout(function(){
_327.pan();
},50);
};
IlvPanInteractor.prototype.cancelPan=function(){
if(this.panTimer){
clearTimeout(this.panTimer);
}
this.view.getDynamicLayer().setPanning(false);
this.processUpdate(false);
};
IlvPanInteractor.prototype.processUpdate=function(_328){
this.view.update(_328,true);
};
IlvPanInteractor.prototype.mouseWheel=function(e){
if(e.wheelDelta>0){
this.view.zoomIn();
}else{
this.view.zoomOut();
}
};
IlvImageMapInteractor=function(){
this.superConstructor();
};
IlvImageMapInteractor.prototype=new IlvInteractor();
IlvImageMapInteractor.prototype.setClassName("IlvImageMapInteractor");
IlvImageMapInteractor.prototype.setView=function(view){
if(this.view!=null){
this.view.hideImageMap();
}
if(view!=null){
view.showImageMap();
}
};
IlvMapInteractor=function(_32b){
this.superConstructor();
this.setCursor("crosshair");
this.setActionName(_32b);
};
IlvMapInteractor.prototype=new IlvInteractor();
IlvMapInteractor.prototype.setClassName("IlvMapInteractor");
IlvMapInteractor.prototype.getActionName=function(){
return this.action;
};
IlvMapInteractor.prototype.setActionName=function(_32c){
this.action=_32c;
};
IlvMapInteractor.prototype.onmousedown=function(e){
var view=this.getView();
var x=e.mouseX;
var y=e.mouseY;
var bbox=view.getViewBBox();
x=bbox.left+x*(bbox.width/view.getWidth());
y=bbox.top+y*(bbox.height/view.getHeight());
var _332=[x,y];
view.performAction(this.action,_332);
return false;
};
IlvMapRectInteractor=function(_333){
this.superConstructor();
this.setActionName(_333);
var _334=this;
this.addRectangleDraggedListener(function(_335){
_334.onEndDrag(_335);
});
};
IlvMapRectInteractor.prototype=new IlvDragRectangleInteractor();
IlvMapRectInteractor.prototype.setClassName("IlvMapRectInteractor");
IlvMapRectInteractor.prototype.getActionName=function(){
return this.action;
};
IlvMapRectInteractor.prototype.setActionName=function(_336){
this.action=_336;
};
IlvMapRectInteractor.prototype.onEndDrag=function(_337){
if(this.getActionName()){
var view=this.view;
var bbox=view.getViewBBox();
var s1=bbox.width/view.getWidth();
var s2=bbox.height/view.getHeight();
var x=bbox.left+_337.left*s1;
var y=bbox.top+_337.top*s2;
var w=_337.width*s1;
var h=_337.height*s2;
var _340=[x,y,w,h,_337.corner];
view.performAction(this.getActionName(),_340);
}
};
IlvLegend=function(left,top,_343,_344,view){
if(!window.IlvEmptyView){
alert(jviews.messages.IlvLegend.requiresIlvEmptyView);
}
this.superConstructor(left,top,_343,_344);
this.fontSize=1;
this.titleFontSize=1;
this.title="Layers";
this.titleColor="#D4D4D4";
this.titleTextColor="black";
this.textColor="black";
this.background="#FFFFFF";
this.view=view;
this.layer=new IlvHTMLPanel("");
this.layer.setBounds(left,top,_343,_344);
this.layer.setVisible(true);
IlvLegend.instances[this.toString()]=this;
var _346=this;
view.addCapabilitiesOnLoadListener(function(view){
_346.fillLayers();
});
};
IlvLegend.prototype=new IlvEmptyView();
IlvLegend.prototype.setClassName("IlvLegend");
IlvLegend.instances=[];
IlvLegend.prototype.getView=function(){
return this.view;
};
IlvLegend.prototype.setTitle=function(_348){
this.title=_348;
this.fillLayers();
};
IlvLegend.prototype.getTitle=function(){
return this.title;
};
IlvLegend.prototype.setTitleBackgroundColor=function(_349){
this.titleColor=_349;
this.fillLayers();
};
IlvLegend.prototype.getTitleBackgroundColor=function(){
return this.titleColor;
};
IlvLegend.prototype.setTitleForegroundColor=function(_34a){
this.titleTextColor=_34a;
this.fillLayers();
};
IlvLegend.prototype.getTitleForegroundColor=function(){
return this.titleTextColor;
};
IlvLegend.prototype.setTextColor=function(_34b){
this.textColor=_34b;
this.fillLayers();
};
IlvLegend.prototype.getTextColor=function(){
return this.textColor;
};
IlvLegend.prototype.setFontSize=function(size){
this.fontSize=size;
this.fillLayers();
};
IlvLegend.prototype.getFontSize=function(){
return this.fontSize;
};
IlvLegend.prototype.setTitleFontSize=function(size){
this.titleFontSize=size;
this.fillLayers();
};
IlvLegend.prototype.getTitleFontSize=function(){
return this.titleFontSize;
};
IlvLegend.prototype.setBackgroundColor=function(_34e){
this.background=_34e;
this.fillLayers();
};
IlvLegend.prototype.getBackgroundColor=function(){
return this.background;
};
IlvLegend.prototype.setChildrenBounds=function(left,top,_351,_352){
this.superInvoke("setChildrenBounds",left,top,_351,_352);
this.layer.setBounds(left,top,_351,_352);
};
IlvLegend.prototype.fillLayers=function(){
if(!this.view.isCapabilitiesLoaded()){
return;
}
var _353="<div style=\"width: "+this.width+"px; height: "+this.height;
_353+="px; overflow: auto;\">";
_353+="<form><table><tr bgcolor=\""+this.titleColor+"\"><td><p><font size=\""+this.titleFontSize+"\" color=\""+this.titleTextColor+"\">"+this.title+"</font></p></td></tr>";
var view=this.view;
var _355;
var _356;
if(view.isTiled()){
_355=view.getDynamicLayers();
}else{
_355=view.getLayers();
}
for(var i=_355.length-1;i>=0;i--){
_353+="<tr><td>";
_353+="<p><input type=\"checkbox\" name=\""+_355[i]+"\"";
if(view.isLayerVisible(_355[i])){
_353+=" checked=\"checked\" ";
}
_353+="onclick=\"IlvLegend.prototype.toggleLayer('"+this.toString()+"',"+i+")\">";
_353+="<font color=\""+this.textColor+"\" size=\""+this.fontSize+"\">"+_355[i]+"</font></p>";
_353+="</td></tr>";
}
_353+="</table></form></div>";
this.layer.setBackgroundColor(this.getBackgroundColor());
this.layer.setContent(_353);
};
IlvLegend.prototype.toggleLayer=function(_358,_359){
var _35a=IlvLegend.instances[_358];
var view=_35a.view;
var _35c;
if(view.isTiled()){
_35c=view.getDynamicLayers();
}else{
_35c=view.getLayers();
}
var name=_35c[_359];
view.setLayerVisible(name,!view.isLayerVisible(name));
};
IlvLegend.prototype.removeHTML=function(){
this.layer.removeHTML();
};
IlvPanTool=function(left,top,view){
if(!window.IlvButton){
alert(jviews.messages.IlvPanTool.requiresIlvButton);
}
var _361=3*IlvPanTool.buttonSize+6;
var _362=_361;
this.superConstructor(left,top,_361,_362);
this.view=view;
this.infoPanel=null;
this.enabled=true;
IlvPanTool.instances[this.toString()]=this;
this.buttons=[];
var s=IlvPanTool.buttonSize;
this.buttons[0]=this.createButton(left,top,s,s,jviews.messages.IlvPanTool.panNorthWestIcon,jviews.messages.IlvPanTool.panNorthWestRolloverIcon,"panNorthWest",jviews.messages.IlvPanTool.panNorthWest);
this.buttons[1]=this.createButton(left+_361/2-s/2,top,s,s,jviews.messages.IlvPanTool.panNorthIcon,jviews.messages.IlvPanTool.panNorthRolloverIcon,"panNorth",jviews.messages.IlvPanTool.panNorth);
this.buttons[2]=this.createButton(left+_361-s,top,s,s,jviews.messages.IlvPanTool.panNorthEastIcon,jviews.messages.IlvPanTool.panNorthEastRolloverIcon,"panNorthEast",jviews.messages.IlvPanTool.panNorthEast);
this.buttons[3]=this.createButton(left,top+_362/2-s/2,s,s,jviews.messages.IlvPanTool.panWestIcon,jviews.messages.IlvPanTool.panWestRolloverIcon,"panWest",jviews.messages.IlvPanTool.panWest);
this.buttons[4]=this.createButton(left+_361/2-s/2,top+_362/2-s/2,s,s,jviews.messages.IlvPanTool.showAllIcon,jviews.messages.IlvPanTool.showAllRolloverIcon,"showAll",jviews.messages.IlvPanTool.showAll);
this.buttons[5]=this.createButton(left+_361-s,top+_362/2-s/2,s,s,jviews.messages.IlvPanTool.panEastIcon,jviews.messages.IlvPanTool.panEastRolloverIcon,"panEast",jviews.messages.IlvPanTool.panEast);
this.buttons[6]=this.createButton(left,top+_362-s,s,s,jviews.messages.IlvPanTool.panSouthWestIcon,jviews.messages.IlvPanTool.panSouthWestRolloverIcon,"panSouthWest",jviews.messages.IlvPanTool.panSouthWest);
this.buttons[7]=this.createButton(left+_361/2-s/2,top+_362-s,s,s,jviews.messages.IlvPanTool.panSouthIcon,jviews.messages.IlvPanTool.panSouthRolloverIcon,"panSouth",jviews.messages.IlvPanTool.panSouth);
this.buttons[8]=this.createButton(left+_361-s,top+_362-s,s,s,jviews.messages.IlvPanTool.panSouthEastIcon,jviews.messages.IlvPanTool.panSouthEastRolloverIcon,"panSouthEast",jviews.messages.IlvPanTool.panSouthEast);
};
IlvPanTool.prototype=new IlvEmptyView();
IlvPanTool.prototype.setClassName("IlvPanTool");
IlvPanTool.buttonSize=16;
IlvPanTool.instances=[];
IlvPanTool.prototype.dispose=function(){
this.superInvoke("dispose");
this.view=null;
if(this.infoPanel){
this.infoPanel.dispose();
}
for(var i=0;i<9;i++){
this.buttons[i].dispose();
this.buttons[i]=null;
}
IlvPanTool.instances[this.toString()]=null;
};
IlvPanTool.prototype.removeHTML=function(){
for(var i=0;i<9;i++){
this.buttons[i].removeHTML();
}
};
IlvPanTool.prototype.updateVisibility=function(){
for(var i=0;i<9;i++){
this.buttons[i].updateVisibility();
}
};
IlvPanTool.prototype.setViewInternal=function(view){
this.view=view;
};
IlvPanTool.prototype.setChildrenBounds=function(left,top,_36a,_36b){
this.superInvoke("setChildrenBounds",left,top,_36a,_36b);
var s=IlvPanTool.buttonSize;
this.buttons[0].setLocation(left,top);
this.buttons[1].setLocation(left+_36a/2-s/2,top);
this.buttons[2].setLocation(left+_36a-s,top);
this.buttons[3].setLocation(left,top+_36b/2-s/2);
this.buttons[4].setLocation(left+_36a/2-s/2,top+_36b/2-s/2);
this.buttons[5].setLocation(left+_36a-s,top+_36b/2-s/2);
this.buttons[6].setLocation(left,top+_36b-s);
this.buttons[7].setLocation(left+_36a/2-s/2,top+_36b-s);
this.buttons[8].setLocation(left+_36a-s,top+_36b-s);
};
IlvPanTool.prototype.childrenToHTML=function(_36d){
this.superInvoke("childrenToHTML",_36d);
for(var i=0;i<9;i++){
this.buttons[i].toHTML(_36d);
}
};
IlvPanTool.prototype.setMessagePanel=function(_36f){
for(var i=0;i<9;i++){
this.buttons[i].setMessagePanel(_36f);
}
this.infoPanel=_36f;
};
IlvPanTool.prototype.getMessagePanel=function(){
return this.infoPanel;
};
IlvPanTool.prototype.setEnabled=function(_371){
if(_371!=this.enabled){
for(var i=0;i<9;i++){
this.buttons[i].setEnabled(_371);
}
this.enabled=_371;
}
};
IlvPanTool.prototype.isEnabled=function(l){
return this.enabled;
};
IlvPanTool.prototype.createButton=function(left,top,_376,_377,_378,_379,func,_37b){
var b=new IlvButton(left,top,_376,_377,IlvFrameworkConstants.frameworkPath+_378,"IlvPanTool.instances[\""+this.toString()+"\"].view."+func+"()");
b.setRolloverImage(IlvFrameworkConstants.frameworkPath+_379);
b.setMessage(_37b);
b.setToolTipText(_37b);
return b;
};
IlvZoomTool=function(left,top,_37f,_380,_381,view,_383){
if(!window.IlvEmptyView){
alert(jviews.messages.IlvZoomTool.requiresIlvEmptyView);
}
if(!window.IlvButton){
alert(jviews.messages.IlvZoomTool.requiresIlvButton);
}
this.infoPanel=null;
this.superConstructor(left,top,_37f,_380);
this.acc=1;
this.orientation=IlvZoomTool.prototype.Horizontal;
this.nbbuttons=_381;
this.zoomLevels=new Array(this.nbbuttons);
this.buttons=null;
this.plusminus=_383;
this.buttonSize=IlvZoomTool.buttonSize;
IlvZoomTool.instances[this.toString()]=this;
this.setViewInternal(view);
};
IlvZoomTool.prototype=new IlvEmptyView();
IlvZoomTool.prototype.setClassName("IlvZoomTool");
IlvZoomTool.buttonSize=16;
IlvZoomTool.instances=[];
IlvZoomTool.prototype.Vertical="Vertical";
IlvZoomTool.prototype.Horizontal="Horizontal";
IlvZoomTool.prototype.dispose=function(){
this.superInvoke("dispose");
this.view=null;
if(this.infoPanel){
this.infoPanel.dispose();
this.infoPanel=null;
}
for(var i=0;i<this.nbbuttons;i++){
this.buttons[i].dispose();
}
IlvZoomTool.instances[this.toString()]=null;
};
IlvZoomTool.prototype.upImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.upIcon;
IlvZoomTool.prototype.rolloverUpImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.rolloverUpIcon;
IlvZoomTool.prototype.downImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.downIcon;
IlvZoomTool.prototype.rolloverDownImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.rolloverDownIcon;
IlvZoomTool.prototype.rightImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.rightIcon;
IlvZoomTool.prototype.rolloverRightImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.rolloverRightIcon;
IlvZoomTool.prototype.leftImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.leftIcon;
IlvZoomTool.prototype.rolloverLeftImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.rolloverLeftIcon;
IlvZoomTool.prototype.currentImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.currentIcon;
IlvZoomTool.prototype.rolloverCurrentImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.rolloverCurrentIcon;
IlvZoomTool.prototype.plusImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.plusIcon;
IlvZoomTool.prototype.rolloverPlusImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.rolloverPlusIcon;
IlvZoomTool.prototype.minusImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.minusIcon;
IlvZoomTool.prototype.rolloverMinusImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvZoomTool.rolloverMinusIcon;
IlvZoomTool.prototype.setViewInternal=function(view){
if(view){
this.view=view;
var tool=this;
view.addCapabilitiesOnLoadListener(function(view){
tool.resetZoomButton();
});
view.addImageOnLoadListener(function(view){
tool.resetCurrentZoom();
});
}
};
IlvZoomTool.prototype.removeHTML=function(){
if(this.buttons){
for(var i=0;i<this.nbbuttons;i++){
this.buttons[i].removeHTML();
}
}
};
IlvZoomTool.prototype.updateVisibility=function(){
if(this.buttons){
for(var i=0;i<this.nbbuttons;i++){
this.buttons[i].updateVisibility();
}
}
};
IlvZoomTool.prototype.getView=function(){
return this.view;
};
IlvZoomTool.prototype.setOrientation=function(_38b){
this.orientation=_38b;
var _38c=this.getBounds();
this.setBounds(_38c.left,_38c.top,_38c.width,_38c.height);
this.resetCurrentZoom();
};
IlvZoomTool.prototype.getOrientation=function(){
return this.orientation;
};
IlvZoomTool.prototype.setChildrenBounds=function(left,top,_38f,_390){
this.superInvoke("setChildrenBounds",left,top,_38f,_390);
var _391=(this.orientation==this.Horizontal);
var x;
var y;
var tb=this.topButton;
var bb=this.bottomButton;
var size=this.buttonSize;
var nb=this.nbbuttons;
if(tb){
nb=nb+1;
}
if(bb){
nb=nb+1;
}
if(!_391){
x=this.left-size/2;
y=this.top+(this.height/nb)/2-this.buttonSize/2;
}else{
x=this.left+(this.width/nb)/2-this.buttonSize/2;
y=this.top-size/2;
}
var dy=this.height/nb;
var dx=this.width/nb;
if(tb){
tb.setLocation(x-this.buttonSize/2,y);
y+=dy;
}
if(this.buttons!=null){
for(var i=0;i<this.nbbuttons;i++){
this.buttons[i].setLocation(x,y);
if(!_391){
y+=dy;
}else{
x+=dx;
}
}
}
if(bb){
bb.setLocation(x-this.buttonSize/2,y);
}
};
IlvZoomTool.prototype.childrenToHTML=function(_39b){
this.superInvoke("childrenToHTML",_39b);
var _39c=(this.orientation==this.Horizontal);
var x,y;
var _39f,_3a0;
var size=this.buttonSize;
var nb=this.nbbuttons;
if(this.plusminus){
nb=nb+1;
nb=nb+1;
}
if(!_39c){
x=this.left-size/2;
y=this.top+(this.height/nb)/2-size/2;
_39f=this.upImage;
_3a0=this.rolloverUpImage;
}else{
y=this.top-size/2;
x=this.left+(this.width/nb)/2-size/2;
_39f=this.rightImage;
_3a0=this.rolloverRightImage;
}
var _3a3=this;
var dx=this.width/nb;
var dy=this.height/nb;
if(this.plusminus){
var top=new IlvButton(x,y,size,size,this.plusImage,function(){
_3a3.plus();
});
top.setRolloverImage(this.rolloverPlusImage);
top.setMessage(jviews.messages.IlvZoomTool.clickToZoom);
top.setToolTipText(jviews.messages.IlvZoomTool.clickToZoom);
top.toHTML(_39b);
this.topButton=top;
if(!_39c){
y+=dy;
}else{
x+=dx;
}
}
this.buttons=new Array(this.nbbuttons);
var _3a7=function(i){
return function(){
_3a3.buttonClick(i);
};
};
for(var i=0;i<this.nbbuttons;i++){
this.buttons[i]=new IlvButton(x,y,size,size,_39f,_3a7(i));
this.buttons[i].setRolloverImage(_3a0);
this.buttons[i].setMessage(IlvUtil.formatStr(jviews.messages.IlvZoomTool.clickToChangeZoomLevel,i));
this.buttons[i].setToolTipText(IlvUtil.formatStr(jviews.messages.IlvZoomTool.clickToChangeZoomLevel,i));
this.buttons[i].toHTML(_39b);
this.buttons[i].tool=this;
if(!_39c){
y+=dy;
}else{
x+=dx;
}
}
if(this.plusminus){
var bot=new IlvButton(x,y,size,size,this.minusImage,function(){
_3a3.minus();
});
bot.setRolloverImage(this.rolloverMinusImage);
bot.setMessage(jviews.messages.IlvZoomTool.clickToUnzoom);
bot.setToolTipText(jviews.messages.IlvZoomTool.clickToUnzoom);
bot.toHTML(_39b);
this.bottomButton=bot;
}
};
IlvZoomTool.prototype.buttonClick=function(_3ab){
var view=this.view;
if(view.isCapabilitiesLoaded()){
var bbox=view.getViewBBox();
var _3ae=view.getManagerBBox();
var zoom=Math.max(_3ae.width/bbox.width,_3ae.height/bbox.height);
if(this.zoomLevels&&_3ab<this.zoomLevels.length){
view.zoomBy(this.zoomLevels[_3ab]/zoom);
}
}
};
IlvZoomTool.prototype.resetCurrentZoom=function(){
var view=this.view;
if(view==null||!view.isCapabilitiesLoaded()){
return;
}
var bbox=view.getViewBBox();
var _3b2=view.getManagerBBox();
var zoom=Math.max(_3b2.width/bbox.width,_3b2.height/bbox.height);
var best=0;
var diff=0;
for(var i=0;i<this.nbbuttons;i++){
if(i===0||(diff>Math.abs(this.zoomLevels[i]-zoom))){
best=i;
diff=Math.abs(this.zoomLevels[i]-zoom);
}
}
var _3b7,_3b8,_3b9,_3ba;
if(this.orientation==this.Vertical){
_3b7=this.downImage;
_3b9=this.rolloverDownImage;
_3b8=this.upImage;
_3ba=this.rolloverUpImage;
}else{
_3b7=this.rightImage;
_3b9=this.rolloverRightImage;
_3b8=this.leftImage;
_3ba=this.rolloverLeftImage;
}
if(this.buttons!=null){
for(var i=0;i<this.nbbuttons;i++){
if(i<best){
this.buttons[i].setImage(_3b8);
this.buttons[i].setRolloverImage(_3ba);
}else{
if(i>best){
this.buttons[i].setImage(_3b7);
this.buttons[i].setRolloverImage(_3b9);
}else{
this.buttons[i].setImage(this.currentImage);
this.buttons[i].setRolloverImage(this.rolloverCurrentImage);
}
}
}
}
};
IlvZoomTool.prototype.currentIndex=function(){
var view=this.view;
if(view==null||!view.isCapabilitiesLoaded()){
return -1;
}
var bbox=view.getViewBBox();
var _3bd=view.getManagerBBox();
var zoom=Math.max(_3bd.width/bbox.width,_3bd.height/bbox.height);
var best=0;
var diff=0;
for(var i=0;i<this.nbbuttons;i++){
if(i===0||(diff>Math.abs(this.zoomLevels[i]-zoom))){
best=i;
diff=Math.abs(this.zoomLevels[i]-zoom);
}
}
return best;
};
IlvZoomTool.prototype.plus=function(_3c2){
var i=this.currentIndex();
if(i<this.nbbuttons-1){
this.buttonClick(i+1);
}
};
IlvZoomTool.prototype.minus=function(_3c4){
var i=this.currentIndex();
if(i>0){
this.buttonClick(i-1);
}
};
IlvZoomTool.prototype.resetZoomButton=function(){
var view=this.view;
if(view==null||!view.capabilitiesLoaded){
return;
}
var _3c7=view.getMaxZoomLevel();
var _3c8=view.getZoomLevels();
if(_3c8){
this.zoomLevels=_3c8;
}else{
var m=Math.pow(_3c7,1/this.acc);
for(var i=0;i<this.nbbuttons;i++){
this.zoomLevels[i]=Math.pow(1+i*(m-1)/(this.nbbuttons-1),this.acc);
}
}
this.resetCurrentZoom();
};
IlvZoomTool.prototype.setMessagePanel=function(_3cb){
for(var i=0;i<this.nbbuttons;i++){
this.buttons[i].setMessagePanel(_3cb);
}
this.infoPanel=_3cb;
};
IlvZoomTool.prototype.getMessagePanel=function(){
return this.infoPanel;
};
IlvZoomTool.prototype.setNonLinearFactor=function(a){
this.acc=a;
this.resetZoomButton();
};
IlvZoomTool.prototype.getNonLinearFactor=function(){
return this.acc;
};
IlvPopupMenu=function(){
this.superConstructor(true);
};
IlvPopupMenu.prototype=new IlvAbstractPopupMenu();
IlvPopupMenu.prototype.setClassName("IlvPopupMenu");
IlvPopupMenu.prototype.createRequestURL=function(view,_3cf,_3d0){
var x=Math.floor(_3cf.mouseX);
var y=Math.floor(_3cf.mouseY);
var _3d3=view.getBounds();
var _3d4=view.getRequestURL();
_3d4+="?request="+this.factory.getRequestType();
_3d4+="&format=html&point=("+x+","+y+")";
if(_3d0!=null){
_3d4+="&modelId="+_3d0;
}
var bbox=view.getViewBBox();
_3d4+="&bbox="+escape(bbox.left+","+bbox.top+","+bbox.width+","+bbox.height);
_3d4+="&width="+_3d3.width;
_3d4+="&height="+_3d3.height;
var _3d6=view.isTiled()?view.getDynamicVisibleLayers():view.getVisibleLayers();
_3d4+="&layer="+IlvUtil.getEncodedVisibleLayers(view,_3d6);
_3d4+=view.getAdditionalParameters();
return _3d4;
};
IlvPopupMenu.prototype.onModelLoaded=function(){
this.view.resetSessionExpirationTimer();
};
IlvSelectionManager=function(){
if(!window.IlvAbstractSelectionManager){
alert(jviews.messages.IlvSelectionManager.requiresIlvAbstractSelectionManager);
}
this.superConstructor(true);
var mgr=this;
this._sessionListener=function(){
if(mgr.view){
mgr.view.resetSessionExpirationTimer();
}
};
this.addSelectionChangedListener(this._sessionListener);
};
IlvSelectionManager.prototype=new IlvAbstractSelectionManager();
IlvSelectionManager.prototype.setClassName("IlvSelectionManager");
IlvSelectionManager.prototype.setViewInternal=function(view){
if(this.view!=view){
if(this.view){
this.removeSelectionChangedListener(this._sessionListener);
if(this.view.tileSize){
this.view.getDynamicLayer().removeImageLoadListener(this.imageOnLoadListener);
this.view.getDynamicLayer().removeImagePreloadListener(this.imagePreloadListener);
this.removeAdditionalParameter("dynamic");
}else{
this.view.imagePanel.removeScrollListener(this.scrollListener);
this.view.removeImageOnLoadListener(this.imageOnLoadListener);
this.view.removeBeforeImageOnLoadListener(this.beforeImageOnLoadListener);
}
}
this.view=view;
this.imageOnLoadListener=function(view){
if(!mgr.imageMode){
mgr.updateAll();
}else{
if(mgr.imageMode&&!mgr.dragging){
mgr.hideAll();
}
}
};
if(view){
var mgr=this;
if(this.view.isTiled()){
this.setAdditionalParameters("dynamic","true");
view.getDynamicLayer().addImageLoadListener(this.imageOnLoadListener);
this.imagePreloadListener=function(view){
mgr.hideAll();
};
view.getDynamicLayer().addImagePreloadListener(this.imagePreloadListener);
}else{
this.scrollListener=function(_3dc){
var val=_3dc.getScrollPosition();
mgr.onViewScrolled(val.x,val.y);
};
view.imagePanel.addScrollListener(this.scrollListener);
view.addImageOnLoadListener(this.imageOnLoadListener);
this.beforeImageOnLoadListener=function(view){
mgr.hideAll();
};
view.addBeforeImageOnLoadListener(this.beforeImageOnLoadListener);
}
if(!this.imageMode){
this.updateAll();
}
}
}
};
IlvSelectionManager.prototype.setSelectionProperties=function(_3df,_3e0){
if(!_3df){
return;
}
this.superInvoke("setSelectionProperties",_3df,_3e0);
_3df.tag=_3e0[3];
_3df.properties=_3e0.slice(_3e0.length-1);
};
IlvSelectionManager.prototype.createRequestURL=function(){
var v=this.view;
var _3e2=v.isTiled()?v.getDynamicVisibleLayers():v.getVisibleLayers();
var _3e3=[v.getRequestURL(),"?request=lightselect","&bbox="+escape([v.qbboxx,v.qbboxy,v.qbboxw,v.qbboxh].join(",")),"&width=",v.getWidth(),"&height=",v.getHeight(),"&layer=",IlvUtil.getEncodedVisibleLayers(v,_3e2),v.getAdditionalParameters(),this.getAdditionalParameters()];
return _3e3.join("");
};
IlvSelectionManager.prototype.performServerAction=function(_3e4,_3e5,_3e6){
if(this.isForceUpdateProperties()){
if(!this.forceListener){
this.forceListener=function(v){
v.removeImageOnLoadListener(v.getSelectionManager().forceListener);
v.getSelectionManager().updateSelectionProperties();
};
}
this.view.addImageOnLoadListener(this.forceListener);
}
if(_3e6){
var l=function(v){
v.removeImageOnLoadListener(l);
_3e6.call(v.getSelectionManager(),v);
};
this.view.addImageOnLoadListener(l);
}
this.view.performAction(_3e4,_3e5);
};
IlvSelectionManager.prototype.updateCapabilities=function(_3ea,view){
if(_3ea.minx!=undefined&&view){
view.minx=_3ea.minx;
view.miny=_3ea.miny;
view.maxx=_3ea.maxx;
view.maxy=_3ea.maxy;
}
};
IlvSelectionManager.prototype.performUpdateImageMode=function(){
var _3ec=[this.imageMode];
if(this.view.capabilitiesLoaded){
this.view.performAction("imageModeAction",_3ec);
}else{
this.view.setAdditionalParameters("action","imageModeAction("+this.imageMode+")");
this.imageModeListener=function(v){
var _3ee=v.getSelectionManager().imageModeListener;
if(_3ee){
v.removeCapabilitiesOnLoadListener(_3ee);
}
v.removeAdditionalParameter("action");
};
this.view.addCapabilitiesOnLoadListener(this.imageModeListener);
}
};
IlvSelectionManager.prototype.performUpdateImage=function(){
if(this.isForceUpdateProperties()){
if(!this.forceListener){
this.forceListener=function(v){
v.removeImageOnLoadListener(v.getSelectionManager().forceListener);
v.getSelectionManager().updateSelectionProperties();
};
}
this.view.addImageOnLoadListener(this.forceListener);
}
if(this.view.isTiled()){
this.view.updateAll(false,true,true);
}else{
this.view.updateAll();
}
};
IlvSelectionManager.prototype.isHiddenWhenDragging=function(r){
return r.getObjectType()=="link";
};
IlvSelectInteractor=function(){
this.superConstructor();
};
IlvSelectInteractor.prototype=new IlvInteractor();
IlvSelectInteractor.prototype.setClassName("IlvSelectInteractor");
IlvSelectInteractor.prototype.mouseDown=function(e){
if(e.button!=2&&this.view!=null&&!this.view.forcePan){
var mgr=this.view.getSelectionManager();
if(mgr!=null){
var x=e.mouseX,y=e.mouseY;
var _3f5=this.view.hitmap;
if(_3f5){
if(_3f5.hittest(x,y)>0){
return mgr.startDragging(e);
}
}else{
return mgr.startDragging(e);
}
}
}
return false;
};
IlvSelectInteractor.prototype.mouseDrag=function(e){
if(e.button!=2&&this.view!=null){
var mgr=this.view.getSelectionManager();
if(mgr!=null&&mgr.isMoveAllowed()&&mgr.isDragging()){
return mgr.whileDragging(e);
}
}
return false;
};
IlvSelectInteractor.prototype.mouseUp=function(e){
if(e.button!=2&&this.view!=null){
var mgr=this.view.getSelectionManager();
if(mgr!=null&&mgr.isDragging()){
return mgr.stopDragging(e);
}
}
return false;
};
IlvSelectInteractor.prototype.keyDown=function(e){
if((e.keyCode==27)&&(this.view!=null)){
var mgr=this.view.getSelectionManager();
if(mgr!=null&&mgr.isDragging()){
return mgr.abortDragging(e);
}
}
return false;
};
IlvMakeObjectInteractor=function(_3fc,_3fd){
this.superConstructor();
this.setCursor("crosshair");
this.oncompleted=_3fc;
this.from=0;
this.to=0;
if(_3fd){
this.action=_3fd;
}else{
this.action="createObject";
}
};
IlvMakeObjectInteractor.prototype=new IlvInteractor();
IlvMakeObjectInteractor.prototype.setClassName("IlvMakeObjectInteractor");
IlvMakeObjectInteractor.prototype.mouseDown=function(e){
if(!this.linkMode){
if(e.button!=2&&this.view!=null){
var _3ff=[e.mouseX,e.mouseY,"true"];
if(this.additionalParams){
_3ff=_3ff.concat(this.additionalParams);
}
this.performAction(_3ff);
if(this.oncompleted){
this.oncompleted.call(this,"node");
}
return true;
}
}else{
if(!this.isDragging&&e.button!=2&&this.view!=null){
this.setCursor(null);
this.sourceX=e.mouseX;
this.clientX=e.clientX;
this.sourceY=e.mouseY;
this.clientY=e.clientY;
if(this.view.getSelectionManager().isImageMode()){
this.oldImageMode=true;
this.view.getSelectionManager().setImageMode(false);
}
this.selectObject(this.sourceX,this.sourceY);
this.lastClientX=e.clientX;
this.lastClientY=e.clientY;
this.isDragging=true;
return true;
}
}
return false;
};
IlvMakeObjectInteractor.prototype.isCandidate=function(e){
if(!this.linkMode||!this.checker){
return 0;
}
if(!this.view||!this.view.hitmap||!this.view.hitmap.hitdata){
return 0;
}
var _401=this.checker.call(this,e);
if(_401<0){
this.setCursor("not-allowed");
}else{
if(_401>0){
this.setCursor("crosshair");
}else{
this.setCursor("default");
}
}
return _401;
};
IlvMakeObjectInteractor.prototype.onmousemove=function(e){
this.isCandidate(e);
};
IlvMakeObjectInteractor.prototype.mouseDrag=function(e){
if(this.isDragging){
if(this.lastClientX==e.clientX&&this.lastClientY==e.clientY){
return;
}
this.lastClientX=e.clientX;
this.lastClientY=e.clientY;
this.clearTimer();
var _404=this.view.getSelectionManager();
var _405=this.view.left;
var _406=this.view.top;
this.line=IlvDrawUtil.drawLine(this.sourceX+_405,this.sourceY+_406,e.mouseX+_405,e.mouseY+_406,_404.getLineWidth(),_404.getLineColor(),this.line,this.view.parentNode);
var _407=this.isCandidate(e);
var _408=this;
if(_407>0||!this.checker){
this.timer=setTimeout(function(){
_408.selectObject(e.mouseX,e.mouseY);
_408.timer=null;
},250);
}
return true;
}
return false;
};
IlvMakeObjectInteractor.prototype.mouseUp=function(e){
if(this.isDragging){
this.reset();
var _40a=[this.sourceX,this.sourceY,"false"];
if(this.additionalParams){
_40a=_40a.concat(this.additionalParams);
}
_40a.push(e.mouseX);
_40a.push(e.mouseY);
this.performAction(_40a);
if(this.oldImageMode){
this.view.getSelectionManager().setImageMode(true);
this.oldImageMode=null;
}
if(this.oncompleted){
this.oncompleted.call(this,"link");
}
return true;
}
return false;
};
IlvMakeObjectInteractor.prototype.keyPress=function(_40b){
if(_40b.keyCode==27){
this.abort();
return true;
}
return false;
};
IlvMakeObjectInteractor.prototype.performAction=function(_40c){
if(this.properties){
var buf=[];
for(var _40e in this.properties){
buf.push(_40e);
var _40f=this.properties[_40e];
_40f=IlvUtil.encodeStringAttribute(_40f);
buf.push("\""+_40f+"\"");
}
this.view.setAdditionalParameters("properties",buf.join(","));
}
var _410=this.view.getSelectionManager().additionalParams;
var _411=0;
var _412=-1;
if(_410&&_410.indexOf){
_412=_410.indexOf(IlvPageId.pageIdKey);
_411=_410.length;
}
for(var i=0;i<_411;i+=2){
this.view.setAdditionalParameters(_410[i],_410[i+1]);
}
this.view.performAction(this.action,_40c,"capabilities");
if(this.properties){
this.view.removeAdditionalParameter("properties");
}
for(i=0;i<_411;i+=2){
if(i!=_412){
this.view.removeAdditionalParameter(_410[i]);
}
}
};
IlvMakeObjectInteractor.prototype.reset=function(){
this.clearTimer();
IlvDrawUtil.releaseLine(this.line);
if(IlvBrowserInfo.instance.ie6up){
this.line=null;
}
this.isDragging=false;
this.setCursor("crosshair");
};
IlvMakeObjectInteractor.prototype.abort=function(){
this.reset();
if(this.oncompleted){
this.oncompleted.call(this,"abort");
}
};
IlvMakeObjectInteractor.prototype.selectObject=function(x,y){
this.view.getSelectionManager().selectOne(x,y,false);
};
IlvMakeObjectInteractor.prototype.clearTimer=function(){
if(this.timer){
clearTimeout(this.timer);
this.timer=null;
}
};
IlvMakeObjectInteractor.prototype.setLinkMode=function(_416){
this.linkMode=_416;
};
IlvMakeObjectInteractor.prototype.getLinkMode=function(){
return this.linkMode;
};
IlvMakeObjectInteractor.prototype.setView=function(view){
if(view!=null){
if(!view.hitmap&&this.linkMode&&this.checker){
view.hitmap=new IlvHitmap();
if(view.capabilitiesLoaded){
view.updateHitmap();
}
}
}
};
IlvMakeObjectInteractor.prototype.setAdditionalParameters=function(args){
this.additionalParams=new Array(arguments.length);
for(var i=0;i<arguments.length;i++){
this.additionalParams[i]=arguments[i];
}
};
IlvMakeObjectInteractor.prototype.setProperties=function(_41a){
this.properties=_41a;
};
IlvMakeObjectInteractor.prototype.setOnCompleted=function(_41b){
this.oncompleted=_41b;
};
IlvMakeObjectInteractor.prototype.setCandidateChecker=function(_41c){
this.checker=_41c;
};
IlvTooltipInteractor=function(_41d){
this.superConstructor();
this.index=0;
this.tooltip=null;
if(_41d){
this.tolerance=_41d;
}
this.template=null;
this.baseTextDirection="";
};
IlvTooltipInteractor.prototype=new IlvInteractor();
IlvTooltipInteractor.prototype.setClassName("IlvTooltipInteractor");
IlvTooltipInteractor.instances={};
IlvTooltipInteractor.prototype.addHitInfotype=function(view){
view&&view.putHitInfoType("tooltip");
};
IlvTooltipInteractor.prototype.setView=function(view){
if(this.view!=null){
IlvTooltipInteractor.instances[this.view]=null;
}
if(view!=null){
this.addHitInfotype(view);
IlvTooltipInteractor.instances[view]=this;
if(!view.hitmap){
view.hitmap=new IlvHitmap();
if(view.capabilitiesLoaded){
view.updateHitmap();
}
}
}
};
IlvTooltipInteractor.prototype.setTemplate=function(_420){
this.template=_420;
if(typeof (_420)=="string"){
try{
_420=eval("("+_420+")");
if(IlvUtil.isFunction(_420)){
this.template=_420;
}
}
catch(err){
}
}
};
IlvTooltipInteractor.prototype.setBaseTextDirection=function(_421){
this.baseTextDirection=_421;
};
IlvTooltipInteractor.prototype.getBaseTextDirection=function(){
return this.baseTextDirection;
};
IlvTooltipInteractor.prototype.onmousedown=function(e){
if(this.view.forceSelect){
return;
}
this.isMousedown=true;
if(this.tooltip){
this.tooltip.setVisible(false);
}
if(!this.view||!this.view.hitmap||!this.view.hitmap.hitdata||!this.view.hitmap.extensions){
return;
}
var func=this.view.hitmap.extensions[this.index];
if(IlvUtil.isFunction(func)){
func();
}
};
IlvTooltipInteractor.prototype.onmouseup=function(e){
if(this.view.forceSelect){
return;
}
this.isMousedown=false;
if(this.tooltip){
var x=e.mouseX,y=e.mouseY;
var _427=this.view.hitmap;
if(!_427){
return false;
}
this.index=this.tolerance?_427.hittest(x,y,this.tolerance):_427.hittest(x,y);
this.tooltip.move(e.clientX,e.clientY);
this.tooltip.setVisible(this.index>0);
}
return false;
};
IlvTooltipInteractor.prototype.mouseWheel=function(e){
};
IlvTooltipInteractor.prototype.onmousemove=function(e){
if(IlvAbstractPopupMenu._openMenu){
return;
}
if(this.isMousedown){
return;
}
if(!this.view||!this.view.hitmap||!this.view.hitmap.hitdata||!this.view.hitmap.tooltips||this.view.forcePan){
return;
}
var x=e.mouseX,y=e.mouseY;
var _42c=this.view.hitmap;
if(!_42c){
return false;
}
this.index=this.tolerance?_42c.hittest(x,y,this.tolerance):_42c.hittest(x,y);
var _42d=_42c.tooltips[this.index]||"";
var _42e=_42c.getGroupIndexes(this.index);
for(var i=0;i<_42e.length;i++){
if(_42e[i]!=this.index&&!this.template){
_42d+="\n";
_42d+=_42c.tooltips[_42e[i]]||"";
}
}
if(!this.tooltip){
this.tooltip=new IlvTooltip(0,0,"",this.template);
}
this.tooltip.setBaseTextDirection(this.baseTextDirection);
if(this.index!=0){
this.tooltip.move(e.clientX,e.clientY);
this.tooltip.setMessage(_42d,this.view,this.index);
this.tooltip.setVisible(true);
}else{
this.tooltip.setVisible(false);
}
};
IlvTooltipInteractor.prototype.onmouseout=function(e){
if(this.tooltip){
this.tooltip.setVisible(false);
}
};
IlvTooltip=function(x,y,_433,_434){
if(document.createElement&&document.body&&typeof document.body.appendChild!="undefined"){
var el=document.createElement("div");
el.id="jviews_tooltip";
el.style.position="absolute";
el.style.visibility="hidden";
el.style.zIndex=999;
el.style.left=x+"px";
el.style.top=y+"px";
if(_433){
el.innerHTML=_433;
}
document.body.appendChild(el);
this.element=document.getElementById(el.id);
this.template=_434;
this.baseTextDirection="";
}
};
IlvTooltip.prototype=new Object();
IlvTooltip.prototype.setBaseTextDirection=function(_436){
this.baseTextDirection=_436;
};
IlvTooltip.prototype.getBaseTextDirection=function(){
return this.baseTextDirection;
};
IlvTooltip.prototype.move=function(x,y){
var _439=x;
var _43a=y;
if(IlvBrowserInfo.instance.isIE){
_439+=document.body.scrollLeft;
_43a+=document.body.scrollTop;
}else{
_439+=window.pageXOffset;
_43a+=window.pageYOffset;
}
this.element.style.left=(_439+12)+"px";
this.element.style.top=(_43a+20)+"px";
};
IlvTooltip.prototype.setVisible=function(_43b){
if(_43b&&this.element.innerHTML){
this.element.style.visibility="visible";
}else{
this.element.style.visibility="hidden";
}
};
IlvTooltip.prototype.setMessage=function(_43c,view,_43e){
if(!_43c){
this.element.innerHTML="";
return;
}
var _43f=this.template;
if(_43f){
if(typeof (_43c)=="string"&&_43c!=""){
_43c="Error: you are using tooltip template, however your tooltip data is not a valid JSON object!";
this.element.innerHTML=_43c;
return;
}
if(IlvUtil.isFunction(_43f)){
_43c=_43f.call(this,view,_43e);
}else{
for(key in _43c){
_43f=_43f.replace("<%"+key+"%>",_43c[key]);
_43f=_43f.replace("%"+key+"%",_43c[key]);
}
_43c=_43f;
}
}
this.element.innerHTML=IlvUtil.setMessageDirection(_43c,this.baseTextDirection)||"";
};
IlvHighlightInteractor=function(_440,_441,_442){
this.superConstructor();
if(_440){
this.tolerance=_440;
}
this.color=_441?_441:"#FF7F50";
this.opacity=_442?_442:0.5;
this.groupable=false;
};
IlvHighlightInteractor.prototype=new IlvInteractor();
IlvHighlightInteractor.prototype.setClassName("IlvHighlightInteractor");
IlvHighlightInteractor.instances={};
IlvHighlightInteractor.prototype.addHitInfotype=function(view){
if(view&&this.groupable){
view.putHitInfoType("group");
}
};
IlvHighlightInteractor.prototype.setView=function(view){
if(this.view!=null){
IlvHighlightInteractor.instances[this.view]=null;
}
if(view!=null){
this.addHitInfotype(view);
IlvHighlightInteractor.instances[view]=this;
if(!view.hitmap){
view.hitmap=new IlvHitmap();
if(view.capabilitiesLoaded){
view.updateHitmap();
}
}
}
};
IlvHighlightInteractor.prototype.setGroupable=function(_445){
this.groupable=_445;
};
IlvHighlightInteractor.prototype.onmousedown=function(e){
this.isMouseDown=true;
return false;
};
IlvHighlightInteractor.prototype.onmouseup=function(e){
this.isMouseDown=false;
return false;
};
IlvHighlightInteractor.prototype.mouseWheel=function(e){
};
IlvHighlightInteractor.prototype.onmousemove=function(e){
if(this.isMouseDown||!this.view||!this.view.hitmap||!this.view.hitmap.hitdata){
return;
}
var x=e.mouseX,y=e.mouseY;
var _44c=this.view.hitmap;
var _44d=this.tolerance?_44c.hittest(x,y,this.tolerance):_44c.hittest(x,y);
if(this.groupable){
var _44e=_44c.getGroupIndexes(_44d);
if(IlvUtil.isArray(_44e)){
_44e.push(_44d);
}
_44d=_44e;
}
this.highlight(_44d);
};
IlvHighlightInteractor.prototype.onmouseout=function(e){
this.highlight(0);
};
IlvHighlightInteractor.prototype.highlight=function(_450){
if(!this.view||!this.view.hitmap||!this.view.hitmap.hitdata){
return;
}
if(this.view.hitmap.highlighted+""==_450+""){
return;
}
var _451=this.view.getDrawPanel();
_451.clear();
this.view.hitmap.highlighted=_450;
if(this.view.hitmap.highlighted==0){
return;
}
if(IlvUtil.isArray(_450)){
for(var i=0;i<_450.length;i++){
this.performHighlight(_450[i]);
}
}else{
this.performHighlight(_450);
}
};
IlvHighlightInteractor.prototype.performHighlight=function(_453){
var _454=this.view.hitmap.getShape(_453);
this.view.drawPanel.addShape(_454,this.color,this.opacity);
};
IlvFacesViewProxy=function(_455,_456,_457,_458,_459){
this.superConstructor(_455);
if(_455){
var size=this.getCreationSize(_456,_457,_458);
var view=this.createInstance([size.width,size.height,_459]);
this.setObject(view);
this.setServletClass("ilog.views.faces.dhtml.servlet.IlvFacesManagerServlet");
this.registerResizeListener(view);
view.setStateInCookie(false);
view.saveState=IlvFacesViewProxy.saveState;
view.restoreState=IlvFacesViewProxy.restoreState;
this.addRequestParameters();
}
for(var i in IlvObject.disposeProxyInstances){
var _45d=IlvObject.disposeProxyInstances[i];
var _45e=IlvObject.disposeProxyInstances[i].getClassName();
if(_45e=="IlvFacesOverviewProxy"||_45e=="IlvFacesPanToolProxy"||_45e=="IlvFacesZoomToolProxy"){
if(_45d.view&&(_45d.view.clientId==_455)){
_45d.setViewInternal(this);
}
}
}
};
IlvFacesViewProxy.prototype=new IlvBasicViewProxy();
IlvFacesViewProxy.prototype.setClassName("IlvFacesViewProxy");
IlvFacesViewProxy.prototype.createInstance=function(_45f){
return new IlvFacesView(0,0,_45f[0],_45f[1]);
};
IlvFacesViewProxy.prototype.setStateURL=function(_460){
this.stateURL=_460;
this.notify("StateURL");
};
IlvFacesViewProxy.prototype.getStateURL=function(){
return this.stateURL;
};
IlvFacesViewProxy.prototype.setResizable=function(_461){
this.getObject().setResizable(_461);
this.notify("Resizable");
};
IlvFacesViewProxy.prototype.isResizable=function(_462){
return this.getObject().isResizable();
};
IlvFacesViewProxy.prototype.setAccessible=function(_463){
this.getObject().setAccessible(_463);
this.notify("Accessible");
};
IlvFacesViewProxy.prototype.setHotkeys=function(_464){
this.getObject().setHotkeys(_464);
this.notify("Hotkeys");
};
IlvFacesViewProxy.prototype.isAccessible=function(_465){
return this.getObject().isAccessible();
};
IlvFacesViewProxy.saveState=function(view){
var _467=view.JSFRef;
var _468=unescape(IlvUtil.decodeStringAttribute(view.getRequest()));
if(_468){
_468=escape(IlvUtil.encodeStringAttribute(_468));
_467.setStateURL(_468);
}
};
IlvFacesViewProxy.restoreState=function(view){
var _46a=view.JSFRef;
var _46b=_46a.getStateURL();
if(_46b){
_46b=unescape(IlvUtil.decodeStringAttribute(_46b));
view.initFromUrl(_46b);
view.capabilitiesListeners.notify(view);
var _46c=view.parseValue(_46b,"layer");
if(_46c=="init"){
for(var i=0;i<view.allLayers.length;i++){
view.visibleLayers[i]=true;
}
}
var bbox=view.parseValue(_46b,"bbox");
if(bbox=="init"){
view.showAll();
}else{
view.recenter(view.constrainedOnContents);
view.updateImage();
}
}else{
view.capabilitiesListeners.notify(view);
view.showAll();
}
};
IlvFacesViewProxy.prototype.setInteractor=function(_46f){
this.interactor=_46f;
this.getObject().setInteractor(_46f?_46f.getObject():null);
this.notify("InteractorId");
};
IlvFacesViewProxy.prototype.getInteractor=function(){
return this.interactor;
};
IlvFacesViewProxy.prototype.getInteractorId=function(){
return this.interactor?this.interactor.getAbsoluteId():null;
};
IlvFacesViewProxy.prototype.getZoomFactor=function(){
return this.getObject().getZoomFactor();
};
IlvFacesViewProxy.prototype.setZoomFactor=function(_470){
this.getObject().setZoomFactor(_470);
this.notify("ZoomFactor");
};
IlvFacesViewProxy.prototype.zoomIn=function(){
this.getObject().zoomIn();
};
IlvFacesViewProxy.prototype.zoomOut=function(){
this.getObject().zoomOut();
};
IlvFacesViewProxy.prototype.zoomBy=function(_471){
this.getObject().zoomBy(_471);
};
IlvFacesViewProxy.prototype.zoomToIdentity=function(_472){
return this.getObject().zoomToIdentity(_472);
};
IlvFacesViewProxy.prototype.showAll=function(){
var view=this.getObject();
view.showAll();
};
IlvFacesViewProxy.prototype.getPanFactor=function(){
return this.getObject().getPanFactor();
};
IlvFacesViewProxy.prototype.setPanFactor=function(_474){
this.getObject().setPanFactor(_474);
this.notify("PanFactor");
};
IlvFacesViewProxy.prototype.getUpdateInterval=function(){
return this.getObject().getUpdateInterval();
};
IlvFacesViewProxy.prototype.setUpdateInterval=function(_475){
this.getObject().setUpdateInterval(_475);
this.notify("UpdateInterval");
};
IlvFacesViewProxy.prototype.getImageFormat=function(){
return this.getObject().getImageFormat();
};
IlvFacesViewProxy.prototype.setImageFormat=function(_476){
this.getObject().setImageFormat(_476);
this.notify("ImageFormat");
};
IlvFacesViewProxy.prototype.getWaitingImage=function(){
return this.getObject().getWaitingImage();
};
IlvFacesViewProxy.prototype.setWaitingImage=function(_477){
this.getObject().setWaitingImage(_477);
this.notify("WaitingImage");
};
IlvFacesViewProxy.prototype.getGenerateImageMap=function(){
return this.getObject().getGenerateImageMap();
};
IlvFacesViewProxy.prototype.setGenerateImageMap=function(_478){
this.getObject().setGenerateImageMap(_478);
this.notify("GenerateImageMap");
};
IlvFacesViewProxy.prototype.getImageMapVisible=function(){
return this.getObject().imageMapVisible;
};
IlvFacesViewProxy.prototype.setImageMapVisible=function(_479){
if(_479){
this.getObject().showImageMap();
}else{
this.getObject().hideImageMap();
}
this.notify("ImageMapVisible");
};
IlvFacesViewProxy.prototype.getImageMapGenerator=function(){
return this.imageMapGenerator;
};
IlvFacesViewProxy.prototype.setImageMapGenerator=function(_47a){
this.imageMapGenerator=_47a;
this.notify("ImageMapGenerator");
var view=this.getObject();
view.setAdditionalParameters("imapGenerator",_47a);
};
IlvFacesViewProxy.prototype.getBackgroundColor=function(){
var _47c=this.getObject().getImageBackgroundColor();
if(_47c&&_47c.indexOf("#")==-1){
_47c="#"+_47c;
}
return _47c;
};
IlvFacesViewProxy.prototype.setBackgroundColor=function(_47d){
this.getObject().setImageBackgroundColor(_47d);
this.notify("BackgroundColor");
};
IlvFacesViewProxy.prototype.getOnImageLoaded=function(){
return this.onImageLoaded;
};
IlvFacesViewProxy.prototype.setOnImageLoaded=function(_47e){
this.onImageLoaded=_47e;
this.getObject().addImageOnLoadListener(_47e);
this.notify("OnImageLoaded");
};
IlvFacesViewProxy.prototype.getOnCapabilitiesLoaded=function(){
return this.capabilitiesLoaded;
};
IlvFacesViewProxy.prototype.setOnCapabilitiesLoaded=function(_47f){
this.capabilitiesLoaded=_47f;
this.getObject().addCapabilitiesOnLoadListener(_47f);
this.notify("OnCapabilitiesLoaded");
};
IlvFacesViewProxy.prototype.getErrorMessage=function(){
return this.getObject().getErrorMessage();
};
IlvFacesViewProxy.prototype.setErrorMessage=function(_480){
this.getObject().setErrorMessage(_480);
this.notify("ErrorMessage");
};
IlvFacesViewProxy.prototype.getServlet=function(){
return this.getServletClass();
};
IlvFacesViewProxy.prototype.setServlet=function(_481){
this.setServletClass(_481);
this.notify("Servlet");
};
IlvFacesViewProxy.prototype.setServletURL=function(_482){
this.getObject().setRequestURL(_482);
this.notify("ServletURL");
};
IlvFacesViewProxy.prototype.getServletURL=function(){
return this.getObject().getRequestURL();
};
IlvFacesViewProxy.prototype.performAction=function(_483,_484,_485,_486){
this.getObject().performAction(_483,_484,_485,_486);
};
IlvFacesViewProxy.prototype.updateImage=function(){
this.getObject().updateImage();
};
IlvFacesViewProxy.prototype.setAutoUpdateCapabilities=function(_487){
this.getObject().setAutoUpdateCapabilities(_487);
this.notify("AutoUpdateCapabilities");
};
IlvFacesViewProxy.prototype.isAutoUpdateCapabilities=function(){
return this.getObject().isAutoUpdateCapabilities();
};
IlvFacesViewProxy.prototype.setStaticLayersCount=function(slc){
this.staticLayersCount=slc;
var view=this.getObject();
view.setAdditionalParameters("slc",slc);
};
IlvFacesViewProxy.prototype.updateAll=function(_48a,_48b){
var view=this.getObject();
view.updateAll(_48a,_48b);
};
IlvFacesViewProxy.prototype.moveTo=function(x,y){
this.getObject().moveTo(x,y);
};
IlvFacesViewProxy.prototype.panEast=function(){
this.getObject().panEast();
};
IlvFacesViewProxy.prototype.panWest=function(){
this.getObject().panWest();
};
IlvFacesViewProxy.prototype.panSouth=function(){
this.getObject().panSouth();
};
IlvFacesViewProxy.prototype.panNorth=function(){
this.getObject().panNorth();
};
IlvFacesViewProxy.prototype.panSouthEast=function(){
this.getObject().panSouthEast();
};
IlvFacesViewProxy.prototype.panNorthEast=function(){
this.getObject().panNorthEast();
};
IlvFacesViewProxy.prototype.panSouthWest=function(){
this.getObject().panSouthWest();
};
IlvFacesViewProxy.prototype.panNorthWest=function(){
this.getObject().panNorthWest();
};
IlvFacesViewProxy.prototype.setPopupMenu=function(_48f){
this.getObject().setPopupMenu(_48f.getObject());
};
IlvFacesViewProxy.prototype.setScrollBar=function(_490){
this.getObject().setScrollBarState(_490);
};
IlvFacesViewProxy.prototype.setScrollBarSize=function(size){
this.getObject().setScrollBarSize(size);
};
IlvFacesViewProxy.prototype.getPopupMenu=function(_492){
return this.getObject().getPopupMenu();
};
IlvFacesViewProxy.prototype.addRequestParameters=function(){
this.superInvoke("addRequestParameters");
var view=this.getObject();
view.setAdditionalParameters("facesComponentId",this.clientId);
};
IlvFacesViewProxy.prototype.setMaxZoomLevel=function(_494){
this.maxZoomLevel=_494;
if(_494){
this.notify("MaxZoomLevel");
}
};
IlvFacesViewProxy.prototype.getMaxZoomLevel=function(){
return this.maxZoomLevel;
};
IlvFacesViewProxy.prototype.setMinZoomLevel=function(_495){
this.minZoomLevel=_495;
if(_495){
this.notify("MinZoomLevel");
}
};
IlvFacesViewProxy.prototype.getMinZoomLevel=function(){
return this.minZoomLevel;
};
IlvFacesViewProxy.prototype.setZoomLevels=function(_496){
this.zoomLevels=_496;
if(_496){
this.notify("ZoomLevels");
}
};
IlvFacesViewProxy.prototype.getZoomLevels=function(){
return this.zoomLevels;
};
IlvFacesViewProxy.prototype.setConstrainedOnContents=function(_497){
this.getObject().setConstrainedOnContents(_497);
this.notify("ConstrainedOnContents");
};
IlvFacesViewProxy.prototype.isConstrainedOnContents=function(){
return this.getObject().isConstrainedOnContents();
};
IlvFacesViewProxy.prototype.performJSFAction=function(mb,_499,_49a,_49b){
var p=_499?[mb].concat(_499):[mb];
this.performAction("jsfAction",p,_49a,_49b);
};
IlvFacesViewProxy.prototype.setBeforeSessionExpirationHandler=function(_49d){
var h=function(v){
_49d(v.JSFRef);
};
this.getObject().setSessionExpirationHandler(h);
};
IlvFacesViewProxy.prototype.setNamespace=function(_4a0){
var view=this.getObject();
view.setAdditionalParameters("namespace",_4a0);
};
IlvFacesViewProxy.prototype.setHitmapLayers=function(_4a2){
this.getObject().setHitmapLayers(_4a2);
};
IlvFacesSelectionManager=function(){
this.superConstructor(true);
};
IlvFacesSelectionManager.prototype=new IlvSelectionManager();
IlvFacesSelectionManager.prototype.setClassName("IlvFacesSelectionManager");
IlvFacesSelectionManager.prototype.setViewInternal=function(view){
this.superInvoke("setViewInternal",view);
this.parentNode=view.JSFRef.refNode;
};
IlvFacesSelectionManager.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.parentNode){
this.parentNode=null;
}
};
IlvFacesTiledView=function(left,top,_4a6,_4a7,_4a8,_4a9){
this.superConstructor(left,top,_4a6,_4a7,_4a8,_4a9);
};
IlvFacesTiledView.prototype=new IlvTiledView();
IlvFacesTiledView.prototype.setClassName("IlvFacesTiledView");
IlvFacesTiledView.prototype.getWaitPanelHTML=function(){
return "<table width=\""+this.getWidth()+"\" height=\""+this.getHeight()+"\"><tr><td align=\"center\" valign=\"middle\">"+"<img style=\"-webkit-user-drag:none\" src=\""+this.waitingImage+"\"/></td></tr></table>";
};
IlvFacesTiledView.prototype.readAdditionalCapabilities=function(_4aa){
if(_4aa.expired){
this.setAdditionalParameters("expired","true");
}
};
IlvFacesTiledView.prototype.setChildrenBounds=function(left,top,_4ad,_4ae){
this.superInvoke("setChildrenBounds",left,top,_4ad,_4ae);
this.setAdditionalParameters("componentWidth",_4ad);
this.setAdditionalParameters("componentHeight",_4ae);
};
IlvFacesTiledView.prototype.readMaxZoomLevel=function(_4af){
this.maxZoom=this.JSFRef.maxZoomLevel;
if(!this.maxZoom){
this.maxZoom=_4af.maxZoom;
this.JSFRef.setMaxZoomLevel(this.maxZoom);
}
};
IlvFacesTiledView.prototype.readMinZoomLevel=function(_4b0){
this.minZoom=this.JSFRef.minZoomLevel;
if(!this.minZoom){
this.minZoom=_4b0.minZoom;
this.JSFRef.setMinZoomLevel(this.minZoom);
}
};
IlvFacesTiledView.prototype.readZoomLevels=function(_4b1){
this.zoomLevels=this.JSFRef.zoomLevels;
if(this.zoomLevels){
this.maxZoom=this.zoomLevels[this.zoomLevels.length-1];
this.minZoom=this.zoomLevels[0];
}else{
this.zoomLevels=_4b1.zoomLevels;
if(this.zoomLevels&&this.zoomLevels.length>0){
this.maxZoom=this.zoomLevels[this.zoomLevels.length-1];
this.minZoom=this.zoomLevels[0];
this.JSFRef.setMaxZoomLevel(this.maxZoom);
this.JSFRef.setMinZoomLevel(this.minZoom);
}
this.JSFRef.setZoomLevels(this.zoomLevels);
}
};
IlvFacesTiledView.prototype.getSelectionManager=function(){
if(!this.selectManager){
this.selectManager=new IlvFacesSelectionManager();
this.selectManager.setViewInternal(this);
}
return this.selectManager;
};
IlvFacesTiledViewProxy=function(_4b2,_4b3,_4b4,_4b5,_4b6){
this.superConstructor(_4b2,_4b3,_4b4,_4b5,_4b6);
if(_4b2){
var view=this.getObject();
view.saveState=IlvFacesTiledViewProxy.saveState;
view.restoreState=IlvFacesTiledViewProxy.restoreState;
}
};
IlvFacesTiledViewProxy.prototype=new IlvFacesViewProxy();
IlvFacesTiledViewProxy.prototype.setClassName("IlvFacesTiledViewProxy");
IlvFacesTiledViewProxy.prototype.createInstance=function(_4b8){
return new IlvFacesTiledView(0,0,_4b8[0],_4b8[1],_4b8[2]);
};
IlvFacesTiledViewProxy.prototype.setTileManager=function(_4b9){
this.tileManager=_4b9;
var view=this.getObject();
view.setAdditionalParameters("tileMgr",_4b9);
};
IlvFacesTiledViewProxy.prototype.getTileManager=function(){
return this.tileManager;
};
IlvFacesTiledViewProxy.saveState=function(view){
var _4bc=view.JSFRef;
var _4bd=unescape(IlvUtil.decodeStringAttribute(view.getRequest()));
if(_4bd){
_4bd=escape(IlvUtil.encodeStringAttribute(_4bd));
_4bc.setStateURL(_4bd);
}
};
IlvFacesTiledViewProxy.restoreState=function(view){
var _4bf=view.JSFRef;
var _4c0=_4bf.getStateURL();
if(_4c0){
_4c0=unescape(IlvUtil.decodeStringAttribute(_4c0));
view.initFromUrl(_4c0);
var _4c1=view.parseValue(_4c0,"layer");
if(_4c1=="init"){
for(var i=0;i<view.allLayers.length;i++){
view.visibleLayers[i]=true;
}
}
var bbox=view.parseValue(_4c0,"bbox");
if(bbox=="init"){
view.showAll();
}else{
view.recenter(view.constrainedOnContents);
view.updateImage();
}
}else{
view.showAll();
}
};
IlvFacesSelectionManager=function(){
this.superConstructor(true);
};
IlvFacesSelectionManager.prototype=new IlvSelectionManager();
IlvFacesSelectionManager.prototype.setClassName("IlvFacesSelectionManager");
IlvFacesSelectionManager.prototype.setViewInternal=function(view){
this.superInvoke("setViewInternal",view);
this.parentNode=view.JSFRef.getPlaceHolder();
};
IlvFacesSelectionManager.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.parentNode){
this.parentNode=null;
}
};
IlvFacesView=function(left,top,_4c7,_4c8,_4c9){
this.superConstructor(left,top,_4c7,_4c8,_4c9);
};
IlvFacesView.prototype=new IlvView();
IlvFacesView.prototype.setClassName("IlvFacesView");
IlvFacesView.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.selectManager){
this.selectManager.dispose();
}
};
IlvFacesView.prototype.readAdditionalCapabilities=function(_4ca){
if(_4ca.expired){
this.setAdditionalParameters("expired","true");
}
};
IlvFacesView.prototype.setChildrenBounds=function(left,top,_4cd,_4ce){
this.superInvoke("setChildrenBounds",left,top,_4cd,_4ce);
this.setAdditionalParameters("componentWidth",_4cd);
this.setAdditionalParameters("componentHeight",_4ce);
};
IlvFacesView.prototype.getSelectionManager=function(){
if(!this.selectManager){
this.selectManager=new IlvFacesSelectionManager();
this.selectManager.setViewInternal(this);
}
return this.selectManager;
};
IlvFacesView.prototype.readMaxZoomLevel=function(_4cf){
this.maxZoom=this.JSFRef.maxZoomLevel;
if(!this.maxZoom){
this.maxZoom=_4cf.maxZoom;
this.JSFRef.setMaxZoomLevel(this.maxZoom);
}
};
IlvFacesView.prototype.readMinZoomLevel=function(_4d0){
this.minZoom=this.JSFRef.minZoomLevel;
if(!this.minZoom){
this.minZoom=_4d0.minZoom;
this.JSFRef.setMinZoomLevel(this.minZoom);
}
};
IlvFacesView.prototype.readZoomLevels=function(_4d1){
this.zoomLevels=this.JSFRef.zoomLevels;
if(this.zoomLevels){
this.maxZoom=this.zoomLevels[this.zoomLevels.length-1];
this.minZoom=this.zoomLevels[0];
}else{
this.zoomLevels=_4d1.zoomLevels;
if(this.zoomLevels&&this.zoomLevels.length>0){
this.maxZoom=this.zoomLevels[this.zoomLevels.length-1];
this.minZoom=this.zoomLevels[0];
this.JSFRef.setMaxZoomLevel(this.maxZoom);
this.JSFRef.setMinZoomLevel(this.minZoom);
}
this.JSFRef.setZoomLevels(this.zoomLevels);
}
};
IlvFacesOverviewProxy=function(_4d2,_4d3,_4d4,_4d5){
this.superConstructor(_4d2);
var _4d6=20;
this.setMinimumSize(_4d6,_4d6);
var size=this.getCreationSize(_4d3);
var _4d8=new IlvOverview(0,0,size.width,size.height);
this.setObject(_4d8);
this.registerResizeListener(_4d8);
_4d8.setStateInCookie(false);
};
IlvFacesOverviewProxy.prototype=new IlvBasicViewHelperProxy();
IlvFacesOverviewProxy.prototype.setClassName("IlvFacesOverviewProxy");
IlvFacesOverviewProxy.prototype.setResizable=function(_4d9){
this.getObject().setResizable(_4d9);
this.notify("Resizable");
};
IlvFacesOverviewProxy.prototype.isResizable=function(){
return this.getObject().isResizable();
};
IlvFacesOverviewProxy.prototype.setIgnoreContentAspectRatio=function(_4da){
this.getObject().setIgnoreContentAspectRatio(_4da);
this.notify("ignoreContentAspectRatio");
};
IlvFacesOverviewProxy.prototype.isIgnoreContentAspectRatio=function(){
return this.getObject().isIgnoreContentAspectRatio();
};
IlvFacesOverviewProxy.prototype.setAutoRefresh=function(_4db){
this.getObject().setAutoRefresh(_4db);
this.notify("AutoRefresh");
};
IlvFacesOverviewProxy.prototype.isAutoRefresh=function(){
return this.getObject().isAutoRefresh();
};
IlvFacesPopupMenu=function(init){
if(typeof (init)!="undefined"){
this.superConstructor(true);
}
};
IlvFacesPopupMenu.prototype=new IlvPopupMenu();
IlvFacesPopupMenu.prototype.setClassName("IlvFacesPopupMenu");
IlvFacesPopupMenu.prototype.createRequestURL=function(view,_4de,_4df){
var _4e0=view.getBounds();
var x=Math.floor(_4de.mouseX);
var y=Math.floor(_4de.mouseY);
var _4e3=view.getRequestURL();
_4e3+="?request="+this.factory.getRequestType();
_4e3+="&format=html&point=("+x+","+y+")";
if(_4df!=null){
_4e3+="&modelId="+_4df;
}
_4e3+="&menufactory="+escape(this.JSFRef.factory);
var _4e4=view.isTiled()?view.getDynamicVisibleLayers():view.getVisibleLayers();
_4e3+="&layer="+IlvUtil.getEncodedVisibleLayers(view,_4e4);
var _4e5=this.JSFRef.getActionParameters(_4de.mouseX,_4de.mouseY);
_4e5[8]=escape(_4e5[8]);
_4e3+="&params=("+_4e5[0]+","+_4e5[1];
for(i=2;i<_4e5.length;i++){
_4e3+=","+_4e5[i];
}
_4e3+=")";
_4e3+=view.getAdditionalParameters();
return _4e3;
};
IlvFacesContextualMenuProxy=function(_4e6,_4e7){
this.superConstructor(_4e6,_4e7);
this.setObject(new IlvFacesPopupMenu(true));
this.baseTextDirection="";
};
IlvFacesContextualMenuProxy.prototype=new IlvAbstractPopupMenuProxy();
IlvFacesContextualMenuProxy.prototype.setClassName("IlvFacesContextualMenuProxy");
IlvFacesContextualMenuProxy.prototype.setBaseTextDirection=function(_4e8){
this.baseTextDirection=_4e8;
this.getObject().setBaseTextDirection(_4e8);
};
IlvFacesContextualMenuProxy.prototype.getBaseTextDirection=function(){
return this.getObject().getBaseTextDirection();
};
IlvFacesContextualMenuProxy.prototype.getActionParameters=function(x,y){
var view=this.getObject().view;
var bbox=view.getViewBBox();
x=bbox.left+x*(bbox.width/view.getWidth());
y=bbox.top+y*(bbox.height/view.getHeight());
return [x,y,bbox.left,bbox.top,bbox.width,bbox.height,view.getWidth(),view.getHeight(),this.finder];
};
IlvFacesContextualMenuProxy.prototype.adaptParameters=function(_4ed){
var x=_4ed[0];
var y=_4ed[1];
var path=_4ed[2];
var _4f1=_4ed.slice(3);
var _4f2=this.getActionParameters(x,y);
_4f2[_4f2.length]=path;
return _4f2.concat(_4f1);
};
IlvFacesZoomToolProxy=function(_4f3,_4f4,_4f5,_4f6,_4f7,_4f8){
this.superConstructor(_4f3);
var minW;
var minH;
this.orientation=_4f8;
if(_4f8=="Vertical"){
minW=IlvZoomTool.buttonSize;
minH=IlvZoomTool.buttonSize*_4f7;
}else{
minH=IlvZoomTool.buttonSize;
minW=IlvZoomTool.buttonSize*_4f7;
}
this.nbButtons=_4f7;
this.setMinimumSize(minW,minH);
var size=this.getCreationSize(_4f4);
var pos=this.positionAfterLayout(size.width,size.height);
var z=new IlvZoomTool(pos.x,pos.y,size.width,size.height,_4f7);
this.setObject(z);
z.setOrientation(_4f8);
};
IlvFacesZoomToolProxy.prototype=new IlvBasicViewHelperProxy();
IlvFacesZoomToolProxy.prototype.setClassName("IlvFacesZoomToolProxy");
IlvFacesZoomToolProxy.prototype.positionAfterLayout=function(_4fe,_4ff){
var pos;
if(this.orientation=="Vertical"){
pos={x:_4fe/2,y:0};
}else{
pos={x:0,y:_4ff/2};
}
return pos;
};
IlvFacesZoomToolProxy.prototype.getNbButtons=function(){
return this.nbButtons;
};
IlvFacesZoomToolProxy.prototype.setNbButtons=function(_501){
this.nbButtons=_501;
this.notify("NbButtons");
};
IlvFacesZoomToolProxy.prototype.getOrientation=function(){
return this.getObject().getOrientation();
};
IlvFacesZoomToolProxy.prototype.setOrientation=function(_502){
this.getObject().setOrientation(_502);
this.notify("Orientation");
};
IlvFacesZoomToolProxy.prototype.setMessageBox=function(_503){
this.messageBox=_503;
var _504=this.getObject();
if(_504.buttons){
_504.setMessagePanel(_503.getObject());
}
this.notify("MessageBoxId");
};
IlvFacesZoomToolProxy.prototype.setDefaultImagePaths=function(){
IlvZoomTool.prototype.upImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.upIcon;
IlvZoomTool.prototype.rolloverUpImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.rolloverUpIcon;
IlvZoomTool.prototype.downImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.downIcon;
IlvZoomTool.prototype.rolloverDownImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.rolloverDownIcon;
IlvZoomTool.prototype.rightImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.rightIcon;
IlvZoomTool.prototype.rolloverRightImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.rolloverRightIcon;
IlvZoomTool.prototype.leftImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.leftIcon;
IlvZoomTool.prototype.rolloverLeftImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.rolloverLeftIcon;
IlvZoomTool.prototype.currentImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.currentIcon;
IlvZoomTool.prototype.rolloverCurrentImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.rolloverCurrentIcon;
IlvZoomTool.prototype.plusImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.plusIcon;
IlvZoomTool.prototype.rolloverPlusImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.rolloverPlusIcon;
IlvZoomTool.prototype.minusImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.minusIcon;
IlvZoomTool.prototype.rolloverMinusImage=IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesZoomToolProxy.rolloverMinusIcon;
};
IlvFacesZoomToolProxy.prototype.toHTML=function(){
this.setDefaultImagePaths();
this.jviewsObject.toHTML(this.getPlaceHolder());
if(this.messageBox){
this.jviewsObject.setMessagePanel(this.messageBox.getObject());
}
};
IlvFacesPanToolProxy=function(_505,_506,_507,_508){
this.superConstructor(_505);
var _509=3*IlvPanTool.buttonSize+6;
this.setMinimumSize(_509,_509);
var size=this.getCreationSize(_506);
this.setObject(new IlvPanTool(0,0));
};
IlvFacesPanToolProxy.prototype=new IlvBasicViewHelperProxy();
IlvFacesPanToolProxy.prototype.setClassName("IlvFacesPanToolProxy");
IlvFacesPanToolProxy.prototype.setEnabled=function(_50b){
this.getObject().setEnabled(_50b);
this.notify("Enabled");
};
IlvFacesPanToolProxy.prototype.isEnabled=function(){
return this.getObject().isEnabled();
};
IlvFacesPanToolProxy.prototype.toHTML=function(){
var obj=this.getObject();
obj.buttons[0].setImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panNorthWestIcon);
obj.buttons[0].setRolloverImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panNorthWestRolloverIcon);
obj.buttons[1].setImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panNorthIcon);
obj.buttons[1].setRolloverImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panNorthRolloverIcon);
obj.buttons[2].setImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panNorthEastIcon);
obj.buttons[2].setRolloverImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panNorthEastRolloverIcon);
obj.buttons[3].setImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panWestIcon);
obj.buttons[3].setRolloverImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panWestRolloverIcon);
obj.buttons[4].setImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.showAllIcon);
obj.buttons[4].setRolloverImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.showAllRolloverIcon);
obj.buttons[5].setImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panEastIcon);
obj.buttons[5].setRolloverImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panEastRolloverIcon);
obj.buttons[6].setImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panSouthWestIcon);
obj.buttons[6].setRolloverImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panSouthWestRolloverIcon);
obj.buttons[7].setImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panSouthIcon);
obj.buttons[7].setRolloverImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panSouthRolloverIcon);
obj.buttons[8].setImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panSouthEastIcon);
obj.buttons[8].setRolloverImage(IlvFrameworkConstants.frameworkPath+jviews.messages.IlvFacesPanToolProxy.panSouthEastRolloverIcon);
this.superInvoke("toHTML");
};
IlvPanTool.prototype.childrenToHTML=function(_50d){
this.superInvoke("childrenToHTML",_50d);
for(var i=0;i<9;i++){
this.buttons[i].toHTML(_50d);
}
};
IlvFacesMapInteractorProxy=function(_50f){
this.superConstructor(_50f);
this.setObject(new IlvMapInteractor());
};
IlvFacesMapInteractorProxy.prototype=new IlvInteractorProxy();
IlvFacesMapInteractorProxy.prototype.setClassName("IlvFacesMapInteractorProxy");
IlvFacesMapInteractorProxy.prototype.getActionName=function(){
return this.getObject().getActionName();
};
IlvFacesMapInteractorProxy.prototype.setActionName=function(_510){
this.getObject().setActionName(_510);
this.notify("ActionName");
};
IlvFacesTooltipInteractorProxy=function(_511,_512){
this.superConstructor(_511);
this.setObject(new IlvTooltipInteractor(_512));
this.baseTextDirection="";
};
IlvFacesTooltipInteractorProxy.prototype=new IlvInteractorProxy();
IlvFacesTooltipInteractorProxy.prototype.setClassName("IlvFacesTooltipInteractorProxy");
IlvFacesTooltipInteractorProxy.prototype.setTolerance=function(_513){
if(_513){
this.getObject().tolerance=_513;
}
};
IlvFacesTooltipInteractorProxy.prototype.setTemplate=function(_514){
if(_514){
this.getObject().setTemplate(_514);
}
};
IlvFacesTooltipInteractorProxy.prototype.setBaseTextDirection=function(_515){
if(_515){
this.getObject().setBaseTextDirection(_515);
}
};
IlvFacesTooltipInteractorProxy.prototype.getBaseTextDirection=function(){
return this.getObject().getBaseTextDirection();
};
IlvFacesMapRectInteractorProxy=function(_516,_517){
this.superConstructor(_516);
this.setObject(new IlvMapRectInteractor());
};
IlvFacesMapRectInteractorProxy.prototype=new IlvDragRectInteractorProxy();
IlvFacesMapRectInteractorProxy.prototype.setClassName("IlvFacesMapRectInteractorProxy");
IlvFacesMapRectInteractorProxy.prototype.getActionName=function(){
return this.getObject().getActionName();
};
IlvFacesMapRectInteractorProxy.prototype.setActionName=function(_518){
this.getObject().setActionName(_518);
this.notify("ActionName");
};
IlvFacesObjectSelectInteractor=function(){
this.superConstructor();
this.setMessage(jviews.messages.IlvFacesObjectSelectInteractor.clickOnObject);
};
IlvFacesObjectSelectInteractor.prototype=new IlvInteractor();
IlvFacesObjectSelectInteractor.prototype.setClassName("IlvFacesObjectSelectInteractor");
IlvFacesObjectSelectInteractor.prototype.setView=function(view){
if(view!=null){
this.JSFRef.setViewId(view.JSFRef.getAbsoluteId());
}
};
IlvFacesObjectSelectInteractor.prototype.mouseDown=function(e){
if(e.button!=2){
var view=this.view;
var x=e.mouseX;
var y=e.mouseY;
var _51e=view.hitmap;
if(view.getInteractor()==this||!_51e||_51e.hittest(x,y)>0){
var bbox=view.getViewBBox();
x=bbox.left+x*(bbox.width/view.getWidth());
y=bbox.top+y*(bbox.height/view.getHeight());
var _520=[x,y,bbox.left,bbox.top,bbox.width,bbox.height,view.getWidth(),view.getHeight()];
if(this.JSFRef.invocationContext=="IMAGE_SERVLET_CONTEXT"){
_520=_520.concat([this.JSFRef.methodRef,this.JSFRef.finder,this.JSFRef.listenersRef]);
this.view.performAction("facesServletAction",_520,true);
}else{
if(view.isTiled()){
var _521=view.getDynamicVisibleLayers();
_520[8]=IlvUtil.getEncodedVisibleLayers(view,_521);
}
this.JSFRef.performSelect(_520);
}
}
}
return false;
};
IlvFacesObjectSelectInteractorProxy=function(_522,_523){
if(_522){
this.superConstructor(_522,_523);
var _524=new IlvFacesObjectSelectInteractor();
_524.JSFRef=this;
this.setObject(_524);
}
};
IlvFacesObjectSelectInteractorProxy.prototype=new IlvObjectSelectInteractorProxy();
IlvFacesObjectSelectInteractorProxy.prototype.setClassName("IlvFacesObjectSelectInteractorProxy");
IlvFacesObjectSelectRectInteractor=function(){
this.superConstructor();
this.setMessage(jviews.messages.IlvFacesObjectSelectRectInteractor.clickOnObject);
};
IlvFacesObjectSelectRectInteractor.prototype=new IlvDragRectangleInteractor();
IlvFacesObjectSelectRectInteractor.prototype.setClassName("IlvFacesObjectSelectRectInteractor");
IlvFacesObjectSelectRectInteractor.prototype.setView=function(view){
if(view!=null){
this.JSFRef.setViewId(view.JSFRef.getAbsoluteId());
}
};
IlvFacesObjectSelectRectInteractor.prototype.stopDragging=function(e){
if(e.button!=2){
var view=this.view;
this.dragging=false;
view.getRectangle().setVisible(false);
var _528=0;
if(this.zleft==this.startx&&this.ztop==this.starty){
_528=0;
}else{
if(this.zright==this.startx&&this.ztop==this.starty){
_528=3;
}else{
if(this.zright==this.startx&&this.zbottom==this.starty){
_528=2;
}else{
if(this.zleft==this.startx&&this.zbottom==this.starty){
_528=1;
}
}
}
}
var bbox=view.getViewBBox();
var _52a=[this.zleft,this.ztop,this.zright-this.zleft,this.zbottom-this.ztop,_528,bbox.left,bbox.top,bbox.width,bbox.height,view.getWidth(),view.getHeight()];
if(this.JSFRef.invocationContext=="IMAGE_SERVLET_CONTEXT"){
_52a=_52a.concat([this.JSFRef.methodRef,this.JSFRef.finder,this.JSFRef.listenersRef]);
this.view.performAction("facesServletRectAction",_52a,true);
}else{
if(view.isTiled()){
var _52b=view.getDynamicVisibleLayers();
_52a[11]=IlvUtil.getEncodedVisibleLayers(view,_52b);
}
this.JSFRef.performSelectRect(_52a);
}
}
return false;
};
IlvFacesObjectSelectRectInteractorProxy=function(_52c,_52d){
if(_52c){
this.superConstructor(_52c,_52d);
var _52e=new IlvFacesObjectSelectRectInteractor();
_52e.JSFRef=this;
this.setObject(_52e);
}
};
IlvFacesObjectSelectRectInteractorProxy.prototype=new IlvObjectSelectRectInteractorProxy();
IlvFacesObjectSelectRectInteractorProxy.prototype.setClassName("IlvFacesObjectSelectRectInteractorProxy");
IlvFacesZoomInteractorProxy=function(_52f,_530){
this.superConstructor(_52f);
this.setObject(new IlvZoomInteractor());
};
IlvFacesZoomInteractorProxy.prototype=new IlvDragRectInteractorProxy();
IlvFacesZoomInteractorProxy.prototype.setClassName("IlvFacesZoomInteractorProxy");
IlvFacesPanInteractorProxy=function(_531){
this.superConstructor(_531);
this.setObject(new IlvPanInteractor());
};
IlvFacesPanInteractorProxy.prototype=new IlvInteractorProxy();
IlvFacesPanInteractorProxy.prototype.setClassName("IlvFacesPanInteractorProxy");
IlvFacesHighlightInteractorProxy=function(_532,_533,_534,_535){
this.superConstructor(_532);
this.setObject(new IlvHighlightInteractor(_533,_534,_535));
};
IlvFacesHighlightInteractorProxy.prototype=new IlvInteractorProxy();
IlvFacesHighlightInteractorProxy.prototype.setClassName("IlvFacesHighlightInteractorProxy");
IlvFacesHighlightInteractorProxy.prototype.setGroupable=function(_536){
this.getObject().setGroupable(_536);
};
}
