package org.jdesktop.animation.timing.triggers;

public class ButtonStateEvent extends TriggerEvent
{
    public static final ButtonStateEvent ARMED;
    public static final ButtonStateEvent DISARMED;
    public static final ButtonStateEvent ROLLOVER;
    public static final ButtonStateEvent ROLLOFF;
    
    protected ButtonStateEvent(final String name) {
        super(name);
    }
    
    @Override
    public TriggerEvent getOppositeEvent() {
        if (this.equals(ButtonStateEvent.ARMED)) {
            return ButtonStateEvent.DISARMED;
        }
        if (this.equals(ButtonStateEvent.DISARMED)) {
            return ButtonStateEvent.ARMED;
        }
        if (this.equals(ButtonStateEvent.ROLLOVER)) {
            return ButtonStateEvent.ROLLOFF;
        }
        if (this.equals(ButtonStateEvent.ROLLOFF)) {
            return ButtonStateEvent.ROLLOVER;
        }
        return this;
    }
    
    static {
        ARMED = new ButtonStateEvent("Armed");
        DISARMED = new ButtonStateEvent("Disarmed");
        ROLLOVER = new ButtonStateEvent("Rollover");
        ROLLOFF = new ButtonStateEvent("Rolloff");
    }
}