package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Point;

public class PropertyRange
{
    private String propertyName;
    private KeyFrames keyFrames;
    
    public PropertyRange(final String propertyName, final KeyFrames keyFrames) {
        this.propertyName = propertyName;
        this.keyFrames = keyFrames;
    }
    
    public static PropertyRange createPropertyRangeInt(final String propertyName, final int... values) {
        final KeyValues keyValues = KeyValues.createKeyValues(values);
        final KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangeInt(final String propertyName, final Spline interpolation, final int from, final int to) {
        final KeyValues keyValues = KeyValues.createKeyValues(new int[] { from, to });
        final KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(new Spline[] { interpolation }));
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangeFloat(final String propertyName, final float... values) {
        final KeyValues keyValues = KeyValues.createKeyValues(values);
        final KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangeFloat(final String propertyName, final Spline interpolation, final float from, final float to) {
        final KeyValues keyValues = KeyValues.createKeyValues(new float[] { from, to });
        final KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(new Spline[] { interpolation }));
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangeDouble(final String propertyName, final double... values) {
        final KeyValues keyValues = KeyValues.createKeyValues(values);
        final KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangeDouble(final String propertyName, final Spline interpolation, final double from, final double to) {
        final KeyValues keyValues = KeyValues.createKeyValues(new double[] { from, to });
        final KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(new Spline[] { interpolation }));
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangePoint(final String propertyName, final Point... values) {
        final KeyValues keyValues = KeyValues.createKeyValues(values);
        final KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangePoint(final String propertyName, final Spline interpolation, final Point from, final Point to) {
        final KeyValues keyValues = KeyValues.createKeyValues(new Point[] { from, to });
        final KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(new Spline[] { interpolation }));
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangeDimension(final String propertyName, final Dimension... values) {
        final KeyValues keyValues = KeyValues.createKeyValues(values);
        final KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangeDimension(final String propertyName, final Spline interpolation, final Dimension from, final Dimension to) {
        final KeyValues keyValues = KeyValues.createKeyValues(new Dimension[] { from, to });
        final KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(new Spline[] { interpolation }));
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangeRectangle(final String propertyName, final Rectangle... values) {
        final KeyValues keyValues = KeyValues.createKeyValues(values);
        final KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangeRectangle(final String propertyName, final Spline interpolation, final Rectangle from, final Rectangle to) {
        final KeyValues keyValues = KeyValues.createKeyValues(new Rectangle[] { from, to });
        final KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(new Spline[] { interpolation }));
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangeColor(final String propertyName, final Color... values) {
        final KeyValues keyValues = KeyValues.createKeyValues(values);
        final KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }
    
    public static PropertyRange createPropertyRangeColor(final String propertyName, final Spline interpolation, final Color from, final Color to) {
        final KeyValues keyValues = KeyValues.createKeyValues(new Color[] { from, to });
        final KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(new Spline[] { interpolation }));
        return new PropertyRange(propertyName, keyFrames);
    }
    
    String getPropertyName() {
        return this.propertyName;
    }
    
    void setStartValue(final Object object) {
        this.keyFrames.getKeyValues().setStartValue(object);
    }
    
    void setValue(final Object object, final Method method, final float fraction) {
        this.keyFrames.setValue(object, method, fraction);
    }
    
    Class getType() {
        return this.keyFrames.getType();
    }
    
    public boolean isToAnimation() {
        return this.keyFrames.getKeyValues().isToAnimation();
    }
}