package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import org.jdesktop.animation.timing.TimingTarget;

public class ObjectModifier implements TimingTarget
{
    private PropertyRange propertyRange;
    private Object object;
    private Method propertySetter;
    private Method propertyGetter;
    
    public ObjectModifier(final Object object, final PropertyRange propertyRange) {
        this.object = object;
        this.propertyRange = propertyRange;
        try {
            this.setupMethodInfo();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Bad property name (" + propertyRange.getPropertyName() + "): could not find " + "an appropriate setter or getter method for that property");
        }
    }
    
    private void setupMethodInfo() throws NoSuchMethodException {
        final String propertyName = this.propertyRange.getPropertyName();
        final String firstChar = propertyName.substring(0, 1);
        final String remainder = propertyName.substring(1);
        final Class propertyType = this.propertyRange.getType();
        final String propertySetterName = "set" + firstChar.toUpperCase() + remainder;
        this.propertySetter = this.object.getClass().getMethod(propertySetterName, propertyType);
        if (this.propertyRange.isToAnimation()) {
            final String propertyGetterName = "get" + firstChar.toUpperCase() + remainder;
            this.propertyGetter = this.object.getClass().getMethod(propertyGetterName, (Class<?>[])new Class[0]);
        }
    }
    
    public void begin() {
        if (this.propertyRange.isToAnimation()) {
            try {
                this.propertyRange.setStartValue(this.propertyGetter.invoke(this.object, new Object[0]));
            }
            catch (Exception e) {
                System.out.println("Problem with propertySetter in ObjectModifier");
            }
        }
    }
    
    public void end() {
    }
    
    public void timingEvent(final long cycleElapsedTime, final long totalElapsedTime, final float fraction) {
        try {
            this.propertyRange.setValue(this.object, this.propertySetter, fraction);
        }
        catch (Exception e) {
            System.out.println("Problem in ObjectModifier.timingEvent: " + e);
        }
    }
}