package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import java.awt.Rectangle;

class KeyValuesRectangle extends KeyValues<Rectangle>
{
    public KeyValuesRectangle(final Rectangle... values) {
        super(values);
        for (final Rectangle value : values) {
            this.values.add(value);
        }
    }
    
    @Override
    public Class<?> getType() {
        return Rectangle.class;
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int i0, final int i1, final float fraction) {
        final Rectangle value = (Rectangle)this.values.get(i0);
        if (i0 != i1) {
            final Rectangle v0 = (Rectangle)this.values.get(i0);
            final Rectangle v2 = (Rectangle)this.values.get(i1);
            final Rectangle rectangle = value;
            rectangle.x += (int)((v2.x - v0.x) * fraction + 0.5);
            final Rectangle rectangle2 = value;
            rectangle2.y += (int)((v2.y - v0.y) * fraction + 0.5);
            final Rectangle rectangle3 = value;
            rectangle3.width += (int)((v2.width - v0.width) * fraction + 0.5);
            final Rectangle rectangle4 = value;
            rectangle4.height += (int)((v2.height - v0.height) * fraction + 0.5);
        }
        try {
            method.invoke(object, value);
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVFloat.setValue:" + e);
        }
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int index) {
        try {
            method.invoke(object, this.values.get(index));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVFloat.setValue:" + e);
        }
    }
}