Rem
Rem Copyright (c) 2011, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      db2_sql.sql - DB2 SQL translator
Rem
Rem    DESCRIPTION
Rem      This script contains the DB2_SQL_TRANSLATOR package
Rem
Rem    INSTALLATION
Rem      > loadjava -user migration_repo/*** -genmissing -definer -resolver '((* MIGRATION_REPO)(* PUBLIC)(* -))' babelfish_db2-?.?.?.?.jar
Rem      > sqlplus migration_repo/***
Rem      SQL> @db2_sql.sql
Rem      SQL> grant execute on db2_sql_translator to <target-user>;
Rem      > sqlplus system/***
Rem      SQL> exec dbms_java.grant_permission('MIGRATION_REPO', 'SYS:java.lang.RuntimePermission', 'getClassLoader', '')
Rem     
Rem    NOTES
Rem      None 
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpang       01/05/12 - Updated
Rem    dooneill    12/16/11 - Created
Rem

create or replace package db2_sql_translator as

  procedure translate_sql(sql_text              in  clob,
                          translated_text       out clob);

  procedure translate_error(error_code          in  binary_integer,
                            translated_code     out binary_integer,
                            translated_sqlstate out varchar2);

end;
/

create or replace package body db2_sql_translator as

  procedure translate_sql(sql_text              in  clob,
                          translated_text       out clob) as
  language java
  name 'oracle.dbtools.babelfish.db2.DB2SQLTranslator.translateSQL(oracle.sql.CLOB,oracle.sql.CLOB[])';

  procedure translate_error(error_code          in  binary_integer,
                            translated_code     out binary_integer,
                            translated_sqlstate out varchar2) as
  language java
  name 'oracle.dbtools.babelfish.db2.DB2SQLTranslator.translateError(int,int[],java.lang.String[])';

end;
/
