<?xml version="1.0"?>
<!--
NAME
    kustrig.xsl
DESCRIPTION
    Convert mdapi TRIGGER_T document to TRIGGER document (SXML)

MODIFIED        MM/DD/YY
    abodge      06/29/12 - Fix xmlns attribute problem
    lbarton     06/02/08 - bug 6767780: view trigger on nested table col
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng     17/02/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <!-- *******************************************************************
Template: TRIGGER_T - top-level template for TRIGGER.
  This template puts out
   - the opening TRIGGER element (with xmlns and version attributes)
   - NAME elements

******************************************************************** -->
 <xsl:template match="TRIGGER_T">
  <xsl:element name="TRIGGER" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:apply-templates select="SCHEMA_OBJ"/>
   <xsl:element name="TRIGGER_TYPE">
    <xsl:choose>
     <xsl:when test="TYPE_NUM=0 or TYPE_NUM=1">BEFORE</xsl:when>
     <xsl:when test="TYPE_NUM=2 or TYPE_NUM=3">AFTER</xsl:when>
     <xsl:when test="TYPE_NUM=4">INSTEAD_OF</xsl:when>
    </xsl:choose>
   </xsl:element>
   <!-- event_clause -->
   <xsl:choose>
    <xsl:when test="SYS_EVTS!=0">
     <xsl:if test="(PROPERTY mod 16)>= 8">
      <xsl:call-template name="database_event_clause"/>
     </xsl:if>
     <xsl:if test="(PROPERTY mod 32)>= 16">
      <xsl:call-template name="ddl_event_clause"/>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="dml_event_clause"/>
    </xsl:otherwise>
   </xsl:choose>
   <!-- when_condition -->
   <xsl:if test="WHENCLAUSE">
    <xsl:element name="WHEN_CONDITION">
     <xsl:value-of select="WHENCLAUSE"/>
    </xsl:element>
   </xsl:if>
   <!-- plsql_block/class_procedure -->
   <xsl:choose>
    <xsl:when test="BODY_VCNT">
     <xsl:choose>
      <!-- Have to strip trailing ';' off CALL triggers(go figure) -->
      <xsl:when test="(PROPERTY mod 4)>=2">
       <xsl:element name="CALL_PROCEDURE">
        <xsl:for-each select="BODY_VCNT/BODY_VCNT_ITEM">
         <xsl:choose>
          <xsl:when test="position()=last() and 
		contains(substring(.,string-length(.)),';')">
           <xsl:value-of select="substring(.,1,string-length(.)-1)"/>
          </xsl:when>
          <xsl:otherwise>
           <xsl:value-of select="."/>
          </xsl:otherwise>
         </xsl:choose>
         <xsl:text>&#xa; </xsl:text>
        </xsl:for-each>
       </xsl:element>
      </xsl:when>
      <xsl:otherwise>
       <xsl:element name="PLSQL_BLOCK">
        <xsl:for-each select="BODY_VCNT/BODY_VCNT_ITEM">
         <xsl:value-of select="."/>
         <xsl:text>&#xa; </xsl:text>
        </xsl:for-each>
       </xsl:element>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <!-- end length greater than 4000 -->
    <xsl:otherwise>
     <!-- body length less than 4000 -->
     <xsl:choose>
      <!-- Have to strip trailing ';' off CALL triggers(go figure) -->
      <xsl:when test="(PROPERTY mod 4)>=2">
       <xsl:element name="CALL_PROCEDURE">
        <xsl:choose>
         <xsl:when test="contains(substring(BODY,string-length(BODY)),';')">
          <xsl:value-of select="substring(BODY,1,string-length(BODY)-1)"/>
         </xsl:when>
         <xsl:otherwise>
          <xsl:value-of select="BODY"/>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:element>
      </xsl:when>
      <xsl:otherwise>
       <xsl:element name="PLSQL_BLOCK">
        <xsl:value-of select="BODY"/>
       </xsl:element>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="ENABLED=0">
    <xsl:element name="DISABLE"/>
   </xsl:if>
  </xsl:element>
 </xsl:template>
 <!-- *******************************************************************
Template: database_event_clause
******************************************************************** -->
 <xsl:template name="database_event_clause">
  <xsl:element name="DATABASE_EVENT">
   <xsl:element name="EVENT_LIST">
    <xsl:call-template name="event_clause"/>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <!-- *******************************************************************
Template: ddl_event_clause
******************************************************************** -->
 <xsl:template name="ddl_event_clause">
  <xsl:element name="DDL_EVENT">
   <xsl:element name="EVENT_LIST">
    <xsl:call-template name="event_clause"/>
   </xsl:element>
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 16)>= 8">
     <xsl:element name="DATABASE"/>
    </xsl:when>
    <xsl:when test="(PROPERTY mod 32)>= 16">
     <xsl:element name="SCHEMA">
      <xsl:value-of select="BASE_OBJ_SCHEMA"/>
     </xsl:element>
    </xsl:when>
    <xsl:otherwise/>
   </xsl:choose>
  </xsl:element>
 </xsl:template>
 <!-- *******************************************************************
Template: event_clause
******************************************************************** -->
 <xsl:template name="event_clause">
  <xsl:if test="(SYS_EVTS mod 8)>=4">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">SERVERERROR</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 16)>=8">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">LOGON</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 32)>=16">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">LOGOFF</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 2 )>=1">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">STARTUP</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 4)>=2">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">SHUTDOWN</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 16777216)>=8388608">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">SUSPEND</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 128)>=64">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">ALTER</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 512)>=256">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">ANALYZE</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 32768)>= 16384">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">ASSOCIATE STATISTICS</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 65536)>=32768">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">AUDIT</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 1024)>=512">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">COMMENT</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 64 )>=32">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">CREATE</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 131072)>=65536">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">DISASSOCIATE STATISTICS</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 256)>=128">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">DROP</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 2048)>=1024">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">GRANT</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 262144)>=131072">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">NOAUDIT</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 16384)>=8192">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">RENAME</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 4096)>=2048">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">REVOKE</xsl:element>
   </xsl:element>
  </xsl:if>
  <xsl:if test="(SYS_EVTS mod 8192)>=4096">
   <xsl:element name="EVENT_LIST_ITEM">
    <xsl:element name="EVENT">TRUNCATE</xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <!-- *******************************************************************
Template: dml_event_clause
******************************************************************** -->
 <xsl:template name="dml_event_clause">
  <xsl:element name="DML_EVENT">
   <xsl:element name="EVENT_LIST">
    <xsl:if test="ACT_INSERT!=0">
     <xsl:element name="EVENT_LIST_ITEM">
      <xsl:element name="EVENT">
       <xsl:text>INSERT</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:if>
    <xsl:if test="ACT_DELETE!=0">
     <xsl:element name="EVENT_LIST_ITEM">
      <xsl:element name="EVENT">
       <xsl:text>DELETE</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:if>
    <xsl:if test="ACT_UPDATE!=0">
     <xsl:element name="EVENT_LIST_ITEM">
      <xsl:element name="EVENT">
       <xsl:text>UPDATE</xsl:text>
      </xsl:element>
      <!-- column_list -->
      <xsl:if test="COLS/COLS_ITEM[TYPE_NUM=0]">
       <!-- really should ckeck if a column exist then output COL_LIST tag -->
       <xsl:element name="COL_LIST">
        <xsl:for-each select="COLS/COLS_ITEM[TYPE_NUM=0]">
         <xsl:element name="COL_LIST_ITEM">
          <xsl:element name="NAME">
           <xsl:value-of select="NAME"/>
          </xsl:element>
         </xsl:element>
        </xsl:for-each>
       </xsl:element>
      </xsl:if>
     </xsl:element>
     <!-- EVENT_LIST_ITEM -->
    </xsl:if>
   </xsl:element>
   <!-- EVENT_LIST -->
   <!-- nested table -->
   <xsl:if test="(PROPERTY mod 64)>=32">
    <xsl:element name="NESTED_TABLE_COLUMN">
     <xsl:value-of select="NTNAME"/>
    </xsl:element>
   </xsl:if>
   <xsl:apply-templates select="BASE_OBJ"/>
   <xsl:if test="REFOLDNAME!='OLD' or REFNEWNAME!='NEW' or REFPRTNAME or
   	TYPE_NUM=1 or TYPE_NUM=3 or TYPE_NUM=4">
    <xsl:element name="REFERENCING">
     <xsl:if test="REFOLDNAME!='OLD'">
      <xsl:element name="OLD_AS">
       <xsl:value-of select="REFOLDNAME"/>
      </xsl:element>
     </xsl:if>
     <xsl:if test="REFNEWNAME!='NEW'">
      <xsl:element name="NEW_AS">
       <xsl:value-of select="REFNEWNAME"/>
      </xsl:element>
     </xsl:if>
     <xsl:if test="REFPRTNAME">
      <xsl:element name="PARENT_AS">
       <xsl:value-of select="REFPRTNAME"/>
      </xsl:element>
     </xsl:if>
     <xsl:if test="TYPE_NUM=1 or TYPE_NUM=3 or TYPE_NUM=4">
      <xsl:element name="FOR_EACH_ROW"/>
     </xsl:if>
    </xsl:element>
    <!-- REFERENCING -->
   </xsl:if>
  </xsl:element>
  <!--  DML_EVENT -->
 </xsl:template>
</xsl:stylesheet>
