<?xml version="1.0"?>
<!--
NAME
    kusqtab.xsl
DESCRIPTION
    Convert mdapi QUETAB_T document to AQ_QUEUE_TABLE document (SXML)

MODIFIED        MM/DD/YY
    abodge     06/29/12 - Fix xmlns attribute problem
    htseng     11/28/05 - remove MAXTRANS from SegmentAttributes
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng     12/09/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <!-- Top level imports -->
 <xsl:import href="kusstorg.xsl"/>
 <xsl:import href="kuscomm.xsl"/>
 <!-- *******************************************************************
Template: QUETAB_T - top-level template for AQ_QUEUE_TABLE.
  This template puts out
   - the opening AQ_QUEUE_TABLE element (with xmlns and version attributes)
   - NAME elements
******************************************************************** -->
 <xsl:template match="QUETAB_T">
  <xsl:element name="AQ_QUEUE_TABLE" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="SCHEMA">
    <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
   </xsl:element>
   <xsl:element name="QUEUE_PAYLOAD_TYPE">
    <xsl:if test="UDATA_TYPE=1">
     <xsl:element name="SCHEMA">
      <xsl:value-of select="substring-before(OBJECT_TYPE,'.')"/>
     </xsl:element>
    </xsl:if>
    <xsl:element name="NAME">
     <xsl:choose>
      <xsl:when test="UDATA_TYPE=1">
       <xsl:value-of select="substring-after(OBJECT_TYPE,'.')"/>
      </xsl:when>
      <xsl:when test="UDATA_TYPE=2">
       <xsl:text>VARIANT</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>RAW</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
   </xsl:element>
   <!-- ?? segment_attributes_clause, need tag name STORE_CLAUSE  -->
   <!-- xsl:call-template name="SegmentAttributes" -->
   <!-- xsl:with-param name="ParentNode" select="STORAGE_CLAUSE"/ -->
   <!-- /xsl:call-template -->
   <xsl:element name="SEGMENT_ATTRIBUTES">
    <xsl:element name="PCTFREE">
     <xsl:value-of select="STORAGE_CLAUSE/PCT_FREE"/>
    </xsl:element>
    <xsl:element name="PCTUSED">
     <xsl:value-of select="STORAGE_CLAUSE/PCT_USED"/>
    </xsl:element>
    <xsl:element name="INITRANS">
     <xsl:value-of select="STORAGE_CLAUSE/INITRANS"/>
    </xsl:element>
    <xsl:element name="TABLESPACE">
     <xsl:value-of select="STORAGE_CLAUSE/TS_NAME"/>
    </xsl:element>
   </xsl:element>
   <xsl:element name="SORT_LIST">
    <xsl:choose>
     <xsl:when test="SORT_COLS =1">
      <xsl:text>PRIORITY</xsl:text>
     </xsl:when>
     <xsl:when test="SORT_COLS =2">
      <xsl:text>ENQ_TIME</xsl:text>
     </xsl:when>
     <xsl:when test="SORT_COLS =3">
      <xsl:text>PRIORITY,ENQ_TIME</xsl:text>
     </xsl:when>
     <xsl:when test="SORT_COLS =4">
      <xsl:text>COMMIT_TIME</xsl:text>
     </xsl:when>
     <xsl:when test="SORT_COLS =5">
      <xsl:text>PRIORITY,COMMIT_TIME</xsl:text>
     </xsl:when>
     <xsl:when test="SORT_COLS =7">
      <xsl:text>ENQ_TIME,PRIORITY</xsl:text>
     </xsl:when>
    </xsl:choose>
   </xsl:element>
   <xsl:if test="(FLAGS mod 2) >= 1">
    <xsl:element name="MULTIPLE_CONSUMERS"/>
   </xsl:if>
   <xsl:if test="(FLAGS mod 4) >= 2">
    <xsl:element name="MESSAGE_GROUPING"/>
   </xsl:if>
   <xsl:if test="string-length(TABLE_COMMENT)!=0">
    <xsl:element name="COMMENT">
     <xsl:value-of select="TABLE_COMMENT"/>
    </xsl:element>
   </xsl:if>
   <xsl:if test="PRIMARY_INSTANCE!=0">
    <xsl:element name="PRIMARY_INSTANCE">
     <xsl:value-of select="PRIMARY_INSTANCE"/>
    </xsl:element>
   </xsl:if>
   <xsl:if test="SECONDARY_INSTANCE!=0">
    <xsl:element name="SECONDARY_INSTANCE">
     <xsl:value-of select="SECONDARY_INSTANCE"/>
    </xsl:element>
   </xsl:if>
   <xsl:element name="COMPATIBLE">
    <xsl:choose>
     <xsl:when test="(FLAGS mod 16) >= 8">
      <xsl:text>8.1.3</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>8.0.3</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <xsl:if test="(FLAGS mod 8192) >= 4096">
    <xsl:element name="SECURE"/>
   </xsl:if>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
