<?xml version="1.0"?>
<!--
NAME
    kusmvld.xsl
DESCRIPTION
    Convert MATERIALIZED VIEW LOG (SXML) document to creation DDL.

MODIFIED        MM/DD/YY
    htseng      01/09/06 - ade transform SEGMENT_ATTRIBUTES param 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    lbarton     08/10/05 - lbarton_mddiff
    htseng      05/13/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <xsl:import href="kustbphd.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PHYSICAL_PROPERTIES">1</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template: top-level template for MATERIALIZED_VIEW_LOG.
******************************************************************** -->
 <xsl:template match="sxml:MATERIALIZED_VIEW_LOG">
  <xsl:text>CREATE MATERIALIZED VIEW LOG ON </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="sxml:ON_TABLE"/>
  </xsl:call-template>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:apply-templates select="sxml:SEGMENT_ATTRIBUTES"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="sxml:CACHE"> CACHE</xsl:if>
  <!-- parallel -->
  <xsl:apply-templates select="sxml:PARALLEL"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:if test="sxml:RECORDS">
   <xsl:text> WITH</xsl:text>
   <xsl:if test="sxml:RECORDS/sxml:ROWID">
    <xsl:text> ROWID</xsl:text>
   </xsl:if>
   <xsl:if test="sxml:RECORDS/sxml:PRIMARY_KEY">
    <xsl:if test="sxml:RECORDS/sxml:ROWID">
     <xsl:text>,</xsl:text>
    </xsl:if>
    <xsl:text> PRIMARY KEY</xsl:text>
   </xsl:if>
   <xsl:if test="sxml:RECORDS/sxml:OBJECT_ID">
    <xsl:if test="sxml:RECORDS/sxml:ROWID or sxml:RECORDS/sxml:PRIMARY_KEY">
     <xsl:text>,</xsl:text>
    </xsl:if>
    <xsl:text> OBJECT ID</xsl:text>
   </xsl:if>
   <xsl:if test="sxml:RECORDS/sxml:SEQUENCE">
    <xsl:if test="sxml:RECORDS/sxml:ROWID or sxml:RECORDS/sxml:PRIMARY_KEY
		or sxml:RECORDS/sxml:OBJECT_ID">
     <xsl:text>,</xsl:text>
    </xsl:if>
    <xsl:text> SEQUENCE</xsl:text>
   </xsl:if>
   <!-- column_list -->
   <xsl:if test="sxml:RECORDS/sxml:COL_LIST">
    <xsl:text>( "</xsl:text>
    <xsl:for-each select="sxml:RECORDS/sxml:COL_LIST/sxml:COL_LIST_ITEM">
     <xsl:value-of select="sxml:NAME"/>
     <xsl:if test="position()!=last()">", "</xsl:if>
    </xsl:for-each>
    <xsl:text>" ) </xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="sxml:INCLUDING_NEW_VALUES">
    <xsl:text> INCLUDING NEW VALUES </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> EXCLUDING NEW VALUES </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
