<?xml version="1.0"?>
<!--
NAME
    kusfga.xsl
DESCRIPTION
    Convert mdapi FGA_POLICY_T document to FGA POLICY document (SXML)

MODIFIED       MM/DD/YY
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    rapayne    11/03/05 - Bug 4715313: Reformat with XMLSpy
    htseng     12/08/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <!-- *******************************************************************
Template: FGA_POLICY_T - top-level template for FGA_POLICY.
  This template puts out
   - the opening FGA_POLICY element (with xmlns and version attributes)
   - NAME elements

******************************************************************** -->
 <xsl:template match="FGA_POLICY_T">
  <xsl:element name="FGA_POLICY"  namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="SCHEMA">
    <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:value-of select="BASE_OBJ/NAME"/>
   </xsl:element>
   <xsl:element name="POLICY_NAME">
    <xsl:value-of select="NAME"/>
   </xsl:element>
   <xsl:if test="PTXT">
    <xsl:element name="AUDIT_CONDITION">
     <xsl:value-of select="PTXT"/>
    </xsl:element>
   </xsl:if>
   <xsl:if test="PCOL/PCOL_ITEM">
    <xsl:element name="AUDIT_COLUMN_LIST">
     <xsl:for-each select="PCOL/PCOL_ITEM">
      <xsl:element name="AUDIT_COLUMN_LIST_ENTRY">
       <xsl:element name="NAME">
        <xsl:value-of select="AUDIT_COLUMN"/>
       </xsl:element>
      </xsl:element>
     </xsl:for-each>
    </xsl:element>
   </xsl:if>
   <xsl:if test="PFSCHEMA">
    <xsl:element name="HANDLER_SCHEMA">
     <xsl:value-of select="PFSCHEMA"/>
    </xsl:element>
   </xsl:if>
   <xsl:if test="PFNAME">
    <xsl:element name="HANDLER_MODULE">
     <xsl:if test="PPNAME">
      <xsl:value-of select="PPNAME"/>
      <xsl:text>.</xsl:text>
     </xsl:if>
     <xsl:value-of select="PFNAME"/>
    </xsl:element>
   </xsl:if>
   <xsl:element name="ENABLE">
    <xsl:choose>
     <xsl:when test="ENABLE_FLAG = 1">
      <xsl:text>Y</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>N</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <xsl:element name="STATEMENT_TYPE_LIST">
    <!--
      The stmt_type uses 4 bits, values 8, 4, 2, and 1.  These represent
      DELETE, UPDATE, INSERT AND SELECT.
   -->
    <!-- If bit 8 is set, is  'DELETE' -->
    <xsl:if test="STMT_TYPE >= 8">
     <xsl:element name="STATEMENT_TYPE_LIST_ENTRY">
      <xsl:element name="NAME">
       <xsl:text>DELETE</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:if>
    <!-- If bit 4 is set, is 'UPDATE'
  -->
    <xsl:if test="(STMT_TYPE mod 8)>=4">
     <xsl:element name="STATEMENT_TYPE_LIST_ENTRY">
      <xsl:element name="NAME">
       <xsl:text>UPDATE</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:if>
    <!-- If bit 2 is set, is 'INSERT'
  -->
    <xsl:if test="(STMT_TYPE mod 4)=2">
     <xsl:element name="STATEMENT_TYPE_LIST_ENTRY">
      <xsl:element name="NAME">
       <xsl:text>INSERT</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:if>
    <!-- If bit 1 is set, is 'SELECT'
  -->
    <xsl:if test="(STMT_TYPE mod 2)=1">
     <xsl:element name="STATEMENT_TYPE_LIST_ENTRY">
      <xsl:element name="NAME">
       <xsl:text>SELECT</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:if>
   </xsl:element>
   <!-- bit 7 set to 1 indicates DB (AUDIT_TRAIL having value 64)
       and set to 0 indicates DB_EXTENDED -->
   <xsl:element name="AUDIT_TRAIL">
    <xsl:choose>
     <xsl:when test="AUDIT_TRAIL = 0">
      <xsl:text>DB_EXTENDED</xsl:text>
     </xsl:when>
     <!-- ??????? what value for EXTENTED and XML -->
     <!-- when it is  XML the bit 7 is set -->
     <xsl:otherwise>
      <xsl:text>DB</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <!-- need ?? DBMS_FGA. -->
   <xsl:element name="AUDIT_COLUMN_OPTS">
    <xsl:choose>
     <xsl:when test="PCOL_OPT = 128">
      <xsl:text>ALL_COLUMNS</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>ANY_COLUMNS</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
