<?xml version="1.0"?>
<!-- 
NAME
    kuprocoj.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_procobj_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     07/18/03 - Bug 3045926: restructure ku_procobj_lines
    htseng      06/12/03 - bug 3006177 : PL/SQL BEGIN/END block too big
    htseng      02/24/03 - fix bug 2811588, need a new line
    lbarton     01/22/03 - params SQLFILE, CURRENT_SCHEMA
    lbarton     12/09/02 - new types for procedural objects
    lbarton     11/07/02 - put BEGIN END around multiple EXP_STRING_ITEMs
    lbarton	10/01/02 - bugfix
    htseng	08/02/02 - add grantee parse param
    htseng 	07/26/02 - add more parse parmas
    lbarton	08/02/02 - transportable export
    htseng	05/23/02 - htseng_proc_obj_api
    htseng	05/21/02 - remove PROCDEPOBJG_T to kuprocoj.xsl.
    htseng	05/08/02 - remove CLASS parameter.
    htseng	04/26/02 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="TRANSPORTABLE">0</xsl:param>
 <xsl:param name="CONNECT_PROCEDURE" select=""/>
 <xsl:param name="CURRENT_SCHEMA" select=""/>
 <xsl:param name="SQLFILE">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="PROCOBJ_T">
  <xsl:apply-templates select="PLSQL">
   <xsl:with-param name="Objecttype">PROCOBJ</xsl:with-param>
   <xsl:with-param name="Schemanode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="Namenode" select="SCHEMA_OBJ/NAME"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="PROCDEPOBJ_T">
  <xsl:apply-templates select="PLSQL">
   <xsl:with-param name="Objecttype">PROCDEPOBJ</xsl:with-param>
   <xsl:with-param name="Schemanode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="Namenode" select="SCHEMA_OBJ/NAME"/>
   <xsl:with-param name="Baseschemanode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="Basenamenode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="Baseobjecttype" select="BASE_OBJ/TYPE"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="PROCACTSCHEMA_T">
  <xsl:apply-templates select="PLSQL">
   <xsl:with-param name="Objecttype">PROCACT_SCHEMA</xsl:with-param>
   <xsl:with-param name="Schemanode" select="SCHEMA_OBJ/OWNER_NAME"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="PROCGRANT_T | PROCAUDIT_T">
  <xsl:apply-templates select="PLSQL">
   <xsl:with-param name="Objecttype">
    <xsl:choose>
     <xsl:when test="local-name(.)='PROCGRANT_T'">PROC_SYSTEM_GRANT</xsl:when>
     <xsl:when test="local-name(.)='PROCAUDIT_T'">PROC_AUDIT</xsl:when>
     <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="PROCOBJA_T |PROCDEPOBJA_T | PROCACTINS_T">
  <xsl:apply-templates select="PLSQL">
   <xsl:with-param name="Objecttype">
    <xsl:choose>
     <xsl:when test="local-name(.)='PROCOBJA_T'">PROCOBJ_AUDIT</xsl:when>
     <xsl:when test="local-name(.)='PROCDEPOBJA_T'">PROCDEPOBJ_AUDIT</xsl:when>
     <xsl:when test="local-name(.)='PROCACTINS_T'">PROCACT_INSTANCE</xsl:when>
     <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="Baseschemanode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="Basenamenode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="Baseobjecttype" select="BASE_OBJ/TYPE"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="PLUGTS_BLK_T">
  <xsl:apply-templates select="PLSQL">
   <xsl:with-param name="Objecttype">PLUGTS_BLK</xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="PROCACTSYS_T">
  <xsl:apply-templates select="PLSQL">
   <xsl:with-param name="Objecttype">PROCACT_SYSTEM</xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="PROCOBJG_T | PROCDEPOBJG_T">
  <xsl:apply-templates select="PLSQL">
   <xsl:with-param name="Objecttype">
    <xsl:choose>
     <xsl:when test="local-name(.)='PROCOBJG_T'">PROCOBJ_GRANT</xsl:when>
     <xsl:when test="local-name(.)='PROCDEPOBJG_T'">PROCDEPOBJ_GRANT</xsl:when>
     <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="Baseschemanode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="Basenamenode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="Baseobjecttype" select="BASE_OBJ/TYPE"/>
  </xsl:apply-templates>
 </xsl:template>
</xsl:stylesheet>
