<?xml version="1.0"?>
<!-- 
NAME
    kudvfl.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL 
    conversion of ku$_dv_factor_link_t UDTs
    corresponding to Database Vault Factor Links created by ADD_FACTOR_LINK
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    pknaggs     07/07/08 - bug 6938028: add Factor support for DVPS.
    pknaggs     07/07/08 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import the kucommon.xsl script, otherwise this template will never get invoked. See line 43 in kucommon.xsl, where the comment is "Top level template for all objects", this is the xsl equivalent of 'main'.  -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- Parameters required for DoParse to function correctly. -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param> 
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <!-- Template to create a new Database Vault Factor Link -->
 <xsl:template match="DVPS_FACTOR_LINK_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_MACADM</xsl:with-param>
   <xsl:with-param name="ObjectType">DVPS_FACTOR_LINK</xsl:with-param>
  </xsl:call-template>      
  <xsl:text>BEGIN DVSYS.DBMS_MACADM.ADD_FACTOR_LINK(parent_factor_name => </xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="PARENT_FACTOR_NAME"/>
   <xsl:with-param name="Leading">'</xsl:with-param>
   <xsl:with-param name="Trailing">'</xsl:with-param>
   <xsl:with-param name="NullVal">NULL</xsl:with-param>
  </xsl:call-template>
  <xsl:text>, child_factor_name => </xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="CHILD_FACTOR_NAME"/>
   <xsl:with-param name="Leading">'</xsl:with-param>
   <xsl:with-param name="Trailing">'</xsl:with-param>
   <xsl:with-param name="NullVal">NULL</xsl:with-param>
  </xsl:call-template>
  <xsl:text>, label_indicator => </xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="LABEL_INDICATOR"/>
   <xsl:with-param name="Leading">'</xsl:with-param>
   <xsl:with-param name="Trailing">'</xsl:with-param>
   <xsl:with-param name="NullVal">NULL</xsl:with-param>
  </xsl:call-template>
  <xsl:text>); END;</xsl:text>
  <!-- Terminate inner SQL statement -->
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
