<?xml version="1.0"?>
<!-- 
NAME
    kuctx.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_context_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton	11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng	12/18/02 - add EXPORT parameter
    htseng	08/02/02 - add grantee parse param
    htseng	07/26/02 - add more parse params
    htseng	09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	06/01/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="CONTEXT_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">CONTEXT</xsl:with-param>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text> CREATE </xsl:text>
  <xsl:if test="$EXPORT=0">
   <xsl:text>OR REPLACE </xsl:text>
  </xsl:if>
  <xsl:text>CONTEXT </xsl:text>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Object" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text> USING </xsl:text>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Object" select="SCHEMA_NAME"/>
  </xsl:call-template>
  <xsl:text>.</xsl:text>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Object" select="PACKAGE_NAME"/>
  </xsl:call-template>
  <xsl:if test="FLAGS=1">
   <xsl:text> INITIALIZED EXTERNALLY </xsl:text>
  </xsl:if>
  <xsl:if test="FLAGS=2">
   <xsl:text> ACCESSED GLOBALLY</xsl:text>
  </xsl:if>
  <xsl:if test="FLAGS=4">
   <xsl:text> INITIALIZED GLOBALLY</xsl:text>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
