<?xml version="1.0" ?>
<!--
NAME
    cmkumview.xsl
DESCRIPTION
    Convert mdapi materialized-view document to editable XML

MODIFIED        MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    abodge      11/08/04 - Fix CACHE etc. atts 
    xshen       09/22/04 - compare options
    ngade       09/01/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>
<xsl:import href="cmkustorage.xsl"/>
<xsl:import href="cmkutable.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="M_VIEW_LOG_T">
  <MATERIALIZED_VIEW_LOG>
    <SCHEMA>
      <xsl:value-of select="MVIEWLOG/MOWNER"/>
    </SCHEMA>

    <NAME>
      <xsl:value-of select="MVIEWLOG/LOG"/>
    </NAME>

    <MASTER_NAME>
      <xsl:value-of select="MVIEWLOG/MASTER"/>
    </MASTER_NAME>

    <!-- Storage Attributes -->
    <xsl:if test="$IGNORE_PHYSICAL_ATTS=0">
      <PHYSICAL_PROPERTIES>
        <xsl:call-template name="DoSegmentAttributes">
          <xsl:with-param name="ParentNode" select="MVIEWLOG_TAB"/>
        </xsl:call-template>
      </PHYSICAL_PROPERTIES>
    </xsl:if>

    <!-- Filter Columns -->
    <xsl:if test = "MVIEWLOG/FC_COUNT > 0">
      <xsl:if test="MVIEWLOG/FC_LIST/FC_LIST_ITEM">
        <FC_LIST>
          <xsl:for-each select = "MVIEWLOG/FC_LIST/FC_LIST_ITEM">
            <xsl:sort select="COLNAME"/>
            <FC_LIST_ITEM NAME="{COLNAME}">
              <NAME>
                <xsl:value-of select="COLNAME"/>
              </NAME>
            </FC_LIST_ITEM>
          </xsl:for-each>
        </FC_LIST>
      </xsl:if>
    </xsl:if>

    <PRIMARY_KEY>
      <xsl:choose>
        <xsl:when test="(MVIEWLOG/FLAG mod 4) >= 2">
          <xsl:text>Y</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>N</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </PRIMARY_KEY>

    <DEGREE>
      <xsl:choose>
        <xsl:when test="MVIEWLOG_TAB/DEGREE=32767">
          <xsl:text>DEFAULT</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="MVIEWLOG_TAB/DEGREE"/>
        </xsl:otherwise>
      </xsl:choose>
    </DEGREE>

    <ROWID>
      <xsl:choose>
        <xsl:when test="(MVIEWLOG/FLAG mod 2) =1">
          <xsl:text>Y</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>N</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </ROWID>

    <SEQUENCE>
      <xsl:choose>
        <xsl:when test= "(MVIEWLOG/FLAG mod 2048) >= 1024">
          <xsl:text>Y</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>N</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </SEQUENCE>

    <INCLUDE_NEW_VALUE>
      <xsl:choose>
        <xsl:when test="(MVIEWLOG/FLAG mod 32) >= 16">
          <xsl:text>Y</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>N</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </INCLUDE_NEW_VALUE>

    <xsl:call-template name="DoParallel">
     <xsl:with-param name="FlagsParent" select="MVIEWLOG_TAB"/>
    </xsl:call-template>

  </MATERIALIZED_VIEW_LOG>
</xsl:template>
</xsl:stylesheet>
