<?xml version="1.0" ?>
<!--
NAME
    cmkufull.xsl
DESCRIPTION
    Convert mdapi FULL_TYPE_T to FULL_TYPE document (editable XML)
    CM currently handles the type spec and the type body together,
    so there is no split between the specification and the body,
    as there is in kufull.xsl.

MODIFIED    MM/DD/YY
    abodge  10/03/11 - Use source gen from kusource.xsl
    pkalire 05/15/08 - Merge 11GC functionality
    abodge  06/20/05 - abodge_support_udt
    abodge  06/20/05 - More UDT work 
    abodge  06/16/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>
<xsl:import href="cmkuproc.xsl"/>
<xsl:import href="../kusource.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<!-- Using kusource.xsl instead
<xsl:template name="getSourceLines">
  <xsl:param name="SourceObj"/>  
  <SOURCE>
    <xsl:if test="$SourceObj">
      <xsl:for-each select="$SourceObj/SOURCE_LINES_ITEM">
        <xsl:value-of select="SOURCE"/>
      </xsl:for-each>
    </xsl:if>
  </SOURCE>   
</xsl:template>
-->

<xsl:template match="FULL_TYPE_T">
 <FULL_TYPE>
  <xsl:call-template name="DoSchemaWithMapping">
   <xsl:with-param name="CurrentSchema" select="SCHEMA_OBJ/OWNER_NAME"/>
  </xsl:call-template>
  <NAME>
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
  </NAME> 
  <TYPE_SPECIFICATION>
   <xsl:choose>
    <xsl:when test="TYPE_T/SCHEMA_OBJ/STATUS=1">  
     <STATUS>
       <xsl:text>VALID</xsl:text>
     </STATUS> 
    </xsl:when>
    <xsl:otherwise>
     <STATUS>
       <xsl:text>INVALID</xsl:text>
     </STATUS> 
    </xsl:otherwise>       
   </xsl:choose>
   <SOURCE>
    <xsl:call-template name="ProcObjType">
     <xsl:with-param name="NodeName" select="'TYPE_T'"/>
    </xsl:call-template>
    <xsl:text>&#x20;</xsl:text>
    <xsl:apply-templates select="TYPE_T/SCHEMA_OBJ"/>
    <xsl:choose>
     <xsl:when test="VERS_MAJOR=1 and VERS_MINOR=0">
      <xsl:apply-templates select="TYPE_T/SOURCE_LINES"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoSourceLines">
        <xsl:with-param name="SourceLines" select="TYPE_T/SOURCE_LINES"/>
      </xsl:call-template>    
     </xsl:otherwise>
    </xsl:choose>
   </SOURCE>
  </TYPE_SPECIFICATION>
  <xsl:if test="TYPE_BODY_T">
   <TYPE_BODY>
    <xsl:choose>
     <xsl:when test="TYPE_BODY_T/SCHEMA_OBJ/STATUS=1">  
      <STATUS>
        <xsl:text>VALID</xsl:text>
      </STATUS> 
     </xsl:when>
     <xsl:otherwise>
      <STATUS>
        <xsl:text>INVALID</xsl:text>
      </STATUS> 
     </xsl:otherwise>       
    </xsl:choose>
    <SOURCE>
     <xsl:call-template name="ProcObjType">
      <xsl:with-param name="NodeName" select="'TYPE_BODY_T'"/>
     </xsl:call-template>
     <xsl:text>&#x20;</xsl:text>
     <xsl:apply-templates select="TYPE_BODY_T/SCHEMA_OBJ"/>
     <xsl:choose>
      <xsl:when test="VERS_MAJOR=1 and VERS_MINOR=0">
       <xsl:apply-templates select="TYPE_BODY_T/SOURCE_LINES">
        <xsl:with-param name="OBJTYPE">2</xsl:with-param>
       </xsl:apply-templates>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="DoSourceLines">
        <xsl:with-param name="SourceLines" select="TYPE_BODY_T/SOURCE_LINES"/>
       </xsl:call-template>    
      </xsl:otherwise>
     </xsl:choose>
    </SOURCE>
   </TYPE_BODY>
  </xsl:if>
 </FULL_TYPE>
</xsl:template>

</xsl:stylesheet>
