@echo off
if "%1"=="" goto INPUT_ERROR
if "%2"=="" goto INPUT_ERROR
if "%3"=="" goto INPUT_ERROR

set ROWTAG='^<row^>'
set ENDROWTAG='^</row^>'
set COLTAG='^<col^>^<![CDATA['
set ENDCOLTAG=']]^>^</col^>'

REM Clear any other dat files
echo "Clearing older data files"
DEL *.dat > NUL

echo "Connnecting to %1 as %2"
db2 -r connect.dat "connect to %1 user %2 using %3"

IF %ERRORLEVEL% NEQ 0 goto STEP_FAILED


:STEP2
rem GET SCHEMA QUERY. 
echo "Get all schemas"
db2 +o -x -r schemas.dat "select SCHEMANAME SCHEMANAME from SYSCAT.SCHEMATA WHERE DEFINER <> 'SYSIBM' AND SCHEMANAME <> 'NULLID' AND SCHEMANAME <> 'SQLJ' AND SCHEMANAME <> 'SYSTOOLS'"

IF %ERRORLEVEL% NEQ 0 goto STEP_FAILED

:STEP5

rem Loop through file containing schema names and extract db objects for each of them

for /f %%s in ('type schemas.dat') do (

    echo Capturing schema %%s

    rem Create schema directory

         DEL /Q %%s\*
         RD %%s
         mkdir %%s


    REM GET TABLES QUERY. 
    echo Get all tables for schema %%s
    db2 -x +o -r %%s/tables.dat "select %ROWTAG%, %COLTAG%||COLUMNS.TABSCHEMA||%ENDCOLTAG%, %COLTAG%||COLUMNS.TABNAME||%ENDCOLTAG%, %COLTAG%||COLUMNS.COLNAME||%ENDCOLTAG%, %COLTAG%||(CASE WHEN (COLUMNS.CODEPAGE = 0 and (COLUMNS.TYPENAME = 'VARCHAR' OR COLUMNS.TYPENAME = 'CHAR' OR COLUMNS.TYPENAME = 'LONG VARCHAR' OR  COLUMNS.TYPENAME = 'CHARACTER')) THEN COLUMNS.TYPENAME||' FOR BIT DATA' ELSE COLUMNS.TYPENAME END)||%ENDCOLTAG%, %COLTAG%||CHAR(COLUMNS.LENGTH)||%ENDCOLTAG%, %COLTAG%||CHAR(COLUMNS.SCALE)||%ENDCOLTAG%, %COLTAG%||COLUMNS.NULLS||%ENDCOLTAG%, %COLTAG%||COALESCE(COLUMNS.DEFAULT, '')||%ENDCOLTAG%, %ENDROWTAG% from SYSCAT.COLUMNS COLUMNS, SYSCAT.TABLES TABLES WHERE COLUMNS.TABSCHEMA = '%%s' AND COLUMNS.TABNAME = TABLES.TABNAME AND COLUMNS.TABSCHEMA = TABLES.TABSCHEMA AND TABLES.TYPE = 'T' ORDER BY COLUMNS.TABNAME, COLUMNS.COLNO"

    REM GET SYNONYMS QUERY. 
    echo Get all synonyms for schema %%s
    db2 -x +o -r %%s/synonyms.dat "select %ROWTAG%, %COLTAG%||TABNAME||%ENDCOLTAG%, %COLTAG%||BASE_TABSCHEMA||%ENDCOLTAG%, %COLTAG%||BASE_TABNAME||%ENDCOLTAG%, %ENDROWTAG%  from syscat.tables where tabschema = '%%s' and type = 'A'"

    REM GET VIEW QUERY.
    echo Get all views for schema %%s

    db2 -x +o -r %%s/views.dat "select %ROWTAG%, %COLTAG%||VIEWSCHEMA||%ENDCOLTAG%, %COLTAG%||VIEWNAME||%ENDCOLTAG%, %COLTAG%||COALESCE(TEXT, '')||%ENDCOLTAG%, %COLTAG%||DEFINER||%ENDCOLTAG%, %COLTAG%||READONLY||%ENDCOLTAG%, %COLTAG%||VALID||%ENDCOLTAG%, %ENDROWTAG% from syscat.views WHERE VIEWSCHEMA = '%%s' ORDER BY VIEWNAME"


    REM GET INDEXES QUERY.
    echo Get all indexes for schema %%s
    db2 -x +o -r %%s/indexes.dat "select %ROWTAG%, %COLTAG%||X.INDSCHEMA||%ENDCOLTAG%, %COLTAG%||X.INDNAME||%ENDCOLTAG%, %COLTAG%||X.INDEXTYPE||%ENDCOLTAG%, %COLTAG%||X.TABSCHEMA||%ENDCOLTAG%, %COLTAG%||X.TABNAME||%ENDCOLTAG%, %COLTAG%||X.UNIQUERULE||%ENDCOLTAG%,%COLTAG%||Y.COLNAME||%ENDCOLTAG%, %COLTAG%||CHAR(Y.COLSEQ)||%ENDCOLTAG%, %ENDROWTAG% from (select INDSCHEMA, INDNAME, INDEXTYPE, TABNAME, TABSCHEMA, UNIQUERULE from SYSCAT.INDEXES WHERE INDSCHEMA = '%%s' AND UNIQUERULE <> 'P') X INNER JOIN (select INDSCHEMA, INDNAME, COLNAME, COLSEQ from SYSCAT.INDEXCOLUSE WHERE INDSCHEMA = '%%s') Y ON (X.INDNAME = Y.INDNAME AND X.INDSCHEMA = Y.INDSCHEMA) ORDER BY X.TABNAME, X.INDNAME, Y.COLSEQ"

    REM GET TRIGGERS QUERY. 
    echo Get all triggers for schema %%s
    
    db2 -x +o -r %%s/triggers.dat "select %ROWTAG%, %COLTAG%||TRIGSCHEMA||%ENDCOLTAG%, %COLTAG%||TRIGNAME||%ENDCOLTAG%, %COLTAG%||DEFINER||%ENDCOLTAG%, %COLTAG%||TABSCHEMA||%ENDCOLTAG%, %COLTAG%||TABNAME||%ENDCOLTAG%, %COLTAG%||TRIGEVENT||%ENDCOLTAG%, %COLTAG%||VALID||%ENDCOLTAG%, %COLTAG%||COALESCE(TEXT, '')||%ENDCOLTAG%, %COLTAG%||COALESCE(REMARKS, '')||%ENDCOLTAG%, %ENDROWTAG% from SYSCAT.TRIGGERS WHERE TRIGSCHEMA = '%%s'"

    REM The for GET  Promary Key CONSTRAINT QUERY. 
    echo Get all primary keys for schema %%s

    db2 -x +o -r %%s/primarykeys.dat "select %ROWTAG%, %COLTAG%||X.CONSTNAME||%ENDCOLTAG%, %COLTAG%||X.TYPE||%ENDCOLTAG%, %COLTAG%||X.TABSCHEMA||%ENDCOLTAG%, %COLTAG%||X.TABNAME||%ENDCOLTAG%, %COLTAG%||Z.COLNAME||%ENDCOLTAG%, %COLTAG%||CHAR(Z.COLSEQ)||%ENDCOLTAG%, %COLTAG%||COALESCE(X.REMARKS, '')||%ENDCOLTAG%, %ENDROWTAG% from (select CONSTNAME, TYPE, TABSCHEMA, TABNAME, REMARKS from SYSCAT.TABCONST where (type = 'P' OR type = 'U')) X FULL OUTER JOIN (select COLNAME,  COLSEQ, CONSTNAME, TABSCHEMA, TABNAME from SYSCAT.KEYCOLUSE) Z on (X.CONSTNAME = Z.CONSTNAME and X.TABSCHEMA = Z.TABSCHEMA and X.TABNAME = Z.TABNAME) WHERE X.TABSCHEMA='%%s' ORDER BY X.CONSTNAME"

    REM GET  Check constraints QUERY.
    echo Get all Check constraints for schema %%s

    db2 -x +o -r %%s/checkConstraints.dat "SELECT %ROWTAG%, %COLTAG%||A.CONSTNAME||%ENDCOLTAG%, %COLTAG%|| COALESCE(TEXT, '') ||%ENDCOLTAG%, %COLTAG%|| A.TABSCHEMA||%ENDCOLTAG%, %COLTAG%|| A.TABNAME ||%ENDCOLTAG%, %COLTAG%|| COLNAME ||%ENDCOLTAG%, %ENDROWTAG% FROM SYSCAT.CHECKS A , SYSCAT.COLCHECKS B WHERE A.CONSTNAME = B.CONSTNAME AND A.TABSCHEMA = B.TABSCHEMA AND A.TABNAME=B.TABNAME AND A.TABSCHEMA = '%%s'"

    REM The command for GET Procedures. 
    echo Get all procedures for schema %%s
    db2 -x +o -r %%s/routines.dat "select %ROWTAG%, %COLTAG%||ROUTINESCHEMA||%ENDCOLTAG%, %COLTAG%||ROUTINENAME||%ENDCOLTAG% NAME, CASE ROUTINETYPE WHEN 'P' THEN %COLTAG%||'PROCEDURE'||%ENDCOLTAG% WHEN 'F' THEN %COLTAG%||'FUNCTION'||%ENDCOLTAG% WHEN 'M' THEN %COLTAG%||'FUNCTION'||%ENDCOLTAG% ELSE %COLTAG%||'NONE'||%ENDCOLTAG% END ROUTINETYPE, %COLTAG%||COALESCE(TEXT, '')||%ENDCOLTAG%, %COLTAG%||CHAR(CREATE_TIME)||%ENDCOLTAG%, %COLTAG%||COALESCE(REMARKS, '')||%ENDCOLTAG%, %ENDROWTAG% from SYSCAT.ROUTINES where ROUTINESCHEMA = '%%s'"

    REM The command for GET foreign keys. 
    echo Get all keys for schema %%s
    db2 -x +o -r %%s/foreignKeys.dat "select %ROWTAG%, %COLTAG%||A.CONSTNAME||%ENDCOLTAG%, %COLTAG%||A.TABNAME||%ENDCOLTAG%, %COLTAG%||A.TABSCHEMA||%ENDCOLTAG%, %COLTAG%||A.REFKEYNAME||%ENDCOLTAG%, %COLTAG%||A.REFTABSCHEMA||%ENDCOLTAG%, %COLTAG%||A.REFTABNAME||%ENDCOLTAG%, %COLTAG%||B.COLNAME||%ENDCOLTAG%, %COLTAG%||B.REFCOLNAME||%ENDCOLTAG%, %COLTAG%||CHAR(B.COLSEQ)||%ENDCOLTAG%, %COLTAG%||C.TYPE||%ENDCOLTAG%, %COLTAG%||COALESCE(C.REMARKS, '')||%ENDCOLTAG%, %ENDROWTAG% from (SELECT * from SYSCAT.REFERENCES WHERE TABSCHEMA = '%%s') A JOIN  (SELECT X.CONSTNAME, X.COLNAME, X.TABNAME, X.TABSCHEMA, Y.CONSTNAME REFCONSTNAME, Y.COLNAME REFCOLNAME, Y.TABNAME REFTABNAME, Y.TABSCHEMA REFTABSCHEMA, X.COLSEQ from (SELECT * from SYSCAT.KEYCOLUSE WHERE TABSCHEMA = '%%s') X JOIN (SELECT * from SYSCAT.KEYCOLUSE) Y on (X.COLSEQ = Y.COLSEQ) ) B  on (A.CONSTNAME = B.CONSTNAME and A.TABNAME = B.TABNAME and A.TABSCHEMA = B.TABSCHEMA and A.REFKEYNAME = B.REFCONSTNAME and A.REFTABNAME = B.REFTABNAME and A.REFTABSCHEMA = B.REFTABSCHEMA), SYSCAT.TABCONST C WHERE (A.CONSTNAME = C.CONSTNAME and A.TABNAME = C.TABNAME and A.TABSCHEMA = C.TABSCHEMA)"
)

goto EXIT

:INPUT_ERROR
echo Usage: startDump [database] [user] [password]
goto exit

:STEP_FAILED
 echo "Step failed"
 goto EXIT

:EXIT
rem ** REMOVE THE VALUE FOR THE END OF ROW DELIMITER ENVIRONMENT VARIABLE
set ROWTAG=
set ENDROWTAG=
rem ** REMOVE THE VALUE FOR THE END OF COLUMN ENVIRONMENT VARIABLE
set COLTAG=
set ENDCOLTAG=
