if [[ $# != 1 ]]; then
	echo "Invalid arguments to get procedures." ;
	exit 11;
fi

#cat schemas.dat | while read SCHEMA_NAME
# Loop through file containing schema names and extract routines for each of them
while read SCHEMA_NAME
do
     echo "Get all procedures for schema $SCHEMA_NAME";
     procedureFile="${SCHEMA_NAME}/""routines.dat";
     # GET PROCEDURES QUERY. */
     db2 -x +o -r $procedureFile "select "$ROWTAG", "$COLTAG"||ROUTINESCHEMA||"$ENDCOLTAG", "$COLTAG"||ROUTINENAME||"$ENDCOLTAG" NAME, 
  		CASE ROUTINETYPE 
         WHEN 'P' THEN "$COLTAG"||'PROCEDURE'||"$ENDCOLTAG" 
         WHEN 'F' THEN "$COLTAG"||'FUNCTION'||"$ENDCOLTAG" 
         WHEN 'M' THEN "$COLTAG"||'FUNCTION'||"$ENDCOLTAG" 
         ELSE "$COLTAG"||'NONE'||"$ENDCOLTAG" 
          END ROUTINETYPE, 
  		"$COLTAG"||COALESCE(TEXT, '')||"$ENDCOLTAG", "$COLTAG"||CHAR(CREATE_TIME)||"$ENDCOLTAG", "$COLTAG"||COALESCE(REMARKS, '')||"$ENDCOLTAG", "$ENDROWTAG" from SYSCAT.ROUTINES where ROUTINESCHEMA = '${SCHEMA_NAME}'";
  done < $1
