-------------------------------------------------------------------------------
-- Name: Cleanup Repository
--
-- Author: Barry McGillin
-- Date: 19:06:2007
-- Description: This script will pick out the specific objects that could be
--              created by the repository creation and it cleans them out.
--              unlike the remove repository, which deals with registered tables
--              this will nuke anything from the repository.
--
--              The only caveat with this is that sometimes, we install a repo
--              into an existing schema and, if the user has similar objects,
--              then these could get nuked too.
--
--------------------------------------------------------------------------------
DECLARE
sequence_not_found EXCEPTION;
pragma exception_init(sequence_not_found, -2289);

-- CURSORS --
CURSOR drop_package is select 'drop package '||object_name query_item from user_objects where (object_name like 'MD_%' OR object_name like 'MIGR_%' OR object_name like 'MIGRATION%'  )
and OBJECT_TYPE='PACKAGE';
CURSOR drop_view is select 'drop view '||view_name query_item from user_views where view_name like 'MGV_ALL%';
CURSOR drop_table is select 'Drop table '||table_name||' cascade constraints' query_item from user_tables 
where table_name in ('MD_OTHER_OBJECTS','MD_SYNONYMS','MD_REPOVERSIONS','MD_CONSTRAINTS','MD_CONSTRAINT_DETAILS'
,'MD_CATALOGS','MIGRLOG','MD_GROUP_PRIVILEGES','MD_USER_PRIVILEGES','MIGR_DATATYPE_TRANSFORM_MAP'
,'MIGR_DATATYPE_TRANSFORM_RULE','MD_MIGR_PARAMETER','MD_MIGR_DEPENDENCY','MIGR_GENERATION_ORDER'
,'MD_REGISTRY','MD_MIGR_WEAKDEP','MIGRATION_RESERVED_WORDS','MD_PROJECTS','MD_CONNECTIONS','MD_USERS'
,'MD_SCHEMAS','MD_TABLES','MD_VIEWS','MD_INDEXES','MD_COLUMNS','MD_INDEX_DETAILS','MD_GROUPS'                      
,'MD_GROUP_MEMBERS','MD_PRIVILEGES','MD_USER_DEFINED_DATA_TYPES','MD_TRIGGERS','MD_STORED_PROGRAMS'             
,'MD_TABLESPACES','MD_ADDITIONAL_PROPERTIES','MD_DERIVATIVES','MD_SEQUENCES','MD_PACKAGES');
CURSOR drop_type is select 'drop TYPE '||object_name query_item from user_objects where OBJECT_TYPE like '%TYPE%' AND
OBJECT_NAME IN ('NAME_AND_COUNT_T','NAME_AND_COUNT_ARRAY','OBJECTIDLIST','NAMELIST','MIGR_FILTER_SET','MIGR_FILTER',
                'MIGR_REPORT_DETAIL_ROW','MIGR_REPORT_DETAIL_TABLE','MIGR_REPORT_SUM_ROW','MIGR_REPORT_SUM_TABLE') 
                order by object_id desc;

BEGIN
  for item in drop_package
  loop
    execute immediate item.query_item;
  end loop;
    for item in drop_view
  loop
    execute immediate item.query_item;
  end loop;
      for item in drop_table
  loop
    execute immediate item.query_item;
  end loop;
      for item in drop_type
  loop
     execute immediate item.query_item;
    --dbms_output.put_line(item.query_item);
  end loop;
  execute immediate 'DROP SEQUENCE DBOBJECTID_SEQUENCE'; 
  EXCEPTION
  WHEN sequence_not_found THEN NULL;
END;
/










