/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataXMLParserCallback;
import oracle.olapi.metadata.XMLParserCallback;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.UnresolvedIdentifier;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;
import oracle.olapi.syntax.parser.ExpParserTokenManager;
import oracle.olapi.syntax.parser.IdentifierResolver;
import oracle.olapi.syntax.parser.ParseException;
import oracle.olapi.syntax.parser.Token;

public abstract class SyntaxObject {
    private boolean m_IsValidated = true;
    private boolean m_IsDefinitionComplete = true;

    static void validateValue(Object object) {
        if (null == object) {
            throw new SyntaxException("ValueExpected");
        }
    }

    static void validateValues(Object[] objectArray, int n) {
        if (objectArray.length < n) {
            throw new SyntaxException("MinimumLengthArrayExpected");
        }
        if (null == objectArray) {
            throw new SyntaxException("ValueExpected");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (null != objectArray[i]) continue;
            throw new SyntaxException("ValueExpected");
        }
    }

    static void validateValues(List list, int n) {
        if (list.size() < n) {
            throw new SyntaxException("MinimumLengthArrayExpected");
        }
        if (null == list) {
            throw new SyntaxException("ValueExpected");
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            if (null != list.get(i)) continue;
            throw new SyntaxException("ValueExpected");
        }
    }

    static int validateEnum(String string, String[] stringArray, int n, int n2) {
        if (null == string) {
            throw new SyntaxException("ValueExpected");
        }
        for (int i = n; i < n2; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return i;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n2; ++i) {
            if (0 != i) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        throw new SyntaxException("InvalidValue", string, stringBuffer.toString());
    }

    static String validateEnum(String string, String[] stringArray) {
        return SyntaxObject.validateEnum(string, stringArray, stringArray);
    }

    static String validateEnum(String string, String[] stringArray, String[] stringArray2) {
        int n = SyntaxObject.validateEnum(string, stringArray, 0, stringArray.length);
        return stringArray2[n];
    }

    static void validateInteger(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            throw new SyntaxException("BadIntegerValue", new Integer(n).toString(), new Integer(n2).toString(), new Integer(n3).toString());
        }
    }

    static FunctionArgument[] getFunctionArgumentArrayClone(FunctionArgument[] functionArgumentArray) {
        if (null == functionArgumentArray) {
            return new FunctionArgument[0];
        }
        FunctionArgument[] functionArgumentArray2 = null;
        for (int i = functionArgumentArray.length - 1; i >= 0; --i) {
            if (null != functionArgumentArray[i]) {
                if (null == functionArgumentArray2) {
                    functionArgumentArray2 = new FunctionArgument[i + 1];
                }
                functionArgumentArray2[i] = functionArgumentArray[i];
                continue;
            }
            if (null == functionArgumentArray2) continue;
            throw new SyntaxException("ValueExpected");
        }
        if (null == functionArgumentArray2) {
            functionArgumentArray2 = new FunctionArgument[]{};
        }
        return functionArgumentArray2;
    }

    static FunctionArgument[] getFunctionArgumentArrayClone(List<FunctionArgument> list) {
        if (null == list) {
            return new FunctionArgument[0];
        }
        FunctionArgument[] functionArgumentArray = null;
        int n = list.size();
        for (int i = n - 1; i >= 0; --i) {
            if (null != list.get(i)) {
                if (null == functionArgumentArray) {
                    functionArgumentArray = new FunctionArgument[i + 1];
                }
                functionArgumentArray[i] = list.get(i);
                continue;
            }
            if (null == functionArgumentArray) continue;
            throw new SyntaxException("ValueExpected");
        }
        if (null == functionArgumentArray) {
            functionArgumentArray = new FunctionArgument[]{};
        }
        return functionArgumentArray;
    }

    final boolean isValidated() {
        return this.m_IsValidated;
    }

    final void setValidated(boolean bl) {
        this.m_IsValidated = bl;
    }

    public SyntaxObject validate(ValidationContext validationContext) {
        return this;
    }

    protected boolean checkIfDefinitionIsComplete() {
        return true;
    }

    final boolean areComponentsComplete(SyntaxObject[] syntaxObjectArray) {
        for (int i = 0; i < syntaxObjectArray.length; ++i) {
            if (syntaxObjectArray[i].isDefinitionComplete()) continue;
            return false;
        }
        return true;
    }

    final boolean areComponentsComplete(FunctionArgument[] functionArgumentArray) {
        for (int i = 0; i < functionArgumentArray.length; ++i) {
            SyntaxObject syntaxObject = (SyntaxObject)((Object)functionArgumentArray[i]);
            if (syntaxObject.isDefinitionComplete()) continue;
            return false;
        }
        return true;
    }

    protected final boolean isDefinitionComplete() {
        return this.m_IsDefinitionComplete;
    }

    final void setDefinitionComplete(boolean bl) {
        this.m_IsDefinitionComplete = bl;
    }

    protected final void initialize() {
        this.setDefinitionComplete(false);
        this.setValidated(false);
        if (this.checkIfDefinitionIsComplete()) {
            this.setDefinitionComplete(true);
            this.validate((XMLParserCallback)null);
        }
    }

    private SyntaxObject validate(XMLParserCallback xMLParserCallback) {
        Object object;
        if (this.isValidated()) {
            return this;
        }
        ValidationContext validationContext = new ValidationContext();
        SyntaxObject syntaxObject = validationContext.validate(this);
        List<UnresolvedIdentifier> list = validationContext.getUnresolvedIDs();
        if (this.isValid() || list.size() == 0) {
            return syntaxObject;
        }
        int n = 1;
        if (null != xMLParserCallback) {
            object = new String[list.size()];
            int n2 = 0;
            for (UnresolvedIdentifier unresolvedIdentifier : list) {
                object[n2++] = unresolvedIdentifier.toSyntax();
            }
            n = xMLParserCallback.processSyntaxIdentifiersError(syntaxObject.toSyntax(), (String[])object);
        }
        if (2 == n) {
            syntaxObject = null;
        } else if (3 != n) {
            object = list.get(0);
            object.getIDResolver().error(object.getIdentifier());
        }
        return syntaxObject;
    }

    abstract void toSyntax(SyntaxPrintingContext var1);

    String getOperator() {
        return null;
    }

    public abstract Object visit(SyntaxObjectVisitor var1, Object var2);

    public final String toSyntax() {
        return this.toSyntax(null, (List<Query>)null);
    }

    public final String toSyntax(String string) {
        return this.toSyntax(string, (List<Query>)null);
    }

    public final String toSyntax(String string, Query query) {
        ArrayList<Query> arrayList = new ArrayList<Query>();
        arrayList.add(query);
        return this.toSyntax(string, arrayList);
    }

    public final String toSyntax(String string, List<Query> list) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toSyntax(stringBuffer, string, list);
        return stringBuffer.toString();
    }

    public final void toSyntax(StringBuffer stringBuffer, String string, List<Query> list) {
        this.toSyntax(stringBuffer, string, list, false);
    }

    public final void toSyntax(StringBuffer stringBuffer, String string, List<Query> list, boolean bl) {
        this.toSyntax(stringBuffer, string, list, bl, null);
    }

    public final void toSyntax(StringBuffer stringBuffer, String string, List<Query> list, boolean bl, MetadataToXMLConverter metadataToXMLConverter) {
        SyntaxPrintingContext syntaxPrintingContext = new SyntaxPrintingContext(stringBuffer, string, list);
        syntaxPrintingContext.suppressNamespace(bl);
        syntaxPrintingContext.setXMLWriter(metadataToXMLConverter);
        syntaxPrintingContext.print(this);
    }

    public static SyntaxObject fromSyntax(String string, MdmMetadataProvider mdmMetadataProvider) {
        return SyntaxObject.fromSyntax(string, mdmMetadataProvider, null, false, null, null);
    }

    public static SyntaxObject fromSyntax(String string, MdmMetadataProvider mdmMetadataProvider, String string2) {
        return SyntaxObject.fromSyntax(string, mdmMetadataProvider, string2, false, null, null);
    }

    public static SyntaxObject fromSyntax(String string, MdmMetadataProvider mdmMetadataProvider, String string2, boolean bl) {
        return SyntaxObject.fromSyntax(string, mdmMetadataProvider, string2, bl, null, null);
    }

    public static SyntaxObject fromSyntax(String string, MdmMetadataProvider mdmMetadataProvider, String string2, boolean bl, List<Query> list) throws SyntaxException {
        return SyntaxObject.fromSyntax(string, mdmMetadataProvider, string2, bl, list, null);
    }

    public static SyntaxObject fromSyntax(String string, MdmMetadataProvider mdmMetadataProvider, String string2, boolean bl, List<Query> list, XMLParserCallback xMLParserCallback) throws SyntaxException {
        try {
            SyntaxObject syntaxObject = SyntaxObject.fromSyntax(new StringReader(string), mdmMetadataProvider, string2, bl, list, xMLParserCallback);
            return syntaxObject;
        }
        catch (SyntaxException syntaxException) {
            if (0 == syntaxException.getMessageID().compareTo("InvalidArguments")) {
                throw new SyntaxException("InvalidArguments", string);
            }
            throw syntaxException;
        }
    }

    public static SyntaxObject fromSyntax(Reader reader, MdmMetadataProvider mdmMetadataProvider, String string, boolean bl, List<Query> list, XMLParserCallback xMLParserCallback) throws SyntaxException {
        MetadataXMLParserCallback metadataXMLParserCallback = null;
        if (null == mdmMetadataProvider && null == xMLParserCallback) {
            xMLParserCallback = new XMLParserCallback(){

                @Override
                public int processError(String string, String string2, String string3) {
                    return 3;
                }

                @Override
                public int processSyntaxIdentifiersError(String string, String string2, String string3, String[] stringArray) {
                    return 3;
                }

                @Override
                public int processSyntaxIdentifiersError(String string, String[] stringArray) {
                    return 3;
                }
            };
        }
        if (xMLParserCallback instanceof MetadataXMLParserCallback) {
            metadataXMLParserCallback = (MetadataXMLParserCallback)xMLParserCallback;
        }
        IdentifierResolver identifierResolver = new IdentifierResolver(string, list, mdmMetadataProvider, metadataXMLParserCallback);
        ExpParserTokenManager expParserTokenManager = new ExpParserTokenManager(reader, identifierResolver, bl);
        ExpParser expParser = new ExpParser(expParserTokenManager);
        try {
            SyntaxObject syntaxObject = expParser.syntax_object();
            syntaxObject = syntaxObject.validate(xMLParserCallback);
            return syntaxObject;
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException;
        }
        catch (ParseException parseException) {
            throw SyntaxObject.throwParseException(parseException);
        }
        catch (Exception exception) {
            throw new SyntaxException("UnexpectedSyntaxError", exception.toString());
        }
    }

    public final boolean isValid() {
        return this.checkIfDefinitionIsComplete();
    }

    static SyntaxException throwParseException(ParseException parseException) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < parseException.expectedTokenSequences.length; ++i) {
            if (n < parseException.expectedTokenSequences[i].length) {
                n = parseException.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < parseException.expectedTokenSequences[i].length; ++j) {
                stringBuffer.append(parseException.tokenImage[parseException.expectedTokenSequences[i][j]]).append(" ");
            }
            if (0 != parseException.expectedTokenSequences[i][parseException.expectedTokenSequences[i].length - 1]) {
                stringBuffer.append("...");
            }
            stringBuffer.append(parseException.eol).append("    ");
        }
        String string = "";
        Token token = parseException.currentToken.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                string = string + " ";
            }
            if (token.kind == 0) {
                string = string + parseException.tokenImage[0];
                break;
            }
            string = string + parseException.add_escapes(token.image);
            token = token.next;
        }
        String string2 = Integer.valueOf(parseException.currentToken.next.beginLine).toString();
        String string3 = Integer.valueOf(parseException.currentToken.next.beginColumn).toString();
        String string4 = null;
        String string5 = null;
        string5 = parseException.expectedTokenSequences.length == 1 ? "ParsingError1" : "ParsingError2";
        string4 = "   " + stringBuffer.toString();
        return new SyntaxException(string5, new String[]{string, string2, string3, string4});
    }

    public final boolean equals(SyntaxObject syntaxObject, boolean bl) {
        boolean bl2 = false;
        if (null != syntaxObject) {
            if (bl) {
                if (this.toSyntax().compareToIgnoreCase(syntaxObject.toSyntax()) == 0) {
                    bl2 = true;
                }
            } else if (this.toSyntax().compareTo(syntaxObject.toSyntax()) == 0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public final boolean equals(SyntaxObject syntaxObject) {
        boolean bl = false;
        return this.equals(syntaxObject, bl);
    }
}

