/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.metadata.mdm.MdmDimensionedObject;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.Qualifier;
import oracle.olapi.syntax.SimpleCommand;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class AssignmentCommand
extends SimpleCommand {
    private BaseMetadataObjectReference m_Target;
    private Qualifier[] m_Qualifiers = null;
    private TypedExpression m_Rhs = null;

    public Qualifier[] getQualifiersInternal() {
        return this.m_Qualifiers;
    }

    private AssignmentCommand(MdmDimensionedObject mdmDimensionedObject, Qualifier[] qualifierArray, boolean bl, TypedExpression typedExpression) {
        AssignmentCommand.validateValue(mdmDimensionedObject);
        AssignmentCommand.validateValue(typedExpression);
        this.m_Qualifiers = null != qualifierArray ? (Qualifier[])qualifierArray.clone() : new Qualifier[0];
        this.m_Target = new MetadataObjectReference(mdmDimensionedObject, MdmDimensionedObject.class);
        this.m_Rhs = typedExpression;
        this.initialize();
    }

    private AssignmentCommand(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, Qualifier[] qualifierArray, boolean bl, TypedExpression typedExpression) {
        AssignmentCommand.validateValue(baseMetadataObjectReference);
        AssignmentCommand.validateValue(typedExpression);
        this.m_Qualifiers = null != qualifierArray ? (Qualifier[])qualifierArray.clone() : new Qualifier[0];
        this.m_Target = baseMetadataObjectReference;
        this.m_Rhs = typedExpression;
        this.initialize();
    }

    private static Qualifier[] createQualifierArray(List<Qualifier> list) {
        if (null == list) {
            return null;
        }
        Qualifier[] qualifierArray = new Qualifier[list.size()];
        list.toArray(qualifierArray);
        return qualifierArray;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("SET ");
        this.m_Target.toSyntax(syntaxPrintingContext);
        if (this.getQualifiersInternal().length > 0) {
            syntaxPrintingContext.append("[");
            for (int i = 0; i < this.getQualifiersInternal().length; ++i) {
                if (0 != i) {
                    syntaxPrintingContext.append(", ");
                }
                syntaxPrintingContext.print(this.getQualifiersInternal()[i]);
            }
            syntaxPrintingContext.append("]");
        }
        syntaxPrintingContext.append(" = ");
        syntaxPrintingContext.print(this.getRHSExpression());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        validationContext.pop();
        validationContext.validateComponents(this, this.getQualifiersInternal());
        this.m_Target = (BaseMetadataObjectReference)validationContext.validate(this.m_Target);
        this.m_Rhs = (TypedExpression)validationContext.validate(this.m_Rhs);
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.getRHSExpression().isDefinitionComplete()) {
            return false;
        }
        if (!this.areComponentsComplete(this.getQualifiersInternal())) {
            return false;
        }
        if (!this.m_Target.isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    public AssignmentCommand(MdmBaseMeasure mdmBaseMeasure, Qualifier[] qualifierArray, TypedExpression typedExpression) {
        this(mdmBaseMeasure, qualifierArray, true, typedExpression);
    }

    public AssignmentCommand(MdmBaseMeasure mdmBaseMeasure, List<Qualifier> list, TypedExpression typedExpression) {
        this(mdmBaseMeasure, AssignmentCommand.createQualifierArray(list), false, typedExpression);
    }

    public AssignmentCommand(MdmBaseAttribute mdmBaseAttribute, Qualifier[] qualifierArray, TypedExpression typedExpression) {
        this(mdmBaseAttribute, qualifierArray, true, typedExpression);
    }

    public AssignmentCommand(MdmBaseAttribute mdmBaseAttribute, List<Qualifier> list, TypedExpression typedExpression) {
        this(mdmBaseAttribute, AssignmentCommand.createQualifierArray(list), false, typedExpression);
    }

    public AssignmentCommand(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, List<Qualifier> list, TypedExpression typedExpression) {
        this(expParser, baseMetadataObjectReference, AssignmentCommand.createQualifierArray(list), false, typedExpression);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitAssignmentCommand(this, object);
    }

    public MdmBaseMeasure getBaseMeasure() {
        if (this.getTarget() instanceof MdmBaseMeasure) {
            return (MdmBaseMeasure)this.getTarget();
        }
        return null;
    }

    public MdmBaseAttribute getBaseAttribute() {
        if (this.getTarget() instanceof MdmBaseAttribute) {
            return (MdmBaseAttribute)this.getTarget();
        }
        return null;
    }

    public MdmDimensionedObject getTarget() {
        return (MdmDimensionedObject)this.m_Target.getBaseMetadataObject();
    }

    public String getTargetID() {
        return this.m_Target.getIdentifier().toString();
    }

    public Qualifier[] getQualifiers() {
        return (Qualifier[])this.getQualifiersInternal().clone();
    }

    public TypedExpression getRHSExpression() {
        return this.m_Rhs;
    }
}

