/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.List;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.Mdm11_ObjectVisitor;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import org.xml.sax.SAXException;

public class MdmRootSchema
extends MdmSchema {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.DATABASE_SCHEMAS};

    protected MdmRootSchema(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    @Override
    protected XMLTag getXMLTag() {
        return MdmXMLTags.ROOTSCHEMA_TAG;
    }

    @Override
    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        if (mdmObjectVisitor instanceof Mdm11_ObjectVisitor) {
            return ((Mdm11_ObjectVisitor)mdmObjectVisitor).visitMdmRootSchema(this, object);
        }
        return super.acceptVisitor(mdmObjectVisitor, object);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public static String generateIDFromXML(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, String string, String string2, String string3, MetadataXMLReader metadataXMLReader) throws SAXException {
        return "RootSchema";
    }

    public final void addDatabaseSchema(MdmDatabaseSchema mdmDatabaseSchema) {
        this.addToListProperty(MdmXMLTags.DATABASE_SCHEMAS, mdmDatabaseSchema);
    }

    @Override
    public final void addSubSchema(MdmSchema mdmSchema) {
        if (mdmSchema instanceof MdmDatabaseSchema) {
            this.addToListProperty(MdmXMLTags.DATABASE_SCHEMAS, mdmSchema);
        }
    }

    public final void removeDatabaseSchema(MdmDatabaseSchema mdmDatabaseSchema) {
        this.removeFromListProperty(MdmXMLTags.DATABASE_SCHEMAS, mdmDatabaseSchema);
    }

    @Override
    public final void removeSubSchema(MdmSchema mdmSchema) {
        if (mdmSchema instanceof MdmDatabaseSchema) {
            this.removeFromListProperty(MdmXMLTags.DATABASE_SCHEMAS, mdmSchema);
        }
    }

    public final List<MdmDatabaseSchema> getDatabaseSchemas() {
        return this.getPropertyListValues(MdmXMLTags.DATABASE_SCHEMAS);
    }

    public final MdmDatabaseSchema getDatabaseSchema(String string) {
        if (null == string) {
            return null;
        }
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string);
        if (metadataObject instanceof MdmDatabaseSchema) {
            return (MdmDatabaseSchema)metadataObject;
        }
        return null;
    }

    @Override
    public final List getSubSchemas() {
        ArrayList arrayList = new ArrayList();
        List list = this.getPropertyListValues(MdmXMLTags.DATABASE_SCHEMAS);
        for (MdmDatabaseSchema mdmDatabaseSchema : list) {
            arrayList.addAll(mdmDatabaseSchema.getSubSchemas());
        }
        return arrayList;
    }

    @Override
    public final MdmSchema getOwner() {
        return this;
    }

    @Override
    public List getMeasures() {
        ArrayList<MdmMeasure> arrayList = new ArrayList<MdmMeasure>();
        this.getMeasures(arrayList);
        return arrayList;
    }

    protected void getMeasures(List<MdmMeasure> list) {
        List<MdmDatabaseSchema> list2 = this.getDatabaseSchemas();
        for (MdmDatabaseSchema mdmDatabaseSchema : list2) {
            mdmDatabaseSchema.getMeasures(list);
        }
    }

    @Override
    public final void addMeasure(MdmMeasure mdmMeasure) {
        throw new UnsupportedOperationException("MdmRootSchema.addMeasure()");
    }

    @Override
    public final void removeMeasure(MdmMeasure mdmMeasure) {
        throw new UnsupportedOperationException("MdmRootSchema.removeMeasure()");
    }

    @Override
    public List getDimensions() {
        ArrayList arrayList = new ArrayList();
        List<MdmDatabaseSchema> list = this.getDatabaseSchemas();
        for (MdmDatabaseSchema mdmDatabaseSchema : list) {
            arrayList.addAll(mdmDatabaseSchema.getDimensions());
        }
        return arrayList;
    }

    @Override
    public List getCubes() {
        ArrayList arrayList = new ArrayList();
        List<MdmDatabaseSchema> list = this.getDatabaseSchemas();
        for (MdmDatabaseSchema mdmDatabaseSchema : list) {
            arrayList.addAll(mdmDatabaseSchema.getCubes());
        }
        return arrayList;
    }
}

