/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.List;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.internal.CopyException;
import oracle.olapi.internal.CopyPolicy;
import oracle.olapi.internal.Copyable;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.PublicMetadataObject;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.Mdm9iNamingConvention;
import oracle.olapi.metadata.mdm.MdmCopyVisitor;
import oracle.olapi.metadata.mdm.MdmDescription;
import oracle.olapi.metadata.mdm.MdmDescriptionType;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmXMLTags;

public abstract class MdmObject
extends PublicMetadataObject
implements Copyable {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.NAME, MdmXMLTags.DESC, MdmXMLTags.SHORT_DESC, MdmXMLTags.CLASSIFICATIONS, MdmXMLTags.DESCRIPTIONS, MdmXMLTags.NEW_NAME};

    public final String getColumnName(XMLTag xMLTag) {
        return this.getPropertyStringValue(xMLTag);
    }

    public final void setColumnName(XMLTag xMLTag, String string) {
        this.setPropertyStringValue(xMLTag, string);
    }

    protected MdmObject(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public MdmObject(BaseMetadataProvider baseMetadataProvider, String string, String string2, short s, BaseMetadataObject baseMetadataObject) {
        super(baseMetadataProvider, string2, s, baseMetadataObject);
        if (string != null) {
            MdmXMLTags.NAME.initializeProperty((BaseMetadataObject)this, (Object)string, s);
        }
    }

    public abstract Object acceptVisitor(MdmObjectVisitor var1, Object var2);

    public final String getDescription() throws MetadataNotFoundException {
        if (this.isServerVersionLaterThan(new int[]{11, 0, 0, 0}) && this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            MdmDescriptionType mdmDescriptionType = MdmDescriptionType.getDescriptionDescriptionType();
            return this.getDescription(mdmDescriptionType);
        }
        return this.getPropertyStringValue(MdmXMLTags.DESC);
    }

    public MdmMetadataProvider getMetadataProvider() {
        return (MdmMetadataProvider)this.getBaseMetadataProvider();
    }

    public String getName(short s) {
        return this.getPropertyStringValue(MdmXMLTags.NAME, s);
    }

    public String getShortDescription() throws MetadataNotFoundException {
        if (this.isServerVersionLaterThan(new int[]{11, 0, 0, 0}) && this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            MdmDescriptionType mdmDescriptionType = MdmDescriptionType.getShortDescriptionDescriptionType();
            return this.getDescription(mdmDescriptionType);
        }
        return this.getPropertyStringValue(MdmXMLTags.SHORT_DESC);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected final String generate102ID() {
        Mdm9iNamingConvention mdm9iNamingConvention = new Mdm9iNamingConvention(null, this.getMetadataProvider());
        return mdm9iNamingConvention.generateID(this);
    }

    public final void setDescription(String string) {
        if (this.isServerVersionLaterThan(new int[]{11, 0, 0, 0}) && this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            MdmDescriptionType mdmDescriptionType = MdmDescriptionType.getDescriptionDescriptionType();
            this.setDescription(mdmDescriptionType, string);
        } else {
            this.setPropertyStringValue(MdmXMLTags.DESC, string);
        }
    }

    public void setName(String string) {
        this.setNameOrNewName(string);
    }

    public void setShortDescription(String string) throws MetadataNotFoundException {
        if (this.isServerVersionLaterThan(new int[]{11, 0, 0, 0}) && this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            MdmDescriptionType mdmDescriptionType = MdmDescriptionType.getShortDescriptionDescriptionType();
            this.setDescription(mdmDescriptionType, string);
        } else {
            this.setPropertyStringValue(MdmXMLTags.SHORT_DESC, string);
        }
    }

    @Override
    public Object copyLocal(CopyPolicy copyPolicy) throws CopyException {
        return MdmCopyVisitor.createCopy(this, copyPolicy);
    }

    public final List getObjectClassifications() {
        return this.getPropertyListValues(MdmXMLTags.CLASSIFICATIONS);
    }

    public final void addObjectClassification(String string) {
        List list = this.getPropertyListValues(MdmXMLTags.CLASSIFICATIONS);
        if (!list.contains(string)) {
            this.addToListProperty(MdmXMLTags.CLASSIFICATIONS, string);
        }
    }

    public final void removeObjectClassification(String string) {
        this.removeFromListProperty(MdmXMLTags.CLASSIFICATIONS, string);
    }

    public final boolean isClassifiedAs(String string) {
        List list = this.getPropertyListValues(MdmXMLTags.CLASSIFICATIONS);
        return list.contains(string);
    }

    public final String getDescription(MdmDescriptionType mdmDescriptionType) {
        String string = this.getMetadataProvider().getDataProvider().getCurrentSession().getDefaultLanguage(false);
        return this.getDescription(mdmDescriptionType, string);
    }

    public final String getDescription(MdmDescriptionType mdmDescriptionType, String string) {
        MdmDescription mdmDescription = this.getDescriptionObject(mdmDescriptionType, string, true);
        if (mdmDescription == null) {
            return "";
        }
        return mdmDescription.getValue();
    }

    public final void setDescription(MdmDescriptionType mdmDescriptionType, String string) {
        String string2 = this.getMetadataProvider().getDataProvider().getCurrentSession().getDefaultLanguage(false);
        this.setDescription(mdmDescriptionType, string2, string);
    }

    public final void setDescription(MdmDescriptionType mdmDescriptionType, String string, String string2) {
        this.findOrCreateDescription(mdmDescriptionType, string, string2);
    }

    public MdmDescription findOrCreateDescription(MdmDescriptionType mdmDescriptionType, String string) {
        string = MdmDescription.stripLanguage(string);
        String string2 = MdmObject.generateID(new String[]{"$DESC", mdmDescriptionType.getDescriptiveType(), string});
        String string3 = MdmObject.generateID(new String[]{this.getID(), string2});
        MdmDescription mdmDescription = (MdmDescription)this.findOrCreateContainedObject(string3, string2, (short)0, MdmXMLTags.DESCRIPTIONS, MdmDescription.class, new XMLTag[]{MdmXMLTags.DESC_TYPE, MdmXMLTags.LANGUAGE}, new String[]{mdmDescriptionType.getDescriptiveType(), string});
        return mdmDescription;
    }

    public MdmDescription findOrCreateDescription(MdmDescriptionType mdmDescriptionType, String string, String string2) {
        MdmDescription mdmDescription = this.findOrCreateDescription(mdmDescriptionType, string);
        mdmDescription.setValue(string2);
        return mdmDescription;
    }

    final MdmDescription getDescriptionObject(MdmDescriptionType mdmDescriptionType, String string, boolean bl) {
        MdmDescriptionType mdmDescriptionType2 = mdmDescriptionType.getDescriptiveTypeDefault();
        MdmDescription mdmDescription = null;
        for (MdmDescription mdmDescription2 : this.getDescriptions()) {
            if (mdmDescriptionType.getDescriptiveType().equalsIgnoreCase(mdmDescription2.getType()) && mdmDescription2.getLanguage().equals(string)) {
                return mdmDescription2;
            }
            if (!bl || mdmDescriptionType2 == null || !mdmDescriptionType2.getDescriptiveType().equalsIgnoreCase(mdmDescription2.getType()) || !mdmDescription2.getLanguage().equals(string)) continue;
            mdmDescription = mdmDescription2;
        }
        if (bl) {
            return mdmDescription;
        }
        return null;
    }

    public final List getDescriptions() {
        return this.getPropertyListValues(MdmXMLTags.DESCRIPTIONS);
    }

    public final void addDescription(MdmDescription mdmDescription) {
        this.addToListProperty(MdmXMLTags.DESCRIPTIONS, mdmDescription);
    }

    public final void removeDescription(MdmDescription mdmDescription) {
        this.removeFromListProperty(MdmXMLTags.DESCRIPTIONS, mdmDescription);
    }
}

