/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.ArrayList;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAWObject;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLCubeDimRef;
import oracle.olapi.metadata.conversion.LegacyXMLCubeMapGroup;
import oracle.olapi.metadata.conversion.LegacyXMLDimension;
import oracle.olapi.metadata.conversion.LegacyXMLDimensionKeySourceExpression;
import oracle.olapi.metadata.conversion.LegacyXMLDimensionMapGroup;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchy;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchyLevelAssociation;
import oracle.olapi.metadata.conversion.LegacyXMLLevel;
import oracle.olapi.metadata.conversion.LegacyXMLRestrictedSourceExpression;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mapping.CubeDimensionalityMap;
import oracle.olapi.metadata.mapping.CubeMap;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionality;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.TypedExpression;

final class LegacyXMLCubeDimensionSourceExpression
extends LegacyXMLRestrictedSourceExpression {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.LEVELS_REF, LegacyXMLTags.DIMENSION_REF};

    protected LegacyXMLCubeDimensionSourceExpression(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    List<LegacyXMLLevel> getLevels() {
        return this.getPropertyListValues(LegacyXMLTags.LEVELS_REF);
    }

    LegacyXMLDimension getDimension() {
        return (LegacyXMLDimension)this.getPropertyObjectValue(LegacyXMLTags.DIMENSION_REF);
    }

    LegacyXMLCubeMapGroup getCubeMapGroup() {
        return (LegacyXMLCubeMapGroup)this.getContainedByObject();
    }

    LegacyXMLCubeDimRef getCubeDimRef() {
        List<LegacyXMLLevel> list;
        LegacyXMLDimension legacyXMLDimension = this.getDimension();
        if (null == legacyXMLDimension && (list = this.getLevels()).size() > 0) {
            legacyXMLDimension = list.get(0).getDimension();
        }
        if (null == legacyXMLDimension) {
            return null;
        }
        return this.getCubeMapGroup().getCube().getCubeDimRef(legacyXMLDimension);
    }

    LegacyXMLAWObject getMappedAWObject() {
        List<LegacyXMLAWObject> list = this.getMappedAWObjects();
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    List<LegacyXMLAWObject> getMappedAWObjects() {
        ArrayList<LegacyXMLAWObject> arrayList;
        block11: {
            LegacyXMLDimension legacyXMLDimension;
            block8: {
                boolean bl;
                LegacyXMLLevel legacyXMLLevel;
                block10: {
                    List<LegacyXMLHierarchy> list;
                    block9: {
                        LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation;
                        arrayList = new ArrayList<LegacyXMLAWObject>();
                        List<LegacyXMLLevel> list2 = this.getLevels();
                        legacyXMLDimension = null;
                        if (null == list2 || list2.size() <= 0) break block8;
                        legacyXMLLevel = list2.get(0);
                        legacyXMLDimension = legacyXMLLevel.getDimension();
                        bl = true;
                        list = legacyXMLDimension.getHierarchies();
                        if (list.size() != 1) break block9;
                        LegacyXMLHierarchy legacyXMLHierarchy = list.get(0);
                        if (!legacyXMLHierarchy.isLevelHierarchy() || null == (legacyXMLHierarchyLevelAssociation = legacyXMLHierarchy.getHierarchyLevelAssociation(legacyXMLLevel)) || !legacyXMLHierarchyLevelAssociation.hasMappingGroup()) break block10;
                        arrayList.add(legacyXMLHierarchyLevelAssociation);
                        break block10;
                    }
                    for (LegacyXMLHierarchy legacyXMLHierarchy : list) {
                        if (!legacyXMLHierarchy.isLevelHierarchy()) {
                            bl = false;
                        } else {
                            LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation = legacyXMLHierarchy.getHierarchyLevelAssociation(legacyXMLLevel);
                            if (null == legacyXMLHierarchyLevelAssociation || !legacyXMLHierarchyLevelAssociation.hasMappingGroup()) {
                                bl = false;
                            }
                        }
                        if (bl) continue;
                        break;
                    }
                }
                if (bl && legacyXMLLevel.hasMappingGroup()) {
                    arrayList.add(legacyXMLLevel);
                }
                break block11;
            }
            if (null != this.getDimension()) {
                LegacyXMLHierarchy legacyXMLHierarchy;
                legacyXMLDimension = this.getDimension();
                List<LegacyXMLHierarchy> list = legacyXMLDimension.getHierarchies();
                if (list.size() == 1 && (legacyXMLHierarchy = list.get(0)).isValueHierarchy() && legacyXMLHierarchy.hasMappingGroup()) {
                    arrayList.add(legacyXMLHierarchy);
                }
                if (legacyXMLDimension.hasMappingGroup()) {
                    arrayList.add(legacyXMLDimension);
                }
            }
        }
        return arrayList;
    }

    CubeDimensionalityMap getMdmCubeDimensionalityMap() {
        return (CubeDimensionalityMap)this.getConvertToObject();
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.CUBE_DIMENSION_SOURCE_EXPRESSION_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        LegacyXMLCubeDimRef legacyXMLCubeDimRef;
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        List<LegacyXMLLevel> list = this.getLevels();
        if (null == this.getLevels() || this.getLevels().size() == 0) {
            if (null == this.getDimension()) {
                legacyXMLConverter.validateRequiredProperty(LegacyXMLTags.LEVELS_REF, null, this);
            }
        } else if (list.size() > 1) {
            legacyXMLConverter.reportError("UnsupportedCubeDimMapConversion", this.getID());
        }
        if (null == (legacyXMLCubeDimRef = this.getCubeDimRef())) {
            legacyXMLConverter.reportError("UnsupportedCubeDimMapConversion", this.getID());
        }
        if (!legacyXMLCubeDimRef.isValid()) {
            return false;
        }
        LegacyXMLAWObject legacyXMLAWObject = this.getMappedAWObject();
        if (null == legacyXMLAWObject) {
            legacyXMLConverter.reportError("UnsupportedCubeDimMapConversion", this.getID());
        }
        return legacyXMLAWObject.isValid() && legacyXMLAWObject.getSourceMappingGroup().isValid();
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        LegacyXMLBaseObject legacyXMLBaseObject;
        CubeMap cubeMap = this.getCubeMapGroup().getMdmCubeMap();
        MdmDimensionality mdmDimensionality = this.getCubeDimRef().getMdmDimensionality();
        CubeDimensionalityMap cubeDimensionalityMap = cubeMap.findOrCreateCubeDimensionalityMap(mdmDimensionality);
        TypedExpression typedExpression = this.getSourceColumnsKeyExpression();
        if (null != typedExpression) {
            cubeDimensionalityMap.setExpression(typedExpression);
        }
        MdmDimension mdmDimension = null;
        LegacyXMLAWObject legacyXMLAWObject = this.getMappedAWObject();
        if (legacyXMLAWObject instanceof LegacyXMLDimension) {
            mdmDimension = ((LegacyXMLDimension)legacyXMLAWObject).getMdmPrimaryDimension();
        } else if (legacyXMLAWObject instanceof LegacyXMLLevel) {
            mdmDimension = ((LegacyXMLLevel)legacyXMLAWObject).getMdmDimensionLevel();
        } else if (legacyXMLAWObject instanceof LegacyXMLHierarchyLevelAssociation) {
            legacyXMLBaseObject = (LegacyXMLHierarchyLevelAssociation)legacyXMLAWObject;
            mdmDimension = ((LegacyXMLHierarchyLevelAssociation)legacyXMLBaseObject).getMdmHierarchyLevel();
        } else if (legacyXMLAWObject instanceof LegacyXMLHierarchy) {
            mdmDimension = ((LegacyXMLHierarchy)legacyXMLAWObject).getMdmHierarchy();
        }
        cubeDimensionalityMap.setMappedDimension(mdmDimension);
        legacyXMLBaseObject = (LegacyXMLDimensionMapGroup)legacyXMLAWObject.getSourceMappingGroup();
        LegacyXMLDimensionKeySourceExpression legacyXMLDimensionKeySourceExpression = ((LegacyXMLDimensionMapGroup)legacyXMLBaseObject).getDimensionKeySourceExpression();
        Condition condition = this.getSourceColumnsJoinCondition(legacyXMLDimensionKeySourceExpression.getSourceColumnsKeyExpression());
        if (null != condition) {
            cubeDimensionalityMap.setJoinCondition(condition);
        }
        this.setMdmCubeDimensionalityMap(cubeDimensionalityMap);
        super.convertToMdm(legacyXMLConverter);
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        LegacyXMLCubeDimRef legacyXMLCubeDimRef = this.getCubeDimRef();
        LegacyXMLAWObject legacyXMLAWObject = this.getMappedAWObject();
        if (null == legacyXMLCubeDimRef && null == legacyXMLAWObject) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        int n = -1;
        int n2 = -1;
        if (null != legacyXMLCubeDimRef) {
            n = legacyXMLCubeDimRef.getConvertOrderNumber(legacyXMLConverter);
        }
        if (null != legacyXMLAWObject) {
            n2 = legacyXMLAWObject.getConvertOrderNumber(legacyXMLConverter);
        }
        return Math.max(n, n2) + 1;
    }

    private void setMdmCubeDimensionalityMap(CubeDimensionalityMap cubeDimensionalityMap) {
        this.setConvertToObject(cubeDimensionalityMap);
    }
}

