/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAWObject;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLDimension;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.deployment.AWAttributeOrganization;
import oracle.olapi.metadata.deployment.AWPrimaryDimensionOrganization;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmTimeDimension;

class LegacyXMLAttribute
extends LegacyXMLBaseObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.ATTR_DATA_TYPE, LegacyXMLTags.CLASSIFICATION, LegacyXMLTags.INSTALL_AS_RELATION, LegacyXMLTags.IS_DEFAULT_ORDER, LegacyXMLTags.IS_MULTI_LINGUAL, LegacyXMLTags.DIMENSION_DOMAIN_REF};

    protected LegacyXMLAttribute(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    final boolean getInstallAsRelation() {
        return this.getPropertyBooleanValue(LegacyXMLTags.INSTALL_AS_RELATION);
    }

    final boolean getIsDefaultOrder() {
        return this.getPropertyBooleanValue(LegacyXMLTags.IS_DEFAULT_ORDER);
    }

    final boolean getIsMultiLingual() {
        return this.getPropertyBooleanValue(LegacyXMLTags.IS_MULTI_LINGUAL);
    }

    final String getDataType() {
        return this.getPropertyStringValue(LegacyXMLTags.ATTR_DATA_TYPE);
    }

    final String getClassification() {
        return this.getPropertyStringValue(LegacyXMLTags.CLASSIFICATION);
    }

    final LegacyXMLDimension getDimensionDomain() {
        return (LegacyXMLDimension)this.getPropertyObjectValue(LegacyXMLTags.DIMENSION_DOMAIN_REF);
    }

    final LegacyXMLAWObject getAWObject() {
        return (LegacyXMLAWObject)this.getContainedByObject();
    }

    final LegacyXMLDimension getDimension() {
        return (LegacyXMLDimension)this.getAWObject();
    }

    final MdmBaseAttribute getMdmBaseAttribute() {
        return (MdmBaseAttribute)this.getConvertToObject();
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.ATTRIBUTE_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        if (!(this.getAWObject() instanceof LegacyXMLDimension)) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.MEMBER_SELECTIONS, this.getID(), this.getAWObject(), false);
        }
        if ("DEFAULT_ORDER" == this.getClassification() || "MEMBER_VISIBLE" == this.getClassification() || !this.getDimension().getIsTime() && ("END_DATE" == this.getClassification() || "TIME_SPAN" == this.getClassification())) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.CLASSIFICATION, this.getClassification(), this);
        }
        if (this.getIsDefaultOrder()) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.IS_DEFAULT_ORDER, new Boolean(this.getIsDefaultOrder()), this);
        }
        return true;
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        MdmBaseAttribute mdmBaseAttribute = null;
        LegacyXMLDimension legacyXMLDimension = this.getDimension();
        MdmPrimaryDimension mdmPrimaryDimension = legacyXMLDimension.getMdmPrimaryDimension();
        String string = this.getName();
        mdmBaseAttribute = mdmPrimaryDimension.findOrCreateBaseAttribute(string);
        if (null != this.getDimensionDomain()) {
            mdmBaseAttribute.setTargetDimension(this.getDimensionDomain().getMdmPrimaryDimension());
        }
        String string2 = this.getDataType();
        if ("MEMBER_LONG_DESCRIPTION" == this.getClassification()) {
            mdmPrimaryDimension.setValueDescriptionAttribute(mdmBaseAttribute);
        } else if ("MEMBER_SHORT_DESCRIPTION" == this.getClassification()) {
            mdmPrimaryDimension.setShortValueDescriptionAttribute(mdmBaseAttribute);
        } else if ("END_DATE" == this.getClassification()) {
            string2 = "DATE";
            ((MdmTimeDimension)mdmPrimaryDimension).setEndDateAttribute(mdmBaseAttribute);
        } else if ("TIME_SPAN" == this.getClassification()) {
            string2 = "INTEGER";
            ((MdmTimeDimension)mdmPrimaryDimension).setTimeSpanAttribute(mdmBaseAttribute);
        }
        mdmBaseAttribute.setSQLDataType(LegacyXMLConverter.getSQLDataType(string2));
        mdmBaseAttribute.setMultiLingual(this.getIsMultiLingual());
        AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = (AWPrimaryDimensionOrganization)mdmPrimaryDimension.getOrganization();
        AWAttributeOrganization aWAttributeOrganization = aWPrimaryDimensionOrganization.getAttributeOrganization(mdmBaseAttribute);
        aWAttributeOrganization.setCreateAttributeIndex(this.getInstallAsRelation());
        this.setMdmBaseAttribute(mdmBaseAttribute);
        super.convertToMdm(legacyXMLConverter);
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        if (null == this.getDimensionDomain()) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        return this.getDimensionDomain().getConvertOrderNumber(legacyXMLConverter) + 1;
    }

    private void setMdmBaseAttribute(MdmBaseAttribute mdmBaseAttribute) {
        this.setConvertToObject(mdmBaseAttribute);
    }
}

