/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.BaseMetadataXMLReaderState;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.MetadataObjectClass;
import oracle.olapi.metadata.MetadataXMLFormat;
import oracle.olapi.metadata.MetadataXMLParserCallback;
import oracle.olapi.metadata.MetadataXMLReaderDeferredPropertyState;
import oracle.olapi.metadata.MetadataXMLReaderState;
import oracle.olapi.metadata.XMLParserCallback;
import oracle.olapi.metadata.XMLReaderPropertyAction;
import oracle.olapi.metadata.XMLRenameMap;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.syntax.parser.Identifier;
import oracle.olapi.xml.MetadataXMLException;
import oracle.olapi.xml.XMLException;
import oracle.olapi.xml.XMLProcessor;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseMetadataXMLReader
extends XMLProcessor {
    private BaseMetadataProvider m_MetadataProvider = null;
    private MetadataXMLFormat m_XMLFormat = null;
    private short m_PersistenceType;
    private List m_CreatedObjects = new ArrayList();
    private List m_ParsedObjects = new ArrayList();
    private MdmDatabaseSchema m_ContextSchema = null;
    private boolean m_CreateOnly = false;
    private boolean m_IsNewObject = false;
    private XMLReaderPropertyAction m_DefaultPropertyAction = null;
    private ArrayList<MetadataXMLReaderDeferredPropertyState> m_DeferredPropStates = null;
    private ArrayList<MetadataXMLReaderDeferredPropertyState> m_DeferredPropSyntaxStates = null;
    private Map<String, String> m_BindValues = null;
    private MetadataXMLParserCallback m_MetadataCallback = null;
    private XMLRenameMap m_RenameMap = null;
    private boolean m_InAttributes = false;
    static final String BIND_ENTITY_PUBLIC_ID = "OLAP BIND VALUES";
    static final String ENTITY_SYSTEM_ID = "OLAP METADATA";

    public final List getCreatedObjects() {
        return this.m_CreatedObjects;
    }

    public final List getParsedObjects() {
        return this.m_ParsedObjects;
    }

    public final short getPersistenceType() {
        return this.m_PersistenceType;
    }

    public final BaseMetadataProvider getMetadataProvider() {
        return this.m_MetadataProvider;
    }

    public final String getAttributeValue(XMLTag xMLTag) throws SAXException {
        return this.getAttributeValue(xMLTag, true);
    }

    public final String getAttributeValue(XMLTag xMLTag, boolean bl) throws SAXException {
        return this.getAttributeValue(this.getCurrentAttributes(), xMLTag, bl);
    }

    public final String getAttributeValue(Attributes attributes, XMLTag xMLTag) throws SAXException {
        return this.getAttributeValue(attributes, xMLTag, true);
    }

    public final String getAttributeValue(Attributes attributes, XMLTag xMLTag, boolean bl) throws SAXException {
        String string = this.getXMLVersion();
        String string2 = xMLTag.getVersionedValue(string);
        String string3 = attributes.getValue(string2);
        if (null == string3 && bl) {
            this.reportError("MissingXMLAttr", string2);
        }
        return string3;
    }

    public final void setContextSchema(MdmDatabaseSchema mdmDatabaseSchema) {
        this.m_ContextSchema = mdmDatabaseSchema;
    }

    public final MdmDatabaseSchema getContextSchema() {
        return this.m_ContextSchema;
    }

    public final void setCreateOnly(boolean bl) {
        this.m_CreateOnly = bl;
    }

    public final boolean isCreateOnly() {
        return this.m_CreateOnly;
    }

    public final void setBindValues(Map<String, String> map) {
        this.m_BindValues = map;
    }

    public final void setUserCallback(XMLParserCallback xMLParserCallback) {
        this.getMetadataCallback().setUserCallback(xMLParserCallback);
    }

    public final MetadataXMLParserCallback getMetadataCallback() {
        return this.m_MetadataCallback;
    }

    protected BaseMetadataXMLReader(short s, BaseMetadataProvider baseMetadataProvider) {
        this.m_PersistenceType = s;
        this.setMetadataProvider(baseMetadataProvider);
        this.initializeXMLFormat();
        this.loadXMLTags();
        this.setDefaultPropertyAction(this.getDefaultPropertyAction());
        this.m_MetadataCallback = new MetadataXMLParserCallback(this);
    }

    final void registerObject(BaseMetadataObject baseMetadataObject, String string, boolean bl) {
        baseMetadataObject.setInitialPersistenceType(this.getPersistenceType());
        baseMetadataObject.setInternalID(string);
        this.getMetadataProvider().registerMetadataObject(string, baseMetadataObject);
        if (bl) {
            this.addParsedObject(baseMetadataObject, true);
        }
    }

    public final void addParsedObject(BaseMetadataObject baseMetadataObject, boolean bl) {
        this.getParsedObjects().add(baseMetadataObject);
        if (bl) {
            this.getCreatedObjects().add(baseMetadataObject);
        }
    }

    public final MetadataXMLFormat getXMLFormat() {
        return this.m_XMLFormat;
    }

    public final String getXMLVersion() {
        return this.getXMLFormat().getVersion();
    }

    final void setIsNewObject(boolean bl) {
        this.m_IsNewObject = bl;
    }

    final boolean isNewObject() {
        return this.m_IsNewObject;
    }

    final XMLReaderPropertyAction getPropertyAction(XMLTag xMLTag, Attributes attributes, boolean bl) throws SAXException {
        XMLReaderPropertyAction xMLReaderPropertyAction = new XMLReaderPropertyAction();
        xMLReaderPropertyAction.setPersistenceType(this.getPersistenceType());
        if (!xMLReaderPropertyAction.populate(xMLTag, attributes, this)) {
            if (!bl) {
                return null;
            }
            return this.getDefaultPropertyAction();
        }
        return xMLReaderPropertyAction;
    }

    public final XMLReaderPropertyAction getDefaultPropertyAction() {
        XMLReaderPropertyAction xMLReaderPropertyAction = this.m_DefaultPropertyAction;
        if (null == xMLReaderPropertyAction) {
            this.m_DefaultPropertyAction = xMLReaderPropertyAction = this.createDefaultPropertyAction();
        }
        return xMLReaderPropertyAction;
    }

    public final void initializeProperty(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, Object object, XMLReaderPropertyAction xMLReaderPropertyAction) {
        this.initializeProperty(baseMetadataObject, xMLTag, object, xMLReaderPropertyAction, true);
    }

    public final void registerDeferredProperty(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, Object object, XMLReaderPropertyAction xMLReaderPropertyAction) {
        if (null == this.m_DeferredPropStates) {
            this.m_DeferredPropStates = new ArrayList();
            this.m_DeferredPropSyntaxStates = new ArrayList();
        }
        String string = this.getState().getFullXmlTagName(this);
        MetadataXMLReaderDeferredPropertyState metadataXMLReaderDeferredPropertyState = new MetadataXMLReaderDeferredPropertyState(baseMetadataObject, xMLTag, object, xMLReaderPropertyAction, string);
        metadataXMLReaderDeferredPropertyState.setLocationInfo(this.getState().getElementName(), this.getLocator(), null);
        if (xMLTag.isSyntaxDataType()) {
            this.m_DeferredPropSyntaxStates.add(metadataXMLReaderDeferredPropertyState);
        } else {
            this.m_DeferredPropStates.add(metadataXMLReaderDeferredPropertyState);
        }
    }

    public final void resolveDeferredProperties() {
        if (null == this.m_DeferredPropStates) {
            return;
        }
        BaseMetadataXMLReaderState baseMetadataXMLReaderState = (BaseMetadataXMLReaderState)this.getState();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (!bl) {
            MetadataXMLReaderDeferredPropertyState metadataXMLReaderDeferredPropertyState = null;
            if (n < this.m_DeferredPropStates.size()) {
                metadataXMLReaderDeferredPropertyState = this.m_DeferredPropStates.get(n++);
            } else {
                if (n2 >= this.m_DeferredPropSyntaxStates.size()) break;
                metadataXMLReaderDeferredPropertyState = this.m_DeferredPropSyntaxStates.get(n2++);
            }
            BaseMetadataObject baseMetadataObject = metadataXMLReaderDeferredPropertyState.getContainerObject();
            XMLTag xMLTag = metadataXMLReaderDeferredPropertyState.getPropertyTag();
            Object object = metadataXMLReaderDeferredPropertyState.getPropertyValue();
            XMLReaderPropertyAction xMLReaderPropertyAction = metadataXMLReaderDeferredPropertyState.getPropertyAction();
            try {
                this.setState(metadataXMLReaderDeferredPropertyState);
                this.initializeDeferredProperty(baseMetadataObject, xMLTag, object, xMLReaderPropertyAction);
            }
            catch (Exception exception) {
                this.processException(exception);
            }
        }
        this.setState(baseMetadataXMLReaderState);
        this.m_DeferredPropStates.clear();
        this.m_DeferredPropSyntaxStates.clear();
    }

    public final void validateRequiredProperty(XMLTag xMLTag, Object object, BaseMetadataObject baseMetadataObject) {
        if (null == object || object instanceof String && ((String)object).length() == 0 || object instanceof List && ((List)object).size() == 0) {
            String string = this.getXMLVersion();
            String string2 = xMLTag.getVersionedValue(string);
            this.reportError("MissingRequiredProp", new String[]{string2, baseMetadataObject.getID()});
        }
    }

    public final void reportIgnoredProperty(XMLTag xMLTag, Object object, BaseMetadataObject baseMetadataObject) {
        this.reportIgnoredProperty("UnsupportedProperty", xMLTag, object, baseMetadataObject, true);
    }

    public final void reportIgnoredProperty(String string, XMLTag xMLTag, Object object, BaseMetadataObject baseMetadataObject, boolean bl) {
        if (null == object || object instanceof String && ((String)object).length() == 0 || object instanceof List && ((List)object).size() == 0) {
            return;
        }
        String string2 = null;
        string2 = object instanceof BaseMetadataObject ? ((BaseMetadataObject)object).getID() : object.toString();
        String string3 = this.getXMLVersion();
        String string4 = xMLTag.getVersionedValue(string3);
        String[] stringArray = new String[]{string4, string2, baseMetadataObject.getID()};
        if (bl) {
            this.reportWarning(string, stringArray);
        } else {
            this.reportError(string, stringArray);
        }
    }

    public final String getCurrentObjectID() {
        BaseMetadataObject baseMetadataObject;
        BaseMetadataXMLReaderState baseMetadataXMLReaderState = (BaseMetadataXMLReaderState)this.getState();
        if (null != baseMetadataXMLReaderState && null != (baseMetadataObject = baseMetadataXMLReaderState.getMetadataObject()) && null != baseMetadataObject.getID() && baseMetadataObject.getID().length() > 0) {
            return baseMetadataObject.getID();
        }
        return null;
    }

    final boolean canSkipPropertyXMLTag(XMLTag xMLTag, BaseMetadataObject baseMetadataObject) {
        if (this.getXMLFormat().getMode() == 0 || null == xMLTag) {
            return false;
        }
        return !xMLTag.isReadableForVersion(this) && null != xMLTag.getPriorValidXmlVersion(this);
    }

    final boolean isValidPropertyXMLTag(XMLTag xMLTag, BaseMetadataObject baseMetadataObject, boolean bl) {
        if (this.getXMLFormat().getMode() == 0) {
            return true;
        }
        if (null == xMLTag) {
            return false;
        }
        if (!xMLTag.isReadableForVersion(this)) {
            return false;
        }
        if (null != baseMetadataObject && baseMetadataObject.hasPrivateName() && MdmXMLTags.NEW_NAME == xMLTag) {
            return false;
        }
        if (bl && !xMLTag.canUseAsXMLAttribute()) {
            return false;
        }
        if (!bl && !xMLTag.canUseAsXMLSubElement()) {
            return false;
        }
        return BaseMetadataXMLTags.NAME != xMLTag || null == baseMetadataObject || !baseMetadataObject.hasPrivateName();
    }

    public final boolean isForRenameOnImport() {
        return null != this.getRenameMap(false);
    }

    protected final boolean suppressXMLAttribute(XMLTag xMLTag, String string, Class clazz, String string2, String string3) {
        if (xMLTag.allowsSuppression()) {
            return this.getMetadataCallback().suppressXMLAttribute(string, clazz, string2, string3);
        }
        return false;
    }

    protected final String renameObject(XMLTag xMLTag, String string) {
        if (xMLTag.getMetadataObjectClass().hasPrivateName()) {
            return string;
        }
        Class clazz = xMLTag.getObjectClass();
        Identifier identifier = Identifier.parseID(string, clazz);
        String string2 = this.getMetadataCallback().renameObject(identifier, clazz);
        if (null != string2) {
            identifier = this.addRename(identifier, string2, xMLTag);
        }
        return identifier.toString();
    }

    final String applyRename(BaseMetadataObject baseMetadataObject, String string) {
        if (!this.isForRenameOnImport()) {
            return string;
        }
        Identifier identifier = Identifier.parseID(baseMetadataObject.getID(), baseMetadataObject.getClass());
        return identifier.getName();
    }

    final String applyRenameForID(BaseMetadataObject baseMetadataObject, String string, XMLTag xMLTag) {
        if (!this.isForRenameOnImport()) {
            return string;
        }
        Identifier identifier = Identifier.parseID(string, xMLTag.getObjectClass());
        Identifier identifier2 = null;
        if (null != baseMetadataObject) {
            identifier2 = Identifier.parseID(baseMetadataObject.getID(), baseMetadataObject.getClass());
        }
        MetadataObjectClass metadataObjectClass = xMLTag.getMetadataObjectClass();
        boolean bl = xMLTag.isXMLExternalObjectReference();
        Identifier identifier3 = this.applyRenameForID(identifier, identifier2, metadataObjectClass, bl);
        return identifier3.toString();
    }

    final Identifier applyRenameForID(Identifier identifier, Identifier identifier2, MetadataObjectClass metadataObjectClass, boolean bl) {
        if (!this.isForRenameOnImport()) {
            return identifier;
        }
        Identifier identifier3 = null;
        Identifier identifier4 = null;
        if (null != identifier2) {
            int n = identifier.getNumCommonComponents(identifier2);
            identifier4 = this.getXMLIDFromRenamedID(identifier, n);
            if (!bl && n >= identifier2.getOwnerIndex() + 2) {
                identifier3 = n == identifier2.getNumComponents() ? identifier2 : identifier2.getParentID(n);
            }
        } else {
            identifier4 = identifier;
        }
        return this.getRenamedIDFromXMLID(identifier4, metadataObjectClass, identifier3);
    }

    public final String applyRenameWithIDAttribute(BaseMetadataObject baseMetadataObject, String string, String string2, XMLTag xMLTag, XMLTag xMLTag2) {
        boolean bl;
        MetadataObjectClass metadataObjectClass;
        if (!this.isForRenameOnImport()) {
            return string;
        }
        Identifier identifier = Identifier.parseID(string2, xMLTag2.getObjectClass());
        Identifier identifier2 = Identifier.parseID(string, xMLTag.getObjectClass());
        Identifier identifier3 = Identifier.parseID(baseMetadataObject.getID(), baseMetadataObject.getClass());
        Identifier identifier4 = this.applyRenameForID(identifier, identifier3, metadataObjectClass = xMLTag2.getMetadataObjectClass(), bl = xMLTag2.isXMLExternalObjectReference());
        if (!identifier4.getName().equals(identifier.getName())) {
            identifier2 = this.addRename(identifier2, identifier4.getName(), xMLTag);
        }
        return identifier2.toString();
    }

    protected final boolean canDeferElement(MetadataXMLReaderState metadataXMLReaderState, XMLTag xMLTag) {
        if (!this.canDeferElement()) {
            return false;
        }
        if (6 != xMLTag.getXMLType()) {
            return false;
        }
        MetadataObjectClass metadataObjectClass = xMLTag.getMetadataObjectClass();
        return null != metadataObjectClass.getObjRefIDAttribute();
    }

    public final boolean isInAttributes() {
        return this.m_InAttributes;
    }

    final void setInAttributes(boolean bl) {
        this.m_InAttributes = bl;
    }

    final String getCurrentOwner(BaseMetadataObject baseMetadataObject) {
        String string = null;
        if (null != baseMetadataObject) {
            if (baseMetadataObject instanceof MdmDatabaseSchema) {
                MdmDatabaseSchema mdmDatabaseSchema = (MdmDatabaseSchema)baseMetadataObject;
                string = mdmDatabaseSchema.getName(this.getPersistenceType());
            } else {
                Identifier identifier = Identifier.parseID(baseMetadataObject.getID(), baseMetadataObject.getClass());
                string = identifier.getOwner();
            }
        }
        if (null == string && null != this.getContextSchema()) {
            string = this.getContextSchema().getName(this.getPersistenceType());
        }
        return string;
    }

    protected abstract void loadXMLTags();

    protected XMLReaderPropertyAction createDefaultPropertyAction() {
        XMLReaderPropertyAction xMLReaderPropertyAction = new XMLReaderPropertyAction();
        xMLReaderPropertyAction.setToDefault();
        xMLReaderPropertyAction.setPersistenceType(this.getPersistenceType());
        return xMLReaderPropertyAction;
    }

    protected void initializeDeferredProperty(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, Object object, XMLReaderPropertyAction xMLReaderPropertyAction) {
        this.initializeProperty(baseMetadataObject, xMLTag, object, xMLReaderPropertyAction, false);
    }

    private void setMetadataProvider(BaseMetadataProvider baseMetadataProvider) {
        this.m_MetadataProvider = baseMetadataProvider;
    }

    private void setXMLFormat(MetadataXMLFormat metadataXMLFormat) {
        this.m_XMLFormat = metadataXMLFormat;
    }

    private void initializeXMLFormat() {
        MetadataXMLFormat metadataXMLFormat = null;
        DataProvider dataProvider = this.getMetadataProvider().getDataProvider();
        metadataXMLFormat = dataProvider.read11gMetadata() ? new MetadataXMLFormat(1, dataProvider.getServerVersion().getMetadataXMLVersion()) : new MetadataXMLFormat(0, "0.1");
        this.setXMLFormat(metadataXMLFormat);
    }

    private Map<String, String> getBindValues() {
        return this.m_BindValues;
    }

    private void setDefaultPropertyAction(XMLReaderPropertyAction xMLReaderPropertyAction) {
        this.m_DefaultPropertyAction = xMLReaderPropertyAction;
    }

    protected final void initializeProperty(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, Object object, XMLReaderPropertyAction xMLReaderPropertyAction, boolean bl) {
        if (bl && xMLTag.canDeferOnParse()) {
            this.registerDeferredProperty(baseMetadataObject, xMLTag, object, xMLReaderPropertyAction);
        } else {
            this.getMetadataCallback().setCurrentObject(baseMetadataObject);
            String string = this.getXMLVersion();
            String string2 = xMLTag.getVersionedValue(string);
            this.getMetadataCallback().setCurrentAttribute(string2);
            xMLTag.initializeProperty(baseMetadataObject, object, xMLReaderPropertyAction, this.getMetadataCallback());
        }
    }

    private Identifier addRename(Identifier identifier, String string, XMLTag xMLTag) {
        Identifier identifier2 = this.getXMLIDFromRenamedID(identifier, identifier.getNumComponents() - 1);
        Identifier identifier3 = new Identifier(identifier);
        identifier3.setName(string);
        this.getRenameMap().addRename(identifier2, identifier3, xMLTag.getMetadataObjectClass());
        return identifier3;
    }

    private Identifier getRenamedIDFromXMLID(Identifier identifier, MetadataObjectClass metadataObjectClass, Identifier identifier2) {
        if (null == identifier2) {
            identifier2 = new Identifier();
        }
        Identifier identifier3 = new Identifier(identifier);
        Identifier identifier4 = null;
        int n = identifier.getOwnerIndex() + 2;
        MetadataObjectClass metadataObjectClass2 = metadataObjectClass;
        while (identifier3.getNumComponents() >= n && identifier3.getNumComponents() > identifier2.getNumComponents()) {
            Identifier identifier5;
            if (metadataObjectClass2.isSubClassOf(BaseMetadataObject.class)) {
                metadataObjectClass2 = metadataObjectClass2.getSubClassForID(identifier3);
            }
            if (this.getRenameMap().containsXmlId(identifier3) && null != (identifier5 = this.getRenameMap().getNewIdFromXmlId(identifier3, metadataObjectClass2))) {
                identifier4 = new Identifier(identifier5);
                break;
            }
            identifier3.trimToContainerID();
            metadataObjectClass2 = metadataObjectClass2.getContainerClass();
        }
        if (null == identifier4 && !identifier3.contains(identifier2)) {
            identifier4 = new Identifier(identifier2);
        }
        if (null == identifier4) {
            return identifier;
        }
        while (identifier4.getNumComponents() != identifier.getNumComponents()) {
            int n2 = identifier4.getNumComponents();
            identifier4.addComponent(identifier.getComponent(n2));
        }
        return identifier4;
    }

    private Identifier getXMLIDFromRenamedID(Identifier identifier, int n) {
        if (0 == n) {
            return identifier;
        }
        Identifier identifier2 = identifier.getParentID(n);
        Identifier identifier3 = null;
        int n2 = identifier.getOwnerIndex() + 2;
        while (identifier2.getNumComponents() >= n2) {
            if (this.getRenameMap().containsNewId(identifier2)) {
                Identifier identifier4 = this.getRenameMap().getXmlIdFromNewId(identifier2);
                identifier3 = new Identifier(identifier4);
                break;
            }
            identifier2.trimToContainerID();
        }
        if (null == identifier3) {
            return identifier;
        }
        while (identifier3.getNumComponents() != identifier.getNumComponents()) {
            int n3 = identifier3.getNumComponents();
            identifier3.addComponent(identifier.getComponent(n3));
        }
        return identifier3;
    }

    private XMLRenameMap getRenameMap() {
        boolean bl = true;
        return this.getRenameMap(bl);
    }

    private XMLRenameMap getRenameMap(boolean bl) {
        if (null == this.m_RenameMap && bl) {
            this.m_RenameMap = new XMLRenameMap();
        }
        return this.m_RenameMap;
    }

    @Override
    public final void startDocument() throws SAXException {
    }

    @Override
    public final InputSource resolveEntity(String string, String string2) throws SAXException {
        if (BIND_ENTITY_PUBLIC_ID.equals(string) && ENTITY_SYSTEM_ID.equals(string2)) {
            String string3 = "";
            if (null != this.getBindValues()) {
                for (String string4 : this.getBindValues().keySet()) {
                    String string5 = this.getBindValues().get(string4);
                    string3 = string3 + "<!ENTITY " + string4 + " \"" + string5 + "\">";
                }
            }
            StringReader stringReader = new StringReader(string3);
            return new InputSource(stringReader);
        }
        return null;
    }

    @Override
    protected void resetState() {
        super.resetState();
        if (null != this.m_DeferredPropStates) {
            this.m_DeferredPropStates.clear();
            this.m_DeferredPropSyntaxStates.clear();
        }
        this.m_CreatedObjects.clear();
        this.m_ParsedObjects.clear();
        this.m_RenameMap = null;
        this.setInAttributes(false);
    }

    @Override
    protected final XMLException createXMLException(String string, String[] stringArray, boolean bl, int n, int n2) {
        return new MetadataXMLException(string, stringArray, bl, n, n2, this.getCurrentObjectID());
    }

    @Override
    protected final XMLException createXMLException(Exception exception, boolean bl, int n, int n2) {
        return new MetadataXMLException(exception, bl, n, n2, this.getCurrentObjectID());
    }
}

