/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.express.ObjectClosedException;
import oracle.olapi.Debug;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.ClientXMLMetadataFetcher;
import oracle.olapi.metadata.DuplicateMetadataIDException;
import oracle.olapi.metadata.MetadataFetcher;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataObjectFetchState;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataUpdateNotSupportedException;
import oracle.olapi.metadata.deployment.AW;

public abstract class BaseMetadataProvider {
    private HashMap m_ObjectMap = new HashMap();
    private MetadataFetcher m_MetadataFetcher = null;
    private DataProvider m_DataProvider = null;
    private String m_ID = null;
    private List<MetadataObjectHolder> m_DefunctHolders = new ArrayList<MetadataObjectHolder>();

    protected BaseMetadataProvider(DataProvider dataProvider) throws ObjectClosedException {
        this(dataProvider, null);
    }

    protected BaseMetadataProvider(DataProvider dataProvider, ClientXMLMetadataFetcher clientXMLMetadataFetcher) throws ObjectClosedException {
        this.setDataProvider(dataProvider);
        this.setMetadataFetcher(new MetadataFetcher(this, clientXMLMetadataFetcher));
    }

    public final void flushDeletedObjects() {
        HashMap<String, BaseMetadataObject> hashMap = new HashMap<String, BaseMetadataObject>();
        Iterator iterator = this.getObjectMap().values().iterator();
        while (iterator.hasNext()) {
            BaseMetadataObject baseMetadataObject = (BaseMetadataObject)iterator.next();
            if (!baseMetadataObject.isDeleted()) {
                hashMap.put(baseMetadataObject.getID(), baseMetadataObject);
            }
            iterator.next();
        }
        this.setObjectMap(hashMap);
    }

    public final synchronized void flushMetadataObjectCache() {
        this.flushMetadataObjectCache(null);
    }

    public final synchronized void flushMetadataObjectCache(Class clazz) {
        if (!this.supportsMetadataUpdate()) {
            throw new MetadataUpdateNotSupportedException("UpdateNotSupported");
        }
        HashSet<BaseMetadataObject> hashSet = null;
        for (MetadataObjectHolder object : this.getObjectMap().values()) {
            if (null == object.getMetadataObject() || !(object.getMetadataObject() instanceof BaseMetadataObject)) continue;
            if (null == clazz) {
                object.setFetchStatus(2);
                continue;
            }
            if (!clazz.isInstance(object.getMetadataObject())) continue;
            if (null == hashSet) {
                hashSet = new HashSet<BaseMetadataObject>();
            }
            hashSet.add(((BaseMetadataObject)object.getMetadataObject()).getTopLevelObject());
        }
        if (null != hashSet) {
            for (BaseMetadataObject baseMetadataObject : hashSet) {
                if (baseMetadataObject instanceof AW) {
                    this.flushCachedAW((AW)baseMetadataObject);
                    continue;
                }
                this.flushCachedObject(baseMetadataObject);
            }
        }
    }

    public void flushCachedObject(BaseMetadataObject baseMetadataObject) {
        if (!this.supportsMetadataUpdate()) {
            throw new MetadataUpdateNotSupportedException("UpdateNotSupported");
        }
        BaseMetadataObject baseMetadataObject2 = baseMetadataObject.getTopLevelObject();
        if (1 != baseMetadataObject2.getHolder().getFetchStatus()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        baseMetadataObject2.getNestedSubObjects(arrayList, true);
        for (MetadataObjectHolder metadataObjectHolder : arrayList) {
            BaseMetadataObject baseMetadataObject3 = (BaseMetadataObject)metadataObjectHolder.getMetadataObject();
            baseMetadataObject3.getHolder().setFetchStatus(2);
        }
        baseMetadataObject2.getHolder().setFetchStatus(2);
    }

    public void flushCachedAW(AW aW) {
        this.flushCachedObject(aW);
        Iterator iterator = aW.getCubes().iterator();
        while (iterator.hasNext()) {
            this.flushCachedObject((BaseMetadataObject)iterator.next());
        }
        iterator = aW.getDimensions().iterator();
        while (iterator.hasNext()) {
            this.flushCachedObject((BaseMetadataObject)iterator.next());
        }
    }

    public final MetadataObject fetchMetadataObject(String string) throws ObjectClosedException {
        return this.fetchMetadataObject(this.getObjectHolder(string));
    }

    public final List fetchMetadataObjects(String[] stringArray) throws ObjectClosedException {
        if (stringArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MetadataObjectHolder> arrayList = new ArrayList<MetadataObjectHolder>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(this.getObjectHolder(stringArray[i]));
        }
        ArrayList arrayList2 = new ArrayList(stringArray.length);
        this.fetchMetadataObjects(arrayList, arrayList2);
        return arrayList2;
    }

    final synchronized MetadataObject fetchMetadataObject(MetadataObjectHolder metadataObjectHolder) throws ObjectClosedException {
        if (null == metadataObjectHolder) {
            return null;
        }
        if (1 == metadataObjectHolder.getFetchStatus() || 3 == metadataObjectHolder.getFetchStatus()) {
            return metadataObjectHolder.getMetadataObject();
        }
        ArrayList arrayList = new ArrayList(1);
        ArrayList<MetadataObjectHolder> arrayList2 = new ArrayList<MetadataObjectHolder>(1);
        arrayList2.add(metadataObjectHolder);
        this.fetchMetadataObjects(arrayList2, arrayList);
        return (MetadataObject)arrayList.get(0);
    }

    final synchronized void fetchMetadataObjects(List list, ArrayList arrayList) throws ObjectClosedException {
        Object object;
        int n;
        if (list.isEmpty()) {
            return;
        }
        int n2 = 0;
        MetadataObjectFetchState[] metadataObjectFetchStateArray = new MetadataObjectFetchState[list.size()];
        for (n = 0; n < list.size(); ++n) {
            MetadataObjectFetchState metadataObjectFetchState;
            MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)list.get(n);
            metadataObjectFetchStateArray[n] = metadataObjectFetchState = new MetadataObjectFetchState(metadataObjectHolder);
            for (int i = 0; i < n; ++i) {
                object = metadataObjectFetchStateArray[i];
                if (!((MetadataObjectFetchState)object).isMatchingFetchRequest(metadataObjectFetchState)) continue;
                metadataObjectFetchState.updateAsDuplicateFetch((MetadataObjectFetchState)object);
                break;
            }
            if (!metadataObjectFetchState.needsFetch()) continue;
            ++n2;
        }
        if (0 != n2) {
            String[] stringArray = new String[n2];
            int n3 = 0;
            for (int i = 0; i < metadataObjectFetchStateArray.length; ++i) {
                MetadataObjectFetchState metadataObjectFetchState = metadataObjectFetchStateArray[i];
                metadataObjectFetchState.applyPreFetch();
                object = metadataObjectFetchState.getIDToFetch();
                if (null == object) continue;
                stringArray[n3++] = object;
            }
            this.getMetadataFetcher().fetchBaseMetadataObjects(stringArray);
        }
        arrayList.ensureCapacity(list.size());
        for (n = 0; n < metadataObjectFetchStateArray.length; ++n) {
            MetadataObjectFetchState metadataObjectFetchState = metadataObjectFetchStateArray[n];
            metadataObjectFetchState.applyPostFetch();
            arrayList.add(metadataObjectFetchState.getHolder().getMetadataObject());
        }
    }

    private final synchronized void fetchMetadataObjects(MetadataObjectHolder[] metadataObjectHolderArray, ArrayList arrayList) throws ObjectClosedException {
        if (0 == metadataObjectHolderArray.length) {
            return;
        }
        ArrayList<MetadataObjectHolder> arrayList2 = new ArrayList<MetadataObjectHolder>(metadataObjectHolderArray.length);
        for (int i = 0; i < metadataObjectHolderArray.length; ++i) {
            arrayList2.add(metadataObjectHolderArray[i]);
        }
        this.fetchMetadataObjects(arrayList2, arrayList);
    }

    public DataProvider getDataProvider() {
        return this.m_DataProvider;
    }

    public String getID() {
        if (null == this.m_ID) {
            this.m_ID = this.getMetadataFetcher().getID();
        }
        return this.m_ID;
    }

    private MetadataFetcher getMetadataFetcher() {
        return this.m_MetadataFetcher;
    }

    final synchronized MetadataObjectHolder getObjectHolder(String string) {
        return this.getObjectHolder(string, true);
    }

    final synchronized MetadataObjectHolder getObjectHolder(String string, boolean bl) {
        MetadataObjectHolder metadataObjectHolder = null;
        metadataObjectHolder = (MetadataObjectHolder)this.getObjectMap().get(string);
        if (null == metadataObjectHolder && bl) {
            FundamentalMetadataProvider fundamentalMetadataProvider = this.getDataProvider().getFundamentalMetadataProvider();
            FundamentalMetadataObject fundamentalMetadataObject = fundamentalMetadataProvider.getMetadataObject(string);
            metadataObjectHolder = null == fundamentalMetadataObject ? new MetadataObjectHolder(string) : new MetadataObjectHolder(string, fundamentalMetadataObject);
            this.getObjectMap().put(string, metadataObjectHolder);
        }
        return metadataObjectHolder;
    }

    private HashMap getObjectMap() {
        return this.m_ObjectMap;
    }

    final synchronized void registerMetadataObject(String string, BaseMetadataObject baseMetadataObject) {
        MetadataObjectHolder metadataObjectHolder = this.getObjectHolder(string);
        if (null != metadataObjectHolder.getMetadataObject()) {
            throw new DuplicateMetadataIDException("DuplicateMetadataID", string);
        }
        metadataObjectHolder.setMetadataObject(baseMetadataObject);
        baseMetadataObject.setHolder(metadataObjectHolder);
    }

    final synchronized void unregisterMetadataObject(BaseMetadataObject baseMetadataObject) {
        String string = baseMetadataObject.getInternalID();
        MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)this.getObjectMap().remove(string);
        metadataObjectHolder.setMetadataObject(null);
    }

    final synchronized void reregisterMetadataObject(BaseMetadataObject baseMetadataObject, String string) {
        String string2 = baseMetadataObject.getInternalID();
        if (string2.equals(string)) {
            return;
        }
        MetadataObjectHolder metadataObjectHolder = baseMetadataObject.getHolder();
        MetadataObjectHolder metadataObjectHolder2 = (MetadataObjectHolder)this.getObjectMap().remove(string);
        Debug._assert(metadataObjectHolder2 == metadataObjectHolder);
        MetadataObjectHolder metadataObjectHolder3 = (MetadataObjectHolder)this.getObjectMap().get(string2);
        if (null != metadataObjectHolder3 && metadataObjectHolder3 != metadataObjectHolder) {
            throw new DuplicateMetadataIDException("DuplicateMetadataID", string2);
        }
        this.getObjectMap().put(string2, metadataObjectHolder);
    }

    final synchronized void renameObjectHolder(MetadataObjectHolder metadataObjectHolder, String string) {
        Debug._assert(metadataObjectHolder.getMetadataObject() == null, "non-empty MetadataObjectHolder used in renameObjectHolder()");
        String string2 = metadataObjectHolder.getObjectID();
        if (string2.equals(string)) {
            return;
        }
        metadataObjectHolder.setObjectID(string);
        MetadataObjectHolder metadataObjectHolder2 = (MetadataObjectHolder)this.getObjectMap().remove(string2);
        Debug._assert(metadataObjectHolder2 == metadataObjectHolder);
        MetadataObjectHolder metadataObjectHolder3 = (MetadataObjectHolder)this.getObjectMap().get(string);
        if (null != metadataObjectHolder3 && metadataObjectHolder3 != metadataObjectHolder) {
            throw new DuplicateMetadataIDException("DuplicateMetadataID", string);
        }
        this.getObjectMap().put(string, metadataObjectHolder);
    }

    private void setDataProvider(DataProvider dataProvider) {
        this.m_DataProvider = dataProvider;
    }

    private void setMetadataFetcher(MetadataFetcher metadataFetcher) {
        this.m_MetadataFetcher = metadataFetcher;
    }

    private void setObjectMap(HashMap hashMap) {
        this.m_ObjectMap = hashMap;
    }

    public final void update() {
    }

    public final boolean supportsMetadataUpdate() {
        return true;
    }

    public synchronized BaseMetadataObject fetchClientMetadataObject(String string, short s, BaseMetadataObject baseMetadataObject) {
        BaseMetadataObject baseMetadataObject2 = null;
        MetadataObjectHolder metadataObjectHolder = this.getObjectHolder(string);
        baseMetadataObject2 = (BaseMetadataObject)metadataObjectHolder.getMetadataObject();
        if (null != baseMetadataObject2) {
            int n = metadataObjectHolder.getFetchStatus();
            if (null != baseMetadataObject) {
                n = baseMetadataObject.getHolder().getFetchStatus();
            }
            if (3 == n) {
                if (3 != metadataObjectHolder.getFetchStatus()) {
                    metadataObjectHolder.setFetchStatus(1);
                }
                if (!baseMetadataObject2.isPersistent() && s == 1) {
                    baseMetadataObject2.changePersistenceType(s, false);
                }
            } else if (1 != metadataObjectHolder.getFetchStatus()) {
                baseMetadataObject2 = (BaseMetadataObject)this.fetchMetadataObject(metadataObjectHolder);
            }
        }
        return baseMetadataObject2;
    }
}

