/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.List;
import oracle.express.ObjectClosedException;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorManagerInterface;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorSpecifierStruct;
import oracle.express.olapi.data.CursorFactory;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.express.olapi.data.full.CursorInputParameter;
import oracle.express.olapi.data.full.CursorInputTemplate;
import oracle.express.olapi.data.full.DataCursorManager;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.cursor.Cursor;
import oracle.olapi.data.cursor.CursorInput;
import oracle.olapi.data.cursor.SourceType;
import oracle.olapi.data.cursor.SpecificationUpdateNeededException;
import oracle.olapi.data.source.BooleanSource;
import oracle.olapi.data.source.CursorInfoSpecification;
import oracle.olapi.data.source.CursorManagerSpecification;
import oracle.olapi.data.source.CursorManagerSpecificationExpiredException;
import oracle.olapi.data.source.DateSource;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SpecifiedCursorManager;
import oracle.olapi.data.source.StringSource;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionInactiveException;
import oracle.olapi.transaction.TransactionTypeUnavailableException;
import oracle.olapi.transaction.TransactionalObjectInvalidException;
import oracle.olapi.transaction.WriteLockException;

public class ExpressSpecifiedCursorManager
extends DataCursorManager
implements SpecifiedCursorManager {
    private CursorManagerSpecification m_CursorManagerSpecification = null;
    private CursorInputTemplate m_CursorInputTemplate = null;

    ExpressSpecifiedCursorManager(Source source, CursorManagerSpecification cursorManagerSpecification, CursorManagerInterface cursorManagerInterface, long l, DefinitionManager definitionManager, CursorInputTemplate cursorInputTemplate, List list) throws CursorManagerSpecificationExpiredException {
        super(source, cursorManagerInterface, l, definitionManager, list);
        this.setNeedsSpecificationUpdate(false);
        this.setCursorManagerSpecification(cursorManagerSpecification);
        this.m_CursorInputTemplate = cursorInputTemplate;
    }

    final CursorInputTemplate getCursorInputTemplate() {
        return this.m_CursorInputTemplate;
    }

    @Override
    protected final List getParameters() {
        if (this.getDefinitionManager().getDataProvider().isServerVersionLaterThan(new int[]{10, 0, 0, 0})) {
            return super.getParameters();
        }
        return this.getCursorInputTemplate().getParameters();
    }

    public static SourceType[] calculateInputSourceTypes(Source[] sourceArray) {
        SourceType[] sourceTypeArray = new SourceType[sourceArray.length];
        for (int i = 0; i < sourceArray.length; ++i) {
            Source source = sourceArray[i];
            sourceTypeArray[i] = source instanceof NumberSource ? SourceType.NUMBER_SOURCE : (source instanceof StringSource ? SourceType.STRING_SOURCE : (source instanceof BooleanSource ? SourceType.BOOLEAN_SOURCE : (source instanceof DateSource ? SourceType.DATE_SOURCE : SourceType.VALUE_SOURCE)));
        }
        return sourceTypeArray;
    }

    @Override
    public final synchronized Cursor createCursor() throws SpecificationUpdateNeededException {
        return this.createCursor(null);
    }

    @Override
    public final synchronized Cursor createCursor(CursorInput[] cursorInputArray) {
        this.commitIncrementalTransaction();
        if (this.isSpecificationUpdateNeeded()) {
            throw new SpecificationUpdateNeededException();
        }
        this.getCursorInputTemplate().addCursorInputs(cursorInputArray);
        if (!this.isPreparedForOpenCursor()) {
            this.prepareForOpenCursor(this.getCursorManagerSpecification().getRootCursorSpecification(), null);
        }
        Parameter[] parameterArray = new Parameter[this.getParameters().size()];
        this.getParameters().toArray(parameterArray);
        CursorTreeManager cursorTreeManager = CursorFactory.createCursorTreeManager(this.getNumCursorStructures(), this.getCursorBlockManager(), parameterArray);
        Cursor cursor = CursorFactory.createCursor(this.getRootCursorStructure(), cursorTreeManager);
        for (int i = 0; i < parameterArray.length; ++i) {
            Parameter parameter = parameterArray[i];
            if (!(parameter instanceof CursorInputParameter)) continue;
            CursorInputParameter cursorInputParameter = (CursorInputParameter)parameter;
            cursorInputParameter.addCursorTreeManager(cursorTreeManager);
        }
        return cursor;
    }

    private final CursorManagerSpecification getCursorManagerSpecification() {
        return this.m_CursorManagerSpecification;
    }

    @Override
    final boolean inputSourcesModified(Transaction transaction) {
        return this.getCursorInputTemplate().getDefinition().isModified(transaction);
    }

    @Override
    public final Source[] getInputSources() throws TransactionalObjectInvalidException, TransactionTypeUnavailableException, TransactionInactiveException {
        return this.getCursorInputTemplate().getInputSources();
    }

    final SourceType[] getInputSourceTypes() {
        return this.getCursorInputTemplate().getInputSourceTypes();
    }

    public final CursorManagerInterface getRemoteStub() throws ObjectClosedException {
        return this.getCursorManagerInterface();
    }

    final void setCursorManagerSpecification(CursorManagerSpecification cursorManagerSpecification) {
        this.m_CursorManagerSpecification = cursorManagerSpecification;
    }

    @Override
    public final void setInputSources(Source[] sourceArray) throws WriteLockException, TransactionTypeUnavailableException, TransactionInactiveException {
        Source[] sourceArray2 = sourceArray;
        if (null == sourceArray2) {
            sourceArray2 = new Source[]{};
        }
        this.getCursorInputTemplate().setInputSources(sourceArray2, ExpressSpecifiedCursorManager.calculateInputSourceTypes(sourceArray2));
    }

    @Override
    public final synchronized void updateSpecification(CursorManagerSpecification cursorManagerSpecification) throws CursorManagerSpecificationExpiredException, IllegalArgumentException {
        this.validateSpecification(cursorManagerSpecification);
        this.setCursorManagerSpecification(cursorManagerSpecification);
        CursorSpecifierStruct[] cursorSpecifierStructArray = DefinitionManager.convertCursorManagerSpecification(cursorManagerSpecification);
        this.updateSpecification(cursorSpecifierStructArray);
    }

    private final void validateSpecification(CursorManagerSpecification cursorManagerSpecification) throws CursorManagerSpecificationExpiredException, IllegalArgumentException {
        if (!this.getCursorManagerSpecification().getRootCursorSpecification().getSource().equals(cursorManagerSpecification.getRootCursorSpecification().getSource())) {
            throw new IllegalArgumentException();
        }
        if (!this.getTransaction().equals(cursorManagerSpecification.getTransaction())) {
            throw new IllegalArgumentException();
        }
        if (cursorManagerSpecification.isExpired()) {
            throw new CursorManagerSpecificationExpiredException();
        }
    }

    @Override
    public final void updateSpecification(CursorInfoSpecification cursorInfoSpecification) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getFetchSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setFetchSize(int n) {
        throw new UnsupportedOperationException();
    }
}

