/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.express.ErrorDescription;
import oracle.express.ExpressServerException;
import oracle.express.ObjectClosedException;
import oracle.express.TaskInterruptedException;
import oracle.express.UnexpectedException;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.RemoteObjectClosedException;
import oracle.express.idl.ExpressModule.RemoteTaskInterruptedException;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorBlock2SequenceHolder;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorBlock3SequenceHolder;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorBlockSequenceHolder;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorManagerInterface;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorSpecifierStruct;
import oracle.express.idl.ExpressOlapiDataSourceModule.CursorManagerSequenceHolder;
import oracle.express.idl.ExpressOlapiDataSourceModule.DefinitionManagerInterface;
import oracle.express.idl.ExpressOlapiDataSourceModule.UnmatchedInputsException;
import oracle.express.idl.reconciliation.TxsOqCursorBlockSequenceHelper;
import oracle.express.idl.reconciliation.TxsOqCursorBlockStruct;
import oracle.express.idl.reconciliation.TxsOqCursorValueUnion;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.WstringHolder;
import oracle.express.idl.util.XMLWriter;
import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.SourceIdentifierProvider;
import oracle.express.olapi.data.full.BaseCursorManager;
import oracle.express.olapi.data.full.CursorInputTemplate;
import oracle.express.olapi.data.full.CursorSpecifierSequenceBuilder;
import oracle.express.olapi.data.full.DataCursorManager;
import oracle.express.olapi.data.full.ExpressDataCursorManager;
import oracle.express.olapi.data.full.ExpressNotCommittableException;
import oracle.express.olapi.data.full.ExpressSQLCursorManager;
import oracle.express.olapi.data.full.ExpressSpecifiedCursorManager;
import oracle.express.olapi.data.full.ServerXMLReader;
import oracle.express.olapi.data.full.SourceConverter;
import oracle.express.olapi.data.full.SourceToXMLConverter;
import oracle.olapi.Debug;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.cursor.CursorManager;
import oracle.olapi.data.cursor.NoDataAvailableException;
import oracle.olapi.data.cursor.SourceIdentifier;
import oracle.olapi.data.cursor.SourceType;
import oracle.olapi.data.source.CursorInfoSpecification;
import oracle.olapi.data.source.CursorLock;
import oracle.olapi.data.source.CursorLockException;
import oracle.olapi.data.source.CursorManagerSpecification;
import oracle.olapi.data.source.CursorSpecification;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.SpecifiedCursorManager;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.InvalidMetadataException;
import oracle.olapi.metadata.MetadataToXMLConverterPrior10105;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.session.UserSession;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.Transaction;
import org.omg.CORBA.NO_IMPLEMENT;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DefinitionManager
implements SourceIdentifierProvider,
CursorLock {
    private boolean m_Open = true;
    private BaseTransaction m_Transaction;
    private DataProvider m_DataProvider;
    private List m_OpenCursorManagers;
    private DefinitionManagerInterface m_DefinitionManagerInterface;
    private Transaction m_PreparedSubtransaction;
    private SourceConverter m_SourceConverter;
    private long m_definitionManagerID = -1L;
    private ServerXMLReader m_XMLReader = null;

    private DefinitionManagerInterface getDefinitionManagerInterface() {
        return this.m_DefinitionManagerInterface;
    }

    private DefinitionManagerInterface getDefinitionManagerInterfaceCheck() throws ObjectClosedException {
        if (!this.isOpen()) {
            throw new ObjectClosedException();
        }
        return this.getDefinitionManagerInterface();
    }

    private void createDefinitionManagerInterface() throws ObjectClosedException, ExpressServerException {
        try {
            UserSession userSession = this.getDataProvider().getCurrentSession();
            this.m_DefinitionManagerInterface = userSession.getDataProviderInterface().createDfnMgrWithNoArgs();
        }
        catch (Exception exception) {
            this.handleException(exception, true);
        }
    }

    public void callGeneric(String string, XMLWriter xMLWriter, WstringHolder wstringHolder) {
        try {
            this.getDefinitionManagerInterface().generic(string, xMLWriter, wstringHolder);
        }
        catch (Exception exception) {
            this.handleException(exception, false);
        }
    }

    private CursorManagerInterface[] createCursorManagerInterfaces(CursorSpecifierStruct[][] cursorSpecifierStructArray, SourceDefinition[] sourceDefinitionArray, Source[][] sourceArray, long l, List[] listArray, long[] lArray, TxsOqCursorBlockStruct[] txsOqCursorBlockStructArray, Properties properties) throws ObjectClosedException, ExpressServerException {
        int n = sourceDefinitionArray.length;
        CursorManagerInterface[] cursorManagerInterfaceArray = null;
        SourceConverter sourceConverter = this.getSourceConverter();
        sourceConverter.reset((InterfaceStub)((Object)this.getDefinitionManagerInterface()), this.getTransaction());
        try {
            TxsOqCursorBlockStruct[] txsOqCursorBlockStructArray2;
            Object object;
            for (int i = 0; i < n; ++i) {
                object = sourceArray[i];
                if (object == null) {
                    object = new Source[]{};
                }
                sourceConverter.convertDefinitionTree(sourceDefinitionArray[i], (Source[])object, true, 0L, true, listArray[i]);
            }
            if (sourceConverter instanceof SourceToXMLConverter) {
                ((SourceToXMLConverter)sourceConverter).convertParametersForCreateCursorManager(true, l, false, false, false, false);
            }
            XMLWriter xMLWriter = sourceConverter.finishup((InterfaceStub)((Object)this.getDefinitionManagerInterface()), properties);
            object = new WstringHolder();
            CursorManagerSequenceHolder cursorManagerSequenceHolder = new CursorManagerSequenceHolder();
            short[][] sArrayArray = new short[][]{SourceType.getTypeIdentifiers(sourceConverter.getInputSourceTypeArray())};
            if (this.fetchInitialBlocks()) {
                Object object2;
                if (((InterfaceStub)((Object)this.getDefinitionManagerInterface())).isPostServerVsnnum("11.0.0.0.0")) {
                    object2 = new CursorBlock3SequenceHolder();
                    this.getDefinitionManagerInterface().crtCurMgrs6(sArrayArray, cursorSpecifierStructArray, xMLWriter, (WstringHolder)object, cursorManagerSequenceHolder, (CursorBlock3SequenceHolder)object2);
                    txsOqCursorBlockStructArray2 = TxsOqCursorBlockSequenceHelper.convertFrom(((CursorBlock3SequenceHolder)object2).value);
                } else if (((InterfaceStub)((Object)this.getDefinitionManagerInterface())).isPostServerVsnnum("10.1.0.5.0")) {
                    object2 = new CursorBlock2SequenceHolder();
                    this.getDefinitionManagerInterface().crtCurMgrs5(sArrayArray, cursorSpecifierStructArray, xMLWriter, (WstringHolder)object, cursorManagerSequenceHolder, (CursorBlock2SequenceHolder)object2);
                    txsOqCursorBlockStructArray2 = TxsOqCursorBlockSequenceHelper.convertFrom(((CursorBlock2SequenceHolder)object2).value);
                } else {
                    object2 = new CursorBlockSequenceHolder();
                    this.getDefinitionManagerInterface().crtCurMgrs4(sArrayArray, cursorSpecifierStructArray, xMLWriter, (WstringHolder)object, cursorManagerSequenceHolder, (CursorBlockSequenceHolder)object2);
                    txsOqCursorBlockStructArray2 = TxsOqCursorBlockSequenceHelper.convertFrom(((CursorBlockSequenceHolder)object2).value);
                }
                System.arraycopy(txsOqCursorBlockStructArray2, 0, txsOqCursorBlockStructArray, 0, n);
            } else {
                this.getDefinitionManagerInterface().crtCurMgrs2(sArrayArray, cursorSpecifierStructArray, xMLWriter, (WstringHolder)object, cursorManagerSequenceHolder);
            }
            cursorManagerInterfaceArray = cursorManagerSequenceHolder.value;
            txsOqCursorBlockStructArray2 = new StringReader(object.value);
            boolean bl = this.getXMLReader().readGeneratedSQLStatements((Reader)txsOqCursorBlockStructArray2, null, lArray);
            if (!bl) {
                Debug._assert(false);
                throw new RuntimeException();
            }
            if (cursorManagerInterfaceArray.length != n) {
                Debug._assert(false);
                throw new RuntimeException();
            }
            sourceConverter.success();
        }
        catch (Exception exception) {
            this.handleException(exception, true);
        }
        return cursorManagerInterfaceArray;
    }

    private boolean fetchInitialBlocks() {
        DataProvider dataProvider = this.getDataProvider();
        boolean bl = dataProvider.isServerVersionLaterThan(new int[]{10, 1, 0, 0, 0}) && !dataProvider.isServerVersionLaterThan(new int[]{10, 1, 0, 3, 0});
        return dataProvider.isServerVersionLaterThan(new int[]{9, 2, 0, 7, 0}) && !bl;
    }

    private ServerXMLReader getXMLReader() {
        return this.m_XMLReader;
    }

    private void setXMLReader(ServerXMLReader serverXMLReader) {
        this.m_XMLReader = serverXMLReader;
    }

    public void setTransaction(BaseTransaction baseTransaction) {
        this.m_Transaction = baseTransaction;
    }

    private Transaction getPreparedSubtransaction() {
        return this.m_PreparedSubtransaction;
    }

    private void setPreparedSubtransaction(Transaction transaction) {
        this.m_PreparedSubtransaction = transaction;
    }

    private final boolean localPrepare(BaseTransaction baseTransaction) throws oracle.olapi.data.source.UnmatchedInputsException, ExpressNotCommittableException {
        try {
            SourceConverter sourceConverter = this.getSourceConverter();
            XMLWriter xMLWriter = sourceConverter.finishup((InterfaceStub)((Object)this.getDefinitionManagerInterface()), null);
            boolean bl = false;
            bl = this.getDefinitionManagerInterfaceCheck().prepare2(SourceType.getTypeIdentifiers(sourceConverter.getInputSourceTypeArray()), sourceConverter.getInputSourceCountArray(), sourceConverter.getCursorManagerIDArray(), xMLWriter);
            sourceConverter.success();
            this.setPreparedSubtransaction(baseTransaction);
            return bl;
        }
        catch (Exception exception) {
            this.handleException(exception, true);
            return false;
        }
    }

    static CursorSpecifierStruct[] convertCursorSpecification(CursorSpecification cursorSpecification) {
        ArrayList arrayList = new ArrayList();
        cursorSpecification.acceptVisitor(new CursorSpecifierSequenceBuilder(), arrayList);
        CursorSpecifierStruct[] cursorSpecifierStructArray = new CursorSpecifierStruct[arrayList.size()];
        return arrayList.toArray(cursorSpecifierStructArray);
    }

    static final CursorSpecifierStruct[] convertCursorManagerSpecification(CursorManagerSpecification cursorManagerSpecification) {
        CursorSpecification cursorSpecification = cursorManagerSpecification.getRootCursorSpecification();
        return DefinitionManager.convertCursorSpecification(cursorSpecification);
    }

    static final CursorSpecifierStruct[] convertCursorInfoSpecification(int n, CursorInfoSpecification cursorInfoSpecification) {
        if (!(cursorInfoSpecification instanceof CursorSpecification)) {
            throw new UnsupportedOperationException();
        }
        CursorSpecification cursorSpecification = (CursorSpecification)cursorInfoSpecification;
        if (n >= 1) {
            cursorSpecification.setDefaultFetchSize(n);
        } else if (n == -1) {
            cursorSpecification.setDefaultFetchSize(0x7FFFFFFE);
        } else {
            throw new IllegalArgumentException();
        }
        return DefinitionManager.convertCursorSpecification(cursorSpecification);
    }

    private void handleException(Exception exception) {
        this.handleException(exception, true);
    }

    private void handleException(Exception exception, boolean bl) {
        try {
            throw exception;
        }
        catch (ExpressException expressException) {
            ExpressServerException expressServerException = new ExpressServerException(expressException);
            ErrorDescription errorDescription = (ErrorDescription)expressServerException.getErrorStack().getErrorDescriptions().get(0);
            if (errorDescription.getErrorType() == 1) {
                throw new NoDataAvailableException();
            }
            throw expressServerException;
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            if (bl) {
                this.closeDefinitionManager();
            }
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
        catch (UnmatchedInputsException unmatchedInputsException) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < unmatchedInputsException.ids.length; ++i) {
                arrayList.add(unmatchedInputsException.ids[i]);
            }
            throw new oracle.olapi.data.source.UnmatchedInputsException(arrayList);
        }
        catch (oracle.express.idl.ExpressModule.InvalidMetadataException invalidMetadataException) {
            throw new InvalidMetadataException(invalidMetadataException);
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            if (bl) {
                this.closeDefinitionManager();
            }
            throw new ObjectClosedException(exception.toString());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception2) {
            throw new UnexpectedException(exception2.toString());
        }
    }

    public DefinitionManager(BaseTransaction baseTransaction, DataProvider dataProvider) throws ObjectClosedException, ExpressServerException {
        this.m_Transaction = baseTransaction;
        this.m_DataProvider = dataProvider;
        this.m_OpenCursorManagers = new ArrayList();
        this.m_DataProvider._definitionManagerOpened(this);
        this.m_SourceConverter = null;
        this.createDefinitionManagerInterface();
        ServerXMLReader serverXMLReader = new ServerXMLReader();
        serverXMLReader.init();
        this.setXMLReader(serverXMLReader);
        this.m_SourceConverter = SourceToXMLConverter.createSourceToXMLConverter(this.getDataProvider().getServerVersion(), this);
    }

    public final DataProvider getDataProvider() {
        return this.m_DataProvider;
    }

    protected List getOpenCursorManagers() {
        return this.m_OpenCursorManagers;
    }

    SourceConverter getSourceConverter() {
        return this.m_SourceConverter;
    }

    @Override
    public BaseTransaction getTransaction() {
        return this.m_Transaction;
    }

    boolean isOpen() {
        if (this.m_Open) {
            this.m_Open = this.getDataProvider().isOpen();
        }
        return this.m_Open;
    }

    public long getDefinitionManagerID() {
        if (-1L == this.m_definitionManagerID) {
            this.m_definitionManagerID = this.getDefinitionManagerInterface().getInternalID();
        }
        return this.m_definitionManagerID;
    }

    void closeDefinitionManager() {
        this.m_Open = false;
        this.getDataProvider()._definitionManagerClosed(this);
    }

    final synchronized void cursorManagerClosed(BaseCursorManager baseCursorManager) {
        this.getOpenCursorManagers().remove(baseCursorManager);
    }

    final synchronized void cursorManagerOpened(BaseCursorManager baseCursorManager) {
        this.getOpenCursorManagers().add(baseCursorManager);
    }

    public final synchronized void prepare(BaseTransaction baseTransaction) throws NotCommittableException {
        if (null == baseTransaction || null == baseTransaction.getDefinitionManager()) {
            return;
        }
        try {
            this.getDefinitionManagerInterface().mergeSrcInfoToParentDfnMgr(baseTransaction.getDefinitionManager().getDefinitionManagerID());
        }
        catch (ExpressException expressException) {
            throw new ExpressNotCommittableException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            this.closeDefinitionManager();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        baseTransaction.getDefinitionManager().getSourceConverter().mergeChildTransactionOnCommit(this.getSourceConverter());
    }

    public synchronized void prepareSubtransaction(BaseTransaction baseTransaction) throws NotCommittableException {
        if (this.getOpenCursorManagers().isEmpty()) {
            return;
        }
        this.setPreparedSubtransaction(baseTransaction);
        SourceConverter sourceConverter = this.getSourceConverter();
        sourceConverter.reset((InterfaceStub)((Object)this.getDefinitionManagerInterface()), baseTransaction);
        try {
            for (BaseCursorManager baseCursorManager : this.getOpenCursorManagers()) {
                baseCursorManager.createDefinitionSequence(baseTransaction, sourceConverter);
            }
        }
        catch (CursorLockException cursorLockException) {
            sourceConverter.recover();
            throw new NotCommittableException(cursorLockException.toString());
        }
        Object object = sourceConverter.getCursorManagerIDArray();
        if (0 == ((Object)object).length) {
            return;
        }
        boolean bl = this.localPrepare(baseTransaction);
        for (BaseCursorManager baseCursorManager : this.getOpenCursorManagers()) {
            DataCursorManager dataCursorManager;
            if (!(baseCursorManager instanceof DataCursorManager) || !sourceConverter.cursorManagerWasSent((dataCursorManager = (DataCursorManager)baseCursorManager).getCursorManagerID())) continue;
            if (bl) {
                dataCursorManager._structureUpdated();
                continue;
            }
            dataCursorManager._dataUpdated();
        }
    }

    public final void rollback() {
        try {
            this.getDefinitionManagerInterfaceCheck().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeDefinitionManager();
    }

    public final void rollbackSubtransaction(BaseTransaction baseTransaction) {
        if (this.getPreparedSubtransaction() != baseTransaction) {
            return;
        }
        try {
            this.getDefinitionManagerInterfaceCheck().rollback();
        }
        catch (ExpressException expressException) {
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            this.closeDefinitionManager();
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            this.closeDefinitionManager();
        }
        finally {
            this.setPreparedSubtransaction(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit(BaseTransaction baseTransaction) {
        BaseTransaction baseTransaction2 = null;
        if (null == baseTransaction) {
            return;
        }
        if (null != baseTransaction.getDefinitionManager()) {
            try {
                this.getDefinitionManagerInterface().close();
            }
            catch (NO_IMPLEMENT nO_IMPLEMENT) {
            }
            catch (Exception exception) {
                this.handleException(exception, false);
            }
            finally {
                this.closeDefinitionManager();
            }
            return;
        }
        DefinitionManager definitionManager = baseTransaction.getDefinitionManager();
        for (ExpressSpecifiedCursorManager expressSpecifiedCursorManager : this.getOpenCursorManagers()) {
            expressSpecifiedCursorManager._closed();
        }
        baseTransaction2.setDefinitionManager(this);
        this.setTransaction(baseTransaction2);
    }

    public final void commitSubtransaction() {
        this.setPreparedSubtransaction(null);
    }

    public final InvalidMetadataException commitRoot() throws NotCommittableException {
        return this.commitRoot(null);
    }

    public final InvalidMetadataException commitRoot(Properties properties) throws NotCommittableException {
        Object object;
        Object object2;
        Object object3;
        SourceConverter sourceConverter = this.getSourceConverter();
        sourceConverter.reset((InterfaceStub)((Object)this.getDefinitionManagerInterface()), this.getTransaction());
        MdmMetadataProvider mdmMetadataProvider = this.getDataProvider().getMdmMetadataProvider();
        if (sourceConverter.getMetadataToXMLConverter().getXMLFormat().is10gMode()) {
            sourceConverter.getMetadataToXMLConverter().addMetadataObject(mdmMetadataProvider.getRootSchema());
        } else {
            object3 = new ArrayList();
            this.getTransaction().getModifiedMetadataObjectsSince(null, (List)object3);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof BaseMetadataObject)) continue;
                sourceConverter.getMetadataToXMLConverter().addMetadataObject(((BaseMetadataObject)object).getTopContainedByObject());
            }
        }
        object3 = sourceConverter.finishup((InterfaceStub)((Object)this.getDefinitionManagerInterface()), properties);
        object2 = new WstringHolder();
        this.callGeneric("CommitRoot", (XMLWriter)object3, (WstringHolder)object2);
        this.commit(null);
        object = null;
        if (null != ((WstringHolder)object2).value) {
            InputSource inputSource = new InputSource(new StringReader(((WstringHolder)object2).value));
            MetadataXMLReader metadataXMLReader = this.createXMLReader();
            object = this.processXML(inputSource, metadataXMLReader);
        }
        this.getTransaction().updateParticipantStates();
        sourceConverter.handleCommitRoot();
        return object;
    }

    public void rollbackState() {
        this.getSourceConverter().getMetadataToXMLConverter().rollbackState();
    }

    public void bulkSendMetadata() throws ObjectClosedException, ExpressServerException {
        Object var1_1 = null;
        try {
            SourceConverter sourceConverter = this.getSourceConverter();
            sourceConverter.reset((InterfaceStub)((Object)this.getDefinitionManagerInterface()), this.getTransaction());
            MdmMetadataProvider mdmMetadataProvider = this.getDataProvider().getMdmMetadataProvider();
            ((MetadataToXMLConverterPrior10105)sourceConverter.getMetadataToXMLConverter()).setIsForBulkSend(true);
            sourceConverter.getMetadataToXMLConverter().addMetadataObject(mdmMetadataProvider.getRootSchema());
            XMLWriter xMLWriter = sourceConverter.finishup((InterfaceStub)((Object)this.getDefinitionManagerInterface()), null);
            CursorManagerSequenceHolder cursorManagerSequenceHolder = new CursorManagerSequenceHolder();
            CursorSpecifierStruct[][] cursorSpecifierStructArray = new CursorSpecifierStruct[][]{};
            short[][] sArrayArray = new short[][]{};
            WstringHolder wstringHolder = new WstringHolder();
            this.getDefinitionManagerInterface().crtCurMgrs2(sArrayArray, cursorSpecifierStructArray, xMLWriter, wstringHolder, cursorManagerSequenceHolder);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public final ExpressSQLCursorManager[] createSQLCursorManagers(Source[] sourceArray, long l, boolean bl, boolean bl2, String[] stringArray, Properties properties) throws ObjectClosedException, ExpressServerException {
        int n = sourceArray.length;
        ExpressSQLCursorManager[] expressSQLCursorManagerArray = new ExpressSQLCursorManager[n];
        try {
            int n2;
            SourceToXMLConverter sourceToXMLConverter = (SourceToXMLConverter)this.getSourceConverter();
            sourceToXMLConverter.reset((InterfaceStub)((Object)this.getDefinitionManagerInterface()), this.getTransaction());
            List[] listArray = new List[n];
            for (n2 = 0; n2 < n; ++n2) {
                listArray[n2] = new ArrayList();
                sourceToXMLConverter.convertDefinitionTree(sourceArray[n2].getDefinition(), new Source[0], false, 0L, true, listArray[n2]);
            }
            DataProvider dataProvider = this.getDataProvider();
            boolean bl3 = dataProvider.isServerVersionLaterThan(new int[]{10, 1, 0, 3, 0});
            if (!bl3 && bl) {
                throw new UnsupportedOperationException();
            }
            sourceToXMLConverter.convertParametersForCreateCursorManager(true, l, bl3, bl, true, bl2);
            XMLWriter xMLWriter = sourceToXMLConverter.finishup((InterfaceStub)((Object)this.getDefinitionManagerInterface()), properties);
            WstringHolder wstringHolder = new WstringHolder();
            CursorManagerSequenceHolder cursorManagerSequenceHolder = new CursorManagerSequenceHolder();
            this.getDefinitionManagerInterface().crtCurMgrs3(xMLWriter, wstringHolder, cursorManagerSequenceHolder);
            sourceToXMLConverter.success();
            CursorManagerInterface[] cursorManagerInterfaceArray = cursorManagerSequenceHolder.value;
            long[] lArray = new long[n];
            StringReader stringReader = new StringReader(wstringHolder.value);
            boolean bl4 = this.getXMLReader().readGeneratedSQLStatements(stringReader, stringArray, lArray);
            if (!bl4) {
                Debug._assert(false);
                throw new RuntimeException();
            }
            if (cursorManagerInterfaceArray.length != n) {
                throw new RuntimeException();
            }
            for (n2 = 0; n2 < n; ++n2) {
                ExpressSQLCursorManager expressSQLCursorManager;
                expressSQLCursorManagerArray[n2] = expressSQLCursorManager = new ExpressSQLCursorManager(sourceArray[n2], cursorManagerInterfaceArray[n2], lArray[n2], this, listArray[n2]);
                this.cursorManagerOpened(expressSQLCursorManager);
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return expressSQLCursorManagerArray;
    }

    public final ExpressSpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification, CursorInputTemplate cursorInputTemplate, long l, Properties properties) throws ObjectClosedException, ExpressServerException {
        SourceDefinition[] sourceDefinitionArray;
        Source source = cursorInputTemplate.getSource();
        ArrayList arrayList = new ArrayList();
        long[] lArray = new long[1];
        CursorManagerInterface cursorManagerInterface = null;
        try {
            CursorSpecifierStruct[][] cursorSpecifierStructArray = new CursorSpecifierStruct[1][];
            List[] listArray = new List[1];
            sourceDefinitionArray = new SourceDefinition[1];
            Source[][] sourceArray = new Source[1][];
            cursorSpecifierStructArray[0] = DefinitionManager.convertCursorManagerSpecification(cursorManagerSpecification);
            sourceArray[0] = null;
            if (!this.getDataProvider().areParametersSupported()) {
                sourceArray[0] = cursorInputTemplate.getInputSources();
            }
            sourceDefinitionArray[0] = source.getDefinition();
            listArray[0] = arrayList;
            CursorManagerInterface[] cursorManagerInterfaceArray = this.createCursorManagerInterfaces(cursorSpecifierStructArray, sourceDefinitionArray, sourceArray, l, listArray, lArray, null, properties);
            cursorManagerInterface = cursorManagerInterfaceArray[0];
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        long l2 = lArray[0];
        sourceDefinitionArray = new ExpressSpecifiedCursorManager(source, cursorManagerSpecification, cursorManagerInterface, l2, this, cursorInputTemplate, arrayList);
        this.cursorManagerOpened((BaseCursorManager)sourceDefinitionArray);
        return sourceDefinitionArray;
    }

    public final SpecifiedCursorManager[] createCursorManagers(CursorManagerSpecification[] cursorManagerSpecificationArray, CursorInputTemplate[] cursorInputTemplateArray, long l, Properties properties) throws ObjectClosedException, ExpressServerException {
        int n = cursorManagerSpecificationArray.length;
        SpecifiedCursorManager[] specifiedCursorManagerArray = new SpecifiedCursorManager[n];
        try {
            CursorManagerInterface[] cursorManagerInterfaceArray;
            TxsOqCursorBlockStruct[] txsOqCursorBlockStructArray;
            int n2;
            CursorSpecifierStruct[][] cursorSpecifierStructArray = new CursorSpecifierStruct[n][];
            List[] listArray = new List[n];
            SourceDefinition[] sourceDefinitionArray = new SourceDefinition[n];
            Source[][] sourceArray = new Source[n][];
            long[] lArray = new long[n];
            for (n2 = 0; n2 < n; ++n2) {
                txsOqCursorBlockStructArray = cursorManagerSpecificationArray[n2];
                cursorManagerInterfaceArray = cursorInputTemplateArray[n2].getSource();
                sourceDefinitionArray[n2] = cursorManagerInterfaceArray.getDefinition();
                sourceArray[n2] = null;
                if (!this.getDataProvider().areParametersSupported()) {
                    sourceArray[n2] = cursorInputTemplateArray[n2].getInputSources();
                }
                listArray[n2] = new ArrayList();
                cursorSpecifierStructArray[n2] = DefinitionManager.convertCursorManagerSpecification((CursorManagerSpecification)txsOqCursorBlockStructArray);
            }
            txsOqCursorBlockStructArray = new TxsOqCursorBlockStruct[n];
            cursorManagerInterfaceArray = this.createCursorManagerInterfaces(cursorSpecifierStructArray, sourceDefinitionArray, sourceArray, l, listArray, lArray, txsOqCursorBlockStructArray, properties);
            for (n2 = 0; n2 < n; ++n2) {
                CursorManagerSpecification cursorManagerSpecification = cursorManagerSpecificationArray[n2];
                Source source = cursorInputTemplateArray[n2].getSource();
                ExpressSpecifiedCursorManager expressSpecifiedCursorManager = new ExpressSpecifiedCursorManager(source, cursorManagerSpecification, cursorManagerInterfaceArray[n2], lArray[n2], this, cursorInputTemplateArray[n2], listArray[n2]);
                specifiedCursorManagerArray[n2] = expressSpecifiedCursorManager;
                this.cursorManagerOpened(expressSpecifiedCursorManager);
                if (!this.fetchInitialBlocks() || cursorInputTemplateArray[n2].getInputSources().length != 0 || listArray[n2].size() != 0) continue;
                CursorBlock cursorBlock = new CursorBlock(txsOqCursorBlockStructArray[n2], new TxsOqCursorValueUnion[0]);
                expressSpecifiedCursorManager.prepareForOpenCursor(cursorManagerSpecificationArray[n2].getRootCursorSpecification(), cursorBlock);
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return specifiedCursorManagerArray;
    }

    public final CursorManager[] createCursorManagers(Source[] sourceArray, int[] nArray, CursorInfoSpecification[] cursorInfoSpecificationArray, long l, Properties properties) throws ObjectClosedException, ExpressServerException {
        int n = sourceArray.length;
        CursorManager[] cursorManagerArray = new CursorManager[n];
        try {
            int n2;
            CursorSpecifierStruct[][] cursorSpecifierStructArray = new CursorSpecifierStruct[n][];
            List[] listArray = new List[n];
            SourceDefinition[] sourceDefinitionArray = new SourceDefinition[n];
            Source[][] sourceArray2 = new Source[n][];
            long[] lArray = new long[n];
            for (n2 = 0; n2 < n; ++n2) {
                sourceDefinitionArray[n2] = sourceArray[n2].getDefinition();
                listArray[n2] = new ArrayList();
                sourceArray2[n2] = null;
                cursorSpecifierStructArray[n2] = DefinitionManager.convertCursorInfoSpecification(nArray[n2], cursorInfoSpecificationArray[n2]);
            }
            TxsOqCursorBlockStruct[] txsOqCursorBlockStructArray = new TxsOqCursorBlockStruct[n];
            CursorManagerInterface[] cursorManagerInterfaceArray = this.createCursorManagerInterfaces(cursorSpecifierStructArray, sourceDefinitionArray, sourceArray2, l, listArray, lArray, txsOqCursorBlockStructArray, properties);
            for (n2 = 0; n2 < n; ++n2) {
                ExpressDataCursorManager expressDataCursorManager = new ExpressDataCursorManager(sourceArray[n2], nArray[n2], cursorInfoSpecificationArray[n2], cursorManagerInterfaceArray[n2], lArray[n2], this, listArray[n2]);
                cursorManagerArray[n2] = expressDataCursorManager;
                this.cursorManagerOpened(expressDataCursorManager);
                if (!this.fetchInitialBlocks() || listArray[n2].size() != 0) continue;
                CursorBlock cursorBlock = new CursorBlock(txsOqCursorBlockStructArray[n2], new TxsOqCursorValueUnion[0]);
                CursorSpecification cursorSpecification = null;
                try {
                    cursorSpecification = (CursorSpecification)cursorInfoSpecificationArray[n2];
                }
                catch (ClassCastException classCastException) {
                    throw new UnsupportedOperationException();
                }
                expressDataCursorManager.prepareForOpenCursor(cursorSpecification, cursorBlock);
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return cursorManagerArray;
    }

    @Override
    public final SourceIdentifier getSourceIdentifier(String string) {
        return null;
    }

    @Override
    public final SourceIdentifier getSourceIdentifier(String string, String string2) {
        return null;
    }

    private MetadataXMLReader createXMLReader() {
        short s = 3;
        MetadataXMLReader metadataXMLReader = new MetadataXMLReader(s, this.getDataProvider().getMdmMetadataProvider());
        return metadataXMLReader;
    }

    private InvalidMetadataException processXML(InputSource inputSource, MetadataXMLReader metadataXMLReader) {
        if (null == inputSource) {
            return null;
        }
        UserSession userSession = this.getDataProvider().getCurrentSession();
        metadataXMLReader.setUserCallback(userSession.getServerXMLParserCallback());
        try {
            metadataXMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        return metadataXMLReader.getRootCommitError();
    }
}

