/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.express.olapi.data.ExpressCursor;

class CursorValidationContext {
    private CursorTreeManager _cursorTreeManager;
    private CursorBlock _cursorBlock;
    private long[] _newPositions;
    private int[] _newIndices;
    private int[] _newDataIndices;

    public CursorValidationContext(CursorTreeManager cursorTreeManager, CursorBlock cursorBlock) {
        this._cursorTreeManager = cursorTreeManager;
        this._cursorBlock = cursorBlock;
        int n = cursorTreeManager.getNumCursors();
        this._newPositions = new long[n];
        this._newIndices = new int[n];
        this._newDataIndices = new int[n];
        for (int i = 0; i < n; ++i) {
            this._newPositions[i] = -1L;
            this._newIndices[i] = -1;
            this._newDataIndices[i] = -1;
        }
    }

    public final CursorTreeManager getCursorTreeManager() {
        return this._cursorTreeManager;
    }

    public final ExpressCursor getCursor(int n) {
        return this.getCursorTreeManager().getCursor(n);
    }

    public final CursorBlock getCursorBlock() {
        return this._cursorBlock;
    }

    private long[] getNewPositions() {
        return this._newPositions;
    }

    private int[] getNewIndices() {
        return this._newIndices;
    }

    private int[] getNewDataIndices() {
        return this._newDataIndices;
    }

    public final long getPosition(int n) {
        if (this.getNewPositions()[n] == -1L) {
            return this.getCursorTreeManager().getCursor(n).getPositionDirect();
        }
        return this.getNewPositions()[n];
    }

    public final int getIndex(int n) {
        if (this.getNewIndices()[n] == -1) {
            ExpressCursor expressCursor = this.getCursorTreeManager().getCursor(n);
            this.setNewIndex(n, expressCursor.getIndex(this));
        }
        return this.getNewIndices()[n];
    }

    public final int getDataIndex(int n) {
        return this.getNewDataIndices()[n];
    }

    public final void setNewIndex(int n, int n2) {
        this.getNewIndices()[n] = n2;
    }

    public final void setNewPosition(int n, long l) {
        this.getNewPositions()[n] = l;
    }

    public final void setNewDataIndex(int n, int n2) {
        this.getNewDataIndices()[n] = n2;
    }

    public final void setNewPositionAndIndex(int n, long l, int n2) {
        this.setNewPosition(n, l);
        this.setNewIndex(n, n2);
    }

    public final void commitState() {
        for (int i = 0; i < this.getCursorTreeManager().getNumCursors(); ++i) {
            ExpressCursor expressCursor = this.getCursorTreeManager().getCursor(i);
            long l = this.getPosition(i);
            int n = this.getIndex(i);
            int n2 = this.getDataIndex(i);
            expressCursor.setPositionToValid(l, n, n2);
        }
    }
}

