/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;
import oracle.sql.NUMBER;

public class ShortHelper {
    private ShortHelper() {
    }

    public static short SQL2Java(InterfaceStub interfaceStub, Integer n) {
        short s = n.shortValue();
        OlapiTracer.log("ShortHelper.SQL2Java: sqlshort = " + n + ", jshort = " + s);
        return s;
    }

    public static Integer Java2SQL(InterfaceStub interfaceStub, short s) {
        Integer n = new Integer(s);
        OlapiTracer.log("ShortHelper.Java2SQL: jshort = " + s + ", sqlshort = " + n);
        return n;
    }

    public static short SQL2Java(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable) {
        OlapiTracer.enter("ShortHelper.SQL2Java");
        short s = 0;
        try {
            byte[] byArray = new byte[olapiStreamable.read()];
            byte by = (byte)olapiStreamable.read();
            olapiStreamable.read(byArray);
            if (1 == by) {
                byArray[0] = (byte)(byArray[0] | 0x80);
            }
            s = NUMBER.toShort((byte[])byArray);
            OlapiTracer.log("jshort = " + s);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ShortHelper.SQL2Java");
        return s;
    }

    public static void Java2SQL(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable, short s) {
        OlapiTracer.enter("ShortHelper.Java2SQL");
        OlapiTracer.log("jshort = " + s);
        try {
            byte[] byArray = NUMBER.toBytes((short)s);
            olapiStreamable.write(byArray.length);
            if (byArray[0] >= 0) {
                olapiStreamable.write(0);
            } else {
                olapiStreamable.write(1);
                byArray[0] = (byte)(byArray[0] & 0x7F);
            }
            olapiStreamable.write(byArray);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ShortHelper.Java2SQL");
    }
}

