/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;
import oracle.sql.NUMBER;

public class ByteHelper {
    private ByteHelper() {
    }

    public static byte SQL2Java(InterfaceStub interfaceStub, Integer n) {
        byte by = n.byteValue();
        OlapiTracer.log("ByteHelper.SQL2Java: sqlbyte = " + n + ", jbyte = " + by);
        return by;
    }

    public static Integer Java2SQL(InterfaceStub interfaceStub, byte by) {
        Integer n = new Integer(by);
        OlapiTracer.log("ByteHelper.Java2SQL: jbyte = " + by + ", sqlbyte = " + n);
        return n;
    }

    public static byte SQL2Java(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable) {
        OlapiTracer.enter("ByteHelper.SQL2Java");
        byte by = 0;
        try {
            byte[] byArray = new byte[olapiStreamable.read()];
            byte by2 = (byte)olapiStreamable.read();
            olapiStreamable.read(byArray);
            if (1 == by2) {
                byArray[0] = (byte)(byArray[0] | 0x80);
            }
            by = NUMBER.toByte((byte[])byArray);
            OlapiTracer.log("jbyte = " + by);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ByteHelper.SQL2Java");
        return by;
    }

    public static void Java2SQL(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable, byte by) {
        OlapiTracer.enter("ByteHelper.Java2SQL");
        OlapiTracer.log("jbyte = " + by);
        try {
            byte[] byArray = NUMBER.toBytes((byte)by);
            olapiStreamable.write(byArray.length);
            if (byArray[0] >= 0) {
                olapiStreamable.write(0);
            } else {
                olapiStreamable.write(1);
                byArray[0] = (byte)(byArray[0] & 0x7F);
            }
            olapiStreamable.write(byArray);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ByteHelper.Java2SQL");
    }
}

