/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.transport;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.cmp.transport.TCPMessage;
import oracle.security.crypto.util.Utils;

public class PollRequestTCPMsg
extends TCPMessage {
    private static final TCPMessage.Type TYPE = TCPMessage.Type.POLL_REQ;
    private int pollRef;
    private transient byte[] contents;

    public PollRequestTCPMsg(TCPMessage.Version version, int pollRef) {
        super(version);
        this.pollRef = pollRef;
    }

    public PollRequestTCPMsg(int pollRef) {
        this(TCPMessage.Version.CMP2000, pollRef);
    }

    public PollRequestTCPMsg(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public TCPMessage.Type getType() {
        return TYPE;
    }

    public int getPollRef() {
        return this.pollRef;
    }

    public boolean checkStatus(int pollRef) {
        return this.pollRef == pollRef;
    }

    @Override
    byte[] getValueBytes() {
        if (this.contents == null) {
            this.contents = Utils.wordToBytes((int)this.pollRef);
        }
        return this.contents;
    }

    @Override
    void setValueBytes(byte[] value) {
        this.pollRef = Utils.bytesToWord((int)value[0], (int)value[1], (int)value[2], (int)value[3]);
        this.contents = value;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }

    public String toString() {
        return TYPE + " { pollRef = " + this.pollRef + " }";
    }
}

