/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.transport;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.cmp.transport.TCPMessage;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class FinalTCPMsg
extends TCPMessage {
    private static final TCPMessage.Type TYPE = TCPMessage.Type.FIN_REP;
    private transient byte[] contents;

    public FinalTCPMsg() {
        this(TCPMessage.Version.CMP2000);
    }

    public FinalTCPMsg(TCPMessage.Version version) {
        super(version);
    }

    public FinalTCPMsg(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public TCPMessage.Type getType() {
        return TYPE;
    }

    @Override
    byte[] getValueBytes() {
        if (this.contents == null) {
            this.contents = new byte[1];
        }
        return this.contents;
    }

    @Override
    void setValueBytes(byte[] value) {
        if (value[0] != 0) {
            throw new StreamableInputException("Unexpected finRep message value: " + Utils.toHexString((byte[])value));
        }
    }

    @Override
    void clearCache() {
        this.contents = null;
    }

    public String toString() {
        return TYPE + " { 0 }";
    }
}

