/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.RegistrationInfo;

public class UTF8PairsRegInfo
extends RegistrationInfo {
    private static final ASN1ObjectID TYPE = CMP.id_regInfo_utf8Pairs;
    private Vector names = new Vector();
    private Properties valTab = new Properties();
    private transient StringBuffer pairBuf = new StringBuffer();

    public UTF8PairsRegInfo() {
        super(TYPE, null);
    }

    public UTF8PairsRegInfo(String name, String value) {
        this();
        this.decoded = true;
        this.addPair(name, value);
    }

    public UTF8PairsRegInfo(ASN1String value) {
        super(TYPE, (ASN1Object)value);
        this.decoded = false;
        this.decodeValue();
    }

    public UTF8PairsRegInfo(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public String addPair(String name, String value) {
        String v = this.valTab.getProperty(name);
        if (v != null) {
            this.names.removeElement(name);
        }
        this.names.addElement(name);
        this.valTab.put(name, value);
        this.encoded = false;
        return v;
    }

    public String addPair(String name, GeneralName value) {
        String id = "";
        if (value.getType() == GeneralName.Type.DIRECTORY_NAME) {
            id = "X";
        } else if (value.getType() == GeneralName.Type.OTHER_NAME) {
            id = "O";
        } else if (value.getType() == GeneralName.Type.RFC822_NAME) {
            id = "E";
        } else if (value.getType() == GeneralName.Type.DNS_NAME) {
            id = "D";
        } else if (value.getType() == GeneralName.Type.URI) {
            id = "U";
        } else if (value.getType() == GeneralName.Type.IP_ADDRESS) {
            id = "I";
        }
        return this.addPair(name, id + value.toString());
    }

    public String addPair(Date notBefore, Date notAfter) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        String value = "";
        if (notBefore != null) {
            value = value + sdf.format(notBefore);
        }
        if (notAfter != null) {
            value = value + "-" + sdf.format(notAfter);
        }
        return this.addPair("validity", value);
    }

    public String getValue(String name) {
        this.decodeValue();
        return this.valTab.getProperty(name);
    }

    public Enumeration names() {
        this.decodeValue();
        return this.names.elements();
    }

    private void clearTables() {
        this.names.removeAllElements();
        this.valTab.clear();
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            StringBuffer pairBuf = new StringBuffer();
            int n = this.names.size();
            for (int i = 0; i < n; ++i) {
                String name = (String)this.names.elementAt(i);
                pairBuf.append(name);
                pairBuf.append('?');
                pairBuf.append(this.valTab.getProperty(name));
                pairBuf.append('%');
            }
            if (pairBuf.length() == 0) {
                pairBuf.append('%');
            }
            this.setValue((ASN1Object)new ASN1String(pairBuf.toString(), 12));
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            StringBuffer pairBuf = new StringBuffer(((ASN1String)this.getValue()).getValue());
            StringBuffer nameBuf = new StringBuffer();
            StringBuffer valueBuf = new StringBuffer();
            boolean gotName = false;
            this.clearTables();
            int n = pairBuf.length();
            for (int i = 0; i < n; ++i) {
                char c = pairBuf.charAt(i);
                if (c == '?') {
                    gotName = true;
                    continue;
                }
                if (c == '%') {
                    if (nameBuf.length() > 0 || valueBuf.length() > 0) {
                        this.addPair(nameBuf.toString(), valueBuf.toString());
                    }
                    nameBuf.setLength(0);
                    valueBuf.setLength(0);
                    gotName = false;
                    continue;
                }
                if (gotName) {
                    valueBuf.append(c);
                    continue;
                }
                nameBuf.append(c);
            }
            if (nameBuf.length() > 0 || valueBuf.length() > 0 || gotName) {
                throw new IllegalArgumentException("Invalid utf8Pairs encoding");
            }
            this.decoded = true;
        }
    }
}

