/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.PKIArchiveOptionRegControl;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class RegistrationControl
extends AttributeTypeAndValue {
    private static final CMP.OIDRegistrar oidReg = new CMP.OIDRegistrar();
    protected boolean encoded = false;
    protected boolean decoded = true;

    public RegistrationControl(ASN1ObjectID type, ASN1Object value) {
        super(type, null);
        this.setValue(value);
    }

    public void setValue(ASN1Object value) {
        super.setValue(value);
        this.encoded = value != null;
        this.decoded = false;
    }

    protected void encodeValue() {
        this.encoded = true;
    }

    protected void decodeValue() {
        this.decoded = true;
    }

    public static RegistrationControl inputInstance(InputStream is) throws IOException {
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        ASN1ObjectID type = new ASN1ObjectID((InputStream)sis);
        ASN1Object value = ASN1Utils.inputASN1Object((InputStream)sis);
        sis.terminate();
        Class cl = OIDManager.getOIDManager().getMapping(type, "registrationControl");
        if (cl == null) {
            return new RegistrationControl(type, value);
        }
        if (type.equals((Object)CMP.id_regCtrl_pkiArchiveOptions)) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)type);
            s.addElement(value);
            return PKIArchiveOptionRegControl.inputArchiveOption(Utils.toStream((Streamable)s));
        }
        RegistrationControl reg = null;
        try {
            reg = (RegistrationControl)((Object)cl.newInstance());
            reg.setValue(value);
        }
        catch (IllegalAccessException ex) {
            throw new IOException(ex.toString());
        }
        catch (InstantiationException ex) {
            throw new IOException(ex.toString());
        }
        catch (ClassCastException ex) {
            throw new IOException(ex.toString());
        }
        return reg;
    }

    public void input(InputStream is) throws IOException {
        super.input(is);
        this.encoded = true;
        this.decoded = false;
        this.decodeValue();
        if (!((Object)((Object)this)).getClass().equals(RegistrationControl.class)) {
            ASN1ObjectID type = this.getType();
            Class c = OIDManager.getOIDManager().getMapping(type, "registrationControl");
            if (c != null && !c.isAssignableFrom(((Object)((Object)this)).getClass())) {
                throw new InvalidInputException("RegistrationControl type " + type + " invalid for instance of " + ((Object)((Object)this)).getClass().getName());
            }
        }
    }

    public void output(OutputStream os) throws IOException {
        this.encodeValue();
        super.output(os);
    }

    public int length() {
        this.encodeValue();
        return super.length();
    }
}

