/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.PKIMessage;
import oracle.security.crypto.cmp.attribute.InfoTypeAndValue;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class OrigPKIMessageInfo
extends InfoTypeAndValue {
    private static final ASN1ObjectID TYPE = CMP.id_it_OrigPKIMessage;
    Vector pkiMsgs = new Vector();

    public OrigPKIMessageInfo() {
        super(TYPE);
        this.decoded = true;
    }

    public OrigPKIMessageInfo(PKIMessage pkiMsg) {
        this();
        this.addPKIMessage(pkiMsg);
    }

    public OrigPKIMessageInfo(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public void addPKIMessage(PKIMessage pkiMsg) {
        this.pkiMsgs.addElement(pkiMsg);
        this.encoded = false;
    }

    public Vector getPKIMessage() {
        this.decodeValue();
        return this.pkiMsgs;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("OriginalPKIMessage { ");
        int n = this.pkiMsgs.size();
        for (int i = 0; i < n; ++i) {
            s.append(this.pkiMsgs.elementAt(i).toString());
            if (i >= n - 1) continue;
            s.append(", ");
        }
        s.append(" }");
        return s.toString();
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            this.setValue((ASN1Object)new ASN1Sequence(this.pkiMsgs));
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            try {
                ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.getValue()));
                this.pkiMsgs.removeAllElements();
                while (sis.hasMoreData()) {
                    this.pkiMsgs.addElement(new PKIMessage((InputStream)sis));
                }
                sis.terminate();
            }
            catch (IOException ex) {
                throw new StreamableInputException(ex.toString());
            }
            this.decoded = true;
        }
    }
}

