/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.InfoTypeAndValue;

public class ConfirmWaitTimeInfo
extends InfoTypeAndValue {
    private static final ASN1ObjectID TYPE = CMP.id_it_ConfirmWaitTime;
    private Date time;

    public ConfirmWaitTimeInfo() {
        super(TYPE);
        this.decoded = true;
    }

    public ConfirmWaitTimeInfo(Date time) {
        this();
        this.time = time;
        this.encoded = false;
    }

    public ConfirmWaitTimeInfo(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public Date getTime() {
        this.decodeValue();
        return this.time;
    }

    @Override
    public String toString() {
        return "ConfirmWaitTime { " + this.time + " }";
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            ASN1Date value = new ASN1Date(this.time);
            this.setValue((ASN1Object)value);
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            this.time = ((ASN1Date)this.getValue()).getValue();
            this.decoded = true;
        }
    }
}

