/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.InfoTypeAndValue;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class CAProtEncCertInfo
extends InfoTypeAndValue {
    private static final ASN1ObjectID TYPE = CMP.id_it_CAProtEncCert;
    private X509Certificate certificate;

    public CAProtEncCertInfo() {
        super(TYPE);
        this.decoded = true;
    }

    public CAProtEncCertInfo(X509Certificate certificate) {
        this();
        this.certificate = certificate;
        this.encoded = false;
    }

    public CAProtEncCertInfo(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public X509Certificate getCertificate() {
        this.decodeValue();
        return this.certificate;
    }

    @Override
    public String toString() {
        return "CAProtEncCert { " + this.getCertificate() + " }";
    }

    @Override
    protected void encodeValue() {
        try {
            if (!this.encoded) {
                this.setValue((ASN1Object)new X509(this.certificate.getEncoded()));
                this.encoded = true;
                this.decoded = true;
            }
        }
        catch (IOException ex) {
            throw new StreamableInputException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new StreamableInputException(ex.toString());
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            if (this.getValue() != null) {
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    this.certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(new X509(Utils.toStream((Streamable)this.getValue())).getEncoded()));
                }
                catch (IOException ex) {
                    throw new StreamableInputException(ex.toString());
                }
                catch (CertificateException ex) {
                    throw new StreamableInputException(ex.toString());
                }
            } else {
                this.certificate = null;
            }
            this.decoded = true;
        }
    }
}

