/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cmp.attribute.PKIArchiveOptionRegControl;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class ArchiveRemGenPrivKeyArchOpt
extends PKIArchiveOptionRegControl {
    private boolean archive;

    public ArchiveRemGenPrivKeyArchOpt() {
    }

    public ArchiveRemGenPrivKeyArchOpt(boolean archive) {
        this();
        this.archive = archive;
    }

    public ArchiveRemGenPrivKeyArchOpt(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public boolean getArchive() {
        this.decodeValue();
        return this.archive;
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            this.setValue(ASN1Utils.addImplicitTag((ASN1Object)new ASN1Boolean(this.archive), (int)2));
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            try {
                PushbackInputStream pis = new PushbackInputStream(Utils.toStream((Streamable)this.getValue()));
                int ch = pis.read();
                int tag = ch & 0x1F;
                if (tag != 2) {
                    throw new ASN1FormatException("Unexpected archiveRemGenPrivKey tag: " + tag);
                }
                pis.unread((ch & 0) + 1);
                this.archive = ASN1Boolean.inputValue((InputStream)pis);
            }
            catch (IOException ex) {
                throw new StreamableInputException(ex.toString());
            }
            this.decoded = true;
        }
    }
}

